const { default: axios } = require("axios");

const setAppointment = async (whatsappNumber, userName, apiKey) => {
  if (!whatsappNumber || !userName || !apiKey) {
    throw new Error("WhatsApp number, username, and API key are required");
  }

  try {
    const response = await axios.post(
      "https://backend.aisensy.com/campaign/t1/api/v2",
      {
        apiKey: apiKey, // Use the provided API key
        campaignName: "testPreappoitment_ins", // Campaign name
        destination: whatsappNumber, // WhatsApp number
        userName: userName, // User name
        templateParams: ["$FirstName"],
        source: "new-landing-page form",
        media: {},
        buttons: [],
        carouselCards: [],
        location: {},
        paramsFallbackValue: {
          FirstName: "user",
        },
      },
      {
        headers: {
          "Content-Type": "application/json",
        },
      }
    );

    const { data } = response;

    if (response.status === 200) {
      console.log("Appointment set successfully:", data);
      return data;
    } else {
      throw new Error("Failed to set appointment");
    }
  } catch (error) {
    console.error("Error setting appointment:", error.message);
    throw new Error("Failed to set appointment");
  }
};
const whatsappNumber = "919582711211"; // Replace with the actual WhatsApp number
const userName = "John Doe"; // Replace with the actual user name
const apiKey =
  "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJpZCI6IjY2ZGM2MzY1NzA2ZjgwN2FhY2M3YTBhMyIsIm5hbWUiOiJMaWZlTGlua3IiLCJhcHBOYW1lIjoiQWlTZW5zeSIsImNsaWVudElkIjoiNjZkYzYzNjU3MDZmODA3YWFjYzdhMDlhIiwiYWN0aXZlUGxhbiI6IkJBU0lDX01PTlRITFkiLCJpYXQiOjE3MjU3MTkzOTd9.hXAFAoAPrA6ZmmT3Y_tKh0CGWegZffKiQItj2PzVzg8"; // Replace with actual API key

setAppointment(whatsappNumber, userName, apiKey)
  .then((response) => {
    console.log("Appointment Response:", response);
  })
  .catch((error) => {
    console.error("Error:", error.message);
  });

/*
  RESPONSE 


  Appointment set successfully: {
  success: 'true',
  submitted_message_id: '972624bc-f303-48bf-a549-93b134a467a2'
}
Appointment Response: {
  success: 'true',
  submitted_message_id: '972624bc-f303-48bf-a549-93b134a467a2'
}

  
  */
