const axios = require("axios");

const APIsecret = "bc233ed1-9871-4e0d-9f29-e796b8e13f58";

const start_date = 1725193975000;
const end_date = 1725280375000;

const fetchAnsweredCalls = async (startDate, endDate, apiKey) => {
  if (!startDate || !endDate || !apiKey) {
    throw new Error("Start date, end date, and API key are required");
  }

  try {
    const response = await axios.post(
      "https://rest.telecmi.com/v2/answered",
      {
        appid: 33334263, // Replace with actual app ID if needed
        secret: apiKey, // Use the API key as the secret
        start_date: startDate,
        end_date: endDate,
      },
      {
        headers: {
          "Content-Type": "application/json",
          Authorization: `API-KEY ${apiKey}`, // API-KEY Authorization
        },
      }
    );

    const { data } = response;

    if (response.status === 200 && data.code === 200) {
      console.log("Answered calls data fetched successfully:", data.cdr);
      return data.cdr;
    } else {
      throw new Error("Failed to fetch answered calls data");
    }
  } catch (error) {
    console.error("Error fetching answered calls data:", error.message);
    throw new Error("Failed to fetch answered calls data");
  }
};

const startDate = 1725193975000; // Example start date in timestamp
const endDate = 1725280375000; // Example end date in timestamp

fetchAnsweredCalls(startDate, endDate, APIsecret)
  .then((answeredCalls) => {
    console.log("Answered Calls:", answeredCalls);
  })
  .catch((error) => {
    console.error("Error:", error.message);
  });
