const { PR_patientReg, PR_BillFindPatient, PR_BillPharmacy } = require("../models/PatientReg"); // Adjust the path to your Sequelize models

const { MarkVisit } = require("../models/360Model");
const { Advance } = require("../models/MainBill");
const { PatientCounseling, treatmentAdvice, StimulationSubmit, ovumSchedule, SemenSample, ScheduleEt, EmbryoTransfer } = require("../models/embrology");

const saveMarkVisit = async (req, res) => {
  console.log(`router.post("/markVisit", saveMarkVisit);`);

  try {
    // Get patientID from the session
    const patientID = req.session.patientId;
    console.log(`router.post("/markVisit", saveMarkVisit);`);
    console.log(patientID);
    // Ensure patientID exists
    if (!patientID) {
      return res.status(400).json({
        success: false,
        message: "Patient ID is missing from the session.",
      });
    }

    // Get data from the request body
    const { date, doctor } = req.body;

    console.log(date, doctor);
    console.log(`router.post("/markVisit", saveMarkVisit);`);
    // Validate required fields
    if (!date || !doctor) {
      return res.status(400).json({
        success: false,
        message: "Date and Doctor fields are required.",
      });
    }

    // Save data into the MarkVisit table
    const newVisit = await MarkVisit.create({
      patientid: patientID,
      date,
      doctor,
    });

    // Respond with success
    return res.status(201).json({
      success: true,
      message: "Visit marked successfully.",
      data: newVisit,
    });
  } catch (error) {
    console.error("Error saving visit:", error);
    return res.status(500).json({
      success: false,
      message: "An error occurred while marking the visit.",
    });
  }
};

const checkUHID = async (req, res) => {
  console.log(`in check uhid`);

  const { uhid } = req.body;
  console.log(`uhid: ${uhid}`);

  if (!uhid) {
    return res.status(400).json({ error: "MRN NO  is required" });
  }

  try {
    // Query the database to check if the UHID exists
    const patient = await PR_patientReg.findOne({ where: { mr_no: uhid } });

    if (patient) {
      req.session.patientId = patient.id;
      const patientRecord = await PatientCounseling.findOne({
        where: { patientId: req.session.patientId, status: true, clinicId:req.user.clinicId, },
        attributes: [ "cycle_id", "mrn"],
      });
      if (patientRecord.mrn) {
        req.session.cycle_id = patientRecord.cycle_id;
      }
      return res.status(200).json({ exists: true });
    } else {
      return res.status(200).json({ exists: false });
    }
  } catch (error) {
    console.error(error);
    return res.status(500).json({ error: "Internal Server Error" });
  }
};

// const getPatientDetails = async (req, res) => {
//   console.log("Fetching patient details");

//   const { patientId } = req.session; // Retrieve the patient ID from the session

//   if (!patientId) {
//     return res
//       .status(400)
//       .json({ error: "Patient ID is not available in the session" });
//   }

//   try {
//     // Query the database to get patient details
//     const patient = await PR_patientReg.findOne({
//       where: { id: patientId },
//       attributes: [
//         "firstName",
//         "lastName",
//         "age_years",
//         "mobileNo",
//         "email",
//         "spouse_firstName",
//         "spouse_lastName",
//         "spouse_age_year",
//         "spouse_mobile_1",
//         "spouse_email",
//       ],
//     });

//     if (!patient) {
//       return res.status(404).json({ error: "Patient not found" });
//     }

//     // Construct response data
//     const data = {
//       patient: {
//         name: `${patient.firstName || ""} ${patient.lastName || ""}`.trim(),
//         age: patient.age_years || "N/A",
//         mobile: patient.mobileNo || "N/A",
//         email: patient.email || "N/A",
//       },
//       spouse: {
//         name: `${patient.spouse_firstName || ""} ${
//           patient.spouse_lastName || ""
//         }`.trim(),
//         age: patient.spouse_age_year || "N/A",
//         mobile: patient.spouse_mobile_1 || "N/A",
//         email: patient.spouse_email || "N/A",
//       },
//     };

//     return res.status(200).json(data);
//   } catch (error) {
//     console.error("Error fetching patient details:", error);
//     return res.status(500).json({ error: "Internal Server Error" });
//   }
// };

const getPatientDetails = async (req, res) => {
  console.log("Fetching patient details");

  const { patientId } = req.session; // Retrieve the patient ID from the session

  if (!patientId) {
    return res
      .status(400)
      .json({ error: "Patient ID is not available in the session" });
  }

  try {
    // Query the database to get patient details
    const patient = await PR_patientReg.findOne({
      where: { id: patientId },
      attributes: [
        "firstName",
        "clinic_id",
        "mr_no",
        "lastName",
        "age_years",
        "mobileNo",
        "email",
        "Gender", // Fetch patient gender
        "spouse_firstName",
        "spouse_lastName",
        "spouse_age_year",
        "spouse_mobile_1",
        "spouse_email",
        "spouse_gender",
        "bank_name",
        "branch",
        "ifsc_code",
        "account_no",
        "account_holder",
        "account_type" // Fetch spouse gender
      ],
    });

    if (!patient) {
      return res.status(404).json({ error: "Patient not found" });
    }

    // Fetch the patient's service bills from PR_BillFindPatient
    const serviceBills = await PR_BillFindPatient.findAll({
      where: { mrNo: patient.mr_no },
      attributes: [
        "bill_no", "date", "totalPayAmount", "totalNetAmount", "Advance", "balanceAmount"
      ]
    });

    // Fetch the patient's pharmacy bills from PR_BillPharmacy
    const pharmacyBills = await PR_BillPharmacy.findAll({
      where: { mrNo: patient.mr_no },
      attributes: [
        "bill_no", "date", "pharmacyBillAmount", "Advance", "balanceAmount"
      ]
    });

    // Fetch the patient's advance details from the Advance table
    const advances = await Advance.findAll({
      where: { patient_id: patientId },
      attributes: [
        "rec_no", "date", "amount", "consume_amount", "refunded_amount", "balance_amount"
      ]
    });

    // Construct response data
    const data = {
      patient: {
        name: `${patient.firstName || ""} ${patient.lastName || ""}`.trim(),
        age: patient.age_years || "N/A",
        mobile: patient.mobileNo || "N/A",
        email: patient.email || "N/A",
        gender: patient.Gender || "N/A",
        mr_no: patient.mr_no || "N/A",
        clinic_id: patient.clinic_id || "N/A",
      },
      spouse: {
        name: `${patient.spouse_firstName || ""} ${patient.spouse_lastName || ""}`.trim(),
        age: patient.spouse_age_year || "N/A",
        mobile: patient.spouse_mobile_1 || "N/A",
        email: patient.spouse_email || "N/A",
        gender: patient.spouse_gender || "N/A",
      },
      bank: {
        bank_name: patient.bank_name || "N/A",
        branch: patient.branch || "N/A",
        ifsc_code: patient.ifsc_code || "N/A",
        account_no: patient.account_no || "N/A",
        account_holder: patient.account_holder || "N/A",
        account_type: patient.account_type || "N/A",
      },
      serviceBills: serviceBills.map(bill => ({
        bill_no: bill.bill_no || "N/A",
        date: bill.date || "N/A",
        totalPayAmount: bill.totalPayAmount || "N/A",
        totalNetAmount: bill.totalNetAmount || "N/A",
        advance: bill.Advance || "N/A",
        balanceAmount: bill.balanceAmount || "0.00"
      })),
      pharmacyBills: pharmacyBills.map(bill => ({
        bill_no: bill.bill_no || "N/A",
        date: bill.date || "N/A",
        pharmacyBillAmount: bill.pharmacyBillAmount || "N/A",
        advance: bill.Advance || "N/A",
        balanceAmount: bill.balanceAmount || "0.00"
      })),
      advances: advances.map(advance => ({
        rec_no: advance.rec_no || "N/A",
        date: advance.date || "N/A",
        amount: advance.amount || "0.00",
        consume_amount: advance.consume_amount || "0.00",
        refunded_amount: advance.refunded_amount || "0.00",
        balance_amount: advance.balance_amount || "0.00"
      }))
    };

    return res.status(200).json(data);
  } catch (error) {
    console.error("Error fetching patient details:", error);
    return res.status(500).json({ error: "Internal Server Error" });
  }
};

const formatDate = (date) => {
  if (!date) return null;
  const options = { day: "2-digit", month: "2-digit", year: "numeric" };
  return new Intl.DateTimeFormat("en-GB", options).format(new Date(date));
};

const timeLineApi = async (req, res) => {
  try {
    const cycleID = req.query.cycleID || req.session.cycle_id;
    const patientId = req.query.patientID || req.session.patientId;

    const models = [
      {
        model: PR_patientReg,
        alias: "PrPatientDate",
        where: { id: patientId },
        attributes: ["createdAt"],
      },
      {
        model: PatientCounseling,
        alias: "counsellingDate",
        where: { cycle_id: cycleID, patientId: patientId },
        attributes: ["createdAt"],
      },
      {
        model: treatmentAdvice,
        alias: "eMRDate",
        where: { cycleId: cycleID, patientId: patientId },
        attributes: ["createdAt"],
      },
      {
        model: StimulationSubmit,
        alias: "stimulationDetailsDate",
        where: { cycleId: cycleID },
        attributes: ["createdAt"],
      },
      {
        model: ovumSchedule,
        alias: "opuData",
        where: { cycleId: cycleID, patient_id: patientId },
        attributes: ["createdAt"],
      },
      {
        model: SemenSample,
        alias: "semenSampleData",
        where: { cycleId: cycleID, patient_id: patientId },
        attributes: ["createdAt"],
      },
      {
        model: ScheduleEt,
        alias: "scheduleEtDate",
        where: { cycleId: cycleID, patientId: patientId },
        attributes: ["createdAt"],
      },
      {
        model: EmbryoTransfer,
        alias: "embryoTransfersDate",
        where: { cycleId: cycleID },
        attributes: ["createdAt"],
        isMultiple: true,
      },
    ];

    const results = await Promise.all(
      models.map(async ({ model, alias, where, attributes, isMultiple }) => {
        if (isMultiple) {
          const data = await model.findAll({ where, attributes });
          return {
            [alias]: data.map((item) => ({
              ...item.toJSON(),
              createdAt: formatDate(item.createdAt),
            })),
          };
        } else {
          const data = await model.findOne({ where, attributes });
          if (data) {
            return {
              [alias]: {
                ...data.toJSON(),
                createdAt: formatDate(data.createdAt),
              },
            };
          } else {
            return { [alias]: null };
          }
        }
      })
    );

    const response = results.reduce(
      (acc, result) => ({ ...acc, ...result }),
      {}
    );

    return res.status(200).json(response);
  } catch (error) {
    console.error("Error in timeLineApi:", error);
    return res.status(500).json({ message: "Internal server error", error });
  }
};
module.exports = { checkUHID, getPatientDetails, saveMarkVisit,timeLineApi };
