const {SuperAdmin, Menu}  =require('../models/Admin');
const md5 = require('md5');

const AdminSubmit = async (req, res) => {
    try {
        console.log("Received request body:", req.body);

        // Check if menuRights exists and is a string that needs parsing
        let rightsData = req.body.menuRights;
        
        // If it's a string, attempt to parse it, else use it as is
        if (typeof rightsData === 'string') {
            try {
                rightsData = JSON.parse(rightsData); // Try to parse it if it's a JSON string
            } catch (error) {
                return res.status(400).json({ msg: 'Invalid menuRights format, expected JSON.' });
            }
        }

        // Ensure rightsData is an array (if it's an invalid format, default to an empty array)
        if (!Array.isArray(rightsData)) {
            return res.status(400).json({ msg: 'Invalid menuRights format, expected an array.' });
        }

        // Handle the Freeze checkbox
        req.body.Freeze = req.body.Freeze === 'on'; // True if Freeze is checked, false otherwise

        // Ensure the password is hashed securely (consider using bcrypt in production)
        req.body.Password = md5(req.body.Password);  // Note: Consider bcrypt for security!

        // Get the query parameter for determining whether to create or update
        const queryValue = req.body?.query;

        if (queryValue === '0') {
            // Check if username already exists
            const isExist = await SuperAdmin.findOne({ where: { username: req.body.username } });
            if (isExist) {
                return res.status(400).json({ msg: 'Username already exists.' });
            }

            // Create a new SuperAdmin entry with the provided data
            const newTestCateg = await SuperAdmin.create({
                ...req.body,
                rights: rightsData // Save the menu rights array
            });
            return res.status(200).json({ msg: 'Form saved successfully!', data: newTestCateg });
        } else {
            // Check if the user exists for updating their data
            const existing = await SuperAdmin.findOne({ where: { username: req.body.username } });
            if (!existing) {
                return res.status(404).json({ msg: 'Test category not found for the provided username.' });
            }

            // Update the existing SuperAdmin entry with the new data
            await existing.update({
                ...req.body,
                rights: rightsData // Update the rights array
            });
            return res.status(200).json({ msg: 'Department details updated successfully!', data: existing });
        }
    } catch (error) {
        console.error('Error in AdminSubmit:', error);
        return res.status(500).json({ msg: 'An error occurred while processing your request.' });
    }
};





const getAdmin = async (req, res) => {
    console.log('Fetching admin details');
    try {
      // Fetch all details from the SuperAdmin table
      const details = await SuperAdmin.findAll();
      
      // Prepare an array to store the final response
      const result = [];
  
      // Iterate over each SuperAdmin entry to add menu details
      for (const admin of details) {
        // Parse the `rights` field, which contains menu IDs in JSON string format
        const rightsIds = admin.rights;  // Convert JSON string into an array of menu IDs
  
        // Fetch the menu details for the menu IDs from the Menu table
        const menuDetails = await Menu.findAll({
          where: {
            menu_id: rightsIds  // Use the list of menu_ids from `rights`
          }
        });
  
        // Map the fetched menu data to a more readable structure
        const menus = menuDetails.map(menu => ({
          menu_id: menu.menu_id,
          menu_name: menu.menu_name,
          menu_parent: menu.menu_parent,
          menu_dept: menu.menu_dept,
          menu_master: menu.menu_master,
          menu_url: menu.menu_url
        }));
  
        // Add the admin details along with the associated menu data
        result.push({
          id: admin.id,
          username: admin.username,
          Password: admin.Password,
          clinicName: admin.clinicName,
          clinicId: admin.clinicId,
          mobileNumber: admin.mobileNumber,
          createdBy: admin.createdBy,
          rights: menus,  // Attach the menu details
          Freeze: admin.Freeze,
          status: admin.status,
          createdAt: admin.createdAt,
          updatedAt: admin.updatedAt
        });
      }
  
      // Return the final result with the admin details and associated menus
      res.status(200).json(result);
  
    } catch (error) {
      console.error('Error fetching admin details:', error);
      res.status(500).json({ error: 'An error occurred while fetching admin details.' });
    }
  };
  
      module.exports={getAdmin,AdminSubmit}