const { ConsentPatientUser } = require("../models/table_concent_User.js");
const multer = require("multer");
const path = require("path");

// Define the absolute path to the uploads folder
const uploadsDir = path.join(__dirname, "..", "Concent");
const fs = require("fs");
const { PR_patientReg } = require("../models/concentModel.js");

// Set up storage engine for multer
const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    if (!fs.existsSync(uploadsDir)) {
      fs.mkdirSync(uploadsDir, { recursive: true });
      console.log(`Created directory: ${uploadsDir}`);
    }
    cb(null, uploadsDir); // Use the absolute path
    // console.log("hello file:", uploadsDir);
  },

  filename: (req, file, cb) => {
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    // console.log(file);

    cb(
      null,
      file.fieldname + "-" + uniqueSuffix + path.extname(file.originalname)
    ); // Unique filename
  },
});

// Initialize multer with the storage engine
const upload2 = multer({ storage: storage });

const uploadConcent = async (req, res) => {
  try {
    // Check file exist
    const file = req.body;
    if (!file) return res.status(404).send("File not found");

    // Check patient id exist
    const patientId = req.session.rowId;
    if (patientId == undefined) {
      return res.status(404).send({ message: "Patient ID not found." });
    }

    // Check patient with given id exist
    const patient = await PR_patientReg.findOne({
      where: { id: patientId },
    });
    if (!patient) {
      return res
        .status(400)
        .send({ message: "No patient with this MR registration" });
    }

    // search for consent of the patient
    const patientConsent = await ConsentPatientUser.findOne({
      where: { patientID: patient.id },
    });

    // Create object of consent given by client
    const consent = {
      name: file.formName,
      location: file.path,
      originalName: file.originalName,
    };

    console.log(consent)
    // taking actions ac to consent existence
    if (patientConsent) {
      // Destructs consent list
      const consentList = patientConsent.formNames;

      // Check client give consent already exist?
      const isExist = consentList.some(({ name }) => name == consent.name);
      if (isExist) {
        return res
          .status(403)
          .send({ message: `Consent ${file.formName} already exist.` });
      } else {
        // Updating consents ac to patient ID
        await ConsentPatientUser.update(
          { formNames: [consent, ...consentList] },
          { where: { patientID: patient.id } }
        );

        return res.send({ message: "Consent updated successfully." });
      }
    } else {
      // Create new consent if doesn't exist
      const newPatientConsent = await ConsentPatientUser.create({
        patientID: patient.id,
        patientMr_num: patient.mr_no,
        patientName: patient.firstName,
        formNames: [consent],
        status: true,
      });

      return res.send(newPatientConsent);
    }

    // const { formName } = req.body;
    // // console.log(req.body);

    // // `req.file` contains information about the uploaded file
    // // console.log("File uploaded:", req.file);
    // // const file = req.file;
    // // const { patientName } = req.body;

    // const patientId = req.session.rowId;
    // // console.log("patientId : ", patientId, req.session.rowId);
    // // console.log(req.session);

    // if (!file || !patientId) {
    //   return res.status(400).json({ message: "Incomplete data" });
    // }
    // // console.log(patientName);

    // const id = await PR_patientReg.findOne({
    //   where: { id: patientId },
    // });
    // // console.log(id);

    // if (!id) {
    //   return res
    //     .status(400)
    //     .json({ message: "No patient with this MR registration..." });
    // }

    // const user = await ConsentPatientUser.findOne({
    //   where: { patientID: id.id },
    // });

    // // console.log(user);
    // const myobj = {
    //   name: formName,
    //   location: file.filename,
    // };

    // const requiredFormName = req.body.formName;
    // console.log("Formname: ", requiredFormName);

    // // Determine if formNames is already an object or needs to be parsed
    // let filledForms;
    // let formFilled = false;

    // if (user) {
    //   if (typeof user.formNames === "string") {
    //     filledForms = JSON.parse(user.formNames || "[]");
    //   } else {
    //     filledForms = user.formNames || []; // Assuming it's already an object or array
    //   }
    //   console.log(filledForms);

    //   formFilled = filledForms.some((form) => form.name === requiredFormName);
    //   console.log("formFilled give:", formFilled);

    //   if (formFilled) {
    //     return res.status(403).json({ message: "The file already exists." });
    //   }
    //   // Append the new file to the formNames array
    //   const updatedFormNames = user.formNames
    //     ? [...user.formNames, myobj]
    //     : [myobj];

    //   // Use the update function to update the formNames field
    //   await ConsentPatientUser.update(
    //     { formNames: updatedFormNames },
    //     { where: { id: user.id } }
    //   );

    //   return res.status(200).json({
    //     message: "File uploaded and formNames updated successfully!",
    //     userconcent: updatedFormNames,
    //   });
    // }
    // const userconcent = await ConsentPatientUser.create({
    //   patientID: id.id,
    //   patientMr_num: id.mr_no,
    //   patientName: id.firstName,
    //   formNames: [myobj],
    //   status: true,
    // });

    // res.status(200).json({
    //   message: "File uploaded successfully!",
    //   userconcent,
    // });
  } catch (error) {
    console.error("Error uploading consent file:", error);
    res
      .status(500)
      .send({ message: "unable to upload consent", error: error.message });
  }
};

const getUserConcentForms = async (req, res) => {
  try {
    const patientId = req.session.rowId;
    if (!patientId) {
      return res.status(400).json({ message: "Patient not selected." });
    }
    const forms = await ConsentPatientUser.findOne({
      where: { patientID: patientId },
      attributes: ["formNames"],
    });
    console.log("Given forms: ", forms);

    res.status(200).json(forms);
  } catch (err) {
    console.error("Error fetching user concent forms:", err);
    res
      .status(500)
      .json({ error: "An error occurred while fetching user concent forms." });
  }
};

module.exports = { uploadConcent, upload2, getUserConcentForms };
