const { Op } = require('sequelize');
const {
  KYC,
  kycReports,
  CrmFu_record,
  CrmApt_record,
  CrmVis_record,
  CrmConv_record,
  CrmPatientStatus_record,
  Admin,
  Leads,
} = require("../models/Kyc");
const {
  bankBranchMaster,
  Designation,
  EmrCC,
  EmrFieldvalue,
  RegionMaster,
  SubSpecialization,
} = require("../models/clinicConfig");
const { CashCounterMaster } = require("../models/clinicConfig");
const { Classification } = require("../models/clinicConfig");
const { ClinicConfiguration } = require("../models/clinicConfig");
const { Country, State, City } = require("../models/clinicConfig");
const { Department } = require("../models/clinicConfig");
const { DocCatMaster } = require("../models/clinicConfig");
const { Doctor } = require("../models/clinicConfig");
const { PrimarySymptoms } = require("../models/clinicConfig");
const { UserTokens } = require("../models/UserTokens");
const CryptoJS = require("crypto-js");
//const {CrmVis_record} =require("../models/Kyc.js")
function encryptDataForUrl(data) {
  const secretKey = "ll"; // Replace with your actual secret key
  const encrypted = CryptoJS.AES.encrypt(data, secretKey).toString();
  const encodedEncrypted = encodeURIComponent(encrypted);
  return encodedEncrypted;
}
const { PR_patientReg } = require("../models/PatientReg")

const jwt = require("jsonwebtoken");
var path = require("path");
const md5 = require("md5");

const kycCtrl = async (req, res) => {
  console.log(req.body);
  const clinicId = req.user.clinicId;  // Get clinic_id from session
  console.log("Sd", req.user)
  if (clinicId == null) { // This checks for both null and undefined
    return res.status(400).send({ msg: 'Clinic ID is missing in the session.' });
  }


  console.log("1234")
  req.body.clinic_id = clinicId;  // Use the clinic_id from session

  try {
    // Check if it's a modification query
    if (req.body.modQuery === "1") {
      // console.log("11111");
      const {
        lead_date,
        lead_no,
        contact_no_husband,
        email_id,
        whatsapp_no,
        lead_owner,
        address,
      } = req.body;



      // Update existing KYC entry
      const result = await KYC.update(
        {
          contact_no_husband,
          whatsapp_no,
          email_id,
          address,
          lead_owner,
        },
        {
          where: {
            lead_no: lead_no,
          },
        }
      );
      console.log(result);

      // Check if any rows were updated
      if (result[0] === 0) {
        return res.json({ success: false, msg: "No data found to update." });
      } else {

        return res.json({ success: true, msg: "Updated Succesfully" });
      }
    }

    // New KYC entry creation
    const { lead_no, contact_no_wife, ...rest } = req.body;

    console.log('You Log Req Body', req.body);


    // Check if lead_no is provided

    if (!lead_no) {
      return res.status(400).json({ msg: "Lead number is required" });
    }

    // Check if lead_no already exists
    const existingKYC = await KYC.findOne({ where: { lead_no } });
    if (existingKYC) {
      return res.status(400).json({ msg: "Lead number already exists" });
    }

    // Check if contact_no_wife already exists
    if (contact_no_wife) {
      const existingKYCByContactNoWife = await KYC.findOne({ where: { contact_no_wife } });
      if (existingKYCByContactNoWife) {
        return res.status(400).json({ msg: "Contact number 1 already exists" });
      }
    }

    // Create new KYC entry
    // const newKYC = await KYC.create({ lead_no, ...rest });
    const newKYC = await KYC.create({ lead_no, contact_no_wife, lead_id: req.body.lead_id, ...rest });

    // ✅ Update `isApproached` to `true` in Leads table
    console.log('here', req.body.lead_id);

    // await Leads.update({ isApproached: true }, { where: { id: req.body.lead_id } });
    if (req.body.lead_id) {
      await Leads.update(
        {
          isApproached: true,
          date_of_approach: req.body.lead_date
        },
        {
          where: { id: req.body.lead_id }
        }
      );

    }

    // Handle uploaded reports

    const reports = req.files.map((file) => ({
      report: path.basename(file.path),
      remark: req.body[`remark${file.fieldname.slice(6)}`] || "",
    }));

    // Save reports to database
    for (const { report, remark } of reports) {
      await kycReports.create({
        // kyc_id: newKYC.id,
        kyc_id: newKYC.id || newKYC.lead_id,
        lead_no,
        report,
        remark,
      });
    }

    // Log and respond
    console.log("KYC entry created:", newKYC);
    return res.status(200).json({ msg: "Form saved successfully", kyc: newKYC });
  } catch (error) {
    console.error("Error in /kycreg:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

// Bank Branch Master Controller
const bankBranchMasterCtrl = async (req, res) => {
  try {
    const existing = await bankBranchMaster.findOne({
      bank_branch_m_code: req.body.bank_branch_m_code,
    });
    if (existing) {
      return res.status(400).send({ msg: "Clinic code already exists." });
    }

    const bankBranch = new bankBranchMaster(req.body);
    await bankBranch.save();
    res
      .status(200)
      .json({ message: "Bank branch details saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving bank branch details." });
  }
};

// const modifyApt = async (req, res) => {
//   try {
//     console.log("99", req.body);
//     // Extract data from request body
//     const { apt_id, apt_status } = req.body;

//     // Update the data in the database
//     const result = await CrmApt_record.update(
//       {
//         apt_status,
//       },
//       {
//         where: {
//           id: apt_id,
//         },
//       }
//     );

//     if (result[0] === 0) {
//       // No rows updated, maybe the ID was not found
//       res.json({ success: false, msg: "No data found to update." });
//     } else {
//       // Successfully updated
//       res.json({ success: true });
//     }
//   } catch (error) {
//     console.error("Error updating data:", error);
//     res.status(500).json({ success: false, msg: "Internal server error." });
//   }
// };

const modifyApt = async (req, res) => {
  try {
    console.log("Received modifyApt request:", req.body);
    const { apt_id, apt_status } = req.body;

    // Update the appointment record in CrmApt_record
    const result = await CrmApt_record.update(
      { apt_status },
      { where: { id: apt_id } }
    );

    if (result[0] === 0) {
      return res.json({
        success: false,
        msg: "No appointment record found to update.",
      });
    }

    // Retrieve the updated appointment record to get the associated kyc_id
    const updatedAptRecord = await CrmApt_record.findOne({
      where: { id: apt_id },
    });
    if (!updatedAptRecord) {
      return res.json({
        success: false,
        msg: "Unable to retrieve updated appointment record.",
      });
    }

    const kyc_id = updatedAptRecord.kyc_id;

    // Update the patient's current status in CrmPatientStatus_record using the apt_status value
    await CrmPatientStatus_record.update(
      { current_status: apt_status },
      { where: { kyc_id } }
    );

    return res.json({
      success: true,
      msg: "Appointment and patient status updated successfully.",
    });
  } catch (error) {
    console.error("Error updating data:", error);
    return res
      .status(500)
      .json({ success: false, msg: "Internal server error." });
  }
};

// Cash Counter Master Controller
const cashCounterMasterCtrl = async (req, res) => {
  try {
    const existing = await CashCounterMaster.findOne({
      cash_counter_master_code: req.body.cash_counter_master_code,
    });
    if (existing) {
      return res.status(400).send({ msg: "Code already exists." });
    }

    const cashCounter = new CashCounterMaster(req.body);
    await cashCounter.save();
    res
      .status(200)
      .json({ message: "Cash Counter details saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving cash counter details." });
  }
};

// Classification Controller
const classificationCtrl = async (req, res) => {
  try {
    const existing = await Classification.findOne({
      classification_code: req.body.classification_code,
    });
    if (existing) {
      return res.status(400).send({ msg: "Code already exists." });
    }

    const classification = new Classification(req.body);
    await classification.save();
    res
      .status(200)
      .json({ message: "Classification details saved successfully!" });
  } catch (error) {
    res.status(500).json({
      error: "An error occurred while saving classification details.",
    });
  }
};

//getClassification
const getClassification = async (req, res) => {
  try {
    const details = await Classification.find(); // Assuming Classification is your Mongoose model
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

// Clinic Configuration Controller
const clinicConfigCtrl = async (req, res) => {
  try {
    // Check if clinic_code already exists
    const existingConfig = await ClinicConfiguration.findOne({
      clinic_code: req.body.clinic_code,
    });
    if (existingConfig) {
      return res.status(400).send({ msg: "Clinic code already exists." });
    }

    // If not, proceed to save the new clinic configuration
    const clinicConfig = new ClinicConfiguration(req.body);
    await clinicConfig.save();
    res
      .status(200)
      .json({ message: "Clinic Configuration details saved successfully!" });
  } catch (error) {
    res.status(500).json({
      error: "An error occurred while saving clinic configuration details.",
    });
  }
};

// Country Controller
const getCountry = async (req, res) => {
  try {
    const countries = await Country.find({}, "country_id");
    const countryIds = countries.map((country) => country.country_id);
    res.status(200).json(countryIds);
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while fetching countries." });
  }
};

// State Controller
const getState = async (req, res) => {
  try {
    const { countryId } = req.query;
    const states = await State.find({ countryId: countryId }).select({
      _id: 0,
    });
    res.status(200).json(states);
  } catch (error) {
    res.status(500).json({ error: "An error occurred while fetching states." });
  }
};

// City Controller
const getCity = async (req, res) => {
  try {
    const { stateId } = req.query;
    const cityDoc = await City.findOne({ [stateId]: { $exists: true } });
    const cities = cityDoc[stateId];
    res.status(200).json(cities);
  } catch (error) {
    res.status(500).json({ error: "An error occurred while fetching cities." });
  }
};

// Department Controller
const departmentCtrl = async (req, res) => {
  try {
    const dept = new Department(req.body);
    await dept.save();
    res.status(200).json({ message: "Department Details saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving department details." });
  }
};

// Doc Cat Master Controller
const docCatCtrl = async (req, res) => {
  try {
    const docCat = new DocCatMaster(req.body);
    await docCat.save();
    res.status(200).json({ message: "Doc Cat details saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving doc cat details." });
  }
};

const getDocCat = async (req, res) => {
  try {
    const details = await DocCatMaster.find({});
    console.log(details);
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

const docInfoCtrl = async (req, res) => {
  try {
    const doc = new Doctor(req.body);

    await doc.save();
    console.log(doc);
    res.status(200).json({ message: "Doctor  details saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving doc cat details." });
  }
};

const getDocinfo = async (req, res) => {
  try {
    const details = await Doctor.find({});
    console.log(details);
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

const getDesginfo = async (req, res) => {
  try {
    const details = await Designation.find({});
    console.log(details);
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

const emrCCCtrl = async (req, res) => {
  try {
    const existing = await EmrCC.findOne({ emrCC_code: req.body.emrCC_code });
    if (existing) {
      return res.status(400).send({ msg: "Code already exists." });
    }

    const emr = new EmrCC(req.body);
    await emr.save();
    res.status(200).json({ message: "EMR details saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving bank branch details." });
  }
};

const emrfieldCtrl = async (req, res) => {
  try {
    const existing = await EmrFieldvalue.findOne({
      emr_fv_code: req.body.emr_fv_code,
    });
    if (existing) {
      return res.status(400).send({ msg: "Code already exists." });
    }

    const emr = new EmrFieldvalue(req.body);
    await emr.save();
    res.status(200).json({ message: "EMR Field details saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving bank branch details." });
  }
};

const getEmrInfo = async (req, res) => {
  try {
    const details = await EmrCC.find({});
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

const getEmrFieldInfo = async (req, res) => {
  try {
    const details = await EmrFieldvalue.find({});
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

const primSympCtrl = async (req, res) => {
  try {
    const existing = await PrimarySymptoms.findOne({
      prim_symp_code: req.body.prim_symp_code,
    });
    if (existing) {
      return res.status(400).send({ msg: "Code already exists." });
    }

    const symp = new PrimarySymptoms(req.body);
    await symp.save();
    res.status(200).json({ message: "Primary Symptoms saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving bank branch details." });
  }
};

const getPrimSymp = async (req, res) => {
  try {
    const details = await PrimarySymptoms.find({});
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

const regMasterCtrl = async (req, res) => {
  try {
    const existing = await RegionMaster.findOne({
      region_m_code: req.body.region_m_code,
    });
    if (existing) {
      return res.status(400).send({ msg: "Code already exists." });
    }

    const regMas = new RegionMaster(req.body);
    await regMas.save();
    res.status(200).json({ message: "Primary Symptoms saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving bank branch details." });
  }
};

const getRegion = async (req, res) => {
  try {
    const details = await RegionMaster.find({});
    console.log(details);
    res.status(200).json(details);
  } catch (error) {
    console.error("Error fetching classification details:", error);
    res.status(500).json({
      error: "An error occurred while fetching classification details.",
    });
  }
};

const subSpecCtrl = async (req, res) => {
  try {
    const existing = await SubSpecialization.findOne({
      sub_spec_code: req.body.sub_spec_code,
    });
    if (existing) {
      return res.status(400).send({ msg: "Code already exists." });
    }

    const subSpec = new SubSpecialization(req.body);
    await subSpec.save();
    res.status(200).json({ message: "Sub Specialixation saved successfully!" });
  } catch (error) {
    res
      .status(500)
      .json({ error: "An error occurred while saving bank branch details." });
  }
};
const Sequelize = require("sequelize");
const { SuperAdmin } = require("../models/Admin");
const { sendMessageToAppointment } = require("../apis/whatsappCloudApi");
const { patientRagistration } = require("./patientReg");

// Adjust the path as needed

const dashboardCtrl = async (req, res) => {
  try {
    const kycCount = await KYC.count();
    const apt = await CrmApt_record.count();
    const visits = await CrmVis_record.count();
    const conv = await CrmConv_record.count();

    // Get the current year
    const currentYear = new Date().getFullYear();

    // Fetch clinic areas
    const areas = await ClinicConfiguration.findAll({
      attributes: ["clinic_area"],
    });

    // Fetch count of appointments grouped by clinic and month of creation for the current year
    const aptCounts = await CrmApt_record.findAll({
      attributes: [
        "clinic",
        [
          Sequelize.fn("DATE_FORMAT", Sequelize.col("createdAt"), "%Y-%m"),
          "monthYear",
        ],
        [Sequelize.fn("COUNT", Sequelize.col("id")), "areasaptcount"],
      ],
      where: Sequelize.where(
        Sequelize.fn("YEAR", Sequelize.col("createdAt")),
        currentYear
      ),
      group: ["clinic", "monthYear"],
    });

    // Debugging: Log fetched counts
    console.log(
      "Appointment Counts:",
      aptCounts.map((record) => record.toJSON())
    );

    // Convert aptCounts to a map for easy lookup
    const aptCountMap = aptCounts.reduce((acc, record) => {
      const clinic = record.dataValues.clinic;
      const monthYear = record.dataValues.monthYear;
      const count = parseInt(record.dataValues.areasaptcount, 10);

      if (!acc[clinic]) {
        acc[clinic] = {};
      }
      acc[clinic][monthYear] = isNaN(count) ? 0 : count; // Default to 0 if NaN
      return acc;
    }, {});

    // Debugging: Log map of appointment counts
    console.log("Appointment Count Map:", aptCountMap);

    // Debugging: Log clinic areas
    console.log(
      "Clinic Areas:",
      areas.map((area) => area.toJSON())
    );

    // Prepare data for each area
    const areasWithCount = areas.map((area) => {
      const areaData = {
        clinic_area: area.dataValues.clinic_area,
        appointmentCounts: [],
      };

      // Fill in counts for each month of the current year
      for (let month = 1; month <= 12; month++) {
        const monthYear = `${currentYear}-${month.toString().padStart(2, "0")}`;
        const count =
          (aptCountMap[area.dataValues.clinic_area] &&
            aptCountMap[area.dataValues.clinic_area][monthYear]) ||
          0;
        areaData.appointmentCounts.push({ monthYear, count });
      }

      return areaData;
    });

    // Debugging: Log areas with counts
    console.log("Areas with Counts:", areasWithCount);

    res.render("dashboard", {
      leads: kycCount,
      apt,
      visits,
      conv,
      areas: areasWithCount,
    });
  } catch (error) {
    console.error("Error counting records:", error);
    res.status(500).send("Internal Server Error");
  }
};

const modifyVisit = async (req, res) => {
  try {
    console.log("99", req.body);
    // Extract data from request body
    const { vis_id, visited_status, remark, next_call } = req.body;

    // Fetch the existing row based on vis_id
    const existingRecord = await CrmVis_record.findOne({
      where: {
        id: vis_id,
      },
    });

    if (!existingRecord) {
      // No row found for the given ID
      return res.json({ success: false, msg: "No data found to update." });
    }

    // Update the existing row with the new data
    const result = await CrmVis_record.update(
      {
        visited_status,
        remark,
        next_call,
      },
      {
        where: {
          id: vis_id,
        },
      }
    );

    const updatedAptRecord = await CrmVis_record.findOne({
      where: { id: vis_id },
    });
    if (!updatedAptRecord) {
      return res.json({
        success: false,
        msg: "Unable to retrieve updated visited record.",
      });
    }

    const kyc_id = updatedAptRecord.kyc_id;

    // Update the patient's current status in CrmPatientStatus_record using the visited_status value
    await CrmPatientStatus_record.update(
      { current_status: visited_status },
      { where: { kyc_id } }
    );


    if (result[0] === 0) {
      // No rows updated, maybe the ID was not found
      return res.json({ success: false, msg: "No data found to update." });
    }

    // If remark is not empty, create a new entry
    if (remark && remark.trim() !== "") {
      const newEntryData = {
        kyc_id: existingRecord.kyc_id,
        uhid_no: existingRecord.uhid_no,
        apt_date: existingRecord.apt_date,
        doctor: existingRecord.doctor,
        clinic: existingRecord.clinic,
        treatment: existingRecord.treatment,
        package: existingRecord.package,
        visited_status: "", // Set to blank
        remark: "", // Set to blank
        next_call: null, // Set to blank
      };

      // Create the new entry
      await CrmVis_record.create(newEntryData);
    }

    // Successfully updated
    res.json({ success: true });
  } catch (error) {
    console.error("Error updating data:", error);
    res.status(500).json({ success: false, msg: "Internal server error." });
  }
};

const apt1 = async (req, res) => {
  const clinicId = req.user.clinicId; // Get clinic_id from session

  if (clinicId == null) {
    // This checks for both null and undefined
    return res
      .status(400)
      .send({ msg: "Clinic ID is missing in the session." });
  }

  req.body.clinic_id = clinicId; // Use the clinic_id from session

  console.log(req.body);
  const { lead_input1, fu_status, remark, fu_next_call } = req.body;

  try {
    if (!lead_input1) {
      return res.status(400).json({ msg: "Fill side form" });
    }

    // Find the KYC record by lead_input1
    const existingKYC = await KYC.findOne({ where: { lead_no: lead_input1 } });

    if (!existingKYC) {
      return res.status(404).json({ msg: "KYC record not found" });
    }

    const kyc_id = existingKYC.id;
    const dataToSave = { ...req.body, kyc_id };

    await CrmFu_record.create(dataToSave);
    console.log("🚀 Saving to CrmFu_record:", dataToSave);

    // ✅ **Check if patient exists in CrmPatientStatus_record**
    const existingPatient = await CrmPatientStatus_record.findOne({
      where: { kyc_id: kyc_id },
    });

    const patientData = {
      clinic_id: clinicId,
      kyc_id: kyc_id,
      date: fu_next_call || null,
      current_status: fu_status, // Update status
      remark: remark || null, // Ensure remark is always a string
    };

    if (existingPatient) {
      //* Update if patient already exists**
      await CrmPatientStatus_record.update(patientData, {
        where: { kyc_id: kyc_id },
      });
    } else {
      //* Create new record if not exists**
      await CrmPatientStatus_record.create(patientData);
    }

    const records = await CrmFu_record.findAll({ where: { kyc_id } });

    return res.status(200).json({ data: records });
  } catch (error) {
    console.error("❌ Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

// const apt1 = async (req, res) => {
//   const clinicId = req.user.clinicId;

//   if (!clinicId) {
//     return res.status(400).send({ msg: "Clinic ID is missing in the session." });
//   }

//   req.body.clinic_id = clinicId;

//   console.log(req.body);
//   const { lead_input1, fu_status, remark } = req.body;

//   try {
//     if (!lead_input1) {
//       return res.status(400).json({ msg: "Fill side form" });
//     }

//     // Find KYC record
//     const existingKYC = await KYC.findOne({ where: { lead_no: lead_input1 } });

//     if (!existingKYC) {
//       return res.status(404).json({ msg: "KYC record not found" });
//     }

//     const kyc_id = existingKYC.id;
//     const dataToSave = { ...req.body, kyc_id };

//     console.log("🚀 Saving to CrmFu_record:", dataToSave);

//     // Save data in CrmFu_record
//     await CrmFu_record.create(dataToSave);
//     const records = await CrmFu_record.findAll({ where: { kyc_id } });

//     console.log("📌 Records Retrieved:", records);

//     // ✅ **Insert or Update in CrmPatientStatus_record**
//     const patientData = {
//       clinic_id: clinicId,
//       kyc_id: kyc_id,
//       current_status: fu_status, // Update status
//       remark: remark || "", // Ensure remark is always a string
//     };

//     console.log("🔥 Saving to CrmPatientStatus_record:", patientData);

//     await CrmPatientStatus_record.upsert(patientData, {
//       where: { kyc_id: kyc_id }, // Update if patient exists
//     });

//     return res.status(200).json({ data: records });
//   } catch (error) {
//     console.error("❌ Error occurred:", error);
//     return res.status(500).json({ msg: "Internal server error" });
//   }
// };

const fetchFU = async (req, res) => {
  console.log(req.body);
  console.log(req.params);
  const { kyc_id } = req.params;

  try {
    const records = await CrmFu_record.findAll({ where: { kyc_id } });
    console.log(records);
    return res.status(200).json({ data: records }); // Return the newly created KYC record
  } catch (error) {
    console.error("Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

const fetchApt = async (req, res) => {
  console.log(req.body);
  console.log(req.params);
  const { kyc_id } = req.params;

  try {
    const records = await CrmApt_record.findAll({ where: { kyc_id } });
    console.log(records);
    return res.status(200).json({ data: records }); // Return the newly created KYC record
  } catch (error) {
    console.error("Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

const fetchVisits = async (req, res) => {
  console.log(req.body);
  console.log(req.params);
  const { kyc_id } = req.params;

  try {
    const records = await CrmVis_record.findAll({ where: { kyc_id } });
    console.log(records);
    return res.status(200).json({ data: records }); // Return the newly created KYC record
  } catch (error) {
    console.error("Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

// Function to get lead details by kycId
const getLeadByKycId = async (req, res) => {
  try {
    const { kycId } = req.query; // Extract kycId from request query

    if (!kycId) {
      return res.status(400).json({ error: "kycId is required" });
    }

    // Fetch lead data from the database
    const lead = await Leads.findOne({
      where: { id: kycId }, // Assuming id is the kycId in the Leads table
    });

    if (!lead) {
      return res.status(404).json({ error: "Lead not found" });
    }

    res.json({ success: true, lead });
  } catch (error) {
    console.error("Error fetching lead:", error);
    res.status(500).json({ error: "Internal server error" });
  }
};

const fetchConv = async (req, res) => {
  console.log(req.body);
  console.log(req.params);
  const { kyc_id } = req.params;

  try {
    const records = await CrmConv_record.findAll({ where: { kyc_id } });
    console.log(records);
    return res.status(200).json({ data: records }); // Return the newly created KYC record
  } catch (error) {
    console.error("Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

const apt2 = async (req, res) => {

  console.log("You are in the Apt 2 ");

  const clinicId = req.user.clinicId;  // Get clinic_id from session

  if (clinicId == null) { // This checks for both null and undefined
    return res.status(400).send({ msg: 'Clinic ID is missing in the session.' });
  }

  req.body.clinic_id = clinicId;  // Use the clinic_id from session

  console.log("req body", req.body);
  // const { lead_input2 } = req.body;
  const { lead_input2, apt_date, apt_time, doctor } = req.body;
  console.log('lead_input2 Patient ID - >>>>', lead_input2);

  try {
    if (lead_input2 === "") {
      return res.status(400).json({ msg: "Fill side form" });
    }

    // Find the KYC record by lead_input1
    const existingKYC = await KYC.findOne({ where: { lead_no: lead_input2 } });

    const isSlotBooked = await CrmApt_record.findOne({
      where: { apt_date, apt_time, doctor },
    });


    console.log(existingKYC);
    if (existingKYC) {
      // Extract kycId from the found KYC record
      const kyc_id = existingKYC.id;


      if (isSlotBooked) {
        return res.status(400).json({
          msg: "⚠️ Selected time slot is already booked. Please choose another.",
        });
      }


      const dataToSave = { ...req.body, kyc_id };
      console.log(dataToSave);

      // Create a new KYC record with the data
      const newRecord = await CrmApt_record.create(dataToSave);

      const existingPatient = await CrmPatientStatus_record.findOne({
        where: { kyc_id: kyc_id },
      });

      const { apt_date, apt_status, remark } = req.body;

      const patientData = {
        clinic_id: clinicId,
        kyc_id: kyc_id,
        date: apt_date || "N/A",
        current_status: "Appointment", // Update status
        remark: remark || "N/A", // Ensure remark is always a string
      };


      if (existingPatient) {
        //* Update if patient already exists**
        await CrmPatientStatus_record.update(patientData, {
          where: { kyc_id: kyc_id },
        });
      } else {
        //* Create new record if not exists**
        await CrmPatientStatus_record.create(patientData);
      }

      const records = await CrmApt_record.findAll({ where: { kyc_id } });
      await sendMessageToAppointment(existingKYC, dataToSave);    // send appointment messsaging
      console.log(records);
      // records.reverse()
      return res.status(200).json({ data: records, id: newRecord.id }); // Return the newly created KYC record
    } else {
      // KYC record does not exist, return error
      return res.status(404).json({ msg: "KYC record not found" });
    }
  } catch (error) {
    console.error("Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

const apt3 = async (req, res) => {
  const clinicId = req.user.clinicId; // Get clinic_id from session

  if (clinicId == null) { // This checks for both null and undefined
    return res.status(400).send({ msg: 'Clinic ID is missing in the session.' });
  }

  req.body.clinic_id = clinicId;  // Use the clinic_id from session

  console.log(req.body);
  const { lead_input3, councelor } = req.body;

  try {
    if (lead_input3 == "") {
      return res.status(400).json({ msg: "Fill side form" });
    }

    // Find the KYC record by lead_input1
    const existingKYC = await KYC.findOne({ where: { lead_no: lead_input3 } });

    if (existingKYC) {
      // Extract kycId from the found KYC record
      const kyc_id = existingKYC.id;
      // existingKYC.lead_owner = councelor;
      // existingKYC.save();

      const dataToSave = { ...req.body, kyc_id };
      console.log(dataToSave);

      const newRecord = await CrmVis_record.create(dataToSave);
      const records = await CrmVis_record.findAll({ where: { kyc_id } });


      const existingPatient = await CrmPatientStatus_record.findOne({
        where: { kyc_id: kyc_id },
      });

      const { apt_date, visited_status, remark } = req.body;

      const patientData = {
        clinic_id: clinicId,
        kyc_id: kyc_id,
        date: apt_date || "N/A",
        current_status: visited_status, // Update status
        remark: remark || "N/A", // Ensure remark is always a string
      };


      if (existingPatient) {
        //* Update if patient already exists**
        await CrmPatientStatus_record.update(patientData, {
          where: { kyc_id: kyc_id },
        });
      } else {
        //* Create new record if not exists**
        await CrmPatientStatus_record.create(patientData);
      }

      console.log(records);
      return res.status(200).json({ data: records, id: newRecord.id }); // Return the newly created KYC record
    } else {
      // KYC record does not exist, return error
      return res.status(404).json({ msg: "KYC record not found" });
    }
  } catch (error) {
    console.error("Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

const apt4 = async (req, res) => {
  const clinicId = req.user.clinicId; // Get clinic_id from session

  if (clinicId == null) { // This checks for both null and undefined
    return res.status(400).send({ msg: 'Clinic ID is missing in the session.' });
  }



  req.body.clinic_id = clinicId;  // Use the clinic_id from session

  console.log(req.body);
  const { lead_input4 } = req.body;

  try {
    if (lead_input4 == "") {
      return res.status(400).json({ msg: "Fill side form" });
    }

    // Find the KYC record by lead_input1
    const existingKYC = await KYC.findOne({ where: { lead_no: lead_input4 } });

    if (existingKYC) {
      // Extract kycId from the found KYC record
      const kyc_id = existingKYC.id;

      const dataToSave = { ...req.body, kyc_id };
      console.log(dataToSave);

      const newRecord = await CrmConv_record.create(dataToSave);
      const records = await CrmConv_record.findAll({ where: { kyc_id } });
      console.log(records);
      return res.status(200).json({ data: records, id: newRecord.id }); // Return the newly created KYC record
    } else {
      // KYC record does not exist, return error
      return res.status(404).json({ msg: "KYC record not found" });
    }
  } catch (error) {
    console.error("Error occurred:", error);
    return res.status(500).json({ msg: "Internal server error" });
  }
};

// const updateLeadTag = async (req, res) => {
//   const { kyc_id, lead_tag } = req.body;

//   console.log("Lead TAG IS THIS:",kyc_id);


//   if (!kyc_id) {
//     return res.status(400).json({ error: "kyc_id and lead_tag are required" });
//   }

//   try {
//     // Find the patient record and update the lead_tag
//     const updatedRecord = await CrmPatientStatus_record.update(
//       { lead_tag },
//       { where: { kyc_id } }
//     );

//     console.log(updatedRecord);


//     if (updatedRecord[0] > 0) {
//       res.json({ status: "success", message: "Lead tag updated successfully" });
//     } else {
//       res.status(404).json({ error: "No record found for the given kyc_id" });
//     }
//   } catch (error) {
//     console.error("Error updating lead tag:", error);
//     res.status(500).json({ error: "Internal server error" });
//   }
// };

// Add this route in your Express.js setup

// const updateLeadTag = async (req, res) => {
//   let { kyc_id, lead_tag } = req.body;

//   console.log("Lead TAG IS THIS:", kyc_id);

//   if (!kyc_id) {
//     return res.status(400).json({ error: "kyc_id is required" });
//   }

//   // Convert empty string to null to avoid issues
//   if (lead_tag === "") {
//     lead_tag = null;
//   }

//   try {
//     // Update lead_tag in all related tables
//     const updatedRecords = await Promise.all([
//       CrmPatientStatus_record.update({ lead_tag }, { where: { kyc_id } }),
//       CrmFu_record.update({ lead_tag }, { where: { kyc_id } }),
//       CrmApt_record.update({ lead_tag }, { where: { kyc_id } }),
//       CrmVis_record.update({ lead_tag }, { where: { kyc_id } }),
//       CrmConv_record.update({ lead_tag }, { where: { kyc_id } })
//     ]);

//     console.log(updatedRecords);

//     // Check if at least one record was updated
//     const totalUpdates = updatedRecords.reduce((sum, record) => sum + record[0], 0);

//     if (totalUpdates > 0) {
//       res.json({ status: "success", message: "Lead tag updated successfully in all tables" });
//     } else {
//       res.status(404).json({ error: "No record found for the given kyc_id" });
//     }
//   } catch (error) {
//     console.error("Error updating lead tag:", error);
//     res.status(500).json({ error: "Internal server error" });
//   }
// };

const updateLeadTag = async (req, res) => {
  let { kyc_id, lead_tag } = req.body;

  console.log("Lead TAG IS THIS:", kyc_id);

  if (!kyc_id) {
    return res.status(400).json({ error: "kyc_id is required" });
  }

  // Convert empty string to null to avoid issues
  if (lead_tag === "") {
    lead_tag = null;
  }

  try {
    // Fetch the current_status from CrmPatientStatus_record
    const patientStatusRecord = await CrmPatientStatus_record.findOne({
      where: { kyc_id },
      attributes: ["current_status"],
    });

    if (!patientStatusRecord) {
      return res
        .status(404)
        .json({ error: "No record found for the given kyc_id" });
    }

    const { current_status } = patientStatusRecord;

    let updatedRecords = [];

    // Always update CrmPatientStatus_record
    updatedRecords.push(
      await CrmPatientStatus_record.update({ lead_tag }, { where: { kyc_id } })
    );

    // Conditionally update other tables based on current_status
    switch (current_status) {
      case "Follow Up":
        updatedRecords.push(
          await CrmFu_record.update({ lead_tag }, { where: { kyc_id } })
        );
        break;

      case "Appointment":
        updatedRecords.push(
          await CrmApt_record.update({ lead_tag }, { where: { kyc_id } })
        );
        break;

      case "Visited":
        updatedRecords.push(
          await CrmVis_record.update({ lead_tag }, { where: { kyc_id } })
        );
        break;

      case "booked":
      case "notbooked":
        updatedRecords.push(
          await CrmVis_record.update({ lead_tag }, { where: { kyc_id } })
        );
        break;

      case "Visited":
      case "cancelled":
        updatedRecords.push(
          await CrmConv_record.update({ lead_tag }, { where: { kyc_id } })
        );
        break;

      default:
        // Handle any unexpected status
        console.warn(`Unexpected current_status: ${current_status}`);
        break;
    }

    console.log(updatedRecords);

    // Check if at least one record was updated
    const totalUpdates = updatedRecords.reduce(
      (sum, record) => sum + record[0],
      0
    );

    if (totalUpdates > 0) {
      res.json({
        status: "success",
        message: "Lead tag updated successfully in relevant tables",
      });
    } else {
      res.status(404).json({ error: "No record found for the given kyc_id" });
    }
  } catch (error) {
    console.error("Error updating lead tag:", error);
    res.status(500).json({ error: "Internal server error" });
  }
};

const transferLead = async (req, res) => {
  // Extract leadIds and employee from the request body
  const { leadIds, employee } = req.body;

  // Validate inputs
  if (!leadIds || leadIds.length === 0) {
    return res.status(400).json({ msg: "No leads selected." });
  }
  if (!employee) {
    return res.status(400).json({ msg: "Employee is not provided." });
  }

  try {
    // Update each lead record concurrently using Promise.all
    await Promise.all(
      leadIds.map(async (id) => {
        await Leads.update(
          { isAlloted: true, lead_owner: employee },
          { where: { id } }
        );
      })
    );

    return res
      .status(200)
      .json({ success: true, message: "Leads updated successfully" });
  } catch (error) {
    console.error("Error updating leads:", error);
    return res
      .status(500)
      .json({ success: false, message: "Server error updating leads" });
  }
};

module.exports = { transferLead };

const activeSessions = {};

const JWT_SECRET = "ll";

// Login function with adjusted session data management
const login = async (req, res) => {
  const { userEmail, userPassword, clinicId } = req.body;

  console.log(req.body);

  try {
    // Step 1: Verify user credentials
    const user = await SuperAdmin.findOne({
      where: {
        username: userEmail,
        status: true,
      },
    });

    if (!user) {
      return res.status(404).json({ msg: "Admin not found" });
    }

    const inputPasswordHash = md5(userPassword);
    if (user.Password !== inputPasswordHash) {
      return res.status(401).json({ msg: "Invalid username or password" });
    }

    // Step 2: If no clinicId is provided, just confirm pre-authentication
    if (clinicId == null) {
      return res.status(200).json({
        msg: "Pre-authentication successful. Please select a clinic.",
        user: {
          id: user.id,
          username: user.username,
        },
      });
    }
    const clinic = await ClinicConfiguration.findByPk(clinicId);

    // Step 3: Check if user is already logged in elsewhere
    const existingToken = await UserTokens.findOne({
      where: { userId: user.id },
    });

    if (existingToken) {
      // await UserTokens.destroy({ where: { userId: user.id } });
      return res.status(409).json({ msg: "User already logged in elsewhere." });
      // return res.status(409).json({
      //   msg: "You are already logged in from another device. Do you want to terminate that session and continue?",
      //   userId: user.id, // Include user ID for later use
      // });
    }



    // Step 4: Generate JWT token
    const token = jwt.sign(
      {
        id: user.id,
        username: user.username,
        clinicId: clinic.id,
        role: clinic.main,
        clinicName: clinic.clinic_desc,
        rights: user.rights,
      },
      JWT_SECRET // Secret key stored in environment variable
    );

    // Step 5: Store token in HttpOnly cookie
    res.cookie("token", token, {
      maxAge: 6 * 30 * 24 * 60 * 60 * 1000
    });

    // Step 6: Save token in UserTokens table
    await UserTokens.create({
      userId: user.id,
      jwtToken: token,
      expiresAt: new Date(Date.now() + 3 * 60 * 60 * 1000), // Set token expiration to 3 hours
    });



    // Step 7: Send final login response
    res.status(200).json({
      msg: "Login successful",
      user: {
        id: user.id,
        username: user.username,
        clinicId: user.clinicId,
        rights: user.rights,
      },
    });
  } catch (error) {
    console.error("Error authenticating user:", error);
    res.status(500).json({ msg: "Error during login" });
  }
};

// Assuming you have a mechanism to store invalidated tokens
const invalidatedTokens = [];

const logout = async (req, res) => {
  const token = req.cookies.token; // Get token from HttpOnly cookie

  if (!token) {
    return res.status(400).json({ msg: "No token provided" });
  }

  try {
    const decoded = jwt.verify(token, JWT_SECRET);

    console.log(`decoded-id ${decoded.id}`);

    // Find and delete the token from the UserTokens table
    await UserTokens.destroy({
      where: { userId: decoded.id, jwtToken: token },
    });

    // Clear the token cookie
    res.clearCookie("token");

    // Destroy the session (if using sessions)
    req.session.destroy((err) => {
      if (err) {
        console.error("Failed to destroy session:", err);
        return res.status(500).json({ msg: "Error logging out" });
      }

      console.log(`Session cleared for user: ${decoded.username}`);
      return res.status(200).json({ msg: "Logout successful" });
    });
  } catch (err) {
    console.error("Error during logout:", err);
    return res.status(401).json({ msg: "Failed to authenticate token" });
  }
};

const logoutFromEverywhere = async (req, res) => {
  console.log('22')
  console.log(req.body);
  try {
    const { userEmail, userPassword, clinicId } = req.body;

    console.log(req.body);

    const user = await SuperAdmin.findOne({
      where: {
        username: userEmail,
        status: true,
      },
    });

    await UserTokens.destroy({
      where: { userId: user.id },
    });

    res.status(200).json({ 'message': 'successful' })

  } catch (error) {

  }
}

const register = async (req, res) => {
  console.log(req.body);
  const { userEmail, userPassword } = req.body;

  try {
    const existingUser = await Admin.findOne({ where: { userEmail } });
    if (existingUser) {
      return res.status(400).json({ message: "Username already exists" });
    }

    const passwordHash = md5(userPassword);
    await Admin.create({ userEmail, userPassword: passwordHash });

    res.status(200).json({ message: "User registered successfully" });
  } catch (error) {
    console.error("Error registering user:", error);
    res.status(500).json({ message: "Error registering user" });
  }
};

const getClinicsForUser = async (userClinicId, role) => {
  if (role == 1) {
    // If the user is an admin, fetch all clinics under the main clinic
    const subClinics = await ClinicConfiguration.findAll({
      where: { clinic_id: userClinicId },
    });

    // Return the clinic ID for the main clinic plus all sub-clinic IDs
    return [userClinicId, ...subClinics.map((c) => c.id)];
  }

  // If the user is a doctor, they only have access to their own clinic
  return [userClinicId];
};

const getAllNotRegisterPatientDetails = async (req, res) => {
  try {
    // Fetch all KYC records
    const clinicIds = await getClinicsForUser(req.user.clinicId, req.user.role);

    const kycRecords = await KYC.findAll({
      where: { clinic_id: clinicIds },
      include: [
        {
          model: Leads,
          as: "lead",
          attributes: { exclude: ["createdAt", "updatedAt"] },
        },
        {

          model: CrmPatientStatus_record,
          as: "crmPatientStatusRecords",
          attributes: { exclude: ["createdAt", "updatedAt"] },
        }
      ],
    });

    // Create an array to hold the combined KYC, Leads, and CRMvis_record data
    const combinedData = [];

    // console.log("combinedData",combinedData);

    for (const kyc of kycRecords) {
      const crmVisRecord = await CrmVis_record.findOne({
        where: { kyc_id: kyc.id },
      });

      const kycData = kyc.toJSON();
      const crmData = crmVisRecord ? crmVisRecord.toJSON() : {};

      // Combine KYC data with the CRMvis_record data
      combinedData.push({
        ...kycData,
        crmVisRecord: crmData, // Map the CRMvis_record data with the KYC data
      });
    }
    //console.log(combinedData);
    const encComb = combinedData.map((kycRecord) => {
      const encryptedId = encryptDataForUrl(kycRecord.id.toString());
      return {
        ...kycRecord, // Use kycRecord directly
        id: encryptedId,
      };
    });

    // Send a successful response with the combined data
    return res.status(200).json({
      success: true,
      data: encComb,
    });
  } catch (error) {
    console.error("Error fetching KYC details:", error);

    // Send an error response if something goes wrong
    return res.status(500).json({
      success: false,
      message: "Failed to fetch KYC details",
      error: error.message,
    });
  }
};

const getNotRegisteredDetails = async (req, res) => {
  try {
    const clinicIds = await getClinicsForUser(req.user.clinicId, req.user.role);
    const kycRecords = await KYC.findAll({
      where: {
        clinic_id: clinicIds,
      },
    });

    const patientsReg = await PR_patientReg.findAll({
      attributes: ["phone1"], // Include the phone1 field from PR_patientReg
    });

    const registeredPhones = patientsReg.map((patient) => patient.phone1);

    const combinedData = [];

    for (const kyc of kycRecords) {
      const crmVisRecord = await CrmVis_record.findOne({
        where: { kyc_id: kyc.id },
      });

      const kycData = kyc.toJSON();
      const crmData = crmVisRecord ? crmVisRecord.toJSON() : {};

      combinedData.push({
        ...kycData,
        crmVisRecord: crmData,
      });
    }

    const encComb = combinedData
      .filter((item) => !registeredPhones.includes(item.contact_no_wife))
      .map((kycRecord) => {
        const encryptedId = encryptDataForUrl(kycRecord.id.toString());
        return {
          ...kycRecord,
          id: encryptedId,
        };
      });

    return res.status(200).json({
      success: true,
      data: encComb,
    });
  } catch (error) {
    console.error("Error fetching KYC details:", error);
    return res.status(500).json({
      success: false,
      message: "Failed to fetch KYC details",
      error: error.message,
    });
  }
};

const fetchLeadsByStatus = async (req, res) => {
  try {
    const filter = req.query.filter;
    const leadOwner = req.query.leadOwner;
    let whereConditions = {};

    if (filter === "notAllotted") {
      whereConditions.isAlloted = false;
    } else if (filter === "allotted") {
      whereConditions.isAlloted = true;
    } else if (filter === "notApproached") {
      // For notApproached, we want to return only the data for the particular lead owner.
      if (leadOwner) {
        whereConditions.lead_owner = leadOwner;
        whereConditions.isApproached = false;
      } else {
        return res.status(400).json({
          success: false,
          message: "Lead owner is required for the notApproached filter.",
        });
      }
    }

    // Fetch data from the Leads table based on the conditions
    const leads = await Leads.findAll({
      where: whereConditions,
      attributes: [
        "id",
        "patient_name",
        "patient_email",
        "patient_id",
        "spouse_name",
        "phone_1",
        "phone_2",
        "location",
        "uhid",
        "lead_date",
        "isAlloted",
        "isApproached",
        "clinic",
        "doctor",
        "package",
        "status",
        "lead_owner",
        "source",
        "utm_source",
        "utm_medium",
        "utm_term",
        "utm_content",
        "utm_campaign",
        "date_of_approach",
      ],
      include: [
        {
          model: KYC,
          as: "kycDetails",
          attributes: { exclude: ["updatedAt"] }, // Exclude timestamps if not needed
          include: [
            {
              model: CrmPatientStatus_record,
              as: "crmPatientStatusRecords",
              attributes: { exclude: ["createdAt", "updatedAt"] }, // Exclude timestamps if not needed
            },
            {
              model: CrmVis_record,
              as: "crmVisRecords",
              attributes: { exclude: ["createdAt", "updatedAt"] },
            },
          ],
        },
      ],
    });



    // Return the fetched leads in the response
    return res.status(200).json({
      success: true,
      data: leads,
    });
  } catch (error) {
    console.error("Error fetching leads:", error);
    return res.status(500).json({
      success: false,
      message: "Failed to fetch leads",
      error: error.message,
    });
  }
};

const getLeadOwners = async (req, res) => {
  try {
    // Fetch all lead owners
    const leadOwners = await SuperAdmin.findAll({
      attributes: ["id", "username", "rights"], // Select only required fields
    });

    // Filter only those lead owners who have "3" in their rights array
    const filteredLeadOwners = leadOwners.filter(owner =>
      Array.isArray(owner.rights) && owner.rights.includes("3")
    );
    return res.status(200).json({
      success: true,
      data: filteredLeadOwners,
    });
  } catch (error) {
    console.error("Error fetching lead owners:", error);
    return res.status(500).json({ success: false, message: "Server error" });
  }
};

// const getKyc =async (req, res) => {
//   console.log(req.query)
//   const { kyc_id } = req.query;
// console.log(kyc_id)
//   try {
//     if (kyc_id) {
//       const kycData = await KYC.findByPk(kyc_id);

//       if (!kycData) {
//         console.error('record not found:', kyc_id);
//         return res.status(404).render('error', { message: 'record not found' });
//       }

//       const kycValues = kycData.get({ plain: true });
//       console.log('Department values:', kycValues);
//       return res.render('form-new', { a: kycValues });
//     } else {
//       return res.render('form-new', { a: '' });
//     }
//   } catch (error) {
//     console.error('Error fetching  data:', error);
//     return res.status(500).render('error', { message: 'Internal Server Error' });
//   }
// }

const allFilterPatient = async (req, res) => {
  const patient = await PR_patientReg.findAll();
  console.log(patient);

  return res.json(patient);
};

const filterAllKYCDetailsTwo = async (req, res) => {
  try {
    const { fromDate, toDate, clinic, city, doctor } = req.query;

    // Get the user's clinic access rights
    const clinicIds = await getClinicsForUser(req.user.clinicId, req.user.role);

    // Build the where clause dynamically
    let whereClause = {
      clinic_id: {
        [Sequelize.Op.in]: clinicIds,
      },
    };

    if (fromDate && toDate) {
      whereClause.lead_date = {
        [Sequelize.Op.between]: [new Date(fromDate), new Date(toDate)],
        //[Op.lte`]: new Date(toDate)
      };
    }
    if (clinic) {
      whereClause.clinic_id = clinic;
    }

    if (doctor) {
      whereClause.doctor = doctor;
    }

    // if (source) {
    //   whereClause.source = source;
    // }
    if (city) {
      whereClause.city = city;
    }

    // Fetch filtered KYC records
    const kycRecords = await KYC.findAll({
      where: whereClause,
    });
    //console.log(kycRecords);

    // Create an array to hold the combined KYC and CRMvis_record data
    const combinedData = [];

    // Loop through each KYC record
    for (const kyc of kycRecords) {
      // Fetch related record from CRMvis_record by kyc_id
      const crmVisRecord = await CrmVis_record.findOne({
        where: { kyc_id: kyc.id },
      });

      // If a corresponding CRMvis_record is found, combine it with the KYC data
      const kycData = kyc.toJSON(); // Convert the Sequelize instance to plain JSON
      const crmData = crmVisRecord ? crmVisRecord.toJSON() : {}; // Convert to JSON if exists

      // Combine KYC data with the CRMvis_record data
      combinedData.push({
        ...kycData,
        crmVisRecord: crmData, // Map the CRMvis_record data with the KYC data
      });
    }

    // Encrypt IDs before sending
    const encComb = combinedData.map((kycRecord) => {
      const encryptedId = encryptDataForUrl(kycRecord.id.toString());
      return {
        ...kycRecord, // Use kycRecord directly
        id: encryptedId,
      };
    });

    // Send a successful response with the combined data
    return res.status(200).json({
      success: true,
      data: encComb,
    });
  } catch (error) {
    console.error("Error fetching filtered KYC details:", error);

    // Send an error response if something goes wrong
    return res.status(500).json({
      success: false,
      message: "Failed to fetch KYC details",
      error: error.message,
    });
  }
};

const filterRegisterPatient = async (req, res) => {
  try {
    const { fromDate, toDate, clinic: clinic, city, doctor } = req.query;

    // Set up the 'createdAt' filter only if both dates are present
    const filters = {};

    if (fromDate && toDate) {
      filters.createdAt = {
        [Sequelize.Op.between]: [new Date(fromDate), new Date(toDate)],
      };
    }

    // Check if other filters are provided and add them to the `where` clause
    if (clinic) filters.clinic_id = clinic;
    if (city) filters.city = city;
    if (doctor) filters.doctor = doctor;

    console.log("Filters", filters); // Log for debugging purposes

    // Fetch patient records with the dynamically constructed whereClause filter
    const pr_PatientRecords = await PR_patientReg.findAll({
      where: filters,
    });

    // Respond with the filtered patient data
    return res.json({ status: true, data: pr_PatientRecords });
  } catch (error) {
    // Log the error for better debugging
    console.error("Error occurred:", error);
    return res.status(500).json({ status: false, message: error.message });
  }
};

const transferPatient = async (req, res) => {
  try {
    const { patientId, clinic: nextClinic } = req.body;

    // Validate patientId is an array and not empty
    if (!Array.isArray(patientId) || patientId.length === 0) {
      return res
        .status(400)
        .json({ message: "Invalid or empty patient ID array" });
    }

    // Fetch new clinic details
    const { id: nextClinicId } = await ClinicConfiguration.findOne({
      where: { clinic_desc: nextClinic },
      attributes: ["id"],
    });
    if (!nextClinicId) {
      return res.status(404).json({ message: "Clinic not found" });
    }

    // Fetch previous clinic details
    // const prevClinicData = await ClinicConfiguration.findOne({ where: { clinic_desc: prevClinic } });
    // if (!prevClinicData) {
    //     return res.status(404).json({ message: "Previous clinic not found" });
    // }

    const transferResults = [];

    // Process each patient in the array
    for (const id of patientId) {
      console.log("Processing patient ID:", id);

      const patient = await PR_patientReg.findByPk(id);
      if (!patient) {
        console.warn(`Patient ID ${id} not found`);
        transferResults.push({
          id,
          status: "Failed",
          message: "Patient not found",
        });
        continue;
      }

      const prevClinicID = patient.clinic_id;
      // console.log("patientPrevious--",patientPrevious);

      const prevClinic = await ClinicConfiguration.findOne({
        where: { id: prevClinicID },
      });
      // console.log("prevClinicId",prevClinicId);

      const previousClinicName = prevClinic.clinic_desc;
      // console.log("previousClinicName",previousClinicName);
      const previousClinics = patient.previous_clinics?.length
        ? [
            ...patient.previous_clinics,
            { id: prevClinicID, name: previousClinicName },
          ]
        : [{ id: prevClinicID, name: previousClinicName }];

      const transferDetails = `${patient.mr_no}-PT-${previousClinicName}`;

      // Update patient record
      await patient.update({
        previous_clinics: previousClinics,
        transfer_id: transferDetails,
        clinic_id: nextClinicId,
      });

      transferResults.push({
        id,
        status: "Success",
        transferDetails,
        nextClinicId,
        previousClinics,
      });
    }

    return res.status(200).json({
      message: "Patient transfer process completed",
      results: transferResults,
    });
  } catch (error) {
    console.error("Error transferring patient:", error);
    return res.status(500).json({ message: "Server error" });
  }
};

const allRegisterPatient = async (req, res) => {
  // let patientRegisterData = [];
  // let crmRecord = [];
  // return res.json(patientRegisterData);

  try {
    const clinicIds = await getClinicsForUser(req.user.clinicId, req.user.role);

    console.log("clinicIds", clinicIds);
    //throw new Error("clinicids is not a number!");

    //console.log("clinic ids are", clinicIds);

    const kycRecords = await KYC.findAll({
      // where: {
      //   clinic_id: clinicIds,
      // },
      // include:[
      //  {
      //   model:CrmVis_record,
      //   as:'CrmVis_records',
      //   attributes:["uhid_no","apt_date","clinic"]
      //  }
      // ]
    });
    const kycData = [];
    for (let index = 0; index < kycRecords.length; index++) {
      const entry = kycRecords[index].toJSON();
      kycData.push(entry);
    }
    //console.log("kycRecords", kycRecords);

    // const combinedData = [];

    // for (const kyc of kycRecords) {
    //   const crmVisRecord = await CrmVis_record.findOne({
    //     where: { kyc_id: kyc.id },
    //   });

    //   const kycData = kyc.toJSON();
    //   const crmData = crmVisRecord ? crmVisRecord.toJSON() : {};

    //   // Combine KYC data with the CRMvis_record data
    //   combinedData.push({
    //     ...kycData,
    //     crmVisRecord: crmData, // Map the CRMvis_record data with the KYC data
    //   });
    // }
    console.log("here");

    //console.log('combined',combinedData);

    const patients = await PR_patientReg.findAll({
      where: {
        clinic_id: clinicIds,
      },
    });
    const patientData = [];

    for (let index = 0; index < patients.length; index++) {
      const entry = patients[index].toJSON();
      patientData.push(entry);
    }

    patientData.forEach((patient) => {
      patient.kycDetails = kycData.find(
        (entry) =>
          entry.contact_no_wife === patient.phone1 ||
          entry.contact_no_husband === patient.phone1
      );
    });

    //const combinedData = [];

    for (const patient of patientData) {
      const kyc_id = patient?.kycDetails?.id;
      if (kyc_id) {
        const crmVisRecord = await CrmVis_record.findOne({
          where: { kyc_id: kyc_id },
        });

        const crmData = crmVisRecord ? crmVisRecord.toJSON() : {};

        patient.kycDetails.crmVisRecord = crmData;
      }
    }

    return res.json(patientData);
  } catch (error) {
    console.log(error);

    return res.json([]);
  }
};

const getAllKYCDetails = async (req, res) => {
  try {
    // Fetch all KYC records
    const clinicIds = await getClinicsForUser(req.user.clinicId, req.user.role);

    console.log("User Rights", req.user.rights);

    const kycRecords = await KYC.findAll({
      where: { clinic_id: clinicIds },
      include: [
        {
          model: Leads,
          as: "lead",
          attributes: { exclude: ["createdAt", "updatedAt"] },
        },
        {
          model: CrmPatientStatus_record,
          as: "crmPatientStatusRecords",
          attributes: { exclude: ["createdAt", "updatedAt"] },
        },
      ],
    });

    // Create an array to hold the combined KYC, Leads, and CRMvis_record data
    const combinedData = [];

    // Loop through each KYC record
    for (const kyc of kycRecords) {
      // Fetch related record from CRMvis_record by kyc_id
      const crmVisRecord = await CrmVis_record.findOne({
        where: { kyc_id: kyc.id },
      });

      // Convert Sequelize instances to plain JSON
      const kycData = kyc.toJSON();
      const crmData = crmVisRecord ? crmVisRecord.toJSON() : {};
      const leadData = kyc.lead ? kyc.lead.toJSON() : {}; // Get associated lead data

      // Combine KYC data with the CRMvis_record and Leads data
      combinedData.push({
        ...kycData,
        crmVisRecord: crmData,
        lead: leadData, // Attach lead details
      });
    }

    // Encrypt IDs for frontend use
    const encComb = combinedData.map((kycRecord) => {
      const encryptedId = encryptDataForUrl(kycRecord.id.toString());
      return {
        ...kycRecord,
        id: encryptedId,
      };
    });

    // Send a successful response with the combined data
    return res.status(200).json({
      success: true,
      data: encComb,
    });
  } catch (error) {
    console.error("Error fetching KYC details:", error);

    // Send an error response if something goes wrong
    return res.status(500).json({
      success: false,
      message: "Failed to fetch KYC details",
      error: error.message,
    });
  }
};

module.exports = {
  bankBranchMasterCtrl,
  cashCounterMasterCtrl,
  classificationCtrl,
  clinicConfigCtrl,
  getCountry,
  getState,
  getCity,
  departmentCtrl,
  docCatCtrl,
  getClassification,
  getDocCat,
  docInfoCtrl,
  getDocinfo,
  getDesginfo,
  emrCCCtrl,
  emrfieldCtrl,
  getEmrInfo,
  getEmrFieldInfo,
  primSympCtrl,
  getPrimSymp,
  regMasterCtrl,
  getRegion,
  subSpecCtrl,
  kycCtrl,
  dashboardCtrl,
  modifyApt,
  modifyVisit,
  apt1,
  apt2,
  apt3,
  apt4,
  updateLeadTag,
  login,
  register,
  logoutFromEverywhere,
  logout,
  getNotRegisteredDetails,
  fetchFU,
  fetchApt,
  fetchVisits,
  fetchConv,
  filterAllKYCDetailsTwo,
  allRegisterPatient,
  getAllNotRegisterPatientDetails,
  filterRegisterPatient,
  transferPatient,
  getLeadOwners,
  fetchLeadsByStatus,
  transferLead,
  getLeadByKycId,
  allFilterPatient,
  getAllKYCDetails,
};
