const { ConsentPatientUser } = require("../models/table_concent_User");

async function checkConsentForm(requiredFormName, patientId) {
  try {
    const consentRecord = await ConsentPatientUser.findOne({
      where: { patientID: patientId },
      attributes: ["formNames"],
    });

    if (!consentRecord) {
      return false;
    }

    // Parse formNames if it’s a JSON string, or default to an empty array if null
    const filledForms = consentRecord.formNames;

    // Loop through filled forms to check for required form
    for (let i = 0; i < filledForms.length; i++) {
      if (filledForms[i].name === requiredFormName) {
        return true; // Proceed if form is found
      }
    }

    // If no form with the required name was found, redirect
    return false;
  } catch (error) {
    console.error("Error checking consent form:", error);
    return "false";
  }
}

module.exports = checkConsentForm;
