const { PatientCounseling, Donor } = require("../models/embrology.js");
const checkConsentForm = require("./consent.js");
const crypto = require("crypto");

function decryptDataFromUrl(encryptedData) {
  try {
    const algorithm = "aes-256-cbc";
    const secretKey = Buffer.from("ll".repeat(16)); // The same 32-byte key used for encryption

    // Split the encrypted data to get the IV and the actual encrypted text
    const [ivHex, encryptedText] = encryptedData.split(":");
    const iv = Buffer.from(ivHex, "hex");

    // Create decipher instance
    const decipher = crypto.createDecipheriv(algorithm, secretKey, iv);
    let decrypted = decipher.update(encryptedText, "hex", "utf8");
    decrypted += decipher.final("utf8");

    return decrypted;
  } catch (error) {
    console.error("Decryption failed:", error);
    return false;
  }
}


const patientFinder = async (req, res, next) => {
  try {
    

    if (req.query.id) {
      const id = decryptDataFromUrl(req.query.id);
      if (id) {
        const data = await Donor.findOne({ where: { id: id } });
        
        if (data) {
          res.clearCookie('spermDonor');
          req.session.treatmentType = 'donor';
          res.cookie('currentPage', data.current_page);
          req.session.DonorId = id;
          res.cookie('treatment', 'donor');
          return next();
        } else {
          res.redirect('/embrology/62');
        }
      }
    }
    res.clearCookie('treatment');
    // Check if patient ID is stored in session
    if (!req.session.rowId) {

      return res.redirect("/findpatient/6");
    }


    // Set patient ID
    req.session.patientId = req.session.rowId;

    //concent work
    // let checkConsent = true;
    // if(req.url == '/50'){
    //   checkConsent = checkConsent && await checkConsentForm("form10",req.session.patientId)
    //   checkConsent = checkConsent && await checkConsentForm("form12",req.session.patientId)
    // }
    // if(req.url == '/8'){
    //   console.log(await checkConsentForm('form14B',req.session.patientId))
    //   checkConsent = checkConsent && await checkConsentForm("form14B",req.session.patientId);
    // }
    // if(!checkConsent){
    //   return res.redirect(`/embrology/concent`)
    // }

    //end of concent

    // Find Patient Counseling record with `status: true`
    const patientRecord = await PatientCounseling.findOne({
      where: { patientId: req.session.patientId, status: true, clinicId: req.user.clinicId, },
      attributes: ["currentPage", "cycle_id", "mrn", 'treatmentType', 'spermDonor', 'oocyteDonor', 'frozenOocyte', 'donorId'],
    });
    if (patientRecord) {
      // Set cycle_id if MRN is present
      if (patientRecord.mrn) {
        req.session.cycle_id = patientRecord.cycle_id;
      } else if (req.url == '/199' || req.url == '/6') {
        res.cookie("currentPage", "counselling");
        // res.cookie("spermDonor", patientRecord);
        // res.cookie("oocyteDonor", patientRecord);
        return next();
      } else {
        res.cookie("currentPage", "counselling");
        return res.redirect("/embrology/199");
      }

      let treatmentType = patientRecord.treatmentType;
      req.session.treatmentType = patientRecord.treatmentType;
      res.cookie("frozenOocyte", patientRecord.frozenOocyte);
      req.session.frozenOocyte = patientRecord.frozenOocyte;
      req.session.DonorId = patientRecord.donorId;
      let cases = [];

      if (patientRecord.frozenOocyte) {
        cases = [
          "patientEmr",
          "counselling",
          "concent",
          "cycle",
          "overview",
          "thawing",
          "sperm",
          "culture",
          "et",
          "outcome", // Now for IVF
        ];
      } else if (treatmentType === "IUI") {
        cases = [
          "patientEmr",
          "counselling",
          "concent",
          "cycle",
          "overview",
          "stimulation",
          "sperm",
          "outcome", // Now for IUI
        ];
      } else if (treatmentType === 'Ovum-Freezing') {
        cases = [
          "patientEmr",
          "counselling",
          "concent",
          "cycle",
          "overview",
          "stimulation",
          "opu"
        ];
      } else if (treatmentType === 'Embryo-Freezing') {
        cases = [
          "patientEmr",
          "counselling",
          "concent",
          "cycle",
          "overview",
          "stimulation",
          "opu",
          "sperm",
          "culture"
        ];
      } else if (treatmentType === 'Sperm-Freezing') {
        cases = [
          "patientEmr",
          "counselling",
          "concent",
          "cycle",
          "overview",
          "sperm"
        ];
      } else {
        // Assume IVF by default
        cases = [
          "patientEmr",
          "counselling",
          "concent",
          "cycle",
          "overview",
          "stimulation",
          "opu",
          "sperm",
          "culture",
          "et",
          "outcome", // Now for IVF
        ];
      }

      const menuItems = {
        concent: "/embrology/concent",
        patientEmr: "/embrology/6",
        overview: "/embrology/44",
        counselling: "/embrology/199",
        cycle: "/embrology/71",
        stimulation: "/embrology/19",
        opu: "/embrology/50",
        sperm: "/embrology/34",
        culture: "/embrology/8",
        et: "/embrology/91",
        outcome: "/embrology/31",
        thawing: "/embrology/1000"
      };

      // Retrieve the current page from cookies or initialize it
      const cookiePage = patientRecord.currentPage;
      res.cookie("currentPage", cookiePage);
      res.cookie("spermDonor", patientRecord.spermDonor);
      res.cookie("oocyteDonor", patientRecord.oocyteDonor);
      req.session.spermDonor = patientRecord.spermDonor;
      req.session.oocyteDonor = patientRecord.oocyteDonor;
      let i;
      let urlSite = "/embrology" + req.url;
      for (i = 0; i < cases.length; i++) {
        if (cases[i] === cookiePage) {
          break;
        }
        if (menuItems[cases[i]] === urlSite) {
          return next();
        }
      }
      if (menuItems[cases[i]] === urlSite) {
        return next();
      }
      let l = cases[i];
      i++;
      if (i < cases.length) {
        return res.redirect(menuItems[l]);
      }
      if (i == cases.length) {
        return res.redirect('/embrology/71');
      }
    } else {
      if (req.url == '/6') {
        res.cookie("currentPage", "patientEmr");
      } else {
        res.cookie("currentPage", "patientEmr");
        return res.redirect("/embrology/6");
      }
      return next();
    }



  } catch (err) {
    console.error("Error in patientFinder middleware:", err);
    res.status(500).send("Internal server error");
  }
};

module.exports = {
  patientFinder,
};
