const { DataTypes, INTEGER } = require("sequelize");
const { sequelize } = require("../sequelize");

const MarkVisit = sequelize.define(
  "MarkVisit",
  {
    patientid: {
      type: DataTypes.INTEGER,
      allowNull: false,
      comment: "Unique identifier for the patient", // Add descriptive comments for clarity
    },
    date: {
      type: DataTypes.DATE,
      allowNull: false,
      comment: "Date of the visit",
    },
    doctor: {
      type: DataTypes.STRING(100),
      allowNull: false,
      comment: "Name of the doctor attending the visit",
    },
  },
  {
    timestamps: true, // Adds createdAt and updatedAt fields
    underscored: true, // Ensures column names use snake_case
    tableName: "mark_visit", // Explicit table name
  }
);
// MarkVisit.sync({ alter: true });

module.exports = { MarkVisit };
