const { DataTypes, Sequelize } = require("sequelize");
const { sequelize } = require("../sequelize");


const Menu = sequelize.define(
  "Menu",
  {
    menu_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
    },
    menu_name: DataTypes.STRING,
    menu_parent: DataTypes.INTEGER,
    menu_dept: DataTypes.STRING,
    menu_master: DataTypes.BOOLEAN,
    menu_url: DataTypes.STRING,
  },
  {
    tableName: "tbl_menu",
    timestamps: false, // Assuming you don't have timestamps in the table
  }
);

// Menu.sync({alter:true});  

const SuperAdmin = sequelize.define(
  "superadmin",
  {
    username: {
      type: DataTypes.STRING,
    },
    Password: {
      type: DataTypes.STRING,
    },
    clinicName: {
      type: DataTypes.STRING,
    },
    clinicId: {
      type: DataTypes.STRING,
    },
    mobileNumber: {
      type: DataTypes.STRING,
    },
    createdBy: {
      type: DataTypes.STRING,
    },
    rights: {
      type: DataTypes.JSON,
    },
    Freeze: {
      type: DataTypes.BOOLEAN,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    
  },
  {
    timestamps: true,
    alter: true,
    tableName: "superadmin",
  }
);
// SuperAdmin.sync({alter:true})
// SuperAdmin.sync()

const UserTokens = sequelize.define(
  "usertokens",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    userId: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: "SuperAdmin", // Reference to the SuperAdmin table
        key: "id",
      },
      onDelete: "CASCADE", // On delete cascade
    },
    jwtToken: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    createdAt: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    expiresAt: {
      type: DataTypes.DATE,
      allowNull: true, // Optional, set if token expiry is used
    },
  },
  {
    alter: true,
    timestamps: false, // If you want to manage the timestamps manually
    tableName: "usertokens",
  }
);

  // sequelize.sync()
module.exports = { SuperAdmin, UserTokens, Menu };
