const { DataTypes } = require("sequelize");
const { sequelize } = require("../sequelize");

const TempTable = sequelize.define(
  "TempTable",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },

    uniqueId: { type: DataTypes.UUID },
    path: { type: DataTypes.STRING, unique: true },
    name: { type: DataTypes.STRING, unique: true },
    originalName: { type: DataTypes.STRING },
    mimeType: { type: DataTypes.STRING },
    size: { type: DataTypes.INTEGER },
  },
  {
    timestamps: true,
    tableName: "temp_table",
  }
);

// TempTable.sync({ alter: true });

module.exports = { TempTable };
