const { DataTypes } = require("sequelize");
const { sequelize } = require("../sequelize");

const KYC = sequelize.define(
  "KYC",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    lead_id: { type: DataTypes.STRING },
    clinic_id: { type: DataTypes.STRING, defaultValue: "0" },
    lead_no: { type: DataTypes.STRING ,allowNull:true},
    lead_date: { type: DataTypes.DATE },
    patient_name: { type: DataTypes.STRING },
    patient_age: { type: DataTypes.INTEGER },
    patient_gender: { type: DataTypes.STRING },
    spouce_name: { type: DataTypes.STRING },
    spouce_age: { type: DataTypes.INTEGER },
    married_life: { type: DataTypes.INTEGER },
    contact_no_wife: { type: DataTypes.STRING }, // Assuming phone numbers can be stored as strings
    contact_no_husband: { type: DataTypes.STRING },
    whatsapp_no: { type: DataTypes.STRING },
    email_id: { type: DataTypes.STRING },
    country: { type: DataTypes.STRING },
    area: { type: DataTypes.STRING },
    city: { type: DataTypes.STRING },
    state: { type: DataTypes.STRING },
    pincode: { type: DataTypes.INTEGER },
    past_history: { type: DataTypes.JSON }, // Assuming past_history can be stored as JSON data type
    source: { type: DataTypes.STRING },
    campaign: { type: DataTypes.STRING },
    lead_owner: { type: DataTypes.STRING },
    address: { type: DataTypes.STRING(500) },
    reference: { type: DataTypes.STRING },
  },
  {
    tableName: "kycs",
    timestamps: true,
    alter: true
    // Other model options if needed
  }
);
//reports
//KYC.sync({alter:true})
const kycReports = sequelize.define(
  "kycReports",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    kyc_id: { type: DataTypes.STRING },
    report: { type: DataTypes.STRING },
    remark: { type: DataTypes.STRING },
  },
  {
    tableName: "kycreports",
    timestamps: true,
  }
);

const Leads = sequelize.define(
  "Leads",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    patient_name: {
      type: DataTypes.STRING,
    },
    patient_email: {
      type: DataTypes.STRING,
      validate: {
        isEmail: true,
      },
    },
    patient_id: {
      type: DataTypes.STRING,
    },
    spouse_name: {
      type: DataTypes.STRING,
    },
    uhid: {
      type: DataTypes.STRING,
    },
    phone_1: {
      type: DataTypes.STRING,
    },
    phone_2: {
      type: DataTypes.STRING,
    },
    location: {
      type: DataTypes.STRING,
    },
    lead_date: {
      type: DataTypes.DATE,
    },
    isAlloted: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    isApproached: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    source: {
      type: DataTypes.STRING,
    },
    clinic: {
      type: DataTypes.STRING,
    },
    doctor: {
      type: DataTypes.STRING,
    },
    package: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.STRING,
    },
    lead_owner: {
      type: DataTypes.STRING,
    },
    utm_source: {
      type: DataTypes.STRING,
    },
    utm_medium: {
      type: DataTypes.STRING,
    },
    utm_term: {
      type: DataTypes.STRING,
    },
    utm_content: {
      type: DataTypes.STRING,
    },
    utm_campaign: {
      type: DataTypes.STRING,
    },
    date_of_approach: {
      type: DataTypes.DATE,
    },
    extra_data: {
      type: DataTypes.JSON,
      allowNull: true,
    },

  },
  {
    tableName: "leads",
    timestamps: true,
    alter: true
  }
);

// Sync command
// Leads.sync({ alter: true })

// CrmFu_record model

const CrmFu_record = sequelize.define(
  "CrmFu_record",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    kyc_id: { type: DataTypes.STRING },
    remark: { type: DataTypes.STRING(500) },
    fu_status: { type: DataTypes.STRING },
    lead_tag: { type: DataTypes.STRING },
    fu_next_call: { type: DataTypes.STRING },
    fu_next_call_time: { type: DataTypes.STRING },
  },
  {
    tableName: "crmfu_records",
    timestamps: true,
    alter: true,
  }
);
// CrmFu_record.sync({alter:true})
const CrmApt_record = sequelize.define(
  "CrmApt_record",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    kyc_id: { type: DataTypes.STRING },
    clinic: { type: DataTypes.STRING },
    doctor: { type: DataTypes.STRING },
    lead_tag: { type: DataTypes.STRING },
    apt_date: { type: DataTypes.DATE },
    apt_time: { type: DataTypes.STRING },
    apt_status: { type: DataTypes.STRING },
  },
  {
    tableName: "crmapt_records",
    timestamps: true,
    alter: true,
    // Other model options if needed
  }
);
// CrmApt_record.sync({alter:true})
const CrmVis_record = sequelize.define(
  "CrmVis_record",
  {
    clinic_id:
    {
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    kyc_id: { type: DataTypes.STRING },
    uhid_no: { type: DataTypes.STRING },
    apt_date: { type: DataTypes.STRING },
    clinic: { type: DataTypes.STRING },
    doctor: { type: DataTypes.STRING },
    councelor: { type: DataTypes.STRING },
    treatment: { type: DataTypes.STRING },
    lead_tag: { type: DataTypes.STRING },
    package: { type: DataTypes.STRING },
    visited_status: { type: DataTypes.STRING },
    remark: { type: DataTypes.STRING },
    next_call: { type: DataTypes.DATE, allowNull: true },
  },
  {
    tableName: "crmvis_records",
    timestamps: true,
    alter: true,
    // Other model options if neede
  }
);
// CrmVis_record.sync({alter:true})
const CrmConv_record = sequelize.define(
  "CrmConv_record",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0
    },
    kyc_id: { type: DataTypes.STRING },

    uhid_no: { type: DataTypes.STRING },
    lead_tag: { type: DataTypes.STRING },
    clinic: { type: DataTypes.STRING },
    doctor: { type: DataTypes.STRING },

    treatment: { type: DataTypes.STRING },
    package: { type: DataTypes.STRING },
    con_date: { type: DataTypes.STRING },
  },
  {
    tableName: "crmconv_records",
    timestamps: true,
    alter: true,
    // Other model options if needed
  }
);

const CrmPatientStatus_record = sequelize.define(
  "CrmPatientStatus_record",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    kyc_id: {
      type: DataTypes.STRING,
    },
    date: {
      type: DataTypes.STRING
    },
    lead_tag: {
      type: DataTypes.STRING
    },
    remark: {
      type: DataTypes.STRING(500)
    },
    current_status: {
      type: DataTypes.STRING
    },
  },
  {
    tableName: "crmpatientstatus_records",
    alter: true,
    timestamps: true,
  }
);

// CrmPatientStatus_record.sync({ alter: true });

// CrmConv_record.sync({alter:true})
const Admin = sequelize.define(
  "Admin",
  {
    userId: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    userName: {
      type: DataTypes.STRING,
    },
    userEmail: {
      type: DataTypes.STRING,
    },
    userMobile: {
      type: DataTypes.STRING,
    },
    userPassword: {
      type: DataTypes.STRING,
    },
    userRole: {
      type: DataTypes.STRING,
    },
    userStatus: {
      type: DataTypes.BOOLEAN,
    },
    clinicId: {
      type: DataTypes.STRING,
    },
  },
  {
    tableName: "admins",
    timestamps: true,
    alter: true
  }
);

// Sync the model with the database
// sequelize.sync();


// Leads has one KYC record
Leads.hasOne(KYC, {
  foreignKey: "lead_id",
  as: "kycDetails"
});

KYC.belongsTo(Leads, {
  foreignKey: "lead_id",
  as: "lead"
});

// KYC has many CrmPatientStatus_records
KYC.hasMany(CrmPatientStatus_record, {
  foreignKey: "kyc_id",
  as: "crmPatientStatusRecords"  // Unique alias
});

CrmPatientStatus_record.belongsTo(KYC, {
  foreignKey: "kyc_id",
  as: "kycPatientStatus"  // Unique alias
});

// KYC has many CrmFu_records
KYC.hasMany(CrmFu_record, {
  foreignKey: "kyc_id",
  as: "crmFuRecords"
});
CrmFu_record.belongsTo(KYC, {
  foreignKey: "kyc_id",
  as: "kyc"
});

// KYC has many CrmApt_records
KYC.hasMany(CrmApt_record, {
  foreignKey: "kyc_id",
  as: "crmAptRecords"
});
CrmApt_record.belongsTo(KYC, {
  foreignKey: "kyc_id",
  as: "kyc"
});

// KYC has many CrmVis_records
KYC.hasMany(CrmVis_record, {
  foreignKey: "kyc_id",
  as: "crmVisRecords"
});
CrmVis_record.belongsTo(KYC, {
  foreignKey: "kyc_id",
  as: "kyc"
});

// KYC has many CrmConv_records
KYC.hasMany(CrmConv_record, {
  foreignKey: "kyc_id",
  as: "crmConvRecords"
});
CrmConv_record.belongsTo(KYC, {
  foreignKey: "kyc_id",
  as: "kyc"
});

KYC.hasMany(CrmPatientStatus_record, {
  foreignKey: "kyc_id",
  as: "CrmPatientStatus_record"
});
CrmPatientStatus_record.belongsTo(KYC, {
  foreignKey: "kyc_id",
  as: "kyc"
});



module.exports = {
  KYC,
  Admin,
  Leads,
  CrmFu_record,
  CrmApt_record,
  CrmVis_record,
  CrmConv_record,
  CrmPatientStatus_record,
  kycReports,

};
