const { DataTypes } = require("sequelize");
const { sequelize } = require("../sequelize"); 

const UserTokens = sequelize.define(
  "usertokens",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    userId: {
      type: DataTypes.INTEGER,
      allowNull: false,
      references: {
        model: "SuperAdmin", // Reference to the SuperAdmin table
        key: "id",
      },
      onDelete: "CASCADE", // On delete cascade
    },
    jwtToken: {
      type: DataTypes.TEXT,
      allowNull: false,
    },
    createdAt: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
    expiresAt: {
      type: DataTypes.DATE,
      allowNull: true, // Optional, set if token expiry is used
    },
  },
  {
    timestamps: false, // If you want to manage the timestamps manually
    tableName: "usertokens",
  }
);

// sequelize.sync({alter:true});

module.exports = { UserTokens };
