const { DataTypes, INTEGER } = require("sequelize");
const { sequelize } = require("../sequelize");

const DonorVisit = sequelize.define(
  "DonorVisit",
  {
    donorId: {
      type: DataTypes.STRING,
      primaryKey: true,
      allowNull: false,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    donorVisitNo: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    donorVisitDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    clinic: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    uhid: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    donorAccountName: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    doctorName: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    age: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    ageRemark: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    totalChildren: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0, // Set default to 0
    },
    totalMaleChildren: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0, // Set default to 0
    },
    totalFemaleChildren: {
      type: DataTypes.INTEGER,
      allowNull: true,
      defaultValue: 0, // Set default to 0
    },
    gameteName: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    lastRegistrationDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    lastPickupDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    remarks: {
      type: DataTypes.STRING,
      allowNull: true,
    },
  },
  {
    tableName: "emb_donor_visits",
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);

const Donor = sequelize.define(
  "Donor",
  {
    donorId: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    code: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    eye_color: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    skin_color: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    hair_color: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    bone_structure: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    height: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    blood_group: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    referral_type: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    agency_name: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    current_page: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    viral_marker: {
      type: DataTypes.STRING(100),
    },
    betaThalassemia: {
      type: DataTypes.STRING,
    },
    chlamydia: {
      type: DataTypes.STRING,
    },
    DFI: {
      type: DataTypes.STRING,
    },
  },
  {
    timestamps: true,
    underscored: true,
    tableName: "emb_donors",
  }
);

const DonorOocyte = sequelize.define(
  "DonorOocyte",
  {
    donorId: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    dob: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    code: {
      type: DataTypes.STRING(50),
      allowNull: false,
    },
    donor_name: {
      type: DataTypes.STRING(100), // New field for donor's name
      allowNull: false,
    },
    identity_card_type: {
      type: DataTypes.STRING(50), // New field for identity card type
      allowNull: false,
    },
    identity_card_number: {
      type: DataTypes.STRING(50), // New field for identity card number
      allowNull: false,
    },
    eye_color: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    skin_color: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    hair_color: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    bone_structure: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    height_feet: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    height_inches: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    weight: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    bmi: {
      type: DataTypes.FLOAT,
      allowNull: true,
    },
    blood_group: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    referral_type: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    agency_name: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    viral_marker: {
      type: DataTypes.STRING(100),
    },
    betaThalassemia: {
      type: DataTypes.STRING,
    },
    chlamydia: {
      type: DataTypes.STRING,
    },
    family_health_history: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    psychological_evaluation: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    consent_signed: {
      type: DataTypes.BOOLEAN,
      allowNull: false,
      defaultValue: false,
    },
    current_page: {
      type: DataTypes.STRING(100),
      allowNull: true,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    timestamps: true,
    underscored: true,
    tableName: "emb_donors_oocyte",
  }
);

const SemenSample = sequelize.define(
  "SemenSample",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    userId: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    clinchId: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    patient_id: {
      type: DataTypes.INTEGER,
    },
    parent: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    Storage: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    status: {
      type: DataTypes.STRING,
      defaultValue: "collected",
    },
    stage: {
      type: DataTypes.STRING,
      defaultValue: "Fresh",
    },
    date_of_collect: {
      type: DataTypes.DATE,
    },
    time_of_collect: {
      type: DataTypes.TIME,
    },
    sexual_abstinence_days: {
      type: DataTypes.INTEGER,
    },
    ph_value: {
      type: DataTypes.STRING,
    },
    collected_method: {
      type: DataTypes.STRING,
    },
    received_on: {
      type: DataTypes.DATE,
      allowNull: false,
    },
    time_of_receiving: {
      type: DataTypes.TIME,
    },
    no_of_labels: {
      type: DataTypes.INTEGER,
    },
    received_by: {
      type: DataTypes.STRING,
    },
    donorId: {
      type: DataTypes.INTEGER,
    },
  },
  {
    tableName: "embro_semen_sample_collection",
    timestamps: true,
  }
);

// SemenSample.sync({alter: true})

const WashSemenSample = sequelize.define(
  "WashSemenSample",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    userId: {
      type: DataTypes.INTEGER,
    },
    clinchId: {
      type: DataTypes.INTEGER,
    },
    sample_id: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    collected_on: {
      type: DataTypes.DATE,
      defaultValue: null,
    },
    patient_id: {
      type: DataTypes.INTEGER,
    },
    mrn: {
      type: DataTypes.STRING,
    },
    fresh: {
      type: DataTypes.STRING,
      defaultValue: null,
    },
    capacitated: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    capacitatedData: {
      type: DataTypes.JSON,
    },
    volume: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    concentration: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    total_sperm: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    rapid_progressive: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    slow_progressive: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    non_progressive: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    immobile: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    total_motile_prog: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    normal_in: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    abnormal_in: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    head_defects: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    mid_piece_defects: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    tail_defects: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    excess_residual_cytoplasm: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    teratoz_index: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    normal_prog_motile: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    semen_appearance: {
      type: DataTypes.STRING,
    },
    homogenize: {
      type: DataTypes.STRING,
    },
    complete_sample: {
      type: DataTypes.STRING,
    },
    diagnosis: {
      type: DataTypes.STRING,
    },
    degree_of_diagnosis: {
      type: DataTypes.STRING,
    },
    vitality_test_method: {
      type: DataTypes.STRING,
    },
    vitality_test_in: {
      type: DataTypes.STRING,
    },
    viscosity: {
      type: DataTypes.STRING,
    },
    washing_technique: {
      type: DataTypes.STRING,
    },
    washing_done_by: {
      type: DataTypes.STRING,
    },
    large_halo: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    medium_halo: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    small_halo: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    no_halo: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    fragmented: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    non_fragmented: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    total: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    dfi_percent: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    manual_calculation: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    macs_done: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    hba: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    dfi: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    dfi_total: {
      type: DataTypes.INTEGER,
    },
    dfi_total_2: {
      type: DataTypes.INTEGER,
    },
    picsi: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    general_remarks: {
      type: DataTypes.STRING,
    },
    private_remarks: {
      type: DataTypes.STRING,
    },
    bound_motile_sperm: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    non_bound_motile_sperm: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    total_hba: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    hba_positive_sperm_percent: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    hba_negative_sperm_percent: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    total_percent: {
      type: DataTypes.FLOAT,
      defaultValue: 0.0,
    },
    donorId: {
      type: DataTypes.INTEGER,
    },
  },
  {
    tableName: "embro_wash_semen_sample",
    timestamps: true,
  }
);

// WashSemenSample.sync({alter: true})

const DiscardedSample = sequelize.define(
  "DiscardedSample",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    userId: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    clinchId: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    patient_id: {
      type: DataTypes.INTEGER,
    },
    sample_id: {
      type: DataTypes.INTEGER,
    },
    discardDate: {
      type: DataTypes.DATE,
    },
    discardTime: {
      type: DataTypes.TIME,
    },
    discarded_by: {
      type: DataTypes.STRING,
    },
    reason_for_discard: {
      type: DataTypes.STRING,
    },
    donorId: {
      type: DataTypes.INTEGER,
    },
  },
  {
    tableName: "embrodiscarded_samples",
    timestamps: true,
  }
);

const EmbryoTransfer = sequelize.define(
  "EmbryoTransfer",
  {
    id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    date: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    time: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    embryosTransferred: {
      type: DataTypes.JSON,
      allowNull: true,
      defaultValue: null,
    },
    catheter: {
      type: DataTypes.ENUM(
        "COOK Soft",
        "Embryo Transfer Catheter",
        "Gynetics-Tulip",
        "Hard",
        "IUI Catheter",
        "Labotech",
        "Obturator",
        "Soft",
        "Wallace"
      ),
      allowNull: true,
      defaultValue: null,
    },
    difficulty: {
      type: DataTypes.ENUM("Difficult", "Easy", "Impossible", "Moderate"),
      allowNull: true,
      defaultValue: null,
    },
    transferDFE: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    ecoguided: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    mucous: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    blood: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    repetition: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    bladder: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    allies: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    dilator: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    comments: {
      type: DataTypes.TEXT,
      allowNull: true,
      defaultValue: null,
    },
    doctor: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: null,
    },
    embryologist: {
      type: DataTypes.STRING,
      allowNull: true,
      defaultValue: null,
    },
    status: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
      defaultValue: false,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
  },
  {
    timestamps: true, // Automatically adds createdAt and updatedAt fields
    createdAt: "createdAt",
    updatedAt: "updatedAt",
    // sequelize, // We need to pass the connection instance
    modelName: "EmbryoTransfer", // Model name
    tableName: "embryo_transfers", // Table name
  }
);

// const EmbryoTransfer = sequelize.define('EmbryoTransfer', {
//     userId: {
//         type: DataTypes.INTEGER,
//         defaultValue: 1
//     },
//     clinchId: {
//         type: DataTypes.INTEGER,
//         defaultValue: 1
//     },
//     cycleId: {
//         type: DataTypes.INTEGER,
//         defaultValue: 0,
//     },
//     patient_Id: {
//         type: DataTypes.INTEGER,
//     },
//     date: {
//         type: DataTypes.DATEONLY
//     },
//     time: {
//         type: DataTypes.TIME
//     },
//     embryos_id: {
//         type: DataTypes.STRING,
//     },
//     catheter: {
//         type: DataTypes.STRING
//     },
//     difficulty: {
//         type: DataTypes.STRING
//     },
//     transfer_dfe: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     ecoguided: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     repetition: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     blood: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     mucous: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     bladder: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     allies: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     dialator: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     comments: {
//         type: DataTypes.TEXT
//     },
//     doctor: {
//         type: DataTypes.STRING
//     },
//     embryologist: {
//         type: DataTypes.STRING
//     }
// }, {
//     timestamps: true,
//     tableName: 'embroEmbryoTransfer'
// });

const CanisterData = sequelize.define(
  "embryo_sperm_freezeData",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    userId: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    clinchId: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    patient_id: {
      type: DataTypes.INTEGER,
    },
    sample_id: {
      type: DataTypes.INTEGER,
    },
    canister: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    due_date: {
      type: DataTypes.DATEONLY,
      allowNull: false,
    },
    freeze_in: {
      type: DataTypes.ENUM("vials", "straws"),
      allowNull: false,
    },
    actual_date_renewal: {
      type: DataTypes.DATEONLY,
      allowNull: false,
    },
    color: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    date: {
      type: DataTypes.DATEONLY,
      allowNull: false,
    },
    done_by: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    tank: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    term_duration: {
      type: DataTypes.DATEONLY,
      allowNull: false,
    },
    time: {
      type: DataTypes.TIME,
      allowNull: false,
    },
    vial_holder: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    vial_position: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    donorId: {
      type: DataTypes.INTEGER,
    },
  },
  {
    tableName: "embryo_sperm_freezeData", // You can specify the table name if it is different
    timestamps: false, // Disable timestamps if you don't need createdAt/updatedAt fields
  }
);

// stimulation and culture model

const treatmentAdvice = sequelize.define(
  "treatmentAdvice",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    treatment: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_treatmentadvice",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

treatmentAdvice.sync({ alter: true });

const chiefComplaint = sequelize.define(
  "chiefComplaint",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    complaint: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_chiefcomplaint",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

const preExistingCondition = sequelize.define(
  "preExistingCondition",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    preCondition: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_preexistingcondition",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);
const allergies = sequelize.define(
  "allergies",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    allergies: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_allergies",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);
//   const patientHistory = sequelize.define('patientHistory', {
//     clinic_id:{
//       type:DataTypes.INTEGER,
//       defaultValue:0
//     },
//     patientId: {
//         type: DataTypes.STRING,
//     },
//     doctorId: {
//         type: DataTypes.STRING,
//     },
//     Htype: {
//         type: DataTypes.STRING,

//     },
//     hchiefComplaint: {
//         type: DataTypes.STRING,
//     },
//     height: {
//         type: DataTypes.NUMBER,
//     },
//     weight: {
//         type: DataTypes.NUMBER,
//     },
//     bmi: {
//         type: DataTypes.DECIMAL(10,2),
//     },
//     bloodGroup: {
//         type: DataTypes.STRING,
//     },
//     pulse: {
//         type: DataTypes.NUMBER,
//     },
//     Bp: {
//         type: DataTypes.JSON,
//     },
//     durationInf: {
//         type: DataTypes.JSON,
//     },
//     marriageAge: {
//         type: DataTypes.NUMBER,
//     },
//     comment: {
//         type: DataTypes.TEXT,
//     },
//     note: {
//         type: DataTypes.TEXT,
//     },
//     Lmp: {
//         type: DataTypes.DATEONLY,
//     },
//     mH: {
//         type: DataTypes.JSON,
//     },
//     mHComment:{
//         type:DataTypes.STRING(2000)
//     },
//     fHComment: {
//         type: DataTypes.STRING(2000),
//     },
//     medicalHistory: {
//         type: DataTypes.JSON,
//     },
//     medicalHComment: {
//         type: DataTypes.STRING(2000),
//     },
//     oHPara: {
//         type: DataTypes.INTEGER(2),
//     },
//     oHAbortion: {
//         type: DataTypes.INTEGER(2),
//     },
//     oHEcotopic: {
//         type: DataTypes.INTEGER(2),
//     },
//     oHLiveBirth: {
//         type: DataTypes.INTEGER(2),
//     },
//     oHPregnancy: {
//         type: DataTypes.JSON,
//     },
//     rPL: {
//         type: DataTypes.STRING(3),
//     },
//     oHistoryComment: {
//         type: DataTypes.STRING(2000),
//     },
//     pastInfInvestigation:{
//         type:DataTypes.JSON,
//     },
//     pIIComment:{
//         type:DataTypes.STRING(2000),
//     },
//     partnerheight: {
//         type: DataTypes.NUMBER,
//     },
//     partnerweight: {
//         type: DataTypes.NUMBER,
//     },
//     partnerbmi: {
//         type: DataTypes.DECIMAL(10,2),
//     },
//     partnerbloodGroup: {
//         type: DataTypes.STRING,
//     },
//     partnerpulse: {
//         type: DataTypes.NUMBER,
//     },
//     partnerBp: {
//         type: DataTypes.JSON,
//     },
//     partnerComment:{
//         type:DataTypes.STRING(2000),
//     },
//     partnerPInfInv:{
//         type:DataTypes.JSON
//     },
//     otherRelH:{
//         type:DataTypes.STRING(2000),
//     },
//     Date: {
//         type: DataTypes.DATEONLY,
//     },
//   }, {
//     tableName: 'emb_patienthistory',
//     alter:true,
//     timestamps: true // Enable this if you want createdAt and updatedAt timestamps
//   });
const treatmentHist = sequelize.define(
  "treatmentHist",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    treatHist: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_treatmenthist",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

const GeneralExamination = sequelize.define(
  "GeneralExamination",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    GeneralExamination: {
      type: DataTypes.JSON,
    },
    UsgExamination: {
      type: DataTypes.JSON,
    },
    comments: {
      type: DataTypes.TEXT, // Maximum of 2000 characters
    },
    notesAdvice: {
      type: DataTypes.TEXT, // Maximum of 2000 characters
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    timestamps: true,
    // alter: true,
    tableName: "emb_generalexaminations",
  }
);

GeneralExamination.sync({ alter: true ,force:true});

const diagnosis = sequelize.define(
  "diagnosis",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    infType: {
      type: DataTypes.STRING,
    },
    maleFactor: {
      type: DataTypes.STRING,
    },
    maleFactorRemarks: {
      type: DataTypes.STRING,
    },
    femaleFactor: {
      type: DataTypes.STRING,
    },
    femaleFactorRemarks: {
      type: DataTypes.STRING,
    },
    karyotypeAbnormality: {
      type: DataTypes.STRING,
    },
    karyotypeAbnormalityRemarks: {
      type: DataTypes.STRING,
    },
    noOfInfYear: {
      type: DataTypes.INTEGER(3),
    },
    other: {
      type: DataTypes.STRING,
    },

    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_diagnosis",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

const doctorNotes = sequelize.define(
  "doctorNotes",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    doctorNotes: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_doctornotes",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

const serviceAdvice = sequelize.define(
  "serviceAdvice",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    ServiceAdvice: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_serviceadvices",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

serviceAdvice.sync({ alter: true});

const prescription = sequelize.define(
  "prescription",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    prescribedMedicine: {
      type: DataTypes.JSON,
    },
    prescribedComment: {
      type: DataTypes.STRING,
    },
    favorites: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_prescription",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

prescription.sync({ alter: true });

const attachments = sequelize.define(
  "attachments",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    attachment: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_attachments",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

const FollowUp = sequelize.define(
  "FollowUp",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    followUp: {
      type: DataTypes.JSON,
      // Assuming this field is optional
    },
    appointmentTime: {
      type: DataTypes.TIME,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
    recordedDate: {
      type: DataTypes.DATEONLY,
    },
    recordedBy: {
      type: DataTypes.STRING,
    },
  },
  {
    tableName: "emb_followups",
    alter: true,
    timestamps: true, // Assuming you want to track creation and update timestamps
  }
);

FollowUp.sync({ alter: true });

const procedureAdvice = sequelize.define(
  "procedureAdvice",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.STRING,
    },
    procedure: {
      type: DataTypes.JSON,
      // Assuming this field is optional
    },
  },
  {
    tableName: "emb_procedureadvice",
    alter: true,
    timestamps: true, // Assuming you want to track creation and update timestamps
  }
);

const Day0Record = sequelize.define(
  "Day0Record",
  {
    cycleId: {
      type: DataTypes.INTEGER,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    Date: {
      type: DataTypes.DATEONLY, // Store the entire table data as JSON
    },
    Time: {
      type: DataTypes.TIME, // Store the entire table data as JSON
    },
    FertiMethod: {
      type: DataTypes.STRING,
    },
    primEmbrologist: {
      type: DataTypes.STRING,
    },
    secEmbrologist: {
      type: DataTypes.STRING,
    },
    incubator: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    reportData: {
      type: DataTypes.JSON, // Store the entire table data as JSON
    },
  },
  {
    tableName: "emb_day0record", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);

const Day1Record = sequelize.define(
  "Day1Record",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    primEmbrologist: {
      type: DataTypes.STRING,
    },
    secEmbrologist: {
      type: DataTypes.STRING,
    },
    Date: {
      type: DataTypes.DATEONLY, // Store the entire table data as JSON
    },
    incubator: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    reportData: {
      type: DataTypes.JSON, // Store the entire table data as JSON
    },
  },
  {
    tableName: "emb_day1record", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);

const Day2Record = sequelize.define(
  "Day2Record",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    Date: {
      type: DataTypes.DATEONLY, // Store the entire table data as JSON
    },
    primEmbrologist: {
      type: DataTypes.STRING,
    },
    secEmbrologist: {
      type: DataTypes.STRING,
    },
    incubator: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    reportData: {
      type: DataTypes.JSON, // Store the entire table data as JSON
    },
  },
  {
    tableName: "emb_day2record", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);
const Day3Record = sequelize.define(
  "Day3Record",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    Date: {
      type: DataTypes.DATEONLY, // Store the entire table data as JSON
    },
    primEmbrologist: {
      type: DataTypes.STRING,
    },
    secEmbrologist: {
      type: DataTypes.STRING,
    },
    incubator: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    reportData: {
      type: DataTypes.JSON, // Store the entire table data as JSON
    },
  },
  {
    tableName: "emb_day3record", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);

const Day4Record = sequelize.define(
  "Day4Record",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    Date: {
      type: DataTypes.DATEONLY, // Store the entire table data as JSON
    },
    primEmbrologist: {
      type: DataTypes.STRING,
    },
    secEmbrologist: {
      type: DataTypes.STRING,
    },
    incubator: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    reportData: {
      type: DataTypes.JSON, // Store the entire table data as JSON
    },
  },
  {
    tableName: "emb_day4record", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);
const Day5Record = sequelize.define(
  "Day5Record",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    Date: {
      type: DataTypes.DATEONLY, // Store the entire table data as JSON
    },
    primEmbrologist: {
      type: DataTypes.STRING,
    },
    secEmbrologist: {
      type: DataTypes.STRING,
    },
    incubator: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    reportData: {
      type: DataTypes.JSON, // Store the entire table data as JSON
    },
  },
  {
    tableName: "emb_day5record", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);
const Day6Record = sequelize.define(
  "Day6Record",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    primEmbrologist: {
      type: DataTypes.STRING,
    },
    Date: {
      type: DataTypes.DATEONLY, // Store the entire table data as JSON
    },
    secEmbrologist: {
      type: DataTypes.STRING,
    },
    incubator: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    reportData: {
      type: DataTypes.JSON, // Store the entire table data as JSON
    },
  },
  {
    tableName: "emb_day6record", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);

const SpermAdvanceResult = sequelize.define(
  "SpermAdvanceResult",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    referenceDate: {
      type: DataTypes.STRING,
    },
    referenceNo: {
      type: DataTypes.STRING,
    },
    clinic: {
      type: DataTypes.STRING,
    },
    uhid: {
      type: DataTypes.STRING,
    },
    patientAccount: {
      type: DataTypes.STRING,
    },
    patientRegistration: {
      type: DataTypes.STRING,
    },
    investigationRequestNo: {
      type: DataTypes.STRING,
    },
    investigationType: {
      type: DataTypes.STRING,
    },
    sampleReceivingDate: {
      type: DataTypes.DATEONLY,
    },
    sampleReceivingTime: {
      type: DataTypes.TIME,
    },
    sampleTakenDate: {
      type: DataTypes.DATEONLY,
    },
    sampleTakenTime: {
      type: DataTypes.TIME,
    },
    spermCollectionType: {
      type: DataTypes.STRING,
    },
    collectionAt: {
      type: DataTypes.STRING,
    },
    preparedBy: {
      type: DataTypes.STRING,
    },
    checkedBy: {
      type: DataTypes.STRING,
    },
    remark: {
      type: DataTypes.STRING,
    },
    anySpillageReported: {
      type: DataTypes.STRING,
    },
    volume: {
      type: DataTypes.STRING,
    },
    visualAppearance: {
      type: DataTypes.STRING,
    },
    examinationInitiatedTime: {
      type: DataTypes.STRING,
    },
    examinationEndTime: {
      type: DataTypes.STRING,
    },
    duration: {
      type: DataTypes.STRING,
    },
    liquefaction: {
      type: DataTypes.STRING,
    },
    liquefactionTime: {
      type: DataTypes.STRING,
    },
    ph: {
      type: DataTypes.STRING,
    },
    viscosity: {
      type: DataTypes.STRING,
    },
    abstinencePeriod: {
      type: DataTypes.STRING,
    },
    spermConcentration: {
      type: DataTypes.STRING,
    },
    totalSpermNumber: {
      type: DataTypes.STRING,
    },
    rapidProgressive: {
      type: DataTypes.STRING,
    },
    slowProgressive: {
      type: DataTypes.STRING,
    },
    prProgressive: {
      type: DataTypes.STRING,
    },
    nonProgressive: {
      type: DataTypes.STRING,
    },
    totalMotile: {
      type: DataTypes.STRING,
    },
    immotile: {
      type: DataTypes.STRING,
    },
    debrisName: {
      type: DataTypes.STRING,
    },
    roundCells: {
      type: DataTypes.STRING,
    },
    agglutinationName: {
      type: DataTypes.STRING,
    },
    aggregationName: {
      type: DataTypes.STRING,
    },
    enterViability: {
      type: DataTypes.STRING,
    },
    spermViability: {
      type: DataTypes.STRING,
    },
    fructoseName: {
      type: DataTypes.STRING,
    },
    peroxidasePositiveCollisConcentration: {
      type: DataTypes.STRING,
    },
    systemImpression: {
      type: DataTypes.STRING,
    },
    impression: {
      type: DataTypes.STRING,
    },
  },
  {
    tableName: "emb_spermadvanceresult", // Customize the table name if necessary
    alter: true,
    timestamps: true, // Adds createdAt and updatedAt fields automatically
  }
);

const stimulation = sequelize.define(
  "stimulation",
  {
    cycleId: {
      type: DataTypes.INTEGER,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    DonorId: {
      type: DataTypes.STRING,
    },
    dayId: {
      type: DataTypes.INTEGER,
    },
    option: {
      type: DataTypes.STRING,
    },
    StimulationRows: {
      type: DataTypes.JSON,
      // Assuming this field is optional
    },
  },
  {
    tableName: "emb_stimulation",
    alter: true,
    timestamps: true, // Assuming you want to track creation and update timestamps
  }
);

const StimulationSubmit = sequelize.define(
  "StimulationSubmit",
  {
    cycleId: {
      type: DataTypes.INTEGER,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    DonorId: {
      type: DataTypes.STRING,
    },
    stimulationCompletedOn: {
      type: DataTypes.DATEONLY,
    },
    readyForOpu: {
      type: DataTypes.BOOLEAN,
    },
    failedCycle: {
      type: DataTypes.BOOLEAN,
    },
    reasonForFailure: {
      type: DataTypes.STRING,
    },
    stimulationRecordedBy: {
      type: DataTypes.STRING,
    },
    transfer: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.TEXT,
    },
    firstTrigger: {
      type: DataTypes.JSON,
    },
    triggerType: {
      type: DataTypes.STRING,
    },
    opuOn: {
      type: DataTypes.STRING,
    },
    noOfFollicles: {
      type: DataTypes.INTEGER,
    },
    drug: {
      type: DataTypes.JSON,
    },
  },
  {
    tableName: "emb_stimulationsubmit",
    alter: true,
    timestamps: true,
  }
);

const ScheduleEt = sequelize.define(
  "ScheduleEt",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    etDate: {
      type: DataTypes.DATEONLY,
    },
    etTime: {
      type: DataTypes.TIME,
    },
    etTimeERA: {
      type: DataTypes.STRING,
      defaultValue: false,
    },
    reviewedBy: {
      type: DataTypes.STRING,
    },
    fertStatus: {
      type: DataTypes.STRING,
      defaultValue: false,
    },
  },
  {
    tableName: "emb_schedule_et",
    alter: true,
    timestamps: true, // createdAt and updatedAt fields are automatically added
  }
);

const BetaHcg = sequelize.define(
  "BetaHcg",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
      allowNull: false, // Ensures patientId is required
    },
    clinicId: {
      type: DataTypes.INTEGER,
      allowNull: false, // Ensures clinicId is required
    },
    betahcgValue: {
      type: DataTypes.JSON,
      allowNull: true,
    },
    betaHcgDate: {
      type: DataTypes.DATEONLY, // Store date only (without time)
      allowNull: true,
    },
    recordedBy: {
      type: DataTypes.STRING, // You can use STRING to store the doctor's name or ID
      allowNull: true,
    },
    observations: {
      type: DataTypes.TEXT, // To store free-form observations
      allowNull: true,
    },
  },
  {
    tableName: "emb_beta_hcg_records", // The table name in your database
    timestamps: true, // createdAt and updatedAt fields are automatically added
    alter: true, // Allows Sequelize to update the schema if needed
  }
);

const Outcome = sequelize.define(
  "Outcome",
  {
    cycleId: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    clinicalPregnancyDate: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    clinicalPregnancyRecordedBy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    clinicalPregnancyLocation: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    noOfSac: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    clinicalPregnancyObservations: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    ongoingPregnancyObservations: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    miscarriageDate: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    miscarriageTime: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    abortionType: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    clinicalMiscarriageObservations: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    deliveryDate2: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    birthRecordedBy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    birthType: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    modeOfDelivery: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    neonatalComplications: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    postPartumMaternalComplications: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    birthDetailsObservations: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    biochemicalPregnancy: {
      type: DataTypes.STRING,
    },
  },
  {
    tableName: "emb_outcome_records",
    alter: true,
    timestamps: true, // createdAt and updatedAt fields are automatically added
  }
);

// Outcome.sync({ alter: true });

const ovumSchedule = sequelize.define(
  "ovumSchema",
  {
    cycleId: {
      type: DataTypes.INTEGER,
    },
    DonorId: {
      type: DataTypes.STRING,
    },
    clinchId: {
      type: DataTypes.INTEGER,
      defaultValue: 1,
    },
    patient_id: {
      type: DataTypes.INTEGER,
    },
    Date: {
      type: DataTypes.DATE,
    },
    Time: {
      type: DataTypes.TIME,
    },
    Surgeon: {
      type: DataTypes.STRING,
    },
    AssistantSurgeon: {
      type: DataTypes.STRING,
    },
    Anesthetist: {
      type: DataTypes.STRING,
    },
    AnesthesiaType: {
      type: DataTypes.STRING,
    },
    PrimaryEmbryologist: {
      type: DataTypes.STRING,
    },
    SecondaryEmbryologist: {
      type: DataTypes.STRING,
    },
    OPUNotes: {
      type: DataTypes.STRING,
    },
    NoOfRightFollicles: {
      type: DataTypes.INTEGER,
    },
    NoOfLeftFollicles: {
      type: DataTypes.INTEGER,
    },
    NoOfOocytes: {
      type: DataTypes.INTEGER,
    },
    DenudationDate: {
      type: DataTypes.DATE,
    },
    DenudationTime: {
      type: DataTypes.TIME,
    },
    DenudationDoneBy: {
      type: DataTypes.STRING,
    },
    Option: {
      type: DataTypes.JSON,
    },
    Vitrification: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
  },
  {
    tableName: "embryo_ovumschedule",
    defaultValue: "false",
  }
);

// MINE
//

const PatientCounseling = sequelize.define(
  "PatientCounseling",
  {
    cycle_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    package_bill_no: {
      type: DataTypes.STRING,
      allowNull: true,

    },
    package_bill_no: {
      type: DataTypes.STRING,
      allowNull: true,

    },
    donorId: {
      type: DataTypes.STRING(50),
      allowNull: true,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    mrn: {
      type: DataTypes.STRING,
    },
    package_id: {
      type: DataTypes.INTEGER,
    },
    treatmentType: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    assignedDoctor: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    assignedAssistantDoctor: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    assignedCounselor: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    assignedCoordinator: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    clinicalCounselingDoneBy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    clinicalCounselingDate: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    financialCounselingDoneBy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    financialCounselingDate: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    notesDate: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    notes: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    notesRecordedBy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    amount: {
      type: DataTypes.JSON,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
    currentPage: {
      type: DataTypes.STRING,
    },
    spermDonor: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    oocyteDonor: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    frozenOocyte: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
  },
  {
    timestamps: true,
    tableName: "patient_counseling",
  }
);

PatientCounseling.sync({ alter: true });

const PackageBills = sequelize.define(
  "PackageBills",
  {
    cycle_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    bill_no: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    mr_no: {
      type: DataTypes.STRING,
    },
    package_amount: {
      type: DataTypes.JSON,
    },
    issue_date: {
      type: DataTypes.DATEONLY,
    },
    discount: {
      type: DataTypes.JSON,
    },
    final_amount: {
      type: DataTypes.JSON,
    }
  },
  {
    timestamps: true,
    tableName: "package_bills",
  }
);

PackageBills.sync({alter : true, force:true})

const Bifurcation_Stages = sequelize.define(
  "Bifurcation_Stages",
  {
    
    b_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
    },
    cycle_id: {
      type: DataTypes.INTEGER,
      // primaryKey: true,
    },

    bill_no: {
      type: DataTypes.STRING,
      allowNull: true,
    },

    patientId: {
      type: DataTypes.INTEGER,
      allowNull: true,

    },

    package_id: {
      type: DataTypes.INTEGER,
      allowNull: true,

    },
    payment_mode: {
      type: DataTypes.STRING,
      allowNull: true,

    },
    stage: {
      type: DataTypes.ENUM('et', 'registeration', 'opu', 'day2', 'day6', 'day9', 'Donor', 'trigger'),
      allowNull: false
    },

    total_bifurcated_amount: {
      type: DataTypes.JSON,
      allowNull: true,

    },

    stage_date: {
      type: DataTypes.DATEONLY,
      allowNull: true,

    },

    total_package_amount: {
      type: DataTypes.JSON,
      allowNull: true,

    },
    balance_amount: {
      type: DataTypes.DECIMAL(10, 2), // Storing monetary values
      allowNull: false,
      defaultValue: 0.00
    },
    paid_amount: {
      type: DataTypes.DECIMAL(10, 2),
      allowNull: false,
      defaultValue: 0.00
    },
    date: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW
    },
    adjust_advance: {
      type: DataTypes.DECIMAL(10, 2),
      defaultValue: 0.00

    },
  },
  {
    timestamps: true,
    tableName: "bifurcation_stages",
  }
);

Bifurcation_Stages.sync({ alter: true });

const payments = sequelize.define(
  "payments",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
    },
    cycle_id: {
      type: DataTypes.INTEGER,
      primaryKey: true,
      autoIncrement: true,
      allowNull: false,
    },
    bifurcation_id: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    payment_date: {
      type: DataTypes.DATEONLY,
      allowNull: false,
    },
    patientId: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    paid_amount: {
      type: DataTypes.JSON,
      allowNull: false,
    },
    payment_mode: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    total_advance: {
      type: DataTypes.JSON,
      allowNull: false,
    },
    adjust_from_advance: {
      type: DataTypes.JSON,
      allowNull: false,
    },
    balance: {
      type: DataTypes.JSON,
      allowNull: false,
    },
    remarks: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    total_bifurcated_amount: {
      type: DataTypes.JSON,
      allowNull: false,
    },
    bill_no: {
      type: DataTypes.STRING,
      allowNull: false,
    },
  },
  {
    timestamps: true,
    tableName: "payments",
  }
);

//   geetapage.js

const History = sequelize.define(
  "History",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    doctorId: {
      type: DataTypes.INTEGER,
    },
    History: {
      type: DataTypes.JSON,
    },
    Date: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "emb_history",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);
// History.sync({ force: true });

const Package = sequelize.define(
  "Package",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    packageCode: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    packageName: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    packageRate: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    packageEffDate: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    packageExpDate: {
      type: DataTypes.DATE,
      allowNull: true,
    },
    specialization: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    subSpecialization: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    shortDescription: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    longDescription: {
      type: DataTypes.TEXT,
      allowNull: true,
    },
    service_tax: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    service_per: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    service_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staffDiscount: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    staffDiscount_per: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staffDiscount_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staffParentAccount: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    staffParent_per: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staffParent_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    concession: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    concession_per: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    concession_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    doctor: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    doctor_per: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    doctor_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    rateEditable: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    rateEditable_per: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    rateEditable_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    S_Citizen_Con: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    S_Citizen_per: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    S_Citizen_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    family: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    count: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    selectAll: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    applicableMemberRelations: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    createdAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
    updatedAt: {
      type: DataTypes.DATE,
      allowNull: false,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    tableName: "pkg_newpackage",
    timestamps: true, // This will handle `createdAt` and `updatedAt` automatically
  }
);

const ItemMasterNew = sequelize.define(
  "ItemMaster",
  {
    item_code: {
      type: DataTypes.STRING,
    },
    brand_name: {
      type: DataTypes.STRING,
    },
    item_name: {
      type: DataTypes.STRING,
    },
    item_group: {
      type: DataTypes.STRING,
    },
    dispensing_type: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    pregnancy_class: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    manufactured_by: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    purchase_uom: {
      type: DataTypes.STRING,
    },
    base_uom: {
      type: DataTypes.STRING,
    },
    base_unit_mrp: {
      type: DataTypes.FLOAT,
    },
    discount_on_sale: {
      type: DataTypes.FLOAT,
    },
    AnalysisRequired: {
      type: DataTypes.STRING,
    },
    expiry_alert_before_in_days: {
      type: DataTypes.INTEGER,
    },
    hsn_codes: {
      type: DataTypes.STRING,
    },
    walk_in_patients_discount_on_sale: {
      type: DataTypes.FLOAT,
    },
    staff_discount_on_sale: {
      type: DataTypes.FLOAT,
    },
    registered_patients_discount_on_sale: {
      type: DataTypes.FLOAT,
    },
    strength: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    strength_unit: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    molecule_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    item_category: {
      type: DataTypes.STRING,
    },
    storage_type: {
      type: DataTypes.STRING,
    },
    storage_degree: {
      type: DataTypes.FLOAT,
    },
    therapeutic_class: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    stocking_uom: {
      type: DataTypes.STRING,
    },
    selling_uom: {
      type: DataTypes.STRING,
    },
    base_unit_cost_price: {
      type: DataTypes.FLOAT,
    },
    route: {
      type: DataTypes.STRING,
    },
    batchesRequired: {
      type: DataTypes.STRING,
    },
    batchesRequired: {
      type: DataTypes.STRING,
    },
    suspend: {
      type: DataTypes.BOOLEAN,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvitemmaster",
  }
);

// ItemMasterNew.sync({ alter: true });
const CurrentItemStock = sequelize.define(
  "InventoryItem",
  {
    clinic: {
      type: DataTypes.STRING,
    },
    store: {
      type: DataTypes.STRING,
    },

    item_id: {
      type: DataTypes.INTEGER,
    },
    isFree: {
      type: DataTypes.BOOLEAN,
    },

    batchCode: {
      type: DataTypes.STRING,
    },
    availableStock: {
      type: DataTypes.INTEGER,
    },

    expiryDate: {
      type: DataTypes.DATE,
    },
  },
  {
    tableName: "invcurrentitemstock",
    timestamps: true, // You can change this if you need timestamps
  }
);

// consent

const PatientConsent = sequelize.define(
  "PatientConsent",
  {
    patient_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    form_id: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },

    is_filled: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    filled_at: {
      type: DataTypes.DATE,
      allowNull: true,
    },
  },
  {
    tableName: "patient_consents",
    timestamps: true,
    createdAt: "created_at",
    updatedAt: "updated_at",
  }
);
// consent

// CanisterData.sync();

// Sync all models
// sequelize
//   .sync({ force: true })
//   .then(() => {
//     console.log("All tables have been recreated successfully.");
//   })
//   .catch((error) => {
//     console.error("Error recreating tables:", error);
//   });

// PatientCounseling.sync({ alter: true }) // Use { force: true } if you want to drop and recreate the table
//   .then(() => {
//     console.log("Donor table synced successfully.");
//   })
//   .catch((error) => {
//     console.error("Error syncing Donor table:", error);
//   });
const NotificationTracking = sequelize.define(
  "NotificationTracking",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
      allowNull: false,
    },
    patientId: {
      type: DataTypes.STRING,
    },
    user_id: {
      type: DataTypes.INTEGER,
      allowNull: true, // Set to true for expiring items since no user_id is needed here
    },
    kyc_id: {
      type: DataTypes.INTEGER,
      allowNull: true, // Set to true for expiring items since no kyc_id is needed here
    },
    apt_date: {
      type: DataTypes.DATEONLY,
      allowNull: true, // Set to true for expiring items
    },
    item_code: {
      type: DataTypes.STRING,
      allowNull: true, // Field for tracking expiring items
    },
    batchcode: {
      type: DataTypes.STRING,
      allowNull: true, // Field for tracking batch code from CurrentItemStock
    },
    notification_type: {
      type: DataTypes.STRING,
      allowNull: false, // New field to differentiate types of notifications
      defaultValue: "appointment", // Can be 'appointment' or 'expiry' or desktop
    },
    notification_status: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    notification_date: {
      type: DataTypes.DATE,
      defaultValue: DataTypes.NOW,
    },
  },
  {
    timestamps: false, // Disable timestamps if not needed
    tableName: "notification_tracking",
  }
);

const vitrifyOocyte = sequelize.define(
  "vitrifyOocyte",
  {
    cycleId: {
      type: DataTypes.INTEGER,
    },
    oldCycleId: {
      type: DataTypes.INTEGER,
    },
    patientId: {
      type: DataTypes.INTEGER,
    },
    clinicId: {
      type: DataTypes.INTEGER,
    },
    vitrificationDate: {
      type: DataTypes.DATEONLY,
    },
    oocyteNumber: {
      type: DataTypes.STRING,
    },
    incubator: {
      type: DataTypes.STRING,
    },
    vitrificationTime: {
      type: DataTypes.TIME,
    },
    tank: {
      type: DataTypes.STRING,
    },
    canister: {
      type: DataTypes.STRING,
    },
    goble: {
      type: DataTypes.STRING,
    },
    hexatube: {
      type: DataTypes.STRING,
    },
    visotube: {
      type: DataTypes.STRING,
    },
    cryotopColorAndNumber: {
      type: DataTypes.STRING,
    },
    doneBy: {
      type: DataTypes.STRING,
    },
    witnessedBy: {
      type: DataTypes.STRING,
    },
    expDate: {
      type: DataTypes.DATEONLY,
    },
    status: {
      type: DataTypes.ENUM("freeze", "observe", "consumed"),
      defaultValue: "freeze",
    },
  },
  {
    timestamps: false, // Disable timestamps if not needed
    tableName: "emb_vitrifyoocytes",
  }
);

// <<<<<<< Updated upstream
// vitrifyOocyte.sync({ alter: true });
// NotificationTracking.sync({ alter: true });
// =======
const vitrifyEmbryos = sequelize.define(
  "VitrifyEmbryos",
  {
    cycleId: {
      type: DataTypes.INTEGER,
    },
    parent_cycleId: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    patientId: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    clinicId: {
      type: DataTypes.INTEGER,
      allowNull: false,
    },
    DayEmbryo: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    vitrificationDate: {
      type: DataTypes.DATEONLY,
      allowNull: true,
    },
    oocyteNumber: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    incubator: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    vitrificationTime: {
      type: DataTypes.TIME,
      allowNull: true,
    },
    expiryDate: {
      type: DataTypes.DATEONLY,
    },
    expiryTime: {
      type: DataTypes.TIME,
    },
    tank: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    canister: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    goble: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    hexatube: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    visotube: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    cryotopColorAndNumber: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    doneBy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    witnessedBy: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    status: {
      type: DataTypes.ENUM("freeze", "observe", "consumed"),
      defaultValue: "freeze",
    },
  },
  {
    timestamps: false, // Disable timestamps if not needed
    tableName: "emb_vitrifyembryos",
  }
);

// PatientCounseling.sync({alter: true});
// vitrifyOocyte.sync({ force: true });

// PatientCounseling.sync({alter: true});
// vitrifyOocyte.sync({ force: true });
// sequelize.sync({ alter: true });
module.exports = {
  BetaHcg,
  Donor,
  DonorOocyte,
  DonorVisit,
  SemenSample,
  vitrifyOocyte,
  vitrifyEmbryos,
  WashSemenSample,
  DiscardedSample,
  EmbryoTransfer,
  CanisterData,
  treatmentAdvice,
  chiefComplaint,
  preExistingCondition,
  allergies,
  treatmentHist,
  GeneralExamination,
  diagnosis,
  doctorNotes,
  serviceAdvice,
  prescription,
  attachments,
  FollowUp,
  procedureAdvice,
  Day0Record,
  Day1Record,
  Day2Record,
  Day3Record,
  Day4Record,
  Day5Record,
  Day6Record,
  SpermAdvanceResult,
  stimulation,
  StimulationSubmit,
  ScheduleEt,
  Outcome,
  ovumSchedule,
  PatientCounseling,
  payments,
  PackageBills,
  Bifurcation_Stages,
  History,
  Package,
  ItemMasterNew,
  CurrentItemStock,
  NotificationTracking,
};
