const { DataTypes } = require('sequelize');
const {sequelize} = require('../sequelize');
const LeadForm = require('./leadForm');
const LeadsData = sequelize.define("Lead", {
    id: {
      type: DataTypes.STRING,
      primaryKey: true,
    },
    fullName: {
      type: DataTypes.STRING,
    },
    email: {
      type: DataTypes.STRING,
    },
    phone: {
      type: DataTypes.STRING,
    },
    created_at:{
        type:DataTypes.DATE
    },
    formData:{
        type:DataTypes.JSON
    },
    leadFormId: {
      type: DataTypes.STRING,
      references: {
        model: LeadForm,
        key: "id",
      },
    },
  }, {  alter: true,
  tableName: 'LeadsData',
  timestamps: true });
  
  //Lead.belongsTo(LeadForm, { foreignKey: "leadFormId" });

  LeadForm.hasMany(LeadsData, { foreignKey: "leadFormId" });
  
  module.exports = LeadsData;