const { sequelize } = require("../sequelize");
const { DataTypes } = require("sequelize");

// server.js - Add color field to the Note model
const my_Notes = sequelize.define("Note", {
  id: {
    type: DataTypes.INTEGER,
    primaryKey: true,
    autoIncrement: true,
  },
  title: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  description: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  x_coordinate: {
    type: DataTypes.INTEGER,
    allowNull: false,
  },
  y_coordinate: {
    type: DataTypes.INTEGER,
    allowNull: false,
  },
  color: {
    type: DataTypes.STRING,
    allowNull: true,
    defaultValue: "#fff740", // Default yellow color
  },
  ClinicId: {
    type: DataTypes.INTEGER,
    allowNull: false,
  },
});

my_Notes.sync({ alter: true });

module.exports = { my_Notes };
