
/*
======================================
? Exports To CSV Function :--
======================================
*/

function exportTableToCSV(filename) {
    const tables = document.querySelectorAll("table.approached_table"); 
    let csvContent = [];

    tables.forEach((table) => {
      const rows = table.querySelectorAll("tr");

      rows.forEach((row) => {
        let rowData = [];
        row.querySelectorAll("th, td").forEach((cell) => {
          //* Skiping hidden columns (display: none)
          let isHidden = window.getComputedStyle(cell).display === "none";

          if (!isHidden) {
            let text = cell.innerText.trim().replace(/,/g, " ");
            rowData.push(`"${text}"`);
          }
        });
        if (rowData.length > 0) {
          csvContent.push(rowData.join(",")); 
        }
      });
    });

    let csvBlob = new Blob([csvContent.join("\n")], { type: "text/csv" });
    let csvUrl = URL.createObjectURL(csvBlob);

    let downloadLink = document.createElement("a");
    downloadLink.href = csvUrl;
    downloadLink.download = filename;
    document.body.appendChild(downloadLink);
    downloadLink.click();
    document.body.removeChild(downloadLink);
  }
