export default function generateQRCode(containerID, type, callback) {
  if (!type) return "To generate qr file is a required";
  // create link with unique id
  const uniqueId = uuid.v4();
  const uploadUrl = `${window.location.origin}/file/upload/${type}/${uniqueId}`;

  const qrCodeContainer = document.getElementById(containerID);
  qrCodeContainer.innerHTML = "";

  new QRCode(qrCodeContainer, {
    text: uploadUrl,
    width: 200,
    height: 200,
  });

  const button = document.getElementById("pullFile");

  // Remove any existing click event listeners before adding a new one
  const newButton = button.cloneNode(true);
  button.parentNode.replaceChild(newButton, button);

  // Add the event listener to the cloned button
  newButton.addEventListener("click", async () => {
    try {
      const imageUrl = `/file/upload/${uniqueId}`;

      // Fetch the image file from the server
      const response = await fetch(imageUrl);

      if (response.ok) {
        const data = await response.json();
        await callback(data, undefined);

        return showModal("success", "File pulled successfully!");
      } else {
        await callback(undefined, { message: "file not found." });
        return showModal("warning", "File not found.");
      }
    } catch (error) {
      await callback(error);
      console.error("Error pulling file:", error);
      return showModal("warning", "An error occurred while fetching the file.");
    }
  });

  console.log("QR Code generated with URL:", uploadUrl);
}

// Add this html in the page where to use the qr.
//  <!-- QR CODE -->
//   <div class="modal" id="emrAttachmentsQR">
//     <div class="modal-dialog">
//       <div class="modal-content">
//         <!-- Modal Header -->
//         <div class="modal-header d-flex justify-content-center">
//           <h5 class="modal-title" id="myModalLabel">SCAN QR</h5>
//         </div>

//         <!-- Modal body -->
//         <div
//           id="emrAttachmentsQRContainer"
//           class="modal-body d-flex justify-content-center"
//         ></div>

//         <div class="modal-footer">
//           <button
//             type="button"
//             class="btn btn-secondary"
//             data-bs-dismiss="modal"
//           >
//             Close
//           </button>
//           <button type="button" id="pullFile" class="btn btn-primary">
//             Pull
//           </button>
//         </div>
//       </div>
//     </div>
//   </div>
// </div>
