var express = require("express");
var router = express.Router();
var path = require("path");
var CryptoJS = require("crypto-js");
const session = require("express-session");
const { AdminSubmit, getAdmin } = require("../controllers/SuperAdmin");
const { SuperAdmin, Menu } = require("../models/Admin");
router.use(express.static(path.join(__dirname, "public")));
router.use(express.json());
router.use(express.urlencoded({ extended: true }));

function decryptData(encryptedData, secretKey) {
  const bytes = CryptoJS.AES.decrypt(encryptedData, secretKey);
  return bytes.toString(CryptoJS.enc.Utf8);
}

/* GET home page. */
router.get("/1", function (req, res, next) {
  res.render("Admin/Admin_Listing");
});
router.get("/2", async (req, res) => {
  const id = req.query.id;
  const decryptedId = decryptData(decodeURIComponent(id), "ll");
  if (id) {
    try {
      const dataAdmin = await SuperAdmin.findByPk(id);
      const AdminValues = dataAdmin.get({ plain: true });
      console.log("ssd", AdminValues);
      res.render("Admin/admin.ejs", { result: AdminValues });
    } catch (error) {
      console.error("Error fetching  data:", error);
      res.status(500).send("Internal Server Error");
    }
  } else {
    res.render("Admin/admin.ejs", { result: "" });
  }
});

router.get("/getAdmin", getAdmin);

router.post("/AdminSubmit", AdminSubmit);

router.post("/save-status-data", async (req, res) => {
  try {
    console.log(req.body);
    const { id: encryptedId, status, schema: encryptedSchema } = req.body;
    const secretKey = "ll"; // Replace with your actual secret key

    // Decrypt id and schema
    const id = decryptData(decodeURIComponent(encryptedId), secretKey); // URL decode
    const schema = decryptData(decodeURIComponent(encryptedSchema), secretKey); // URL decode

    console.log("Decrypted id:", id);
    console.log("Decrypted schema:", schema);

    // Use decrypted id and schema to fetch data from the model
    const Model = require("../models/Admin")[schema];
    const data = await Model.findByPk(id);

    if (data) {
      // Update status and save
      data.status = status;
      await data.save();
      res.sendStatus(200);
    } else {
      res.status(404).send("Data not found");
    }
  } catch (error) {
    console.error("Error updating status:", error);
    res.status(500).send("Internal Server Error");
  }
});

function organizeMenuHierarchy(menus) {
  const menuMap = {};
  const menuTree = [];

  // Create a map for quick lookup
  menus.forEach((menu) => {
    menuMap[menu.menu_id] = { ...menu.dataValues, children: [] };
  });

  // Build hierarchy
  menus.forEach((menu) => {
    if (menu.menu_parent === 0) {
      // Top-level menu
      menuTree.push(menuMap[menu.menu_id]);
    } else {
      // Child menu
      if (menuMap[menu.menu_parent]) {
        menuMap[menu.menu_parent].children.push(menuMap[menu.menu_id]);
      }
    }
  });

  return menuTree;
}

router.get("/dropdown", async (req, res) => {
  try {
    const menus = await Menu.findAll({
      order: [
        ["menu_parent", "ASC"],
        ["menu_id", "ASC"],
      ],
    });

    // Organize the menu into a hierarchy
    const menuTree = organizeMenuHierarchy(menus);
    // console.log(menuTree);

    // Render the dropdown in the view
    // res.render("dropdown", { menuTree });
    res.status(200).json(menuTree);
  } catch (error) {
    console.error(error);
    res.status(500).send("Server Error");
  }
});

module.exports = router;
