var express = require("express");
var router = express.Router();
const { sequelize } = require("../sequelize");
const { Sequelize } = require("sequelize");
const { Op } = require("sequelize");
const axios = require('axios');
const { QueryTypes } = require("sequelize");
const moment = require('moment');
const { Bifurcation_Stages, PatientCounseling } = require('../models/embrology')
const fs = require("fs");
const { getTransactionReceipts } = require('../models/billingSchema');

const { PR_patientReg, PR_BillFindPatient, PR_BillPharmacy, PR_BillPaymentDetails } = require("../models/PatientReg");

const CryptoJS = require("crypto-js");

//decryption and encryption fxn
function decryptData(encryptedData, secretKey) {
  const bytes = CryptoJS.AES.decrypt(encryptedData, secretKey);
  return bytes.toString(CryptoJS.enc.Utf8);
}
function encryptDataForUrl(data) {
  console.log(data);
  const secretKey = "ll"; // Replace with your actual secret key
  const encrypted = CryptoJS.AES.encrypt(data, secretKey).toString();
  const encodedEncrypted = encodeURIComponent(encrypted);
  return encodedEncrypted;
}
const getClinicsForUser = async (userClinicId, role) => {
  if (role === 1) {
    // If the user is an admin, fetch all clinics under the main clinic
    const subClinics = await ClinicConfiguration.findAll({
      where: { clinic_id: userClinicId },
    });

    // Return the clinic ID for the main clinic plus all sub-clinic IDs
    return [userClinicId, ...subClinics.map(c => c.id)];
  }

  // If the user is a doctor, they only have access to their own clinic
  return [userClinicId];
};
/* GET users listing. */
router.get("/", function (req, res, next) {
  res.send("respond with a resource");
});

router.post("/storeRowId", (req, res) => {
  const { rowId } = req.body;
  console.log(req.body)
  console.log(req.body.rowId);
  req.session.rowId = rowId;
  console.log(req.session.rowId);
  res.send({ message: "Row ID stored in session", rowId: req.session.rowId });
});

router.get("/1", (req, res) => {

  res.render("MainBilling/find-patient");
});

router.get("/2", async (req, res) => {
  let Id;
  if (req.session.rowId) {
    Id = req.session.rowId;
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    console.log("Row Data", Id);
    res.render("MainBilling/patient-details-patient-advance", { Id: Id, patient2: patient });
  } else {
    console.log("Hello");
    res.redirect("/MainBill/1");
  }
});

router.get("/3", async (req, res) => {
  let Id;
  if (req.session.rowId) {
    Id = req.session.rowId;
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    console.log("Row Data", Id);
    res.render("MainBilling/patient-details-refund-patient-advance", {
      Id: Id,
      patient: patient
    });
  } else {
    console.log("Hello");
    res.redirect("/MainBill/1");
  }
});

router.get("/4", async (req, res) => {
  let Id;
  if (req.session.rowId) {
    Id = req.session.rowId;
    console.log("Row Data", Id);
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    res.render("MainBilling/company-advance", { Id: Id, patient2: patient });
  } else {
    console.log("Hello");
    res.redirect("/MainBill/1");
  }
});
router.get("/5", async (req, res) => {
  let Id;
  if (req.session.rowId) {
    Id = req.session.rowId;
    console.log("Row Data", Id);
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    res.render("MainBilling/company-refund", {
      Id: Id,
      patient2: patient
    });
  } else {
    console.log("Hello");
    res.redirect("/MainBill/1");
  }
});

router.get("/6", async function (req, res) {
  const id = req.query.id;
  const now = new Date();
  const currentDate = now.toISOString().split("T")[0]; // YYYY-MM-DD
  const currentTime = now.toTimeString().split(" ")[0]; // HH:MM:SS
  console.log("patient", req.session.rowId);
  if (req.session.rowId) {
    try {
      const patient = await PR_patientReg.findByPk(req.session.rowId);
      console.log("patient mr", patient.mr_no);
      // console.log("patient s mr", req.session.mrNo);
      if (patient) {
        console.log(1);
        if (patient.mr_no) {
          console.log(2);
          const patient2 = id
            ? await PR_BillFindPatient.findByPk(
              decryptData(decodeURIComponent(id), "ll")
            )
            : null;
          console.log("patient2", patient2);
          if (id && !patient2) {
            req.session.alert = "No patient found for the provided ID.";
            return res.redirect("/MainBill/1");
          }
          if (req.method === "POST" && req.body.billDate) {
            patient.date = req.body.billDate;
            await patient.save();  // Save the new date to DB
          }

          // Render the page with the patient data and current date and time
          return res.render("MainBilling/bill-details", {
            patient: patient,
            patient2: patient2 || "",
            currentDate: currentDate,
            currentTime: currentTime,
          });
        } else {
          req.session.alert = "Mismatch in patient MR number.";
          return res.redirect("/MainBill/1");
        }
      } else {
        // Handle case where no patient is found for the given id
        return res.redirect("/MainBill/1");
      }
    } catch (error) {
      console.error("Error fetching patient:", error);
      return res.status(500).send("Internal Server Error");
    }
  } else {
    // Redirect if no rowId is in the session and no ID is provided
    return res.redirect("/MainBill/1");
  }
});
router.get("/99", async function (req, res) {
  const id = req.query.id;
  const now = new Date();
  const currentDate = now.toISOString().split("T")[0]; // YYYY-MM-DD
  const currentTime = now.toTimeString().split(" ")[0]; // HH:MM:SS
  console.log("patient", req.session.rowId);
  if (req.session.rowId) {
    try {
      const patient = await PR_patientReg.findByPk(req.session.rowId);
      console.log("patient mr", patient.mr_no);
      // console.log("patient s mr", req.session.mrNo);
      if (patient) {
        console.log(1);
        if (patient.mr_no) {
          console.log(2);
          const patient2 = id
            ? await PR_BillPharmacy.findByPk(
              decryptData(decodeURIComponent(id), "ll")
            )
            : null;
          console.log("patient2", patient2);
          if (id && !patient2) {
            req.session.alert = "No patient found for the provided ID.";
            return res.redirect("/MainBill/1");
          }

          return res.render("MainBilling/pharmacyBilling", {
            patient: patient,
            patient2: patient2 || "",
            currentDate: currentDate,
            currentTime: currentTime,
          });

        } else {
          req.session.alert = "Mismatch in patient MR number.";
          return res.redirect("/MainBill/1");
        }
      } else {
        // Handle case where no patient is found for the given id
        return res.redirect("/MainBill/1");
      }
    } catch (error) {
      console.error("Error fetching patient:", error);
      return res.status(500).send("Internal Server Error");
    }
  } else {
    // Redirect if no rowId is in the session and no ID is provided
    return res.redirect("/MainBill/1");
  }
});

router.get("/102", async function (req, res) {
  const id = req.query.id;
  const now = new Date();
  const currentDate = now.toISOString().split("T")[0]; // YYYY-MM-DD
  const currentTime = now.toTimeString().split(" ")[0]; // HH:MM:SS

  try {
    // Check if the id is provided in the query
    let patient = null;
    let patient2 = null;

    if (id) {
      // Fetch the patient by ID (decrypt if necessary)
      patient2 = await PR_BillFindPatient.findByPk(decryptData(decodeURIComponent(id), "ll"));

      // If no patient found with the provided ID, redirect with an alert
      if (!patient2) {
        req.session.alert = "No patient found for the provided ID.";
        return res.redirect("/MainBill/1");
      }

      // Fetch the main patient data using `mr_no` or any other field if necessary
      patient = await PR_patientReg.findOne({ where: { mr_no: patient2.mrNo } });

      if (!patient) {
        req.session.alert = "No matching patient found for the provided ID.";
        return res.redirect("/MainBill/1");
      }
    }

    // Render the page with the patient data and current date and time
    return res.render("MainBilling/viewBill", {
      patient: patient || "",   // Pass an empty string if no patient found
      patient2: patient2 || "", // Pass an empty string if no patient2 found
      currentDate: currentDate,
      currentTime: currentTime,
    });

  } catch (error) {
    console.error("Error fetching patient:", error);
    return res.status(500).send("Internal Server Error");
  }
});
router.get("/104", async function (req, res) {
  const id = req.query.id;
  const now = new Date();
  const currentDate = now.toISOString().split("T")[0]; // YYYY-MM-DD
  const currentTime = now.toTimeString().split(" ")[0]; // HH:MM:SS

  try {
    // Check if the id is provided in the query
    let patient = null;
    let patient2 = null;

    if (id) {
      // Fetch the patient by ID (decrypt if necessary)
      patient2 = await PR_BillPharmacy.findByPk(decryptData(decodeURIComponent(id), "ll"));

      // If no patient found with the provided ID, redirect with an alert
      if (!patient2) {
        req.session.alert = "No patient found for the provided ID.";
        return res.redirect("/MainBill/1");
      }

      // Fetch the main patient data using `mr_no` or any other field if necessary
      patient = await PR_patientReg.findOne({ where: { mr_no: patient2.mrNo } });

      if (!patient) {
        req.session.alert = "No matching patient found for the provided ID.";
        return res.redirect("/MainBill/1");
      }
    }

    // Render the page with the patient data and current date and time
    return res.render("MainBilling/viewBillPharmacy", {
      patient: patient || "",   // Pass an empty string if no patient found
      patient2: patient2 || "", // Pass an empty string if no patient2 found
      currentDate: currentDate,
      currentTime: currentTime,
    });

  } catch (error) {
    console.error("Error fetching patient:", error);
    return res.status(500).send("Internal Server Error");
  }
});

router.get("/getFieldValues", async (req, res) => {
  const { tableName, fieldName } = req.query;

  if (!tableName || !fieldName) {
    return res.status(400).json({ msg: "Invalid parameters" });
  }

  try {
    const query = `SELECT DISTINCT ${fieldName} as value FROM ${tableName}`;
    const results = await sequelize.query(query, { type: QueryTypes.SELECT });

    return res.status(200).json(results);
  } catch (error) {
    console.error("Error fetching field values:", error);
    return res.status(500).json({ msg: "Internal Server Error" });
  }
});

router.get("/25", (req, res) => {
  res.render("MainBilling/bill-details");
});

router.get("/7", async (req, res) => {
  let Id;
  if (req.session.rowId) {
    Id = req.session.rowId;
    console.log("Row Data", Id);
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    res.render("MainBilling/bills-summary", { patient2: patient });
  } else {
    console.log("Hello");
    res.redirect("/MainBill/1");
  }


});
router.get("/103", async (req, res) => {
  let Id;
  if (req.session.rowId) {
    Id = req.session.rowId;

    console.log("Row Data", Id);
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    res.render("MainBilling/Pharmacy-bills-summary", { patient2: patient });
  } else {
    console.log("Hello");
    res.redirect("/MainBill/1");
  }


});
router.get("/101", (req, res) => {

  res.render("MainBilling/approveBill");

});
router.get("/105", (req, res) => {

  res.render("MainBilling/approvePharmacyBill");

});

router.get("/8", (req, res) => {
  res.render("MainBilling/refund-services");
});
router.get("/34", (req, res) => {
  res.render("MainBilling/bills-for-approval");
});

router.get("/9", (req, res) => {
  res.render("MainBilling/approval-refund-service");
});

router.get("/10", (req, res) => {
  res.render("MainBilling/expenses");
});

router.get("/12", (req, res) => {

  res.render("MainBilling/approve-advance-refund");

});

router.get("/13", (req, res) => {
  res.render("MainBilling/billing-dashboard");
});

router.get("/14", (req, res) => {
  res.render("MainBilling/procedure-doctor");
});

router.get("/15", (req, res) => {
  res.render("MainBilling/procedure-doctor-search");
});

router.get("/16", (req, res) => {
  res.render("MainBilling/payment-mode-change");
});

router.get("/17", (req, res) => {
  res.render("MainBilling/doctor-payment");
});

router.get("/18", (req, res) => {
  res.render("MainBilling/doctor-payment-table-data-change");
});

router.get("/19", (req, res) => {
  res.render("MainBilling/doctor-payment-add-doctor");
});

router.get("/20", (req, res) => {
  res.render("MainBilling/doctor-payment-calculate");
});

router.get("/21", (req, res) => {
  res.render("MainBilling/company-invoice");
});

router.get("/22", (req, res) => {
  res.render("MainBilling/company-invoice-new");
});

router.get("/23", (req, res) => {
  res.render("MainBilling/company-invoice-new-add-company-bill");
});

router.get("/24", (req, res) => {
  res.render("MainBilling/package-consumption");
});

router.get("/32", (req, res) => {
  res.render("MainBilling/concent");
});

router.get("/35", async (req, res) => {
  console.log(req.query)
  const { id } = req.query;
  const decryptedDeptId = decryptData(decodeURIComponent(id), 'll'); // Extract dept_id from query parameters
  console.log('aa', decryptedDeptId)
  const clinicData = await CompanyHF.findOne({
    where: {
      clinic_id: req.user.clinicId
    }
  })
  try {
    if (id) {
      const bill = await PR_BillFindPatient.findByPk(decryptedDeptId);

      const patientData = await PR_patientReg.findOne({
        where: {
          mr_no: bill.mrNo,  
        }
      });
      const patientDataPlain = patientData.get({ plain: true });
      if (!bill) {
        console.error('not found:', dept_id);
        return res.status(404).render('error', { message: 'not found' });
      }
      const data = bill.get({ plain: true });

      let receipts = await getTransactionReceipts(bill.mrNo, 'all', 'all');
      receipts = receipts.filter(receipt => receipt.receiptType === 'Advance');
      const paymentDetails = await PR_BillPaymentDetails.findAll({
        where: { bill_no: data.bill_no },
      });
      const bifurcationData = paymentDetails.reduce((acc, payment) => {
        const adjustAdvancePayment = payment.adjustAdvancePayment || 0;
        const recievedAmount = payment.recievedAmount || 0;
        const createdAt = payment.createdAt
          ? new Date(payment.createdAt).toLocaleDateString('en-GB')
          : 'N/A';

        const paymentMethod =
          adjustAdvancePayment !== 0
            ? 'Adjust from Advance'
            : recievedAmount !== 0
              ? 'Counter Cash/ UPI/ NEFT/ RTGS'
              : 'Not Available';

        const amount = paymentMethod === 'Adjust from Advance'
          ? adjustAdvancePayment
          : recievedAmount - adjustAdvancePayment;

        // Add the first entry (for Adjust from Advance)
        acc.push({
          adjustAdvancePayment,
          amount,
          createdAt,
          paymentMethod,
        });

        // If adjustAdvancePayment is not 0, we add the next entry (Counter Cash/ UPI/ NEFT/ RTGS)
        if (adjustAdvancePayment !== 0) {
          const balance = recievedAmount - adjustAdvancePayment;
          acc.push({
            adjustAdvancePayment: 0, // For the next row, adjustAdvancePayment is 0
            amount: balance,
            paymentMethod: 'Counter Cash/ UPI/ NEFT/ RTGS', // Updated payment method
            createdAt,
          });
        }

        return acc;
      }, []);

      console.log('Bifurcation Data:', bifurcationData);

      return res.render("MainBilling/PrintBill", { a: data, patient: patientDataPlain, clinicData: clinicData, receipts: receipts, bifurcationData: bifurcationData, });
    } else {
      return res.render("MainBilling/PrintBill", { a: '', clinicData: clinicData });
    }
  } catch (error) {
    console.error('Error fetching  data:', error);
    return res.status(500).render('error', { message: 'Internal Server Error' });
  }

});
router.get("/109", async (req, res) => {
  console.log(req.query)
  const { id } = req.query;

  const decryptedDeptId = decryptData(decodeURIComponent(id), 'll'); // Extract dept_id from query parameters
  console.log('aa', decryptedDeptId)
  const clinicData = await CompanyHF.findOne({
    where: {
      clinic_id: req.user.clinicId
    }
  })

  try {
    if (id) {
      const bill = await PR_BillPharmacy.findByPk(decryptedDeptId);
      const patientData = await PR_patientReg.findOne({
        where: {
          mr_no: bill.mrNo,
        }
      });
      const patientDataPlain = patientData.get({ plain: true });
      if (!bill) {
        console.error('not found:', dept_id);
        return res.status(404).render('error', { message: 'not found' });
      }
      const data = bill.get({ plain: true });
      const paymentDetails = await PR_BillPaymentDetails.findAll({
        where: {
          bill_no: data.bill_no,
        }
      });
      const bifurcationData = paymentDetails.reduce((acc, payment) => {
        const adjustAdvancePayment = payment.adjustAdvancePayment || 0;
        const recievedAmount = payment.recievedAmount || 0;
        const createdAt = payment.createdAt
          ? new Date(payment.createdAt).toLocaleDateString('en-GB')
          : 'N/A';
        // First payment method and amount
        const paymentMethod =
          adjustAdvancePayment !== 0
            ? 'Adjust from Advance'
            : recievedAmount !== 0
              ? 'Counter Cash/ UPI/ NEFT/ RTGS'
              : 'Not Available';

        const amount = paymentMethod === 'Adjust from Advance'
          ? adjustAdvancePayment
          : recievedAmount - adjustAdvancePayment;

        // Add the first entry (for Adjust from Advance)
        acc.push({
          adjustAdvancePayment,
          amount,
          createdAt,
          paymentMethod,
        });

        // If adjustAdvancePayment is not 0, we add the next entry (Counter Cash/ UPI/ NEFT/ RTGS)
        if (adjustAdvancePayment !== 0) {
          const balance = recievedAmount - adjustAdvancePayment;
          acc.push({
            // adjustAdvancePayment: 0, // For the next row, adjustAdvancePayment is 0
            amount: balance,
            paymentMethod: 'Counter Cash/ UPI/ NEFT/ RTGS', // Updated payment method
            createdAt,
          });
        }

        return acc;
      }, []);

      console.log('Bifurcation Data:', bifurcationData);


      const paymentDetailsPlain = paymentDetails.map(payment => payment.get({ plain: true }));
      // const services= await BillServices.findAll({billId:bill.id})
      // const data = bill.get({ plain: true });
      console.log('values:', data);
      //data destructing kr rahe hai

      // async function sendPdf() {
      //   const pdf = await htmlToPdfGenerate("MainBilling/PrintBillPharmacy",{ a: data,patient: patientDataPlain ,clinicData:clinicData, bifurcationData:bifurcationData});
      //   await sendDocument(pdf,patientData);
      //   deletePdf(pdf)
      // }
      // sendPdf()


      return res.render("MainBilling/PrintBillPharmacy", { a: data, patient: patientDataPlain, clinicData: clinicData, bifurcationData: bifurcationData });
    } else {
      return res.render("MainBilling/PrintBillPharmacy", { a: '', clinicData: clinicData });
    }
  } catch (error) {
    console.error('Error fetching  data:', error);
    return res.status(500).render('error', { message: 'Internal Server Error' });
  }

});

router.get("/concent", (req, res) => {

  res.render("MainBilling/concent");
});
router.get("/33", (req, res) => {

  res.render("MainBilling/approve-company-adv-ref");
});

const {
  loadExpenses,
  newExpenses,
  getExpenses,
  getPaymentModeChange,
  saveStatusData,
  getAllDoctor,
  newCompanyAdvance,
  getAdvance,
  newCompRefund,
  getCompanyRefund,
  storeDataInDb,
  getConcent,
  getpatientBills,
  getServish,
  newBill,
  getApprove,
  newPatientAdvance,
  getPatientAdv,
  newRefund,
  setId,
  getAllApproveReq,
  getPatientServicesDaitle,
  getPrescriptions,
  getPatientAdvance,
  getPatientRefund,
  approvePatientRefundByRecNo,
  getCompanyAdvance,
  approveCompanyRefundByRecNo,
  getServiceDataById,
  sendForServiceApproval,
  getRefundServices,
  getServiceDataByBillId,
  approveSeriveRefund,
  getPatientPackages,
  getPatientAdvanceBalance,
  approveBills,
  getAllpatientBills,
  getpatientPharmacyBills,
  getAllPharmacypatientBills,
  approvePharmacyBills,
  fetchUserData,
  saveCounterSell,
  getCounterBills,
  getPatientPackage,
  savePackageBill,
  getNextRecNo

} = require("../controllers/MainBillingControllers");
const path = require("path");
const { error, PDFDocument } = require("pdf-lib");
const { billPatientSubmit, billPharmacyPatientSubmit } = require("../controllers/patientReg");
const { BillServices } = require("../models/PatientReg");
const { CounterSell, Advance } = require("../models/MainBill");
const { ClinicConfiguration, Clinic_name } = require("../models/clinicConfig");
const { CompanyHF } = require("../models/billingSchema");
const { htmlToPdfGenerate, deletePdf } = require("../apis/htmlToPdf");
const { sendDocument } = require("../apis/whatsappCloudApi");
const { send } = require("process");

router.post("/setAproveId", setId);

router.post("/save-status-data", saveStatusData);

router.get("/00", storeDataInDb);
router.get("/get-Patient-package-services", getPatientPackages);

router.post("/expenses-form-submit", newExpenses);
router.post("/company-advance-form-submit", newCompanyAdvance);
router.post("/company-refaund-form-submit", newCompRefund);
router.post("/bill-form-submit", newBill);
router.post("/patient-form-submit", newPatientAdvance);
router.post("/patient-Refund-form-submit", newRefund);

router.get("/get-service", async (req, res) => {
  try {
    const services = await sequelize.query("SELECT * FROM services", {
      type: sequelize.QueryTypes.SELECT,
    });
    console.log(services)
    res.json(services);
  } catch (error) {
    console.error("Error fetching services:", error);
    res.status(500).json({ error: "Internal server error" });
  }
});

router.post("/print-concent", async (req, res) => {
  try {
    const { patientReg } = req.body;
    console.log(req.body);
    const findPatient = await PR_patientReg.findOne({
      where: { mr_no: patientReg },
    });

    if (req.body.fileName == "file1") {
      const pdfPath = path.join(__dirname, "../views/Concent/pdf", "form-6.pdf");
      let firstPage = await getPath(pdfPath);

      DrawText(firstPage.firstPage, findPatient.clinic_id.toString(), 280, 730, 8);
      DrawText(firstPage.firstPage, findPatient.address, 75, 718, 8);

      await respond(firstPage.pdfDoc);
    } else if (req.body.fileName == "file2") {
      const pdfPath = path.join(__dirname, "../views/Concent/pdf", "form-7.pdf");
      let firstPage = await getPath(pdfPath);
      DrawText(firstPage.firstPage, findPatient.firstName, 80, 535, 9);
      DrawText(firstPage.firstPage, findPatient.spouse_firstName, 405, 535, 9);
      DrawText(firstPage.firstPage, 'Doctor', 80, 513, 9);
      DrawText(firstPage.firstPage, findPatient.firstName, 212, 317, 9);
      DrawText(firstPage.firstPage, findPatient.spouse_firstName, 318, 317, 9);

      await respond(firstPage.pdfDoc);
    } else if (req.body.fileName == "file3") {
      const pdfPath = path.join(__dirname, "../views/Concent/pdf", "form-8.pdf");
      let firstPage = await getPath(pdfPath);
      // Name (at the top)
      DrawText(firstPage.firstPage, findPatient.firstName, 105, 600, 8);

      // Doctor's Name
      DrawText(firstPage.firstPage, 'DOCTOR', 220, 635, 8);

      // ART Bank's No.
      DrawText(firstPage.firstPage, 'findPatient.artBankNo', 90, 600, 8);

      // ART Bank's Registration No.
      DrawText(firstPage.firstPage, 'findPatient.artBankRegNo', 300, 600, 8);

      // Obtained from (ART Bank)
      DrawText(firstPage.firstPage, 'findPatient.artBankObtainedFrom', 120, 580, 8);

      // ART Clinic Name
      DrawText(firstPage.firstPage, 'findPatient.clinicName', 330, 580, 8);


      await respond(firstPage.pdfDoc);
    } else if (req.body.fileName == "form-12") {
      const pdfPath = path.join(__dirname, "../concent/pdf", "form-12.pdf");
      let firstPage = await getPath(pdfPath);
      DrawText(firstPage.firstPage, findPatient.address, 210, 620, 8);
      DrawText(firstPage.firstPage, findPatient.address, 220, 390, 8);
      DrawText(firstPage.firstPage, findPatient.address, 315, 390, 8);

      await respond(firstPage.pdfDoc);
    }
    async function respond(pdfDoc) {
      const pdfBytes = await pdfDoc.save();
      fs.writeFileSync("./filled-consent-form.pdf", pdfBytes);
      res.status(200).json({
        success: true,
        message: "PDF filled and saved successfully.",
      });
    }

    // const pdfPath = path.join(__dirname, '../concent/pdf', 'form-7.pdf')
    // const existingPdfBytes = fs.readFileSync(pdfPath);
    // // const existingPdfBytes = fs.readFileSync('../concent/consent-art-rules-2022-36.pdf');
    // const pdfDoc = await PDFDocument.load(existingPdfBytes);
    // // Get the form
    // const pages = pdfDoc.getPages();
    // const firstPage = pages[0];

    // function DrawText(text, x, y, size) {
    //   firstPage.drawText(text, {
    //     x: x,
    //     y: y,
    //     size: size,
    //   });
    // }

    // DrawText(text1, 345, 756, 9);
    // DrawText(text2, 120, 744, 9);
    // DrawText(text3, 105, 619, 9);
    // DrawText(text4, 80, 527, 9);
    // DrawText(text5, 405, 527, 9);
    // DrawText(text6, 80, 505, 9);
    // DrawText(text7, 210, 310, 9);
    // DrawText(text8, 318, 310, 9);
    // DrawText(text9, 110, 77, 9);
    // DrawText(text10, 125, 64, 9);
    // // Save the PDF with the filled fields
    // const pdfBytes = await pdfDoc.save();
    // fs.writeFileSync('./filled-consent-form.pdf', pdfBytes);
    async function getPath(pdfPath) {
      const existingPdfBytes = fs.readFileSync(pdfPath);
      const pdfDoc = await PDFDocument.load(existingPdfBytes);
      const pages = pdfDoc.getPages();
      const firstPage = pages[0];
      return { firstPage, pdfDoc };
    }
    // const existingPdfBytes = fs.readFileSync('../concent/consent-art-rules-2022-36.pdf');

    // Get the form

    // firstPage.drawText(clinicName, {
    //   x: 275,
    //   y: 722,
    //   size: 8,
    // });
    // firstPage.drawText(clinicAddress, {
    //   x: 75,
    //   y: 710,
    //   size: 8,
    // });

    function DrawText(firstPage, text, x, y, size) {
      firstPage.drawText(text, {
        x: x,
        y: y,
        size: size,
      });
    }
    // Save the PDF with the filled fields
  } catch (error) {
    console.error(error.message);
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
});

router.get("/11", loadExpenses);

router.get("/get-expenses", getExpenses);
router.get("/get-doctor", getAllDoctor);
router.get("/get-advance", getAdvance);
router.get("/get-comp-refund", getCompanyRefund);
// router.get("/get-company-advance", getCompanyAdvance);
router.get("/getpatientBills", getpatientBills);
router.get("/getpatientPharmacyBills", getpatientPharmacyBills);
router.get("/getAllpatientBills", getAllpatientBills);
router.get("/getAllpatientPharmacyBills", getAllPharmacypatientBills);
router.get("/get-concent", getConcent);
router.get("/get-patient", getpatientBills);
router.post("/get-servish", getServish);
router.get("/get-approvel", getApprove);
router.get("/get-patient-advance", getPatientAdv);
router.get("/get-patient-package", getPatientPackage);
router.get("/getPatientAdvances", getPatientAdvance);
router.get("/getCompanyAdvance", getCompanyAdvance);
router.get("/getPatientRefunds", getPatientRefund);
router.get("/getCompanyRefund", getCompanyRefund);
router.get("/get-approve-request", getAllApproveReq);
router.get("/get-patient-daitle", getPatientServicesDaitle);
router.get("/getServiceData/:id", getServiceDataById);
router.get("/get-payment-change", getPaymentModeChange);
router.get("/get-patient-advannce", getPatientAdvanceBalance);

router.post("/billPatientSubmit", billPatientSubmit);
router.post("/billPharmacyPatientSubmit", billPharmacyPatientSubmit);

router.get("/filter-data", async (req, res) => {
  console.log("1");
  try {
    const { table, limit, offset, sortby, ...filters } = req.query;
    console.log(table);
    // Dynamically select the model based on the 'table' parameter
    const Model = require("../models/PatientReg")[table];
    console.log(Model);
    if (!Model) {
      return res.status(400).json({ message: "Invalid table name" });
    }

    console.log('sdsd', sortby);
    const clinicIds = await getClinicsForUser(req.user.clinicId, req.user.role);
    // Construct Sequelize filters
    let sequelizeFilters = { clinic_id: clinicIds };
    for (const [key, value] of Object.entries(filters)) {
      if (value) {
        sequelizeFilters[key] = { [Op.like]: `%${value}%` };
      }
    }

    const options = {
      where: sequelizeFilters,
      // limit: limit ? parseInt(15) : 10,
      offset: offset ? parseInt(offset) : 0,
      order: sortby ? [[sortby, "ASC"]] : [], // Default ordering
    };

    // Fetch data from the specified table

    const data = await Model.findAndCountAll(options);
    console.log(data)
    res.json(data);
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "An error occurred while fetching data" });
  }
});
router.get("/filter-data2", async (req, res) => {
  console.log("1");
  try {
    const { table, limit, offset, sortby, ...filters } = req.query;
    console.log(table);
    // Dynamically select the model based on the 'table' parameter
    const Model = require("../models/MainBill")[table];
    console.log(Model);
    if (!Model) {
      return res.status(400).json({ message: "Invalid table name" });
    }

    console.log('sdsd', sortby);
    // Construct Sequelize filters
    let sequelizeFilters = { clinic_id: req.user.clinicId };
    for (const [key, value] of Object.entries(filters)) {
      if (value) {
        sequelizeFilters[key] = { [Op.like]: `%${value}%` };
      }
    }

    const options = {
      where: sequelizeFilters,
      // limit: limit ? parseInt(15) : 10,
      offset: offset ? parseInt(offset) : 0,
      order: sortby ? [[sortby, "ASC"]] : [], // Default ordering
    };

    // Fetch data from the specified table

    const data = await Model.findAndCountAll(options);
    console.log(data)
    res.json(data);
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "An error occurred while fetching data" });
  }
});

// router.post('/form-6', async (req, res) => {
//   const { clinicName, clinicAddress } = req.body;
//   try {
//     // Load the existing PDF
//     const pdfPath = path.join(__dirname, '../concent/pdf', 'form-6.pdf');
//     const existingPdfBytes = fs.readFileSync(pdfPath);
//     // const existingPdfBytes = fs.readFileSync('../concent/consent-art-rules-2022-36.pdf');
//     const pdfDoc = await PDFDocument.load(existingPdfBytes);
//     // Get the form
//     const pages = pdfDoc.getPages();
//     const firstPage = pages[0];

//     firstPage.drawText(clinicName, {
//       x: 275,
//       y: 722,
//       size: 8,
//     });
//     firstPage.drawText(clinicAddress, {
//       x: 75,
//       y: 710,
//       size: 8,
//     });
//     // Save the PDF with the filled fields
//     const pdfBytes = await pdfDoc.save();
//     fs.writeFileSync('./filled-consent-form.pdf', pdfBytes);

//     res.send('PDF filled and saved successfully.');
//   } catch (error) {
//     console.error('Error filling PDF:', error);
//     res.status(500).send('Error filling PDF.');
//   }
// });
router.post("/form-7", async (req, res) => {
  try {
    const {
      text1,
      text2,
      text3,
      text4,
      text5,
      text6,
      text7,
      text8,
      text9,
      text10,
    } = req.body;
    // Load the existing PDF
    const pdfPath = path.join(__dirname, "../concent/pdf", "form-7.pdf");
    const existingPdfBytes = fs.readFileSync(pdfPath);
    // const existingPdfBytes = fs.readFileSync('../concent/consent-art-rules-2022-36.pdf');
    const pdfDoc = await PDFDocument.load(existingPdfBytes);
    // Get the form
    const pages = pdfDoc.getPages();
    const firstPage = pages[0];

    function DrawText(text, x, y, size) {
      firstPage.drawText(text, {
        x: x,
        y: y,
        size: size,
      });
    }

    DrawText(text1, 345, 756, 9);
    DrawText(text2, 120, 744, 9);
    DrawText(text3, 105, 619, 9);
    DrawText(text4, 80, 527, 9);
    DrawText(text5, 405, 527, 9);
    DrawText(text6, 80, 505, 9);
    DrawText(text7, 210, 310, 9);
    DrawText(text8, 318, 310, 9);
    DrawText(text9, 110, 77, 9);
    DrawText(text10, 125, 64, 9);
    // Save the PDF with the filled fields
    const pdfBytes = await pdfDoc.save();
    fs.writeFileSync("./filled-consent-form.pdf", pdfBytes);

    res.send("PDF filled and saved successfully.");
  } catch (error) {
    console.error("Error filling PDF:", error);
    res.status(500).send("Error filling PDF.");
  }
});

router.get('/filter-data', async (req, res) => {
  console.log('1');
  try {
    const { table, limit, offset, sortby, ...filters } = req.query;
    console.log(table);
    // Dynamically select the model based on the 'table' parameter
    const Model = require('../models/MainBill')[table];
    console.log(Model);
    if (!Model) {
      return res.status(400).json({ message: 'Invalid table name' });
    }

    console.log(sortby);
    // Construct Sequelize filters
    let sequelizeFilters = { clinic_id: req.user.clinicId };
    for (const [key, value] of Object.entries(filters)) {
      if (value) {
        sequelizeFilters[key] = { [Op.like]: `%${value}%` };
      }
    }

    const options = {
      where: sequelizeFilters,
      // limit: limit ? parseInt(limit) : 10,
      offset: offset ? parseInt(offset) : 0,
      order: sortby ? [[sortby, 'ASC']] : [], // Default ordering
    };

    // Fetch data from the specified table
    const data = await Model.findAndCountAll(options);
    res.json(data);
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: 'An error occurred while fetching data' });
  }
});

router.post('/sendForServiceApproval', sendForServiceApproval);
router.get("/prescriptions", getPrescriptions);
router.get("/getBillRefundData", getRefundServices);
router.get("/getApprServiceData/:approvalId", getServiceDataByBillId);

router.post('/approvePatRefund', approvePatientRefundByRecNo)
router.post('/approveServiceRefund', approveSeriveRefund)
router.post('/approveCompanyRefund', approveCompanyRefundByRecNo)
router.post('/approveBills', approveBills)
router.post('/approvePharmacyBills', approvePharmacyBills)

router.get("/111", (req, res) => {
  res.render("MainBilling/CounterBill");
});
router.get("/112", (req, res) => {
  res.render("MainBilling/counterBillList");
});

router.get('/113', async (req, res) => {
  try {
    const { id } = req.query;

    // Fetch the bill details from the CounterSell table
    const bill = await CounterSell.findOne({
      where: { id },
      raw: true // Optional: To simplify the object structure
    });
    console.log(bill)
    if (!bill) {
      return res.status(404).json({ message: 'Bill not found' });
    }

    // Fetch the patient details from the PR_patientReg table using patient_id from the bill
    const patient = await PR_patientReg.findOne({
      where: { id: bill.patient_id },
      raw: true // Optional: To simplify the object structure
    });

    console.log(patient)
    if (!patient) {
      return res.status(404).json({ message: 'Patient not found' });
    }

    // Render the EJS template and pass the bill and patient data
    res.render('MainBilling/printCounterBill', {
      data: bill,
      patient: patient
    });
  } catch (error) {
    console.error('Error fetching bill or patient details:', error);
    res.status(500).json({ message: 'Internal Server Error', error: error.message });
  }
});

router.get("/114", async (req, res) => {
  let Id;
  if (req.session.rowId) {
    Id = req.session.rowId;
    console.log("Row Data", Id);

    const patient = await PR_patientReg.findByPk(req.session.rowId);
    console.log(patient); // Check if the patient data is being fetched correctly

    res.render("MainBilling/PackageBill", { patient: patient });
  } else {
    console.log("Hello");

    res.redirect("/MainBill/1");
  }
});

router.get("/115", async (req, res) => {
  console.log(req.query);
  const { id } = req.query;

  try {
    const decryptedPackageId = decryptData(decodeURIComponent(id), 'll');
    console.log('Decrypted Package ID:', decryptedPackageId);

    const billId = decryptedPackageId.replace(/\D/g, '');
    console.log('Extracted Bill ID:', billId);
    const clinicData = await CompanyHF.findOne({
      where: { clinic_id: req.user.clinicId }
    });

    const query = `
      SELECT 
          bs.bill_no,
          bs.package_id,
          bs.stage,
          bs.patientId,
          bs.total_bifurcated_amount,
          bs.total_package_amount,
          bs.balance_amount,
          bs.adjust_advance,
          bs.paid_amount,
          bs.payment_mode,
          bs.createdAt,
          pc.assignedDoctor,
          pc.mrn->>'$.mr_no' AS mr_no,
          pc.amount->>'$.balance' AS balance_amount
      FROM bifurcation_stages AS bs
      LEFT JOIN patient_counseling AS pc ON bs.patientId = pc.patientId
      WHERE bs.bill_no LIKE :billId
      ORDER BY bs.createdAt DESC;
    `;

    const [packageBills] = await sequelize.query(query, {
      replacements: { billId: `%${billId}%` },
    });

    if (packageBills.length === 0) {
      return res.status(404).send("No records found for the given bill number.");
    }

    const { mr_no, assignedDoctor, balance_amount } = packageBills[0];
    console.log({
      packageBills,
      clinicData,
      mr_no,
      assignedDoctor,
      balance_amount, 
      bill_no: decryptedPackageId
    });

    res.render('MainBilling/packagebillprint', {
      packageBills,
      clinicData,
      mr_no,
      assignedDoctor,
      balance_amount, 
      bill_no: decryptedPackageId
    });

  } catch (error) {
    console.error('Error fetching package bills:', error);
    res.status(500).send('Server error');
  }
});

router.get('/service_masters', (req, res) => {
  const searchQuery = `%${req.query.query}%`;  // Add wildcard for LIKE

  // Log the query to ensure it's being passed correctly
  console.log("Received query:", req.query.query);

  const sql = `SELECT ser_name FROM service_masters WHERE ser_name LIKE ?`;

  // Query the database
  sequelize.query(sql, {
    replacements: [searchQuery], // Properly pass the query with wildcards
    type: sequelize.QueryTypes.SELECT
  })
    .then(results => {
      console.log("Results:", results);
      res.json(results);
    })
    .catch(err => {
      console.error("Database error:", err);
      res.status(500).json({ error: 'Database error', message: err.message });
    });
});

router.get('/api/emb_serviceadvices', (req, res) => {
  const patientId = req.query.patientId;

  if (!patientId) {
    return res.status(400).json({ error: 'Patient ID is required' });
  }

  // For MySQL 8.0+ (Updated query)
  const serviceAdviceQuery = 'SELECT JSON_UNQUOTE(JSON_EXTRACT(serviceAdvice, \'$[0].service\')) AS service FROM emb_serviceadvices WHERE patientId = :patientId';

  sequelize.query(serviceAdviceQuery, {
    replacements: { patientId },
    type: sequelize.QueryTypes.SELECT
  }).then(serviceAdvices => {
    console.log("Fetched Service Advice:", serviceAdvices);

    // Return the service value
    const serviceValues = serviceAdvices.map(advice => advice.service || 'No service available');

    res.json({ serviceAdvices: serviceValues });
  }).catch(err => {
    console.error("Error fetching service advices:", err);
    return res.status(500).json({ error: 'Database error while fetching service advices' });
  });
});

router.get('/get-prescription', async (req, res) => {
  const { patientId } = req.query;
  // const patientId = req.query.patientId;

  if (!patientId) {
    return res.status(400).json({ error: 'Patient ID is required' });
  }
  try {
    let prescription = await sequelize.query(
      'SELECT prescribedMedicine FROM emb_prescription WHERE patientId = :patientId',
      {
        type: sequelize.QueryTypes.SELECT,  
        replacements: { patientId },
        
      }
    );
    console.log("prescription fetched:", prescription);
    prescription = prescription.reverse()
    // Check if prescription exists
    if (prescription && prescription.length > 0) {
      // Directly use the prescription without parsing (since it's already an object or array)
      res.json({ prescribedMedicine: prescription[0].prescribedMedicine || 'No prescription found.' });
    } else {
      res.json({ prescribedMedicine: 'No prescription found.' });
    }
  } catch (error) {
    console.error("Error fetching prescription:", error);
    res.status(500).json({ error: error.message });
  }
});

router.get('/getPaymentAmount', (req, res) => {
  const { category } = req.query;
  console.log("Requested Category:", category);  // Debugging log

  if (!category) {
    console.log("Category not provided!");
    return res.status(400).json({ success: false, message: 'Category is required' });
  }

  // Query the database with the category value
  const query = 'SELECT total_bifurcated_amount FROM bifurcation_stages WHERE stage = ?';
  db.query(query, [category], (err, result) => {
    if (err) {
      console.error('Database error:', err);
      return res.status(500).json({ success: false, message: 'Database error' });
    }

    if (result.length > 0) {
      const amount = result[0].total_bifurcated_amount;
      console.log('Payment amount found:', amount);
      return res.json({ success: true, amount: amount });
    } else {
      console.log('No data found for category:', category);
      return res.status(404).json({ success: false, message: 'No amount found for the provided category' });
    }
  });
});

router.get('/get-total-advance', async (req, res) => {
  try {
    const patientId = req.query.patientId;
    if (!patientId) {
      console.error("ERROR: patientId is missing in the request");
      return res.status(400).json({ error: 'patientId is required' });
    }
    console.log(`Fetching total advance for patientId: ${patientId}`);
    const query =
      `SELECT m.balance_amount as total_advance
      FROM mainpatientadvance AS m
      INNER JOIN bifurcation_stages AS b ON m.patient_id = b.patientId
      WHERE b.patientId = :patientId;`
      ;

    const result = await sequelize.query(query, {
      replacements: { patientId },
      type: sequelize.QueryTypes.SELECT
    });
    console.log("Query Result:", JSON.stringify(result, null, 2));
    if (!result || result.length === 0) {
      console.warn("No records found for patientId:", patientId);
    }
    const distinctValues = [...new Set(result.map(item => parseFloat(item.total_advance) || 0))];
    const total_advance = distinctValues.reduce((sum, value) => sum + value, 0);
    console.log("Sum of Distinct Total Advance:", total_advance);
    res.send({ total_advance: total_advance });

  } catch (error) {
    console.error("UNEXPECTED ERROR:", error);
    res.status(500).json({ error: "Unexpected server error", details: error.message });
  }
});

router.get('/get-bifurcation-stages/:patientId', async (req, res) => {
  try {
    const { patientId } = req.params;

    const bifurcationStages = await Bifurcation_Stages.findAll({
      where: { patientid: patientId },
      attributes: ['stage', 'b_id']
    });
    console.log("biid", bifurcationStages);
    res.json(bifurcationStages);
  } catch (error) {
    console.error("Error fetching bifurcation stages:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
});

router.post('/save-payment', async (req, res) => {
  try {
    console.log("Received Request Body:", req.body);
    const {
      patientId,
      paid_amount,
      adjust_advance,
      balance_amount,
      remarks,
      stage,
      payment_mode
    } = req.body;
    const query =
      `SELECT m.balance_amount as totalAdvance
      FROM mainpatientadvance AS m
      INNER JOIN bifurcation_stages AS b ON m.patient_id = b.patientId
      WHERE b.patientId = :patientId;`
      ;
    const result = await sequelize.query(query, {
      replacements: { patientId },
      type: sequelize.QueryTypes.SELECT
    });

    console.log("Query Result:", JSON.stringify(result, null, 2));
    if (!result || result.length === 0) {
      console.warn("No records found for patientId:", patientId);
    }
    const distinctValues = [...new Set(result.map(item => parseFloat(item.totalAdvance) || 0))];
    const total_advance = distinctValues.reduce((sum, value) => sum + value, 0);
    console.log("Sum of Distinct Total Advance:", total_advance);
    const counselingRecord = await PatientCounseling.findOne({
      where: { patientId },
      attributes: ['cycle_id', 'package_bill_no', 'package_id', 'financialCounselingDate', 'amount']
    });
    const { cycle_id, package_bill_no, package_id, financialCounselingDate, amount } = counselingRecord;
    if (!amount || typeof amount !== 'object') {
      return res.status(400).json({ message: "Invalid amount data in patient counseling" });
    }
    const total_bifurcated_amount = amount[stage] ? parseFloat(amount[stage]) : 0;
    const lastBifurcation = await Bifurcation_Stages.findOne({
      where: { cycle_id },
      order: [['b_id', 'DESC']],
      attributes: ['b_id']
    });
    const b_id = lastBifurcation?.b_id + 1;
    console.log("Generated b_id:", b_id);

    const lastBill = await Bifurcation_Stages.findOne({
      order: [['b_id', 'DESC']],
      attributes: ['bill_no']
    });
    let newBillNo = "PACKBILL01";  // Default value for the first entry
    if (lastBill && lastBill.bill_no) {
      const lastNumber = parseInt(lastBill.bill_no.replace("PACKBILL", "")) || 0;
      const newNumber = lastNumber + 1;
      newBillNo = `PACKBILL${newNumber.toString().padStart(2, '0')}`;
    }
    console.log("Generated Bill No:", newBillNo);

    let total_package_amount = 0;
    Object.keys(amount).forEach(key => {
      if (key !== 'balance' && key !== 'discountPerc') {
        total_package_amount += parseFloat(amount[key]) || 0;
      }
    });
    console.log("Total Package Amount:", total_package_amount);

    amount.balance = (amount.balance) - parseFloat(paid_amount);

    await PatientCounseling.update(
      { amount },
      { where: { cycle_id } }
    );
    await Bifurcation_Stages.create({
      cycle_id,
      patientId,
      paid_amount: parseFloat(paid_amount),
      adjust_advance: parseFloat(adjust_advance),
      balance_amount: parseFloat(balance_amount),
      remarks: remarks || null,
      stage,
      b_id,
      total_package_amount,
      package_bill_no,
      package_id,
      total_bifurcated_amount,
      bill_no: newBillNo,
      stage_date: financialCounselingDate,
      payment_mode,
    });
    const newRecNo = await getNextRecNo();
    console.log("Generated Rec No:", newRecNo);

    const formattedDate = moment(new Date()).format('YYYY-MM-DD');
    console.log("Formatted Date:", formattedDate);

    const balanceAmount = total_advance - parseFloat(adjust_advance);
    console.log("Calculated Balance Amount:", balance_amount);
    const totalAdvanceValue = parseFloat(total_advance) || 0;
    console.log("Total Advance before saving:", totalAdvanceValue);

    await Advance.create({
      date: formattedDate, // Use formatted date here
      rec_no: newRecNo,
      patient_id: patientId,
      amount: totalAdvanceValue,  // Convert it to a float
      total_advance: 0,
      consume_amount: parseFloat(adjust_advance),
      refunded_amount: 0,
      balance_amount: balanceAmount,
      paymentMethod: payment_mode
    });

    res.status(200).json({ message: "Payment saved successfully", b_id, total_package_amount, newBillNo, newRecNo });
  } catch (error) {
    console.error("Error saving payment:", error);
    res.status(500).json({ error: error.message });
  }
});

router.get('/get-balance-amount', async (req, res) => {
  try {
    const patientId = req.query.patientId;

    // Step 1: Get the latest cycle_id for the patient
    const cycleQuery = `
      SELECT cycle_id 
      FROM patient_counseling
      WHERE patientId = :patientId
      ORDER BY updatedAt DESC
      LIMIT 1;
    `;

    const cycleResult = await sequelize.query(cycleQuery, {
      replacements: { patientId },
      type: sequelize.QueryTypes.SELECT
    });

    const cycle_id = cycleResult[0]?.cycle_id;

    if (!cycle_id) {
      return res.status(404).json({ message: "No cycle_id found for the patient." });
    }

    // Step 2: Query to get the balance amount using cycle_id
    const query = `
      SELECT JSON_UNQUOTE(JSON_EXTRACT(pc.amount, '$.balance')) AS balanceAmount
      FROM patient_counseling AS pc
      WHERE pc.cycle_id = :cycle_id;
    `;

    const result = await sequelize.query(query, {
      replacements: { cycle_id },
      type: sequelize.QueryTypes.SELECT
    });

    // Step 3: Extracting balance amount from the result
    const balanceAmount = result[0]?.balanceAmount || '0.00'; // Default to 0.00 if no balance is found
    console.log("Balance Amount Result:", balanceAmount);  // Debugging

    // Step 4: Return the balance amount in JSON format
    res.status(200).json({ balanceAmount });
  } catch (error) {
    console.log("Error fetching balance amount:", error.message);
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
});

router.get('/get-package-id/:patientId', async (req, res) => {
  try {
    const { patientId } = req.params;

    const package = await Bifurcation_Stages.findAll({ where: { patientId } })
    // const package = await sequelize.query(`SELECT bill_no FROM bifurcation_stages WHERE patientId = ? LIMIT 1`, [patientId]);
    console.log("fgh", package);
    if (package.length > 0) {
      res.json({ bill_no: package[0].bill_no });
    } else {
      res.json({ bill_no: null });
    }
  }
  catch (error) {
    console.error("Error fetching package id:", error);
  }
});

router.get("/getpatientData", fetchUserData);
router.post("/save-counter-sell", saveCounterSell);
router.get("/getCounterBills", getCounterBills);
router.post("/savePackageBill", savePackageBill);


module.exports = router;
