const express = require("express");
const { getPatientDetailsCounseling } = require("../controllers/reportsCtrl");
const router = express.Router();
const { Op, sequelize } = require('sequelize');
const { CompanyHF, getCombinedBills, getTransactionReceipts, getSapData, getEmrData, getCycleIdFromPatientId, getReceiptDetails, getBillsByDateRange } = require('../models/billingSchema');
const { con } = require("../sequelize");
const { PR_patientReg } = require("../models/PatientReg");
const { PatientCounseling } = require("../models/embrology");
const { getClinicalKpiReports } = require('../controllers/reportsCtrl');


const getClinicsForUser = async (userClinicId, role) => {
  if (role === 1) {
    // If the user is an admin, fetch all clinics under the main clinic
    const subClinics = await ClinicConfiguration.findAll({
      where: { clinic_id: userClinicId },
    });

    // Return the clinic ID for the main clinic plus all sub-clinic IDs
    return [userClinicId, ...subClinics.map(c => c.id)];
  }

  // If the user is a doctor, they only have access to their own clinic
  return [userClinicId];
};

// Route for Payment 
router.get('/paymentDetails', (req, res) => {
  res.render('Reports/PatientPaymentDetails');
});

// Route for Service Bills
router.get('/serviceBills', (req, res) => {
  res.render('Reports/serviceBills');
});

// Route for getting Counseling Details
router.get('/getCounselingDetails', getPatientDetailsCounseling);

router.get('/patientReports', async (req, res) => {
  console.log("patient", req.session.rowId);
  if (!req.session.rowId) {
    return res.redirect("/findpatient/6");
  }
  try {
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    if (!patient || !patient.mr_no) {
      req.session.alert = "Mismatch in patient MR number.";
      return res.redirect("/findpatient/6");
    }
    const mrNo = patient.mr_no;
    // Fetch billing data and transaction receipts (for payment mode chart)
    const { combinedBills } = await getCombinedBills(mrNo);
    const receiptType = 'all';
    const paymentType = 'all';
    const receipts = await getTransactionReceipts(mrNo, receiptType, paymentType);
    console.log("Receipts Fetched11:", receipts);
    const patientCounseling = await PatientCounseling.findAll({ where: { mrn: mrNo } });
    console.log("Simplified JSON Query Result:", JSON.stringify(patientCounseling, null, 2));
    let stageBillingData = {};
    console.log("abcd stage");

    if (true) {
      try {
        console.log("before stage");
        const patientCounseling = await PatientCounseling.findOne({
          where: {
            mrn: {
              [Op.like]: `%\"mr_no\":\"${mrNo}\"%`
            }
          },
          attributes: ['amount']
        });

        console.log("patientCounseling", patientCounseling);
        console.log("Executing Query:", `SELECT amount FROM patient_counseling WHERE mrn LIKE '%"mr_no":"${mrNo}"%'`);

        const amountData = patientCounseling?.dataValues?.amount || {};

        stageBillingData = Object.entries(amountData).reduce((acc, [stage, amount]) => {
          if (stage !== 'balance' && stage !== 'discountPerc' && amount) {
            acc[stage] = parseFloat(amount) || 0;
            console.log("Stage:", stage, "Amount:", amount, "Parsed Amount:", acc[stage]);
          }
          return acc;
        }, {});

      } catch (err) {
        console.error('Error parsing amount:', err);
      }
    }

    console.log("Processed Stage Billing Data:", stageBillingData);

    // Format data for the bar chart
    const formattedStageBillingData = Object.entries(stageBillingData).map(([stage, amount]) => ({
      label: stage,
      value: amount
    }));

    console.log("Formatted Stage Billing Data (for EJS):", formattedStageBillingData);
    res.render('Reports/patientReportsOptions', {
      combinedBills, receipts, formattedStageBillingData: JSON.stringify(formattedStageBillingData) || '[]'
    });
  } catch (error) {
    console.error('Error fetching reports:', error);
    res.render('Reports/patientReportsOptions', { combinedBills: [], receipts: "[]", formattedStageBillingData: "[]" });
  }
});

router.get('/getBillsData', async (req, res) => {
  const { fromDate, toDate } = req.query;
  console.log("patient", req.session.rowId);
  if (!req.session.rowId) {
    return res.redirect("/findpatient/6");
  }
  console.log("fromDate:", fromDate, "toDate:", toDate);

  try {
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    if (!patient || !patient.mr_no) {
      req.session.alert = "Mismatch in patient MR number.";
      return res.redirect("/findpatient/6");
    }
    const mrNo = patient.mr_no;
    const billsByDate = await getBillsByDateRange(mrNo, fromDate, toDate);
    console.log("Bills by Date:", billsByDate);
    res.json({ bills: billsByDate });
  } catch (error) {
    console.error('Error in getDate route:', error.message);
    res.status(500).send('Internal Server Error');
  }
});

router.get('/billingReports', async (req, res) => {
  console.log("patient Error ", req.session.rowId);
  if (!req.session.rowId) {
    return res.redirect("/findpatient/6");
  }
  try {
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    if (!patient || !patient.mr_no) {
      req.session.alert = "Mismatch in patient MR number.";
      return res.redirect("/findpatient/6");
    }

    console.log("patient mr", patient.mr_no);
    const mrNo = patient.mr_no;
    const { combinedBills } = await getCombinedBills(mrNo);
    console.log(combinedBills);

    res.render('Reports/billingReports', {
      mrNo,
      combinedBills,
    });
  } catch (error) {
    console.error('Error fetching billing reports:', error);  // Log the error for more details
    res.status(500).send(`Error fetching billing reports: ${error.message}`);
  }

});
// router.get("/pharmacy-bill/:billType", (req, res) => {
//     const { billType } = req.params;
//     const { id } = req.query; // Fetching id from query parameters

//     console.log("Received Request for:", billType);
//     console.log("Query Parameters:", req.query); // Debugging log

//     if (!id || id === "undefined" || id.trim() === "") {
//         console.error("Error: Missing or Invalid ID");
//         return res.status(400).send("Missing or Invalid ID");
//     }

//     let redirectUrl = "";
//     if (billType === "pharmacy") {
//         redirectUrl = `/MainBill/109?id=${encodeURIComponent(id)}`;
//     } else if (billType === "service") {
//         redirectUrl = `/MainBill/35?id=${encodeURIComponent(id)}`;
//     } else {
//         console.error("Invalid bill type:", billType);
//         return res.status(400).send("Invalid bill type");
//     }

//     console.log("Redirecting to:", redirectUrl);
//     res.redirect(redirectUrl);
// });

router.get('/transreports', async (req, res) => {
  console.log("patient", req.session.rowId);
  if (!req.session.rowId) {
    return res.redirect("/findpatient/6");
  }
  try {
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    if (!patient || !patient.mr_no) {
      req.session.alert = "Mismatch in patient MR number.";
      return res.redirect("/findpatient/6");
    }

    console.log("patient mr", patient.mr_no);
    const mrNo = patient.mr_no;
    const receiptType = 'all';
    const paymentType = 'all';
    const receipts = await getTransactionReceipts(mrNo, receiptType, paymentType);
    console.log('Receipts fetched:', receipts);
    res.render('Reports/transactions', { mrNo, receipts });
  } catch (error) {
    console.error('Error fetching transaction reports:', error.message);
    res.status(500).send(`Error fetching transaction reports: ${error.message}`);
  }
});

router.get('/receipt/:receiptNo', async (req, res) => {
  const { receiptNo } = req.params;

  try {
    const receipt = await getReceiptDetails(receiptNo); // Fetch receipt details
    if (!receipt) {
      return res.status(404).json({ error: 'Receipt not found' });
    }
    const clinicData = await CompanyHF.findOne({
      where: {
        clinic_id: req.user.clinicId
      }
    })
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    if (!patient || !patient.mr_no) {
      req.session.alert = "Mismatch in patient MR number.";
      return res.redirect("/findpatient/6");
    }

    console.log("patient mr", patient.mr_no);
    // const patient = await PatientModel.findOne({ where: { id: receipt.patient_id } }); // Adjust the query as needed

    if (!patient) {
      return res.status(404).json({ error: 'Patient not found' });
    }

    // Add patient details to the receipt object
    receipt.patientName = patient.name; // Adjust the field name as needed
    receipt.mrNo = patient.mrNo;
    console.log('Receipt Data:', receipt);
    console.log('Clinic Data:', clinicData);
    console.log('Patient Data:', patient);

    // Render the printable receipt template with the receipt data
    res.render('MainBilling/recPrint', { receipt, clinicData });
  } catch (error) {
    console.error('Error fetching receipt details:', error);
    res.status(500).json({ error: 'Failed to fetch receipt details' });
  }
});
router.get('/sapreports', async (req, res) => {
  // console.log("patient", req.session.rowId);
  if (!req.session.rowId) {
    return res.redirect("/findpatient/6");
  }
  try {
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    if (!patient || !patient.mr_no) {
      req.session.alert = "Mismatch in patient MR number.";
      return res.redirect("/findpatient/6");
    }

    // console.log("patient mr", patient.mr_no);
    const mrNo = patient.mr_no;
    let sapData = await getSapData(mrNo);

    console.log(sapData);
    
    // return res.send(sapData);
    // Render the report with the SAP data
    res.render('Reports/sap', {
      mrNo, sapData,
    });
  } catch (error) {
    console.error('Error fetching SAP reports:', error.message);  // Log the error for more details
    res.status(500).send(`Error fetching SAP reports: ${error.message}`);
  }
});


router.get('/emrreports', async (req, res) => {
  console.log("patient", req.session.rowId);

  if (!req.session.rowId) {
    return res.redirect("/findpatient/6");
  }

  try {
    const patient = await PR_patientReg.findByPk(req.session.rowId);
    
    if (!patient || !patient.mr_no) {
      req.session.alert = "Mismatch in patient MR number.";
      return res.redirect("/findpatient/6");
    }

    console.log("patient mr", patient.mr_no);
    const mrNo = patient.mr_no;
    console.log(`Fetching cycle details for MR No: ${mrNo}`);

    const cycleDetails = await getCycleIdFromPatientId(mrNo);
    console.log('Cycle Details Response:', cycleDetails);

    // ✅ Handle missing cycle IDs safely
    if (!Array.isArray(cycleDetails) || cycleDetails.length === 0) {
      console.warn(`No cycle ID found for patient with MR No: ${mrNo}. Redirecting to /findpatient/6`);
      req.session.alert = `No cycle data found for MR No: ${mrNo}.`;
      return res.redirect("/findpatient/6");
    }

    const cycleIds = cycleDetails.map(cycle => cycle.cycle_id);
    console.log(`Extracted Cycle ID: ${cycleIds}`);

    const emrDataArray = await Promise.all(cycleIds.map(id => getEmrData(id)));
    const emrData = emrDataArray.flat();
    console.log('Fetched Data:', emrData);
    
    res.render('Reports/emrrep', {
      mrNo,
      cycleData: cycleDetails,
      emrData,
    });

  } catch (error) {
    console.error('Error fetching EMR reports:', error.message);
    req.session.alert = "An error occurred while fetching the reports.";
    res.redirect("/findpatient/6");
  }
});


router.get('/api/getReportsByCycle', async (req, res) => {
  const cycleId = req.query.cycle_id;
  console.log('Received cycleId in API:', cycleId); // Check received cycleId

  if (!cycleId) {
    return res.status(400).json({ message: 'Cycle ID is required' });
  }

  try {
    const reports = await getEmrData(cycleId);
    if (!reports || reports.length === 0) {
      return res.status(404).json({ message: 'No reports found for this cycle' });
    }
    res.json({ reports });
  } catch (error) {
    console.error('Error fetching reports for cycleId:', cycleId, error);
    res.status(500).json({ message: 'Internal Server Error' });
  }
});

router.get('/api/getCycles', async (req, res) => {
  try {
    const cycles = await getCyclesFromDatabase(); // Fetch cycles from DB
    if (cycles.length === 0) {
      return res.status(404).json({ message: 'No cycles found.' });
    }
    res.json({ cycles });
  } catch (error) {
    console.error('Error fetching cycles:', error);
    res.status(500).json({ message: 'Server error occurred while fetching cycles.' });
  }
});

// Route to render patient history report
router.get('/embrology/patient-history', (req, res) => {
  const cycleId = req.query.cycleId;
  if (!cycleId) {
    return res.status(400).send('Cycle ID is required');
  }
  // Fetch and render patient history based on cycleId
  res.render('patient-history', { cycleId });
});

// Route for Discharge Summary FET report
router.get('/embrology/discharge-summary-fet-tabular', (req, res) => {
  const cycleId = req.query.cycleId;
  if (!cycleId) {
    return res.status(400).send('Cycle ID is required');
  }
  // Fetch and render Discharge Summary FET based on cycleId
  res.render('discharge-summary-fet-tabular', { cycleId });
});

// Route for Discharge Summary report
router.get('/embrology/discharge-summary', (req, res) => {
  const cycleId = req.query.cycleId;
  if (!cycleId) {
    return res.status(400).send('Cycle ID is required');
  }
  // Fetch and render Discharge Summary based on cycleId
  res.render('discharge-summary', { cycleId });
});

// Route for Discharge Summary IUI report
router.get('/embrology/iui-discharge-summary-formatted', (req, res) => {
  const cycleId = req.query.cycleId;
  if (!cycleId) {
    return res.status(400).send('Cycle ID is required');
  }
  // Fetch and render Discharge Summary IUI based on cycleId
  res.render('iui-discharge-summary-formatted', { cycleId });
});

// Route for Ultrasound TVS Graph report
router.get('/embrology/ultrasound-tvs-report-with-graph', (req, res) => {
  const cycleId = req.query.cycleId;
  if (!cycleId) {
    return res.status(400).send('Cycle ID is required');
  }
  // Fetch and render Ultrasound TVS Graph based on cycleId
  res.render('ultrasound-tvs-report-with-graph', { cycleId });
});

// Route for Ultrasound TVS report
router.get('/embrology/ultrasound-tvs-report', (req, res) => {
  const cycleId = req.query.cycleId;
  if (!cycleId) {
    return res.status(400).send('Cycle ID is required');
  }
  // Fetch and render Ultrasound TVS based on cycleId
  res.render('ultrasound-tvs-report', { cycleId });
});

// Route for Detailed Embryology report
router.get('/embrology/detailed-embryology-report', (req, res) => {
  const cycleId = req.query.cycleId;
  if (!cycleId) {
    return res.status(400).send('Cycle ID is required');
  }
  // Fetch and render Detailed Embryology report based on cycleId
  res.render('detailed-embryology-report', { cycleId });
});

router.post('/findpatient/storeRowId', (req, res) => {
  const { rowId } = req.body;

  // Store the selected patient ID in the session
  req.session.patientId = rowId;

  res.send({ success: true });
});



//? Marketing Kpi :-- 
router.get('/10', (req, res) => {
  res.render('Reports/marketingKpi')
})

//? Clincal Kpi :-- 
router.get('/11', (req, res) => {
  res.render('Reports/clinicalKpi')
})


router.get('/get-reports-response', getClinicalKpiReports)



module.exports = router;