require('dotenv').config();
const {Sequelize} = require('sequelize')

const { DB_NAME, DB_USERNAME, DB_PASSWORD, DB_HOST } = process.env;
//db test user root pass 
const sequelize = new Sequelize(DB_NAME, DB_USERNAME, DB_PASSWORD, {
  host: DB_HOST,
  port: 3306,
  dialect: 'mysql',
  // logging: console.log,
  define: {
    freezeTableName: true,  // Prevents automatic pluralization
    timestamps: true,       // Adds createdAt and updatedAt fields to tables
    hooks: {
      beforeDefine: (attributes, options) => {
        if (options.tableName) {
          // Ensures that if a tableName is provided, it will be converted to lowercase
          options.tableName = options.tableName.toLowerCase();
        } else {
          // If no tableName is provided, convert the model name to lowercase and use it
          options.tableName = options.modelName.toLowerCase();
        }
      }
    }
  }
});

const con = async () => {
  try {
    await sequelize.authenticate();
    console.log('DB Connected');
    return 'ok';
  } catch (error) {
    console.error('Unable to connect to DB:', error);
    return 'Unable to connect to DB';
  }
};
  
module.exports = {con,sequelize};