// function for genrating OTP

const generateAadhaarOtp = async (aadhaarNumber) => {
  if (!aadhaarNumber) {
    throw new Error("Aadhaar number is required");
  }

  try {
    const response = await axios.post(
      "https://kyc-api.surepass.io/api/v1/aadhaar-v2/generate-otp",
      {
        id_number: aadhaarNumber,
      },
      {
        headers: {
          "Content-Type": "application/json",
          Authorization: `Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJmcmVzaCI6ZmFsc2UsImlhdCI6MTcyMzgxMDUyMSwianRpIjoiNzk5NGRlZTctNWZiOS00NDcyLTkxYzgtNTE4YmYxMjVjZjdhIiwidHlwZSI6ImFjY2VzcyIsImlkZW50aXR5IjoiZGV2LmxpZmVsaW5rZXJAc3VyZXBhc3MuaW8iLCJuYmYiOjE3MjM4MTA1MjEsImV4cCI6MTcyNjQwMjUyMSwiZW1haWwiOiJsaWZlbGlua2VyQHN1cmVwYXNzLmlvIiwidGVuYW50X2lkIjoibWFpbiIsInVzZXJfY2xhaW1zIjp7InNjb3BlcyI6WyJ1c2VyIl19fQ.LO6_zf5B0SafS0F5LAJwvjC_Boelpcx1ouDupmW3J6o`, // Authorization header with Bearer token
        },
      }
    );

    const { data } = response.data;

    if (response.status === 200 && data.otp_sent) {
      console.log("OTP Sent successfully. Client ID:", data.client_id);
      return { clientId: data.client_id, message: "OTP sent successfully" };
    } else {
      throw new Error("Failed to send OTP");
    }
  } catch (error) {
    console.error("Error generating OTP:", error.message);
    throw new Error("Failed to generate OTP");
  }
};

// function for validating OTP and Fetching Client Aadhaar Details

const fetchAadhaarInfo = async (otp, clientId) => {
  if (!otp || !clientId) {
    throw new Error("OTP and Client ID are required");
  }

  try {
    const response = await axios.post(
      "https://kyc-api.surepass.io/api/v1/aadhaar-v2/submit-otp",
      {
        client_id: clientId,
        otp: otp,
      },
      {
        headers: {
          "Content-Type": "application/json",
          Authorization: `Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJmcmVzaCI6ZmFsc2UsImlhdCI6MTcyMzgxMDUyMSwianRpIjoiNzk5NGRlZTctNWZiOS00NDcyLTkxYzgtNTE4YmYxMjVjZjdhIiwidHlwZSI6ImFjY2VzcyIsImlkZW50aXR5IjoiZGV2LmxpZmVsaW5rZXJAc3VyZXBhc3MuaW8iLCJuYmYiOjE3MjM4MTA1MjEsImV4cCI6MTcyNjQwMjUyMSwiZW1haWwiOiJsaWZlbGlua2VyQHN1cmVwYXNzLmlvIiwidGVuYW50X2lkIjoibWFpbiIsInVzZXJfY2xhaW1zIjp7InNjb3BlcyI6WyJ1c2VyIl19fQ.LO6_zf5B0SafS0F5LAJwvjC_Boelpcx1ouDupmW3J6o`, // Authorization header with Bearer token
        },
      }
    );

    const { data } = response.data;

    if (response.status === 200 && data.status === "success_aadhaar") {
      console.log("Aadhaar information fetched successfully:", data);
      return data;
    } else {
      throw new Error("Failed to fetch Aadhaar information");
    }
  } catch (error) {
    console.error("Error fetching Aadhaar info:", error.message);
    throw new Error("Failed to fetch Aadhaar information");
  }
};

// example code to use like this

const aadhaarNumber = "123457897894";
const token = "x89y8sadsadjkasnd"; // Example token

// Step 1: Generate OTP
generateAadhaarOtp(aadhaarNumber)
  .then((otpResponse) => {
    const clientId = otpResponse.clientId;
    const otp = "756719"; // Replace with the actual OTP received
    // Step 2: Verify OTP and fetch Aadhaar info
    return fetchAadhaarInfo(otp, clientId);
  })
  .then((aadhaarInfo) => {
    console.log("Aadhaar Info:", aadhaarInfo);
  })
  .catch((error) => {
    console.error("Error:", error.message);
  });
