const express = require("express");
const axios = require("axios");
const sequelize = require("../db.config");
const fs = require("fs");
const app = express();
app.use(express.json());

const adharValidation = async (id_number) => {
  console.log(id_number);
  if (!id_number) {
    throw new Error("Aadhaar number is required");
  }

  try {
    const response = await axios.post(
      "https://sandbox.surepass.io/api/v1/aadhaar-validation/aadhaar-validation",
      {
        id_number: id_number,
      },
      {
        headers: {
          "Content-Type": "application/json",
          Authorization: "Bearer Your-Token",
        },
      }
    );

    return response.data;
  } catch (error) {
    console.error("Error validating Aadhaar:", error.message);
    throw new Error("Aadhaar validation failed");
  }
};

const panVerification = async (id_number) => {
  if (!id_number) {
    throw new Error("PAN number is required");
  }

  try {
    const response = await axios.post(
      "https://sandbox.surepass.io/api/v1/pan/pan-comprehensive",
      {
        id_number: id_number,
      },
      {
        headers: {
          "Content-Type": "application/json",
          Authorization:
            "Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJmcmVzaCI6ZmFsc2UsImlhdCI6MTcyMzgxMDUyMSwianRpIjoiNzk5NGRlZTctNWZiOS00NDcyLTkxYzgtNTE4YmYxMjVjZjdhIiwidHlwZSI6ImFjY2VzcyIsImlkZW50aXR5IjoiZGV2LmxpZmVsaW5rZXJAc3VyZXBhc3MuaW8iLCJuYmYiOjE3MjM4MTA1MjEsImV4cCI6MTcyNjQwMjUyMSwiZW1haWwiOiJsaWZlbGlua2VyQHN1cmVwYXNzLmlvIiwidGVuYW50X2lkIjoibWFpbiIsInVzZXJfY2xhaW1zIjp7InNjb3BlcyI6WyJ1c2VyIl19fQ.LO6_zf5B0SafS0F5LAJwvjC_Boelpcx1ouDupmW3J6o",
        },
      }
    );

    return response.data;
  } catch (error) {
    console.error("Error validating PAN:", error.message);
    throw new Error("PAN validation failed");
  }
};

// for testing purpose only

const getclientsAadhaarDetails = async (req, res) => {
  const client_id = req.body.client_id;

  try {
    const query = `select*from clientsAadhaar where client_id = ${client_id}`;
    // const query = `select*from clientsAadhaar`;

    console.log(`inside clientsAadhaar api`);

    const [results, metadata] = await sequelize.query(query);

    let res2 = JSON.stringify(results[0]);
    const resultsjson = res2;

    // Read existing data from the file
    let existingData = [];
    if (fs.existsSync("clientsAadhaarData.json")) {
      const fileData = fs.readFileSync("clientsAadhaarData.json", "utf8");

      if (fileData == "") {
      } else existingData = JSON.parse(fileData);
    }
  

    // Create a set of existing client_ids for quick lookup
    const existingClientIds = new Set(
      existingData.map((client) => client.client_id)
    );

    // Filter out clients that already exist in the file
    const newClients = results.filter(
      (client) => !existingClientIds.has(client.client_id)
    );

    // Combine existing data with new unique data
    const combinedData = existingData.concat(newClients);

    // //
    // // Combine existing data with new data
    // const combinedData = existingData.concat(results);

    // Write combined data to the file

    fs.writeFileSync(
      "clientsAadhaarData.json",
      JSON.stringify(combinedData, null, 2),
      "utf8"
    );

    res.json(results);
  } catch (error) {
    console.error(error);
    res.status(500).json({ message: "Server Error" });
  }
};

module.exports = { adharValidation, panVerification, getclientsAadhaarDetails };
