const axios = require("axios");

const initiateCall = async (toNumber, apiKey, token, callerId) => {
  if (!toNumber || !apiKey || !token || !callerId) {
    throw new Error("To number, API key, token, and caller ID are required");
  }

  try {
    const response = await axios.post(
      "https://rest.telecmi.com/v2/ind/click2call",
      {
        token: token, // Use the provided token
        to: toNumber, // Number to call
        extra_params: { crm: "true" }, // Example extra parameters
        callerid: callerId, // Caller ID for the call
      },
      {
        headers: {
          "Content-Type": "application/json",
          Authorization: `API-KEY ${apiKey}`, // API-KEY Authorization
        },
      }
    );

    const { data } = response;

    if (response.status === 200 && data.code === 200) {
      console.log(
        "Call initiated successfully:",
        data.msg,
        "Request ID:",
        data.request_id
      );
      return data;
    } else {
      throw new Error("Failed to initiate call");
    }
  } catch (error) {
    console.error("Error initiating call:", error.message);
    throw new Error("Failed to initiate call");
  }
};

const toNumber = 919582711211; // Replace with the actual number to call
const apiKey = "bc233ed1-9871-4e0d-9f29-e796b8e13f58"; // Replace with actual API key
const token =
  "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJjYXRlZ29yeSI6ImluciIsImlkIjoiMTExMV8zMzMzNDI2MyIsImluZXRfbm8iOjMzMzM0MjYzLCJuYW1lIjoiU2FoaWwiLCJpYXQiOjE3MjY2NTg4NzMsImV4cCI6MTcyOTI1MDg3M30.zVuiFqoWfQ9Pf9lfG2m_ygw2boE2LHhdcN2-gXtJ2Kk"; // Replace with actual token
const callerId = 911203203882; // Replace with actual caller ID

// initiateCall(toNumber, apiKey, token, callerId)
//   .then((response) => {
//     console.log("Call Response:", response);
//   })
//   .catch((error) => {
//     console.error("Error:", error.message);
//   });

module.exports = { initiateCall };
