const ejs = require('ejs');
const fs = require('fs');
const path = require('path');
const puppeteer = require('puppeteer');

async function generatePDF(html,pdfPath) {
    const browser = await puppeteer.launch();
  const page = await browser.newPage();

  await page.setContent(html, { waitUntil: 'domcontentloaded' });

  await page.pdf({
    path: pdfPath, // Output file path
    format: 'A4', // Paper size
    printBackground: true, // Include background color/images
  });

 // console.log('PDF generated:', pdfPath);

  await browser.close();
}

async function htmlToPdfGenerate(filename,data){
    const templatePath = path.join(__dirname,'..','views', filename +'.ejs');
    const template = fs.readFileSync(templatePath, 'utf8');
    //console.log(template);
   // const pdfPath = path.join(__dirname,'..','public','bills', 'pdf-' + new Date().getTime() +'.pdf');
    const pdfPath = path.resolve('public','bills', 'pdf-' + new Date().getTime() +'.pdf');
    
    const html = ejs.render(template, data);
    await generatePDF(html,pdfPath);
    console.log('DONE');
    return pdfPath;
}

function deletePdf(path){
  fs.unlink(path,(err)=>{
    if(err){
      console.log(err);
      
    }
    else{
      console.log("deleted");
      
    }
  })
  
}



module.exports = {htmlToPdfGenerate, deletePdf};