const APIsecret = "bc233ed1-9871-4e0d-9f29-e796b8e13f58";

const start_date = 1725193975000;
const end_date = 1725280375000;

const fetchMissedCalls = async (startDate, endDate, apiKey) => {
  if (!startDate || !endDate || !apiKey) {
    throw new Error("Start date, end date, and API key are required");
  }

  try {
    const response = await axios.post(
      "https://rest.telecmi.com/v2/missed",
      {
        appid: 33334263, // Replace with actual app ID if needed
        secret: apiKey, // Use the API key as the secret
        start_date: startDate,
        end_date: endDate,
      },
      {
        headers: {
          "Content-Type": "application/json",
          Authorization: `API-KEY ${apiKey}`, // API-KEY Authorization
        },
      }
    );

    const { data } = response;

    if (response.status === 200 && data.code === 200) {
      console.log("Missed calls data fetched successfully:", data.cdr);
      return data.cdr;
    } else {
      throw new Error("Failed to fetch missed calls data");
    }
  } catch (error) {
    console.error("Error fetching missed calls data:", error.message);
    throw new Error("Failed to fetch missed calls data");
  }
};

// example code to run it

/*

const startDate = 1569911400000;  // Example start date in timestamp
const endDate = 1570167249853;    // Example end date in timestamp
const apiKey = 'your-api-key-here';  // Replace with actual API key

fetchMissedCalls(startDate, endDate, apiKey)
  .then((missedCalls) => {
    console.log("Missed Calls:", missedCalls);
  })
  .catch((error) => {
    console.error("Error:", error.message);
  });



*/
