const {Router } = require('express');
const axios = require('axios');
const OutboundCall = require('../models/vapiCallModel');
const { sequelize } = require('../sequelize');
const router = Router();


// const phoneNumberId = 'eaa40384-1d8f-413b-a465-f73d0289043d';
// const assistantId = '12d182e3-1a33-4a9d-a736-d9787bfbb97c';
const API_KEY = 'e5e76bef-60b9-4b1f-8a03-7fce93833552';

const vapiServicesData ={
  assistantId:[],
  phoneNumberId:[],
  setAssistantId:function(data){
    if(!data) return;
    this.assistantId = [];
    data.forEach((entry)=>{
      this.assistantId.push(entry.id);
    })
  },
  setPhoneNumberId:function(data) {
    if(!data) return;
    this.phoneNumberId = [];
    data.forEach((entry)=>{
      this.phoneNumberId.push(entry.id);
    })
  }
}
async function getAssistants() {
  const {data} = await axios.get("https://api.vapi.ai/assistant",{
    headers:{
      "Authorization": `Bearer ${API_KEY}`,
    }
  })
  
  return data;
  
}

async function getPhoneIds() {
  const {data} = await axios.get("https://api.vapi.ai/phone-number",{
    headers:{
      "Authorization": `Bearer ${API_KEY}`,
    }
  })
  
  return data;
}

async function setVapiServices() {
  const phoneIdData = await getPhoneIds();
  vapiServicesData.setPhoneNumberId(phoneIdData);
  const assistantData = await getAssistants();
  vapiServicesData.setAssistantId(assistantData);
  console.log(vapiServicesData);
  
}


router.post('/initiate-call', async (req, res) => {

  
    console.log(req.body);
    //  await sequelize.sync({ alter: true }).then(() => {
    //     console.log("Database is synced!");
    // });
  await OutboundCall.sync({ alter: true });
  
    // const { phoneNumberId, assistantId, customerNumber } = req.body;
    //const { contactNo:customerNumber } = req.body;
    const customerNumber = '+1 848 315 2569';
     try {
      // Make a POST request to the VAPI API
      if(vapiServicesData.assistantId.length === 0 || vapiServicesData.phoneNumberId.length === 0){
        await setVapiServices();
      }
      const phoneNumberId = vapiServicesData.phoneNumberId[0];
      const assistantId = vapiServicesData.assistantId[0];
      const response = await axios.post(
        'https://api.vapi.ai/call',
        {
          phoneNumberId,
          assistantId,
          customer: { number: customerNumber },
        },
        {
          headers: {
            Authorization: `${API_KEY}`,
          },
        }
      );
      // Send the response data as JSON
      console.log("response",response.data);
      const callData = response.data;

      const newCall = await OutboundCall.create({
        id: callData.id,
        assistantId: callData.assistantId,
        phoneNumberId: callData.phoneNumberId,
        type: callData.type,
        createdAt: callData.createdAt,
        updatedAt: callData.updatedAt,
        orgId: callData.orgId,
        cost: callData.cost,
        customerNumber: callData.customer?.number, // Extracting number from nested object
        status: callData.status,
        phoneCallProvider: callData.phoneCallProvider,
        phoneCallProviderId: callData.phoneCallProviderId,
        phoneCallTransport: callData.phoneCallTransport,
        listenUrl: callData.monitor?.listenUrl, // Extracting from nested object
        controlUrl: callData.monitor?.controlUrl // Extracting from nested object
    });

    console.log("Outbound call inserted successfully:", newCall.toJSON());
      
      res.status(200).json(response.data);


    //return res.json({ message: 'Initiated call successfully' });
  
  
    } catch (error) {
      await setVapiServices();
      // Handle errors
      console.log("error",error.message);
      
      res.status(500).json({ message: 'Failed to place outbound call', error: error.message });
    }
  });


  module.exports = router;
  module.exports.setVapiServices = setVapiServices;
