require("dotenv").config();
const axios = require("axios");
const fs = require("fs");
const FormData = require("form-data");

const WHATSAPP_TOKEN = process.env.WHATSAPP_TOKEN;

const Phone = "917701940897";

//    async function sendMessage(mr_no, Phone = '917701940897', appointmentDate = '2022-01-01') {
//     try {
//         // Retrieve patient data (using PR_patientReg model, for example)
//         const patient = await PR_patientReg.findOne({
//             where: { mr_no: mr_no },
//             attributes: [
//                 'firstName',
//                 'lastName',
//                 'spouse_firstName',
//                 'spouse_lastName',
//                 'clinic_id',
//                 'doctor',
//                 'Gender',
//                 'spouse_gender',
//                 'is_employee',
//                 'spouse_occupation'
//             ]
//         });

//         if (!patient) {
//             return res.status(404).json({ error: 'Patient not found.' });
//         }

//         // Retrieve clinic information based on clinic_id
//         const clinic = await ClinicConfiguration.findOne({
//             where: { clinic_id: patient.clinic_id }
//         });

//         if (!clinic) {
//             return res.status(404).json({ error: 'Clinic not found.' });
//         }

//         // Construct clinic address
//         const clinicAddress = `${clinic.clinic_add_line1 || ''}, ${clinic.clinic_add_line2 || ''}, ${clinic.clinic_add_line_3 || ''}, ${clinic.clinic_city || ''}, ${clinic.clinic_state || ''}, ${clinic.clinic_country || ''}, Pincode: ${clinic.clinic_pincode || ''}`;

//         // Define patient prefix (Mr., Mrs., Dr., etc.)
//         let patientPrefix = '';
//         if (patient.Gender && patient.Gender.toLowerCase() === 'male') {
//             patientPrefix = 'Mr.';
//         } else if (patient.Gender && patient.Gender.toLowerCase() === 'female') {
//             patientPrefix = 'Mrs.';
//         }

//         if (patient.is_employee && patient.is_employee.toLowerCase() === 'doctor') {
//             patientPrefix = 'Dr.';
//         }

//         // Define spouse prefix (Mr., Mrs., Dr., etc.)
//         let spousePrefix = '';
//         if (patient.spouse_gender && patient.spouse_gender.toLowerCase() === 'male') {
//             spousePrefix = 'Mr.';
//         } else if (patient.spouse_gender && patient.spouse_gender.toLowerCase() === 'female') {
//             spousePrefix = 'Mrs.';
//         }

//         // Construct patient and spouse names
//         const patientName = `${patientPrefix} ${patient.firstName || ''} ${patient.lastName || ''}`;
//         const spouseName = `${spousePrefix} ${patient.spouse_firstName || ''} ${patient.spouse_lastName || ''}`;
//         const clinicId = patient.clinic_id;
//         const doctorName = patient.doctor || 'Not Assigned';

//         // Prepare the template data
//         const templateData = {
//             messaging_product: 'whatsapp',
//             to: Phone, // Recipient's phone number
//             type: 'template',
//             template: {
//                 name: 'patient_name',  // Replace with your template name
//                 language: {
//                     code: 'en_US'
//                 },
//                 components: [
//                     {
//                         type: 'body',
//                         parameters: [
//                             { type: 'text', text: patientName },       // Patient Name with prefix
//                             { type: 'text', text: spouseName },         // Spouse Name with prefix
//                             { type: 'text', text: clinicId.toString() }, // Clinic ID
//                             { type: 'text', text: doctorName },          // Doctor Name
//                             { type: 'text', text: appointmentDate },      // Appointment Date
//                             { type: 'text', text: clinicAddress }         // Clinic Address
//                         ]
//                     }
//                 ]
//             }
//         };

//         // Send message via WhatsApp API
//         const response = await axios({
//             url: 'https://graph.facebook.com/v21.0/565640756626368/messages', // Your API endpoint
//             method: 'post',
//             headers: {
//                 'Authorization': `Bearer ${WHATSAPP_TOKEN}`,
//                 'Content-Type': 'application/json'
//             },
//             data: JSON.stringify(templateData) // Use JSON.stringify to send the data as a string
//         });

//         console.log('Message sent successfully:', response.data);
//     } catch (error) {
//         if (error.response) {
//             console.error('Error response:', error.response.data);
//         } else {
//             console.error('Error sending message:', error.message);
//         }
//     }
// }

// Example usage
//  sendMessage("MR_42", '917701940897', '2022-01-01');

// async function sendMessageToWhatsApp(patientName, doctorName, clinicName, appointmentDate) {
//     // Format the time and date
//     const messageDate = new Date();
//     messageDate.setDate(messageDate.getDate() - 1);  // Set to 1 day ago
//     const formattedDate = messageDate.toLocaleString();  // Format the date for better readability

//     // Construct the message body
//     const message = `
//         Hello ${patientName},\n\n
//         This is a reminder for your appointment at ${clinicName} with Dr. ${doctorName}.\n
//         Appointment Date: ${appointmentDate}\n
//         Sent: ${formattedDate}
//     `;

//     // Construct the request payload for the WhatsApp API
//     const payload = {
//         messaging_product: 'whatsapp',
//         to: patientName,  // The recipient's phone number (in international format)
//         text: { body: message },
//     };

//     try {
//         // Send the message via WhatsApp Cloud API using Axios
//         const response = await axios.post(
//             `https://graph.facebook.com/v15.0/${phoneNumberId}/messages`,
//             payload,
//             {
//                 headers: {
//                     'Authorization': `Bearer ${accessToken}`,
//                     'Content-Type': 'application/json',
//                 },
//             }
//         );

//         console.log('Message sent successfully:', response.data);
//     } catch (error) {
//         console.error('Error sending message:', error.response ? error.response.data : error.message);
//     }
// }

// // Example usage
// const patientName = 'John Doe';
// const doctorName = 'Dr. Smith';
// const clinicName = 'ABC Clinic';
// const appointmentDate = '2025-01-23 10:00 AM';  // Format: YYYY-MM-DD HH:mm AM/PM

// sendMessageToWhatsApp(patientName, doctorName, clinicName, appointmentDate);

async function sendFollowUpMessage(followUpData, patientData) {
  try {
    const { firstName, lastName, Gender } = patientData; // Extract patient name and phone number
    // const { clinic, doctor, apt_date, apt_time } = followUpData;
    const { followUpDate, appointmentTime, requestedBy } = followUpData;
    // Format the appointment date and time
    const formattedDate = new Date(followUpDate).toLocaleDateString(); // Convert date to a readable format
    const formattedTime = appointmentTime; // Assuming time is already formatted in the model
    let patientPrefix = "";
    if (Gender && Gender.toLowerCase() === "male") {
      patientPrefix = "Mr.";
    } else if (Gender && Gender.toLowerCase() === "female") {
      patientPrefix = "Mrs.";
    }
    const patientName = `${patientPrefix} ${firstName || ""}  ${lastName}`;
    // Construct the request payload for the WhatsApp API template message
    const payload = {
      messaging_product: "whatsapp",
      to: Phone, // The recipient's phone number in international format
      type: "template",
      template: {
        name: "template_follow", // Replace with your actual WhatsApp template name
        language: { code: "en_US" }, // Replace with the desired language code
        components: [
          {
            type: "body",
            parameters: [
              { type: "text", text: patientName }, // Patient name
              { type: "text", text: requestedBy }, // Doctor name
              { type: "text", text: formattedDate }, // Appointment date
              { type: "text", text: formattedTime }, // Appointment time
            ],
          },
        ],
      },
    };

    // Send the message via WhatsApp Cloud API using Axios
    const response = await axios.post(
      `https://graph.facebook.com/v21.0/565640756626368/messages`,
      payload,
      {
        headers: {
          Authorization: `Bearer ${WHATSAPP_TOKEN}`,
          "Content-Type": "application/json",
        },
      }
    );

    console.log("Template message sent successfully:", response.data);
  } catch (error) {
    console.error(
      "Error sending template message:",
      error.response ? error.response.data : error.message
    );
  }
}

async function sendMessageToAppointment(userData, appointmentData) {
  try {
    // Fetch appointment details from the model using `kycId`
    // const appointment = await CrmApt_record.findOne({
    //   where: { kyc_id: kycId },
    //   attributes: ["clinic", "doctor", "apt_date", "apt_time", "patient_name"], // Fetch patient_name too
    // });

    // if (!appointment) {
    //   console.error("Appointment not found for the given KYC ID.");
    //   return;
    // }
    const { patient_name, patient_gender } = userData; // userdata se phone number bi nikal lunga  mobile_husband
    const { clinic, doctor, apt_date, apt_time } = appointmentData;

    let patientPrefix = "";
    if (patient_gender && patient_gender.toLowerCase() === "male") {
      patientPrefix = "Mr.";
    } else if (patient_gender && patient_gender.toLowerCase() === "female") {
      patientPrefix = "Mrs.";
    }
    const patientName = `${patientPrefix} ${patient_name || ""}`;
    // Format the appointment date and time
    const formattedDate = new Date(apt_date).toLocaleDateString(); // Convert date to a readable format
    const formattedTime = apt_time; // Assuming time is already formatted in the model

    // Construct the request payload for the WhatsApp API template message
    const payload = {
      messaging_product: "whatsapp",
      to: Phone, // The recipient's phone number in international format
      type: "template",
      template: {
        name: "template_two", // Replace with your actual WhatsApp template name
        language: { code: "en_US" }, // Replace with the desired language code
        components: [
          {
            type: "body",
            parameters: [
              { type: "text", text: patientName }, // Patient name
              { type: "text", text: doctor }, // Doctor name
              { type: "text", text: clinic }, // Clinic name
              { type: "text", text: formattedDate }, // Appointment date
              { type: "text", text: formattedTime }, // Appointment time
            ],
          },
        ],
      },
    };

    // Send the message via WhatsApp Cloud API using Axios
    const response = await axios.post(
      `https://graph.facebook.com/v21.0/565640756626368/messages`,
      payload,
      {
        headers: {
          Authorization: `Bearer ${WHATSAPP_TOKEN}`,
          "Content-Type": "application/json",
        },
      }
    );

    console.log("Template message sent successfully:", response.data);
  } catch (error) {
    console.error(
      "Error sending template message:",
      error.response ? error.response.data : error.message
    );
  }
}

async function uploadDocument(pdfPath) {
  //upload document
  try {
    const form = new FormData();
    form.append("file", fs.createReadStream(pdfPath), {
      filename: "bill.pdf",
    });
    form.append("messaging_product", "whatsapp");

    const response = await axios.post(
      "https://graph.facebook.com/v21.0/565640756626368/media",
      form,
      {
        headers: {
          Authorization: `Bearer ${WHATSAPP_TOKEN}`,
          ...form.getHeaders(),
        },
      }
    );

    console.log("Document uploaded successfully:", response.data);
    return response.data.id;
  } catch (error) {
    console.error(
      "Error uploading document:",
      error.response ? error.response.data : error.message
    );
    throw error;
  }
}

async function sendPDFMessage(mediaId, patientData) {
  //send document
  try {
    const { firstName, lastName } = patientData;
    const response = await axios({
      url: "https://graph.facebook.com/v21.0/565640756626368/messages",
      method: "post",
      headers: {
        Authorization: `Bearer ${WHATSAPP_TOKEN}`,
        "Content-Type": "application/json",
      },
      data: {
        messaging_product: "whatsapp",
        to: `${Phone}`,
        type: "document",
        document: {
          id: mediaId,
          caption: `Hello ${firstName} ${lastName}, Here is your bill for the recent appointment.`,
        },
      },
    });

    console.log("PDF document sent successfully:", response.data);
  } catch (error) {
    console.error(
      "Error sending document message:",
      error.response ? error.response.data : error.message
    );
  }
}

async function sendDocument(pdfPath, patientData) {
  try {
    const mediaId = await uploadDocument(pdfPath);

    if (mediaId) {
      await sendPDFMessage(mediaId, patientData);
    }
  } catch (error) {
    console.error("Error in sending document:", error.message);
  }
}

// sendDocument();

module.exports = {
  sendMessageToAppointment,
  sendFollowUpMessage,
  sendDocument,
};
