const LeadZapier = require("../models/zapierLeadModel");

const submitLead = async (req, res) => {
    try {
        const { name, email, phone, utm_source, utm_medium, utm_term, utm_content, utm_campaign, fbclid, gclid, ...extra } = req.body;

        
        let source = "other"; 
        if (fbclid) source = "facebook";
        else if (gclid) source = "google";
        else if (utm_source) source = utm_source.toLowerCase();

       // await LeadZapier.sync({ alter: true });

        // Store lead in database
        const lead = await LeadZapier.create({
            name,
            email,
            phone,
            utm_source,
            utm_medium,
            utm_term,
            utm_content,
            utm_campaign,
            source, 
            extra_data: extra,
        });

        res.status(201).json({ message: "Lead saved successfully", lead });
    } catch (error) {
        res.status(500).json({ error: "Failed to save lead" });
    }
};


const getLeads = async (req, res) => {
    try {
        const lead = await LeadZapier.findAll();
        res.render("leads", { lead });
        //res.status(200).json({ leads });
    } catch (error) {
        res.status(500).json({ error: "Failed to fetch leads" });
    }
}
module.exports = { submitLead, getLeads };          