var createError = require("http-errors");
var express = require("express");
var path = require("path");
var cookieParser = require("cookie-parser");
var logger = require("morgan");
var flash = require("connect-flash");
const multer = require("multer")
const md5 = require("md5");
const session = require("express-session");
const jwt = require("jsonwebtoken");
const compression = require("compression");
const MainBilling = require("./routes/MainBilling");
const Reports = require("./routes/newReports");
const helmet = require("helmet");
const concentRouter = require("./routes/concent");
const appRouter = require("./routes/AppConfig");
const notes = require("./routes/notes");
const facebookApiRoute = require("./routes/facebookApiRoute");
const zapierApiRoute = require("./routes/zapierLeadRoute")
const vapiCallRouter = require("./apis/vapiCallServices");
const leadRouter = require('./routes/leadRoute');
const fileRouter = require("./routes/file");
const { getNotRegisteredDetails } = require('./controllers/controller')


const { Admin, KYC } = require("./models/Kyc");
const clinicRoutes = require("./routes/clinicalRoute");
var adminInventory = require("./routes/adminInventory");
var usersRouter = require("./routes/users");
const { radioRouter } = require("./routes/Radiology");
var patientconfigRouter = require("./routes/patientconfig");
const mainInv = require("./routes/mainInv");
var billing = require("./routes/billing");
var indexRouter = require("./routes/Admin");
// var patRegRoute = require("./routes/PatientRegistration");
var packageConfigRouter = require("./routes/packageConfig");
var pathologyRouter = require("./routes/pathology");
var dashboard = require("./routes/360");
const recordRoutes = require("./routes/crm"); // Adjust the path
// const MainBilling = require("./routes/MainBilling");
const findpatient = require("./routes/PatientRegistration");
var embRouter = require("./routes/embrology");
var fieldData = require("./routes/fieldData");
const { ClinicConfiguration } = require("./models/clinicConfig");
const { UserTokens } = require("./models/UserTokens");
const CryptoJS = require("crypto-js");
var app = express();


function decryptData(encryptedData, secretKey) {
  try {
    const bytes = CryptoJS.AES.decrypt(encryptedData, secretKey);
    const decryptedText = bytes.toString(CryptoJS.enc.Utf8);

    if (!decryptedText) {
      throw new Error("Decryption failed, possibly due to incorrect key or missing salt/IV.");
    }
    return decryptedText;
  } catch (error) {
    console.error("Decryption error:", error.message);
    return null;
  }
}



const {
  kycCtrl,
  dashboardCtrl,
  modifyApt,
  modifyVisit,
  apt1,
  apt2,
  apt3,
  apt4,
  updateLeadTag,
  login,
  logoutFromEverywhere,
  register,
  logout,
  getAllKYCDetails,
  fetchLeadsByStatus,
  getLeadOwners,
  fetchFU,
  fetchApt,
  fetchVisits,
  fetchConv,
  transferLead,
  getLeadByKycId
} = require("./controllers/controller");

const storage = multer.diskStorage({
  destination: (req, file, cb) => {
    cb(null, "public/images/myuploads");
  },
  filename: function (req, file, cb) {
    const uniqueSuffix = Date.now() + "-" + Math.round(Math.random() * 1e9);
    cb(
      null,
      "clinical-" +
      file.fieldname +
      "-" +
      uniqueSuffix +
      path.extname(file.originalname)
    );
  },
});

const upload = multer({ storage: storage });


app.use(cookieParser());

app.use(
  session({
    secret: "abc", // change 'your_secret_key' to a real secret
    resave: false,
    saveUninitialized: true,
    cookie: { secure: "auto" }, // Adjust settings as necessary
  })
);

app.use(logger("dev"));
app.use(express.json());
app.use(express.urlencoded({ extended: true }));    
app.use(express.static(path.join(__dirname, "public")));

app.use(
  compression({
    level: 6,
    threshold: 100 * 1000,
    filter: (req, res) => {
      if (req.header["x-no-compression"]) {
        return false;
      }
      return compression.filter(req, res);
    },
  })
);



const authenticateMiddleware = (req, res, next) => {
  const token = req.cookies.token;

  // Allow access to the /1 and / routes
  const publicRoutes = ['/1', '/', '/login', '/getUserClinic', '/logoutFromEverywhere',];

  if (publicRoutes.includes(req.path)) {
    return next(); // Skip the authentication check for these routes
  }

  if (!token) {
    return res.status(404).send('Not Found'); // Return 404 error if token is missing
  }

  next();
};

// Place this at the top of your app.js file
app.use(authenticateMiddleware);


//  app.use(helmet());

// Middleware to ensure authentication
// const ensureAuthenticated = (req, res, next) => {
//   // Routes that do not require authentication
//   const openRoutes = ['/1', '/login'];

//   // Skip authentication check for open routes
//   if (openRoutes.includes(req.path)) {
//     return next();
//   }

//   console.log(req.session)
//   // Redirect unauthenticated users to login
//   if (!req.session.user) {

//     return res.redirect('/1');
//   }

//   // Proceed if authenticated
//   next();
// };

// // // Apply ensureAuthenticated globally
// app.use(ensureAuthenticated);

const JWT_SECRET = "ll";
const verifyToken = async (req, res, next) => {
  const token = req.cookies.token; // Read token from HttpOnly cookie
  console.log(token);

  if (!token) {
    return res.redirect("/1");
  }
  const user = await UserTokens.findOne({ where: { jwtToken: token } });
  console.log(user);

  if (!user) {
    return res.redirect("/1");
  }
  try {
    const decoded = jwt.verify(token, JWT_SECRET);
    req.user = decoded; // Attach user details to req.user
    res.locals.user = req.user; // Make user available in templates
    next();
  } catch (err) {
    return res.status(401).json({ message: "Invalid Token" });
  }
};
function checkRights(requiredRight) {
  return function (req, res, next) {
    // Check if the user exists and has the rights array
    if (req.user && req.user.rights && Array.isArray(req.user.rights)) {
      // Check if the requiredRight is included in the rights array
      if (req.user.rights.includes(requiredRight)) {
        // User has the required right
        return next();
      }
    }

    // If the required right is not found, redirect or handle access denial
    return res.redirect("/1"); // Redirecting to the access denied page
  };
}


app.use((req, res, next) => {
  const token = req.cookies.token;

  console.log(token);
  if (token) {
    try {
      const decoded = jwt.verify(token, JWT_SECRET);
      req.user = decoded;
      res.locals.user = req.user;
    } catch (err) {
      console.error("Invalid token", err);
    }
  }
  next();
});

// Middleware to get today's date
const todayDateMiddleware = (req, res, next) => {
  const today = new Date();
  const formattedDate = today.toISOString().split("T")[0]; // Format as YYYY-MM-DD
  req.todayDate = formattedDate;
  next();
};
app.use(todayDateMiddleware);

// Set views and engine
app.set("views", path.join(__dirname, "views"));
app.set("view engine", "ejs");

app.use((req, res, next) => {
  if (req.user) {
    console.log("User given: ", req.user);
    res.locals.clinicName = req.user.clinicName || "X";
  } else {
    console.log("No user found");
    res.locals.clinicName = "X"; // Default clinic name when no user is found
  }
  next();
});

// Routes setup
app.use("/field", fieldData);
app.use("/adminInv", verifyToken, checkRights('51'), adminInventory);
app.use("/clinic", verifyToken, checkRights('2'), clinicRoutes);
app.use("/users", verifyToken, usersRouter);
app.use("/radiology", verifyToken, checkRights('3'), radioRouter);
app.use("/patient", verifyToken, checkRights('3'), patientconfigRouter);
app.use("/MainInv", verifyToken, checkRights('52'), mainInv);
app.use("/billing", verifyToken, checkRights('23'), billing);
app.use("/Admin", verifyToken, checkRights('0000'), indexRouter);
app.use("/package", verifyToken, checkRights('2'), packageConfigRouter);
app.use("/concent", checkRights('3'), concentRouter);
app.use("/pathology", verifyToken, checkRights('3'), pathologyRouter);
app.use("/main", verifyToken, dashboard);
app.use("/findpatient", verifyToken, checkRights('3'), findpatient);
app.use("/MainBill", verifyToken, checkRights('23'), MainBilling);
app.use("/embrology", verifyToken, checkRights('174'), embRouter);
app.use("/appConfig", verifyToken, appRouter);
// app.use("/MainBill", verifyToken, checkRights('23'), MainBilling);  
app.use("/getRecords", verifyToken, recordRoutes);
app.use("/leads", verifyToken, leadRouter);
app.use("/file", fileRouter);
app.use('/reports',verifyToken, Reports)


app.get("/getUserClinic", async (req, res) => {

  try {
    // Log the user object to see the details (this is optional, for debugging)
    console.log('Req', req.query);

    // Extract the user identifier (e.g., userEmail, userId) from req.user
    const { username } = req.query; // You could also use req.user.id if userEmail isn't provided

    // Step 1: Query the User schema (or table) to get the clinicId
    const user = await SuperAdmin.findOne({
      where: { username: username }, // or you can use req.user.id to look up by userId
    });

    // If user is not found, return an error message
    if (!user) {
      return res.status(404).json({ msg: "User not found." });
    }

    // Extract the clinicId from the user record
    const { clinicId } = user;

    // Step 2: Use the clinicId to find the clinic from ClinicConfiguration table
    const clinic = await ClinicConfiguration.findAll({
      where: { clinic_id: clinicId },
    });
    console.log(clinic)
    // If clinic is not found, return an error message
    if (clinic == null) {
      return res.status(404).json({ msg: "Clinic not found." });
    }

    // Return the clinic details
    res.status(200).json(clinic);
  } catch (error) {
    console.error("Error fetching clinic details:", error);
    res.status(500).json({
      msg: "An error occurred while fetching clinic details.",
    });
  }
});


// Routes
app.get("/home", verifyToken, async (req, res) => {
  console.log(req.query);
  const { kyc_id } = req.query;
  console.log(kyc_id);
  const decId = decryptData(kyc_id, "ll");
  const admins = await Admin.findAll();
  try {
    if (decId) {
      const kycData = await KYC.findByPk(decId);

      if (!kycData) {
        console.error("record not found:", decId);
        return res.status(404).render("error", { message: "record not found" });
      }

      const kycValues = kycData.get({ plain: true });
      console.log(" values:", kycValues);
      return res.render("form-new", {
        a: kycValues,
        loginName: req.user.username,
        admins,
      });
    } else {
      console.log(req.user); // Now using JWT to fetch user info
      res.render("form-new", { a: "", loginName: req.user.username, admins });
    }
  } catch (error) {
    console.error("Error fetching  data:", error);
    return res
      .status(500)
      .render("error", { message: "Internal Server Error" });
  }
});

app.get("/", (req, res) => {
  res.redirect("/1");
});

app.get("/1", async (req, res) => {
  const token = req.cookies.token; // Retrieve the JWT token from cookies

  if (token) {
    try {
      // Verify the token
      const decoded = jwt.verify(token, JWT_SECRET);
      const user = await UserTokens.findOne({ where: { jwtToken: token } });
      console.log("hi");
      console.log(user);

      if (user) {
        return res.redirect("/patientlist");
      } else {
        console.log("in");
        return res.render("login");
      }
      // If the token is valid, redirect to home
    } catch (err) {
      console.error("Invalid token", err);
      // If token verification fails, continue to render login
    }
  }

  // If no valid token is found, render the login page
  res.render("login");
});

//
const setClinicName = (req, res, next) => {
  const token = req.cookies.token;

  if (token) {
    jwt.verify(token, JWT_SECRET, (err, decoded) => {
      if (!err) {
        res.locals.clinicName = decoded.clinicName; // Set clinicName in res.locals
      }
    });
  }
  next();
};

app.get("/patientlist", verifyToken, setClinicName, async (req, res) => {
  // Get the clinicName from the query parameters
  const clinicName = req.query.clinicName;
  // console.log("session id: ", req.session);

  // Check if the clinicName exists in the query string
  if (clinicName && clinicName.trim() !== "") {
    console.log("Clinic Name Received:", clinicName);
    // Set the clinicName in the session
    req.session.clinicName = clinicName;
  }

  // Render the form-new-list template
  res.render("form-new-list", {
    user: req.user,
    clinic: req.session.clinicName || "X",
  });
});

app.get("/2", (req, res) => {
  res.redirect(301, "/1");
});

app.get("/auditDash", (req, res) => {
  res.render("1-audit-trial-dashboard");
});
app.get("/corfin", (req, res) => {
  res.render("2-corporate-financial-dashboard");
});
app.get("/dailykpidash", (req, res) => {
  res.render("3-daily-kpi-dashboard");
});
app.get("/hosfindash", (req, res) => {
  res.render("4-hospital-financial-dashboard");
});


app.get("/dashboard", dashboardCtrl);
app.get("/get-pat-notregis-dtl", getNotRegisteredDetails);

app.get("/get-pat-dtl", getAllKYCDetails);
app.get('/get-all-leads', fetchLeadsByStatus);
app.get("/get-lead-owners", getLeadOwners);
const checkUHIDRoutes = require("./routes/360new");
app.use(checkUHIDRoutes);
app.post("/register", register);
app.post("/login", login);
app.post("/logout", logout);
app.post("/kycreg", upload.any(), kycCtrl);
app.post("/modify-apt", modifyApt);
app.post("/modify-vis", modifyVisit);
app.post("/appointment_1", apt1);
app.post('/update_lead_tag', updateLeadTag);
app.post('/update-leads', transferLead);
app.get("/followUp-data/:kyc_id", fetchFU);
app.get("/getLeadByKycId", getLeadByKycId);
app.get("/appointment-data/:kyc_id", fetchApt);
app.get("/visited-appointment-data/:kyc_id", fetchVisits);
app.get("/converted-appointment-data/:kyc_id", fetchConv);
app.post("/appointment_2", apt2);
app.post("/appointment_3", apt3);
app.post("/appointment_4", apt4);
app.post("/logoutFromEverywhere", logoutFromEverywhere);
app.use("/api", notes);
app.use("/", vapiCallRouter)

// Catch 404 and forward to error handler
app.use(function (req, res, next) {
  next(createError(404));
});

// Error handler
app.use(function (err, req, res, next) {
  console.error("Server error is here:", err);
  res.locals.message = err.message;
  res.locals.error = req.app.get("env") === "development" ? err : {};
  res.status(err.status || 500);
  res.render("error");
});

// Start the server
const { con } = require("./sequelize");
const { SuperAdmin } = require("./models/Admin");

const PORT = 5000;
app.listen(PORT, async () => {
  console.log(`Server started at PORT ${PORT}`);
  await con();
});

module.exports = app;


