const { sequelize } = require("../sequelize");

const CryptoJS = require("crypto-js");
const PDFDocument = require("pdfkit");
const {
  serviceAdvice,
  doctorNotes,
  diagnosis,
  GeneralExamination,
  treatmentHist,
  History,
  allergies,
  chiefComplaint,
  treatmentAdvice,
  preExistingCondition,
  procedureAdvice,
  FollowUp,
  prescription,
  attachments,
  PatientCounseling,
  Day0Record,
  Day1Record,
  Day2Record,
  EmbryoTransfer,
  Day3Record,
  Day4Record,
  Day5Record,
  Day6Record,
  SpermAdvanceResult,
  StimulationSubmit,
  ScheduleEt,
  // ItemMasterNew,
  Outcome,
  stimulation,
  vitrifyOocyte,
  vitrifyEmbryos,
  Donor,
  DonorOocyte,
  BetaHcg,
  // PatientAssignPackage,
} = require("../models/embrology");

const { ClinicConfiguration } = require("../models/clinicConfig.js");
const { ConsentPatientUser } = require("../models/table_concent_User.js");
const { CrmApt_record } = require("../models/Kyc.js");
const { ItemMasterNew } = require("../models/adminInventorySchema.js");
const { PatientAssignPackage } = require("../models/MainBill");
const { PR_patientReg } = require("../models/PatientReg.js");

//decryption and encryption fxn

function decryptData(encryptedData, secretKey) {
  const bytes = CryptoJS.AES.decrypt(encryptedData, secretKey);
  return bytes.toString(CryptoJS.enc.Utf8);
}

function encryptDataForUrl(id) {
  const secretKey = CryptoJS.enc.Hex.parse("ll".repeat(16)); // 32-byte key
  const iv = CryptoJS.lib.WordArray.random(16); // 16-byte IV

  const encrypted = CryptoJS.AES.encrypt(id.toString(), "ll", {
    iv: iv,
    mode: CryptoJS.mode.CBC,
    padding: CryptoJS.pad.Pkcs7,
  });

  // Return the IV and encrypted data, formatted as "iv:encrypted"
  return `${iv.toString()}:${encrypted.toString()}`;
}

const Day0Submit = async (req, res) => {
  try {
    const {
      Date,
      Time,
      FertiMethod,
      primEmbrologist,
      secEmbrologist,
      incubator,
      remarks,
      reportData,
    } = req.body;

    // Get all uploaded files
    const files = req.files; // `req.files` will contain an array of uploaded files
    console.log(files);

    // Map growth images to report data
    let transformedReportData = JSON.parse(reportData).map((item, index) => {
      return {
        attempts: item.attempts || "",
        breakage: item.breakage || "",
        comments: item.comments || "",
        oocyteNo: item.oocyteNo || "",
        spzMorpho: item.spzMorpho || "",
        spzLocation: item.spzLocation || null,
        oocyteMorpho1: item.oocyteMorpho1 || "",
        oocyteMorpho2: item.oocyteMorpho2 || "",
        oocyteMorpho3: item.oocyteMorpho3 || "",
        oocyteMorpho4: item.oocyteMorpho4 || "",
        oocyteMorpho5: item.oocyteMorpho5 || "",
        oocyteMorpho6: item.oocyteMorpho6 || "",
        semenSampleId: item.semenSampleId || "",
        stageSurvival: item.stageSurvival || "",
        semenSourceIcon: item.semenSourceIcon || "",
        polarBodyPosition: item.polarBodyPosition || "",
        embryoGrowthImage: files[index] ? files[index].filename : "", // Save the filename of the uploaded growth image
      };
    });

    // Create a new record in the database
    const newReport = await Day0Record.create({
      Date,
      Time,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      FertiMethod,
      primEmbrologist,
      secEmbrologist,
      incubator,
      remarks,
      reportData: transformedReportData,
    });

    res.json({ success: true, report: newReport });
  } catch (error) {
    console.log(error);
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

const Day1Submit = async (req, res) => {
  try {
    const {
      primEmbrologist,
      Date,
      secEmbrologist,
      incubator,
      remarks,
      reportData,
    } = req.body;

    const files = req.files;
    console.log(files);

    let transformedReportData = JSON.parse(reportData).map((item, index) => ({
      pb: item.pb || "",
      pn: item.pn || "",
      grade: item.grade || "",
      pnSize: item.pnSize || "",
      viable: item.viable || "",
      oocyteNo: item.oocyteNo || "",
      noOfCells: item.noOfCells || "",
      spermSource: item.spermSource || "",
      cytoplasmicHalo: item.cytoplasmicHalo || "",
      npbDistribution: item.npbDistribution || "",
      zygoteMorphology: item.zygoteMorphology || "",
      embryoGrowthImageIcon: item.embryoGrowthImageIcon || "",
      embryoGrowthImageText: files[index] ? files[index].filename : "",
    }));

    const newReport = await Day1Record.create({
      primEmbrologist,
      secEmbrologist,
      incubator,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      Date,
      remarks,
      reportData: transformedReportData,
    });

    res.json({ success: true, report: newReport });
  } catch (error) {
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

const Day2Submit = async (req, res) => {
  try {
    const {
      primEmbrologist,
      Date,
      secEmbrologist,
      incubator,
      remarks,
      reportData,
    } = req.body;

    const files = req.files;

    let transformedReportData = JSON.parse(reportData).map((item, index) => ({
      grade: item.grade || "",
      status: item.status || "",
      BigFrag: item.BigFrag || "",
      totalMN: item.totalMN || "",
      Frag_Dis: item.Frag_Dis || "",
      Frag_Per: item.Frag_Per || "",
      biNuclei: item.biNuclei || "",
      comments: item.comments || "",
      embryoNo: item.embryoNo || "",
      oocyteNo: item.oocyteNo || "",
      symmetry: item.symmetry || "",
      NoOfCells: item.NoOfCells || "",
      noVisible: item.noVisible || "",
      monoNuclei: item.monoNuclei || "",
      multiNuclei: item.multiNuclei || "",
      spermSource: item.spermSource || "",
      embryoGrowthImageIcon: item.embryoGrowthImageIcon || "",
      embryoGrowthImageText: files[index] ? files[index].filename : "",
    }));

    const newReport = await Day2Record.create({
      primEmbrologist,
      secEmbrologist,
      incubator,
      Date,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      remarks,
      reportData: transformedReportData,
    });

    res.json({ success: true, report: newReport });
  } catch (error) {
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

const Day3Submit = async (req, res) => {
  try {
    const {
      primEmbrologist,
      Date,
      secEmbrologist,
      incubator,
      remarks,
      reportData,
    } = req.body;

    const files = req.files;

    let transformedReportData = JSON.parse(reportData).map((item, index) => ({
      grade: item.grade,
      status: item.status,
      BigFrag: item.BigFrag,
      totalMN: item.totalMN,
      Frag_Dis: item.Frag_Dis,
      Frag_Per: item.Frag_Per,
      biNuclei: item.biNuclei,
      comments: item.comments,
      embryoNo: item.embryoNo,
      oocyteNo: item.oocyteNo,
      symmetry: item.symmetry,
      NoOfCells: item.NoOfCells,
      noVisible: item.noVisible,
      monoNuclei: item.monoNuclei,
      multiNuclei: item.multiNuclei,
      spermSource: item.spermSource,
      assistedHatching: item.assistedHatching,
      embryoGrowthImageIcon: item.embryoGrowthImageIcon,
      embryoGrowthImageText: files[index] ? files[index].filename : "",
    }));

    const newReport = await Day3Record.create({
      primEmbrologist,
      secEmbrologist,
      incubator,
      Date,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      remarks,
      reportData: transformedReportData,
    });

    res.json({ success: true, report: newReport });
  } catch (error) {
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

const Day4Submit = async (req, res) => {
  try {
    const {
      primEmbrologist,
      Date,
      secEmbrologist,
      incubator,
      remarks,
      reportData,
    } = req.body;

    const files = req.files;

    let transformedReportData = JSON.parse(reportData).map((item, index) => ({
      icm: item.icm || "",
      stage: item.stage || "",
      status: item.status || "",
      trofect: item.trofect || "",
      biopsied: item.biopsied || false,
      comments: item.comments || "",
      embryoNo: item.embryoNo || "",
      oocyteNo: item.oocyteNo || "",
      symmetry: item.symmetry || "",
      noOfCells: item.noOfCells || "",
      pgdStatus: item.pgdStatus || "",
      compaction: item.compaction || "",
      spermSource: item.spermSource || "",
      pgdKeyFindings: item.pgdKeyFindings || "",
      fragmentPercent: item.fragmentPercent || "",
      assistedHatching: item.assistedHatching || false,
      fragmentDistribution: item.fragmentDistribution || "",
      embryoGrowthImageIcon: item.embryoGrowthImageIcon || "",
      embryoGrowthImageText: files[index] ? files[index].filename : "",
    }));

    const newReport = await Day4Record.create({
      primEmbrologist,
      secEmbrologist,
      incubator,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      Date,
      remarks,
      reportData: transformedReportData,
    });

    res.json({ success: true, report: newReport });
  } catch (error) {
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

const Day5Submit = async (req, res) => {
  try {
    const {
      primEmbrologist,
      Date,
      secEmbrologist,
      incubator,
      remarks,
      reportData,
    } = req.body;

    const files = req.files;

    let transformedReportData = JSON.parse(reportData).map((item, index) => ({
      icm: item.icm || "",
      addOn: item.addOn || "",
      grade: item.grade || "",
      stage: item.stage || "",
      status: item.status || "",
      trofect: item.trofect || "",
      biopsied: item.biopsied || false,
      comments: item.comments || "",
      embryoNo: item.embryoNo || "",
      oocyteNo: item.oocyteNo || "",
      pgdStatus: item.pgdStatus || "",
      spermSource: item.spermSource || "",
      computedGrade: item.computedGrade || "",
      expansionGrade: item.expansionGrade || "",
      pgdKeyFindings: item.pgdKeyFindings || "",
      embryoGrowthImageIcon: item.embryoGrowthImageIcon || "",
      embryoGrowthImageText: files[index] ? files[index].filename : "",
    }));

    const newReport = await Day5Record.create({
      primEmbrologist,
      secEmbrologist,
      incubator,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      Date,
      remarks,
      reportData: transformedReportData,
    });

    res.json({ success: true, report: newReport });
  } catch (error) {
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

const Day6Submit = async (req, res) => {
  try {
    const {
      primEmbrologist,
      Date,
      secEmbrologist,
      incubator,
      remarks,
      reportData,
    } = req.body;

    const files = req.files;

    let transformedReportData = JSON.parse(reportData).map((item, index) => ({
      icm: item.icm || "",
      addOn: item.addOn || "",
      grade: item.grade || "",
      stage: item.stage || "",
      status: item.status || "",
      trofect: item.trofect || "",
      biopsied: item.biopsied || false,
      comments: item.comments || "",
      embryoNo: item.embryoNo || "",
      oocyteNo: item.oocyteNo || "",
      pgdStatus: item.pgdStatus || "",
      spermSource: item.spermSource || "",
      computedGrade: item.computedGrade || "",
      expansionGrade: item.expansionGrade || "",
      pgdKeyFindings: item.pgdKeyFindings || "",
      embryoGrowthImageIcon: item.embryoGrowthImageIcon || "",
      embryoGrowthImageText: files[index] ? files[index].filename : "",
    }));

    const newReport = await Day6Record.create({
      primEmbrologist,
      secEmbrologist,
      incubator,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      Date,
      remarks,
      reportData: transformedReportData,
    });

    res.json({ success: true, report: newReport });
  } catch (error) {
    console.error(error); // Added error logging
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

// Patient EMR controllers
const serviceAdviceSubmit = async (req, res) => {
  try {
    const patientId = req.session.patientId;
    // Prepare the data to be saved
    const adviceData = {
      clinic_id: req.user.clinicId,
      patientId,
      ServiceAdvice: req.body, // Assigning the entire incoming JSON data to the 'ServiceAdvice' key
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new advice record with the modified data
    const newAdvice = await serviceAdvice.create(adviceData);

    // Responding with a success message and the newly created advice
    res.json({ success: true, advice: newAdvice });
  } catch (error) {
    console.error("Error saving advice:", error);
    res.status(500).json({ success: false, message: "Error saving advice" });
  }
};

const doctorNotesSubmit = async (req, res) => {
  try {
    // Prepare the data to be saved
    const notesData = {
      clinic_id: req.user.clinicId,
      patientId: req.session.patientId,
      doctorNotes: req.body, // Assigning the entire incoming JSON data to the 'ServiceAdvice' key
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new advice record with the modified data
    const newnotes = await doctorNotes.create(notesData);

    // Responding with a success message and the newly created advice
    res.json({ success: true, newnotes: newnotes });
  } catch (error) {
    console.error("Error saving advice:", error);
    res.status(500).json({ success: false, message: "Error saving advice" });
  }
};

const examinationSubmit = async (req, res) => {
  try {
    // Prepare the data to be saved
    const examinationData = {
      patientId: req.session.patientId,
      clinic_id: req.user.clinicId,
      GeneralExamination: req.body.generalExamination, // Assigning the 'generalExamination' part of the request
      UsgExamination: req.body.usgExamination, // Assigning the 'usgExamination' part of the request
      comments: req.body.comments, // Extracting comments if provided
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new record with the structured data
    const newExamination = await GeneralExamination.create(examinationData);

    // Responding with a success message and the newly created record
    res.json({ success: true, newExamination: newExamination });
  } catch (error) {
    console.error("Error saving examination:", error);
    res
      .status(500)
      .json({ success: false, message: "Error saving examination" });
  }
};

const attachmentSubmit = async (req, res) => {
  try {
    // Save the data to the attachments table
    const newAttachmentRecord = await attachments.create({
      patientId: req.session.patientId,
      clinic_id: req.user.clinicId,
      attachment: req.body,
      Date: new Date().toISOString().split("T")[0],
    });

    // Respond with success and details of saved files
    res.status(200).json({
      message: "Files uploaded successfully",
      files: req.body,
      dbRecord: newAttachmentRecord, // The saved DB record
    });
  } catch (error) {
    console.error("Error saving attachments:", error);
    res.status(500).json({ message: "Error saving attachments", error });
  }
};

const treatmentSubmit = async (req, res) => {
  try {
    const treatment = req.body[0].treatmentType;
    req.session.treatmentType = treatment;
    const donorId = req.body[0].donorId;

    // Prepare the data to be saved
    const treatmentData = {
      clinic_id: req.user.clinicId, // Retrieve or default clinic ID
      patientId: req.session.patientId, // Ensure these are provided in the req.body or set defaults
      doctorId: req.body.doctorId,
      cycleId: 0,
      treatment: req.body, // Directly using req.body as it should be the JSON array of treatment details
    };

    // Creating a new treatment advice record with the structured data
    const newTreatmentAdvice = await treatmentAdvice.create(treatmentData);

    // Ending cycle due to give treatment advice
    if (treatment === "Follow-Up" || treatment === "Conceive-Naturally") {
      return res.json({
        success: true,
        newTreatmentAdvice,
      });
    }

    if (donorId) {
      const donor = await DonorOocyte.findOne({
        where: {
          donorId,
          clinicId: req.user.clinicId,
        },
      });

      await donor.update(
        { status: 0 },
        { where: { donorId, clinicId: req.user.clinicId } }
      );

      await PatientCounseling.create({
        currentPage: "counselling",
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
        status: true,
        donorId: donorId,
      });
    } else {
      await PatientCounseling.create({
        currentPage: "counselling",
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
        status: true,
      });
    }

    // Responding with a success message and the newly created treatment advice record
    res.json({ success: true, newTreatmentAdvice: newTreatmentAdvice });
  } catch (error) {
    console.error("Error saving treatment advice:", error);
    res
      .status(500)
      .json({ success: false, message: "Error saving treatment advice" });
  }
};

const allergySubmit = async (req, res) => {
  try {
    // Prepare the data to be saved
    const allergyData = {
      clinic_id: req.user.clinicId, // Retrieve or default clinic ID
      patientId: req.session.patientId, // Ensure these are provided in the req.body or set defaults
      doctorId: req.body.doctorId,
      allergies: req.body, // Directly using req.body as it should be the JSON array of allergies
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new allergy record with the structured data
    const newAllergyRecord = await allergies.create(allergyData);

    // Responding with a success message and the newly created allergy record
    res.json({ success: true, newAllergyRecord: newAllergyRecord });
  } catch (error) {
    console.error("Error saving allergy:", error);
    res.status(500).json({ success: false, message: "Error saving allergy" });
  }
};

const complaintSubmit = async (req, res) => {
  try {
    // Prepare the data to be saved
    const complaintData = {
      clinic_id: req.user.clinicId, // Retrieve or default clinic ID
      patientId: req.session.patientId, // Ensure these are provided in the req.body or set defaults
      doctorId: req.body.doctorId,
      complaint: req.body, // Directly using req.body as it should be the JSON data for the complaint
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new chief complaint record with the structured data
    const newComplaintRecord = await chiefComplaint.create(complaintData);

    // Responding with a success message and the newly created chief complaint record
    res.json({ success: true, newComplaintRecord: newComplaintRecord });
  } catch (error) {
    console.error("Error saving chief complaint:", error);
    res
      .status(500)
      .json({ success: false, message: "Error saving chief complaint" });
  }
};

const HistSubmit = async (req, res) => {
  try {
    // Log the incoming request body
    console.log(`req.body infirlity history`, req.body);

    // Convert incoming JSON to an array format suitable for the 'History' JSON type
    // This assumes the entire `req.body` is the history data you want to save
    const historyDataArray = req.body; // Since req.body is already an array of histories

    // Prepare the data to be saved
    const historyData = {
      clinic_id: req.user.clinicId, // Placeholder: Replace with actual logic to obtain clinic_id
      patientId: req.session.patientId, // Placeholder: Replace with actual logic
      doctorId: req.body.doctorId || 0, // Placeholder: Replace with actual logic
      History: historyDataArray, // Storing the array directly to 'History'
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new history record with the structured data
    const newHistory = await History.create(historyData);

    // Responding with a success message and the newly created history record
    res.json({ success: true, newHistory: newHistory });
  } catch (error) {
    console.error("Error saving history:", error);
    res.status(500).json({ success: false, message: "Error saving history" });
  }
};

const procedureSubmit = async (req, res) => {
  try {
    // Convert incoming JSON to a format suitable for the 'procedure' JSON type
    // This assumes the entire `req.body` is the procedure data you want to save
    const procedureDataArray = req.body; // Since req.body is already an array of procedure advice

    // Prepare the data to be saved
    const procedureData = {
      clinic_id: req.user.clinicId, // Replace with actual logic to obtain clinic_id
      patientId: req.session.patientId, // Ensure these are provided in the req.body or set defaults
      doctorId: req.body.doctorId, // Ensure these are provided in the req.body or set defaults
      procedure: procedureDataArray, // Storing the array directly to 'procedure'
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new procedure advice record with the structured data
    const newProcedureRecord = await procedureAdvice.create(procedureData);

    // Responding with a success message and the newly created procedure advice record
    res.json({ success: true, newProcedureRecord: newProcedureRecord });
  } catch (error) {
    console.error("Error saving procedure advice:", error);
    res
      .status(500)
      .json({ success: false, message: "Error saving procedure advice" });
  }
};

const savePrescription = async (req, res) => {
  try {
    const { prescribedMedicine, prescribedComment } = req.body;

    const newPrescription = await prescription.create({
      patientId: req.session.patientId,
      clinic_id: req.user.clinicId,
      prescribedMedicine,
      prescribedComment,
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    });

    res.status(200).json({
      success: true,
      message: "Prescription saved successfully",
      data: newPrescription,
    });
  } catch (error) {
    console.error("Error saving prescription:", error);
    res.status(500).json({
      success: false,
      message: "Error saving prescription",
      error: error.message,
    });
  }
};

const followUpSubmit = async (req, res) => {
  try {
    const { followUps, recordedBy, recordedDate } = req.body;

    // Ensure followUps data is present
    // if (!followUps || !followUps.followUpDate || !followUps.requestedBy) {
    //   return res.status(400).json({
    //     success: false,
    //     message: "Missing follow-up date or requestedBy information",
    //   });
    // }

    if (req.body?.followUps[0]?.instructions) {
      const { followUpDate, requestedBy } = followUps[0];

      // Create a new record in CrmApt_record
      const newRecord = await CrmApt_record.create({
        apt_date: followUpDate,
        doctor: requestedBy,
        apt_status: "Visited",
        patientId: req.session.patientId,
      });

      const followUpsToSave = followUps.map((followUp) => {
        // Ensure the recordedDate is valid before converting it
        const safeRecordedDate = recordedDate
          ? new Date(recordedDate).toISOString().split("T")[0]
          : null;

        const safeFollowUpDate = followUp.followUpDate
          ? new Date(followUp.followUpDate).toISOString().split("T")[0]
          : safeRecordedDate;

        return {
          clinic_id: req.user.clinicId,
          patientId: req.session.patientId,
          doctorId: req.body.doctorId,
          recordedBy: recordedBy,
          recordedDate: safeRecordedDate,
          followUp: followUps,
          Date: safeFollowUpDate, // Use the safe date conversion
        };
      });

      const newFollowUpRecords = await FollowUp.bulkCreate(followUpsToSave);

      res.json({
        success: true,
        message: "Follow-up records saved successfully",
        newFollowUpRecords,
        recordedBy,
        recordedDate,
      });
    } else {
      const newFollowUpRecords = await FollowUp.create({
        clinic_id: req.user.clinicId,
        patientId: req.session.patientId,
        doctorId: req.body.doctorId,
        recordedBy: recordedBy,
        recordedDate: recordedDate,
        followUp: [followUps],
        Date: recordedDate, // Use the safe date conversion
      });

      res.json({
        success: true,
        message: "Follow-up records saved successfully",
        newFollowUpRecords,
        recordedBy,
        recordedDate,
      });
    }
  } catch (error) {
    console.error("Error saving follow-up:", error);
    res.status(500).json({ success: false, message: "Error saving follow-up" });
  }
};

const conditionsSubmit = async (req, res) => {
  try {
    // Convert incoming JSON to an array format suitable for the 'preCondition' JSON type
    // This assumes the entire `req.body` is the conditions data you want to save
    const conditionsDataArray = req.body; // Since req.body is already an array of conditions

    // Prepare the data to be saved
    const conditionsData = {
      clinic_id: req.user.clinicId, // Placeholder: Replace with actual logic to obtain clinic_id
      patientId: req.session.patientId, // Placeholder: Replace with actual logic
      doctorId: "", // Placeholder: Replace with actual logic
      preCondition: conditionsDataArray, // Storing the array directly to 'preCondition'
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new pre-existing condition record with the structured data
    const newConditionRecord = await preExistingCondition.create(
      conditionsData
    );

    // Responding with a success message and the newly created record
    res.json({ success: true, newConditionRecord: newConditionRecord });
  } catch (error) {
    console.error("Error saving pre-existing condition:", error);
    res
      .status(500)
      .json({ success: false, message: "Error saving pre-existing condition" });
  }
};

const treatmentHistSubmit = async (req, res) => {
  try {
    // Log the incoming request body
    console.log(req.body);

    // Convert incoming JSON to an array format suitable for the 'treatHist' JSON type
    const treatmentHistoryArray = Object.values(req.body); // Converts the row1, row2, etc., into an array

    // Prepare the data to be saved
    const treatmentData = {
      // clinic_id: req.body.clinic_id, // Ensure this value is provided or retrieved from the context
      // patientId: req.body.patientId,
      // doctorId: req.body.doctorId,
      clinic_id: req.user.clinicId,
      patientId: req.session.patientId,
      treatHist: treatmentHistoryArray, // Assigning the converted array to 'treatHist'
      Date: new Date().toISOString().split("T")[0], // Formatting today's date as 'YYYY-MM-DD'
    };

    // Creating a new treatment history record with the structured data
    const newTreatmentHist = await treatmentHist.create(treatmentData);

    // Responding with a success message and the newly created treatment history
    res.json({ success: true, newTreatmentHist: newTreatmentHist });
  } catch (error) {
    console.error("Error saving treatment history:", error);
    res
      .status(500)
      .json({ success: false, message: "Error saving treatment history" });
  }
};

const diagnosisDataSubmit = async (req, res) => {
  try {
    console.log(req.body); // Log the incoming request body

    // Map the incoming JSON data to the diagnosis model fields
    const diagnosisData = {
      // Assuming you have some way to get clinic_id, patientId, and doctorId
      clinic_id: req.user.clinicId,
      patientId: req.session.patientId,
      maleFactor: req.body.maleFactor,
      maleFactorRemarks: req.body.maleFactorOther,
      femaleFactor: req.body.femaleFactor,
      femaleFactorRemarks: req.body.femaleFactorOther,
      karyotypeAbnormality: req.body.karyotypeAbnormality,
      karyotypeAbnormalityRemarks: req.body.karyotypeOther,
      noOfInfYear: req.body.yearsInfertile || 0,
      other: req.body.otherFactors,
      Date: new Date().toISOString().split("T")[0], // Today's date in 'YYYY-MM-DD' format
    };

    // Creating a new diagnosis record with the structured data
    const newDiagnosis = await diagnosis.create(diagnosisData);

    // Responding with a success message and the newly created diagnosis record
    res.json({ success: true, newDiagnosis: newDiagnosis });
  } catch (error) {
    console.error("Error saving diagnosis:", error);
    res.status(500).json({ success: false, message: "Error saving diagnosis" });
  }
};

const saveSpermAdvanceResult = async (req, res) => {
  try {
    console.log(req.body); // req.body now contains your form data as a JSON object
    const newReport = await SpermAdvanceResult.create(req.body);
    res.json({ success: true, report: newReport });
  } catch (error) {
    console.error("Error saving report:", error);
    res.status(500).json({ success: false, message: "Error saving report" });
  }
};

const stimulationSubmit = async (req, res) => {
  try {
    let cycleId = req.session.cycle_id;
    let patientId = req.session.patientId;
    let DonorId = req.session.DonorId;
    let dataToSave;
    if (req.session.DonorId) {
      dataToSave = {
        cycleId: cycleId,
        patientId: patientId,
        clinicId: req.user.clinicId,
        DonorId: DonorId,
        ...req.body,
      };
    } else {
      dataToSave = {
        cycleId: cycleId,
        patientId: patientId,
        clinicId: req.user.clinicId,
        ...req.body,
      };
    }
    console.log(dataToSave);

    if (req.body.failedCycle) {
      await PatientCounseling.update(
        { status: false },
        {
          where: {
            patientId: patientId,
            cycle_id: cycleId,
            clinicId: req.user.clinicId,
          },
        }
      );
    }

    if (req.session.treatmentType == "IUI") {
      await PatientCounseling.update(
        { currentPage: "sperm" },
        {
          where: {
            patientId: patientId,
            cycle_id: cycleId,
            status: true,
            clinicId: req.user.clinicId,
          },
        }
      );
    } else {
      await PatientCounseling.update(
        { currentPage: "opu" },
        {
          where: {
            patientId: patientId,
            cycle_id: cycleId,
            status: true,
            clinicId: req.user.clinicId,
          },
        }
      );
    }

    if (req.body.readyForOpu) {
      dataToSave.firstTrigger = req.body.firstTrigger;
    }

    // Check if a record with the given cycleId already exists
    let existingRecord = await StimulationSubmit.findOne({
      where: {
        cycleId: cycleId,
        patientId: patientId,
        clinicId: req.user.clinicId,
      },
    });

    let newRecord;
    if (existingRecord) {
      // Update the existing record
      newRecord = await existingRecord.update(dataToSave);
    } else {
      // Create a new record
      newRecord = await StimulationSubmit.create(dataToSave);
    }

    res.json({ success: true, data: newRecord });
  } catch (error) {
    console.error("Error saving stimulation data:", error);
    res
      .status(500)
      .json({ success: false, message: "Error saving stimulation data" });
  }
};

const getTreatmentAdvice = async (req, res) => {
  try {
    const patientId = req.session.patientId;
    if (!patientId) {
      return res
        .status(400)
        .json({ success: false, message: "Patient ID not found in session." });
    }

    // Fetch treatment advice for the current patient
    const treatmentAdviceData = await treatmentAdvice.findOne({
      where: { patientId, clinic_id: req.user.clinicId },
    });

    if (treatmentAdviceData) {
      res.json({ success: true, data: treatmentAdviceData });
    } else {
      res.json({
        success: false,
        message: "No treatment advice found for this patient.",
      });
    }
  } catch (error) {
    console.error("Error fetching treatment advice:", error);
    res
      .status(500)
      .json({ success: false, message: "Error fetching treatment advice" });
  }
};

const getStimulationDetails = async (req, res) => {
  try {
    const cycleID = req.query.cycleID || req.session.cycle_id;

    if (!cycleID) {
      return res.status(400).json({ message: "Cycle ID is required" });
    }

    const stimulationDetails = await StimulationSubmit.findOne({
      attributes: ["stimulationCompletedOn", "stimulationRecordedBy"],
      where: { cycleId: cycleID },
    });

    if (!stimulationDetails) {
      return res.status(404).json({ message: "No stimulation details found" });
    }

    return res.status(200).json(stimulationDetails);
  } catch (error) {
    console.error("Error fetching stimulation details:", error);
    return res.status(500).json({ message: "Internal server error" });
  }
};

const getEtDateForAdmissionDischargeSummary = async (req, res) => {
  try {
    const cycleID = req.query.cycleID || req.session.cycle_id;

    if (!cycleID) {
      return res.status(400).json({ error: " Cycle ID is required. " });
    }

    const date = await ScheduleEt.findOne({
      where: { cycleId: cycleID },
      attributes: ["etDate"],
    });

    if (!date) {
      return res.status(404).json({ error: " ET Date not found. " });
    }

    res.status(200).json({
      etAdmissionDate: date.etDate,
    });
  } catch (error) {
    res.status(500).json({ error: "An internal server error occurred." });
  }
};

const saveScheduleEt = async (req, res) => {
  try {
    const { etDate, etTime, etTimeERA, reviewedBy, fertStatus } = req.body;

    // Check if a record with the given cycleId already exists
    let existingSchedule = await ScheduleEt.findOne({
      where: {
        cycleId: req.session.cycle_id,
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
      },
    });

    if (existingSchedule) {
      // If a record exists, update it
      existingSchedule = await existingSchedule.update({
        etDate,
        etTime,
        etTimeERA,
        reviewedBy,
        fertStatus,
      });

      res.status(200).json({
        success: true,
        message: "Schedule ET updated successfully",
        data: existingSchedule,
      });
    } else {
      // If no record exists, create a new one
      const newSchedule = await ScheduleEt.create({
        cycleId: req.session.cycle_id,
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
        etDate,
        etTime,
        etTimeERA,
        reviewedBy,
        fertStatus,
      });
      await PatientCounseling.update(
        { currentPage: "et" },
        {
          where: {
            patientId: req.session.patientId,
            cycle_id: req.session.cycle_id,
            status: true,
            clinicId: req.user.clinicId,
          },
        }
      );
      res.status(200).json({
        success: true,
        message: "Schedule ET saved successfully",
        data: newSchedule,
      });
    }
  } catch (error) {
    console.error("Error saving Schedule ET:", error);
    res.status(500).json({
      success: false,
      message: "Error saving Schedule ET",
      error: error.message,
    });
  }
};

// controllers/outcomeController.js

const submitOutcome = async (req, res) => {
  console.log(req.body);
  console.log(2);
  try {
    const {
      clinicalPregnancyDate,
      clinicalPregnancyRecordedBy,
      clinicalPregnancyLocation,
      noOfSac,
      clinicalPregnancyObservations,
      ongoingPregnancyObservations,
      miscarriageDate,
      miscarriageTime,
      abortionType,
      clinicalMiscarriageObservations,
      deliveryDate,
      birthRecordedBy,
      birthType,
      modeOfDelivery,
      neonatalComplications,
      postPartumMaternalComplications,
      birthDetailsObservations,
      betaHcgData,
      biochemicalPregnancy,
    } = req.body;

    // Save all data including Beta HCG as JSON
    const outcome = await Outcome.create({
      clinicalPregnancyDate,
      clinicalPregnancyRecordedBy,
      clinicalPregnancyLocation,
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      noOfSac,
      clinicalPregnancyObservations,
      ongoingPregnancyObservations,
      miscarriageDate,
      miscarriageTime,
      abortionType,
      clinicalMiscarriageObservations,
      deliveryDate,
      birthRecordedBy,
      birthType,
      modeOfDelivery,
      neonatalComplications,
      postPartumMaternalComplications,
      birthDetailsObservations,
      biochemicalPregnancy,
      betaHcgData, // JSON array of Beta HCG rows
    });
    await PatientCounseling.update(
      { currentPage: "cycle", status: false },
      {
        where: {
          patientId: req.session.patientId,
          cycle_id: req.session.cycle_id,
          status: true,
          clinicId: req.user.clinicId,
        },
      }
    );

    res.status(200).json({ message: "Data saved successfully", outcome });
  } catch (error) {
    res.status(500).json({ error: "An error occurred while saving data" });
  }
};

// beta hcg

// Controller to save Beta HCG data

const saveBetaHcg = async (req, res) => {
  try {
    // Retrieve data from session

    console.log(`model now rock michel`);
    console.log(`model now rock michel`);
    console.log(`model now rock michel`);
    console.log(`model now rock michel`);
    console.log(`model now rock michel`);
    console.log(`model now rock michel`);
    console.log(`model now rock michel`);

    const patientId = req.session.patientId;
    const cycleId = req.session.cycle_id;
    const clinicId = req.user.clinicId;

    // Validate that essential session data exists
    if (!patientId || !cycleId || clinicId==null) {
      return res
        .status(400)
        .json({ message: "Required session data is missing." });
    }

    // Extract additional data from the request body
    const { betahcgValue, betaHcgDate, recordedBy, observations } = req.body;

    // Create a new BetaHcg record
    const newRecord = await BetaHcg.create({
      cycleId: cycleId || 0, // Use default value if not provided
      patientId,
      clinicId,
      betahcgValue: betahcgValue || null,
      betaHcgDate: betaHcgDate || null,
      recordedBy: recordedBy || null,
      observations: observations || null,
    });

    // Send success response
    res.status(201).json({
      message: "Beta HCG record saved successfully.",
      data: newRecord,
    });
  } catch (error) {
    console.error("Error saving Beta HCG record:", error);
    res.status(500).json({
      message: "An error occurred while saving the Beta HCG record.",
      error: error.message,
    });
  }
};

// const saveBetaHcg = async (req, res) => {
//   try {
//     const { betahcgValue } = req.body;

//     // Extract data from session
//     const patientId = req.session.patientId;
//     const cycleId = req.session.cycle_id;
//     const clinicId = req.session.clinic_id;

//     // Validate required fields
//     if (!betahcgValue || !cycleId || !patientId || clinicId==null) {
//       return res.status(400).json({ message: "Missing required fields." });
//     }

//     // Create a new Beta HCG record
//     const newBetaHcg = await BetaHcg.create({
//       cycleId,
//       patientId,
//       clinicId,
//       betahcgValue,
//     });

//     return res.status(201).json({
//       message: "Beta HCG data saved successfully.",
//       data: newBetaHcg,
//     });
//   } catch (error) {
//     console.error("Error saving Beta HCG data:", error);
//     return res.status(500).json({ message: "An error occurred.", error });
//   }
// };

// beta hcg

// controllers/sperm

const {
  SemenSample,
  WashSemenSample,
  CanisterData,
  DiscardedSample,
} = require("../models/embrology.js");
const { Op, where } = require("sequelize");

const newSemenSample = async (req, res) => {
  try {
    // Extract and convert request body
    const {
      no_of_labels,
      time_of_receiving,
      received_on,
      received_by,
      collected_method,
      ph_value,
      sexual_abstinence_days,
      time_of_collect,
      date_of_collect,
    } = req.body;
    console.log(req.session.patientId);
    let formattedData;

    if (req.session.treatmentType == "donor") {
      formattedData = {
        no_of_labels: parseInt(no_of_labels, 10),
        time_of_receiving: time_of_receiving + ":00", // Format to 'HH:MM:SS'
        received_on: new Date(received_on), // Convert to Date object
        received_by,
        collected_method,
        ph_value: ph_value.toString(), // Ensure ph_value is a string
        sexual_abstinence_days: parseInt(sexual_abstinence_days, 10),
        time_of_collect: time_of_collect + ":00", // Format to 'HH:MM:SS'
        date_of_collect: new Date(date_of_collect), // Convert to Date object
        donorId: req.session.DonorId,
        cycleId: 12,
      };
    } else {
      // Convert and format data
      formattedData = {
        no_of_labels: parseInt(no_of_labels, 10),
        time_of_receiving: time_of_receiving + ":00", // Format to 'HH:MM:SS'
        received_on: new Date(received_on), // Convert to Date object
        received_by,
        collected_method,
        ph_value: ph_value.toString(), // Ensure ph_value is a string
        sexual_abstinence_days: parseInt(sexual_abstinence_days, 10),
        time_of_collect: time_of_collect + ":00", // Format to 'HH:MM:SS'
        date_of_collect: new Date(date_of_collect), // Convert to Date object
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
      };
    }

    // Create new SemenSample record
    const newSample = await SemenSample.create(formattedData);

    // Return success response
    res.status(201).json({
      status: "success",
      message: "Semen Sample created successfully",
      data: newSample,
    });
  } catch (error) {
    console.error("Error creating Semen Sample:", error);
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
};

const updateDonor = async (req, res) => {
  try {
    console.log("anshhhh");
    console.log(req.body.array[0]);
    SemenSample.update(
      {
        status: "collected",
        cycleId: req.session.cycle_id,
        patient_id: req.session.patientId,
        clinchId: req.user.clinicId,
      },
      {
        where: {
          id: req.body.array[0],
          donorId: req.body.array[1],
        },
      }
    );
    res.status(200).send({ message: "successful" });
  } catch (error) { }
};

const getSemenSample = async (req, res) => {
  try {
    console.log(req.session);
    let allSemenSample;
    if (req.session.treatmentType == "donor") {
      allSemenSample = await SemenSample.findAll({
        where: {
          donorId: req.session.DonorId,
          cycleId: 12,
          clinchId: req.user.clinicId,
        },
      });
    } else {
      if (req.session.spermDonor) {
        allSemenSample = await SemenSample.findAll({
          where: {
            donorId: {
              [Op.ne]: null, // donor_id is not null
            },
            cycleId: req.session.cycle_id,
            patient_id: req.session.patientId,
            clinchId: req.user.clinicId,
          },
        });
      } else {
        allSemenSample = await SemenSample.findAll({
          where: {
            cycleId: req.session.cycle_id,
            patient_id: req.session.patientId,
            clinchId: req.user.clinicId,
          },
        });
        let allSemenSample1 = await SemenSample.findAll({
          where: {
            patient_id: req.session.patientId,
            clinchId: req.user.clinicId,
            status: "frozen",
          },
        });
        allSemenSample = allSemenSample.concat(allSemenSample1);
      }
    }
    console.log("allSemenSample");
    console.log(allSemenSample);
    res.status(200).json(allSemenSample);
  } catch (error) {
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
};

const WashSemenSampleStore = async (req, res) => {
  try {
    console.log(req.body);
    console.log("error ans");

    console.log(
      `heholo bbbbbb in WASHSEMENSAMPLE LETS SEE treatmentType is :- `,
      req.session.treatmentType
    );

    if (req.session.treatmentType == "donor") {
      await WashSemenSample.create({
        ...req.body,
        cycleId: 12,
        donorId: req.session.DonorId,
        clinchId: req.user.clinicId,
      });

      await SemenSample.update(
        { status: "Washed" },
        {
          where: {
            id: req.body.sample_id,
            cycleId: 12,
            donorId: req.session.DonorId,
            clinchId: req.user.clinicId,
          },
        }
      );
    } else {
      await WashSemenSample.create({
        ...req.body,
        cycleId: req.session.cycle_id,
        patient_id: req.session.patientId,
        clinchId: req.user.clinicId,
      });

      await SemenSample.update(
        { status: "Washed" },
        {
          where: {
            id: req.body.sample_id,
            cycleId: req.session.cycle_id,
            patient_id: req.session.patientId,
            clinchId: req.user.clinicId,
          },
        }
      );
    }

    res.status(201).json({
      success: "success",
      message: "Wash Semen Sample created successfully",
    });
  } catch (error) {
    console.log(error.message);
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
};

const DiscardedSemenSample = async (req, res) => {
  try {
    console.log(`in discarded api`);
    console.log(req.body);

    console.log(`req.treatment session`, req.session);

    console.log(`req.slimiyshaddy`, req.session.treatmentType);

    await SemenSample.update(
      { status: "Discarded" },
      {
        where: {
          id: req.body.sample_id,
        },
      }
    );

    if (req.session.treatmentType === "donor")
      await DiscardedSample.create({
        ...req.body,
        cycleId: 12,
        clinchId: req.user.clinicId,
        donorId: req.session.DonorId,
      });
    else {
      await DiscardedSample.create({
        ...req.body,
        clinchId: req.user.clinicId,
        patient_id: req.session.patientId,
        cycleId: req.session.cycleId,
      });
    }

    res.status(201).json({
      success: "success",
      message: "Discarded Semen Sample created successfully",
    });
  } catch (error) {
    console.log(error.message);
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
};
const DiscardedSemenSample2 = async (req, res) => {
  try {
    const { sampleId, patientId, reasonForDiscard, discardedBy } = req.body;

    await SemenSample.update(
      { status: "Discarded" },
      {
        where: {
          id: sampleId,
        },
      }
    );

    if (req.session.treatmentType === "donor")
      await DiscardedSample.create({
        ...req.body,
        sample_id: sampleId,
        cycleId: 12,
        clinchId: req.user.clinicId,
        donorId: patientId,
        discarded_by: discardedBy,
        reason_for_discard: reasonForDiscard,
      });
    else {
      await DiscardedSample.create({
        ...req.body,
        discarded_by: discardedBy,
        sample_id: sampleId,
        clinchId: req.user.clinicId,
        reason_for_discard: reasonForDiscard,
        patient_id: req.session.patientId,
        cycleId: req.session.cycleId,
      });
    }

    res.status(201).json({
      success: "success",
      message: "Discarded Semen Sample created successfully",
    });
  } catch (error) {
    console.log(error.message);
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
};

const getVolume = async (req, res) => {
  try {
    let data, storage;
    if (req.session.treatmentType == "donor") {
      data = await WashSemenSample.findOne({
        where: {
          sample_id: req.body.id,
          donorId: req.session.DonorId,
          cycleId: 12,
          clinchId: req.user.clinicId,
        },
        attributes: ["volume"],
      });
      storage = await SemenSample.findOne({
        where: {
          id: req.body.id,
          donorId: req.session.DonorId,
          cycleId: 12,
          clinchId: req.user.clinicId,
        },
        attributes: ["Storage"],
      });
    } else {
      data = await WashSemenSample.findOne({
        where: {
          sample_id: req.body.id,
          patient_id: req.session.patientId,
          cycleId: req.session.cycle_id,
          clinchId: req.user.clinicId,
        },
        attributes: ["volume"],
      });
      storage = await SemenSample.findOne({
        where: {
          id: req.body.id,
          patient_id: req.session.patientId,
          cycleId: req.session.cycle_id,
          clinchId: req.user.clinicId,
        },
        attributes: ["Storage"],
      });
    }

    if (!storage) {
      storage = "";
    }

    if (!data) {
      return res.status(404).send("Sample not found");
    }

    console.log(data.volume);
    res.status(200).send({ volume: data.volume, storage: storage });
  } catch (error) {
    console.error("Error:", error.message);
    res.status(500).send("An error occurred while fetching the volume");
  }
};

const getVolumeSample = async (req, res) => {
  try {
    let data, storage;

    data = await WashSemenSample.findOne({
      where: {
        sample_id: req.body.id,
        clinchId: req.user.clinicId,
      },
      attributes: ["volume"],
    });
    storage = await SemenSample.findOne({
      where: {
        id: req.body.id,
      },
      attributes: ["Storage"],
    });

    if (!storage) {
      storage = "";
    }

    if (!data) {
      return res.status(404).send("Sample not found");
    }

    console.log(data.volume);
    res.status(200).send({ volume: data.volume, storage: storage });
  } catch (error) {
    console.error("Error:", error.message);
    res.status(500).send("An error occurred while fetching the volume");
  }
};

const saveData = async (req, res) => {
  try {
    if (req.session.treatmentType == "Sperm-Freezing") {
      await PatientCounseling.update(
        { status: false },
        {
          where: {
            patientId: req.session.patientId,
            cycle_id: req.session.cycle_id,
            clinicId: req.user.clinicId,
          },
        }
      );
    }
    if (req.session.treatmentType == "donor") {
      await CanisterData.create({
        ...req.body,
        donorId: req.session.DonorId,
        clinchId: req.user.clinicId,
        cycleId: 12,
      });
      let str = `Tank: ${req.body.tank}, Canister: ${req.body.canister}, Color: ${req.body.color}, Vial Holder: ${req.body.vial_holder}, Vial Position: ${req.body.vial_position}`;
      await SemenSample.update(
        { status: "frozen" },
        {
          where: {
            id: req.body.sample_id,
            donorId: req.session.DonorId,
            cycleId: 12,
            clinchId: req.user.clinicId,
          },
        }
      );
      await SemenSample.update(
        { stage: "frozen" },
        {
          where: {
            id: req.body.sample_id,
            donorId: req.session.DonorId,
            cycleId: 12,
            clinchId: req.user.clinicId,
          },
        }
      );
      await SemenSample.update(
        { Storage: str },
        {
          where: {
            id: req.body.sample_id,
            donorId: req.session.DonorId,
            cycleId: 12,
            clinchId: req.user.clinicId,
          },
        }
      );
    } else {
      await CanisterData.create({
        ...req.body,
        patient_id: req.session.patientId,
        clinchId: req.user.clinicId,
        cycleId: req.session.cycle_id,
      });
      let str = `Tank: ${req.body.tank}, Canister: ${req.body.canister}, Color: ${req.body.color}, Vial Holder: ${req.body.vial_holder}, Vial Position: ${req.body.vial_position}`;
      await SemenSample.update(
        { status: "frozen" },
        {
          where: {
            id: req.body.sample_id,
            patient_id: req.session.patientId,
            cycleId: req.session.cycle_id,
            clinchId: req.user.clinicId,
          },
        }
      );
      await SemenSample.update(
        { stage: "frozen" },
        {
          where: {
            id: req.body.sample_id,
            patient_id: req.session.patientId,
            cycleId: req.session.cycle_id,
            clinchId: req.user.clinicId,
          },
        }
      );
      await SemenSample.update(
        { Storage: str },
        {
          where: {
            id: req.body.sample_id,
            patient_id: req.session.patientId,
            cycleId: req.session.cycle_id,
            clinchId: req.user.clinicId,
          },
        }
      );
    }
    res.status(200).send({ message: "form submitted" });
  } catch (error) {
    console.log(error);
    res.status(500).send({ error: error });
  }
};

const issueData = async (req, res) => {
  try {
    let data = await SemenSample.findAll({
      where: {
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
        status: {
          [Op.ne]: "discarded",
          [Op.ne]: "issued", // Use Op.ne to specify "not equal"
        },
      },
    });
    console.log(data);
    res.status(200).send({ data: data });
  } catch (error) {
    console.log(error);
  }
};
const donorData = async (req, res) => {
  try {
    let data = await SemenSample.findAll({
      where: {
        clinchId: req.user.clinicId,
        donorId: {
          [Op.ne]: null, // donor_id is not null
        },
        status: {
          [Op.ne]: "discarded",

          [Op.ne]: "issued", // Use Op.ne to specify "not equal"
          [Op.ne]: "collected", // Use Op.ne to specify "not equal"
        },
      },
    });
    console.log(data);
    res.status(200).send({ data: data });
  } catch (error) {
    console.log(error);
  }
};
const issuedData = async (req, res) => {
  try {
    if (!req.session.patientId && !req.session.cycle_id) return;
    let data = await SemenSample.findAll({
      where: {
        status: "issued",
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
      },
    });
    console.log(data);
    res.status(200).send({ data: data });
  } catch (error) {
    console.log(error);
  }
};

const issueUpdate = async (req, res) => {
  try {
    let data = req.body.array;
    console.log(data);
    await data.forEach((element) => {
      console.log(element);
      SemenSample.update(
        { status: "issued" },
        {
          where: {
            id: element,
            cycleId: req.session.cycle_id,
            patient_id: req.session.patientId,
            clinchId: req.user.clinicId,
          },
        }
      );
    });
    console.log("issue sperm");
    if (req.session.treatmentType == "IUI") {
      console.log("1 in if");
      await PatientCounseling.update(
        { currentPage: "outcome" },
        {
          where: {
            patientId: req.session.patientId,
            cycle_id: req.session.cycle_id,
            status: true,
            clinicId: req.user.clinicId,
          },
        }
      );
    } else {
      console.log("1 in else");
      await PatientCounseling.update(
        { currentPage: "culture" },
        {
          where: {
            patientId: req.session.patientId,
            cycle_id: req.session.cycle_id,
            status: true,
            clinicId: req.user.clinicId,
          },
        }
      );
    }
  } catch (error) {
    console.log("error");
  }
};

const splitUpdate = async (req, res) => {
  let data = req.body;
  try {
    let semenData = await SemenSample.findOne({
      where: {
        id: data.sampleId,
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
      },
    });
    await SemenSample.update(
      { status: "split" },
      {
        where: {
          id: data.sampleId,
          patient_id: req.session.patientId,
          cycleId: req.session.cycle_id,
          clinchId: req.user.clinicId,
        },
      }
    );
    let washData = await WashSemenSample.findOne({
      where: {
        sample_id: data.sampleId,
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
      },
    });
    console.log(semenData);
    console.log(washData);
    for (let i = 1; i <= data.description; i++) {
      let tempVolume = data[i];
      let tempTotalSperm = data[i] * washData.concentration;
      let rapid = (tempTotalSperm * washData.rapid_progressive) / 100;
      let slow = (tempTotalSperm * washData.slow_progressive) / 100;
      let motile = slow + rapid;
      let normalMotile = (motile * washData.normal_in) / 100;
      // console.log(tempVolume,tempTotalSperm,motile,normalMotile);
      let newSample = await SemenSample.create({
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
        userId: semenData.userId,
        clinchId: semenData.clinchId,
        patient_id: semenData.patient_id,
        parent: data.sampleId,
        Storage: semenData.Storage,
        status: semenData.status,
        stage: semenData.stage,
        date_of_collect: semenData.date_of_collect,
        time_of_collect: semenData.time_of_collect,
        sexual_abstinence_days: semenData.sexual_abstinence_days,
        ph_value: semenData.ph_value,
        collected_method: semenData.collected_method,
        received_on: semenData.received_on,
        time_of_receiving: semenData.time_of_receiving,
        no_of_labels: semenData.no_of_labels,
        received_by: semenData.received_by,
      });
      console.log("sample id:", newSample.id);
      await WashSemenSample.create({
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
        userId: washData.userId,
        sample_id: newSample.id,
        collected_on: washData.collected_on,
        patient_id: washData.patient_id,
        mrn: washData.mrn,
        fresh: washData.fresh,
        capacitated: washData.capacitated,
        capacitatedData: washData.capacitatedData,
        volume: tempVolume,
        concentration: washData.concentration,
        total_sperm: tempTotalSperm,
        rapid_progressive: washData.rapid_progressive,
        slow_progressive: washData.slow_progressive,
        non_progressive: washData.non_progressive,
        immobile: washData.immobile,
        total_motile_prog: motile,
        normal_in: washData.normal_in,
        abnormal_in: washData.abnormal_in,
        head_defects: washData.head_defects,
        mid_piece_defects: washData.mid_piece_defects,
        tail_defects: washData.tail_defects,
        excess_residual_cytoplasm: washData.excess_residual_cytoplasm,
        teratoz_index: washData.teratoz_index,
        normal_prog_motile: normalMotile,
        semen_appearance: washData.semen_appearance,
        homogenize: washData.homogenize,
        complete_sample: washData.complete_sample,
        diagnosis: washData.diagnosis,
        degree_of_diagnosis: washData.degree_of_diagnosis,
        vitality_test_method: washData.vitality_test_method,
        vitality_test_in: washData.vitality_test_in,
        viscosity: washData.viscosity,
        washing_technique: washData.washing_technique,
        washing_done_by: washData.washing_done_by,
        large_halo: washData.large_halo,
        medium_halo: washData.medium_halo,
        small_halo: washData.small_halo,
        no_halo: washData.no_halo,
        fragmented: washData.fragmented,
        non_fragmented: washData.non_fragmented,
        total: washData.total,
        dfi_percent: washData.dfi_percent,
        manual_calculation: washData.manual_calculation,
        macs_done: washData.macs_done,
        hba: washData.hba,
        dfi: washData.dfi,
        picsi: washData.picsi,
        general_remarks: washData.general_remarks,
        private_remarks: washData.private_remarks,
        bound_motile_sperm: washData.bound_motile_sperm,
        non_bound_motile_sperm: washData.non_bound_motile_sperm,
        total_hba: washData.total_hba,
        hba_positive_sperm_percent: washData.hba_positive_sperm_percent,
        hba_negative_sperm_percent: washData.hba_negative_sperm_percent,
        total_percent: washData.total_percent,
      });
    }
  } catch (error) { }
  console.log(req.body);
};

const newEmbroTransfor = async (req, res) => {
  try {
    const Id = req.body.id;
    if (Id) {
      await EmbryoTransfer.update(
        {
          where: {
            id: Id,
            clinicId: req.user.clinicId,
          },
        },
        req.body
      );
    } else {
      await EmbryoTransfer.create(req.body);
    }
    res.status(200).json({
      success: true,
      message: "Embryo Transfer created successfully",
    });
  } catch (error) {
    console.log(error.message);
    res.status(500).json({
      success: false,
      message: error.message,
    });
  }
};

const patientCounsellingPost = async (req, res) => {
  try {
    // If note date is not give
    if (isNaN(new Date(req.body.notesDate).getTime())) {
      req.body.notesDate = null;
    }

    const mrn_no = await PR_patientReg.findOne({
      where: { id: req.session.patientId },
      attributes: ["mr_no"],
    });
    console.log({mrn_no})

    // const mrn_no = await PR_patientReg.findOne({
    //   where: { id: req.session.patientId },
    //   attributes: ["mr_no"],
    // });

    // console.log(mrn_no);
    const mreno = mrn_no.mr_no;

    // const mrNo = patientRecord.mr_no;
    // Example data (similar to your query)
    const data = {
      packageId: 2,
      mrNo: mreno,
      packageName: "IVF",
      packageCost: 100000.0,
      advanceAmt: 600000.0,
      consumedAmt: 0.0,
      serviceComponent: JSON.stringify([
        {
          consumed: "0",
          quantity: "10",
          netAmount: "30000.00",
          remaining: "10",
          serviceId: 1,
          serviceCode: "34567",
          serviceName: "androscopy",
        },
        {
          consumed: "0",
          quantity: "30",
          netAmount: "10000.00",
          remaining: "30",
          serviceId: 2,
          serviceCode: "98675",
          serviceName: "Gyn Theatre",
        },
      ]),
      pharmacyComponent: JSON.stringify([
        {
          quantity: "10",
          medicineId: 1,
          medicineName: "PARACETAMOL 250 MG",
        },
        {
          quantity: "30",
          medicineId: 2,
          medicineName: "RANBAXY 200 mg",
        },
      ]),
    };

    // Insert into the database
    const result = await PatientAssignPackage.create(data);

    // for package insertion

    const checkStatus = await PatientCounseling.findOne({
      where: {
        patientId: req.session.patientId,
        status: true,
        clinicId: req.user.clinicId,
      },
    });

    // Check if checkStatus is null before accessing its properties
    if (checkStatus.mrn) {
      return res.status(400).json({ message: "Cycle already exists" });
    } else {
      let isUnique = false;
      let newCycleId;

      // Generate a new unique cycle_id
      while (!isUnique) {
        // Create a random cycle ID
        newCycleId =
          (Math.ceil(Math.random() * 10) + new Date().getTime()) % 10000;

        // Check if it already exists in the database
        const existingCycleId = await PatientCounseling.findOne({
          where: { cycle_id: newCycleId, clinicId: req.user.clinicId },
        });

        // If not found, it's unique
        if (!existingCycleId) {
          isUnique = true;
        }
      }

      // Once a unique cycle_id is found, assign it to req.session or use it further
      req.session.cycle_id = newCycleId;

      //  uniqueness of cycle id

      // here i  will add cycle_id into patientDb-EMR

      const cid = req.session.cycle_id;

      const pid = req.session.patientId;

      // now update into all tables of emr

      const latestRecord = await FollowUp.findOne({
        where: { patientId: pid, clinic_id: req.user.clinicId },
        order: [["updatedAt", "DESC"]], // Order by the latest updated record
      });

      if (latestRecord) {
        await latestRecord.update({ cycleId: cid });
        // return res.status(404).json({
        //   message: "No follow-up record found for the given patientId",
        // });
      }

      // treatment adivce update

      const latestTreatmentAdvice = await treatmentAdvice.findOne({
        where: { patientId: pid, clinic_id: req.user.clinicId },
        order: [["updatedAt", "DESC"]],
      });

      if (latestTreatmentAdvice) {
        await latestTreatmentAdvice.update({
          cycleId: cid,
          clinic_id: req.user.clinicId,
        });
      } else {
        console.log("No treatmentAdvice record found for the given patientId");
      }

      const latestAttachment = await attachments.findOne({
        where: { patientId: pid, clinic_id: req.user.clinicId },
        order: [["updatedAt", "DESC"]],
      });

      if (latestAttachment) {
        await latestAttachment.update({ cycleId: cid });
        console.log(`Attachments cycleId updated:`, latestAttachment);
      } else {
        console.log("No attachment record found for the given patientId");
      }

      // Update cycleId in prescription table
      const latestPrescription = await prescription.findOne({
        where: { patientId: pid, clinic_id: req.user.clinicId },
        order: [["updatedAt", "DESC"]],
      });

      if (latestPrescription) {
        await latestPrescription.update({ cycleId: cid });
        console.log(`Prescription cycleId updated:`, latestPrescription);
      } else {
        console.log("No prescription record found for the given patientId");
      }

      const latestServiceAdvice = await serviceAdvice.findOne({
        where: { patientId: pid, clinic_id: req.user.clinicId },
        order: [["updatedAt", "DESC"]],
      });

      if (latestServiceAdvice) {
        await latestServiceAdvice.update({ cycleId: cid });
        console.log(`ServiceAdvice cycleId updated:`, latestServiceAdvice);
      } else {
        console.log("No serviceAdvice record found for the given patientId");
      }

      // Update cycleId in doctorNotes table
      const latestDoctorNotes = await doctorNotes.findOne({
        where: { patientId: pid, clinic_id: req.user.clinicId },
        order: [["updatedAt", "DESC"]],
      });

      if (latestDoctorNotes) {
        await latestDoctorNotes.update({
          cycleId: cid,
          clinic_id: req.user.clinicId,
        });
        console.log(`DoctorNotes cycleId updated:`, latestDoctorNotes);
      } else {
        console.log("No doctorNotes record found for the given patientId");
      }

      const latestDiagnosis = await diagnosis.findOne({
        where: { patientId: pid, clinic_id: req.user.clinicId },
        order: [["updatedAt", "DESC"]],
      });

      if (latestDiagnosis) {
        await latestDiagnosis.update({ cycleId: cid });
        console.log(`cycle id updated`, latestDiagnosis);
      } else console.log(`cycle id  not updated`, latestDiagnosis);

      // find record where patirntID and date = latest

      // here i  will add cycle_id into patientDb-EMR

      const treatmentType = await sequelize.query(
        `SELECT 
            JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
            JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].oocyteSource')) AS oocyteSource,
            JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].semenSource')) AS semenSource
          FROM emb_treatmentadvice
          WHERE patientId = :id AND cycleId = :cyle`,
        {
          replacements: { id: req.session.patientId, cyle: cid },
          type: sequelize.QueryTypes.SELECT,
        }
      );

      let treatment = JSON.stringify(treatmentType, null, 2);

      // Parse the string to an array of objects
      let parsedTreatmentType = JSON.parse(treatment);

      // Access treatmentType from the first object in the array
      const treatmentn = parsedTreatmentType[0].treatmentType;
      let oocyteDonor = false;
      let semenDonor = false;
      let frozenOocyte = false;
      if (parsedTreatmentType[0].oocyteSource == "Donor") {
        oocyteDonor = true;
      }
      if (parsedTreatmentType[0].oocyteSource == "Frozen") {
        frozenOocyte = true;
      }
      if (parsedTreatmentType[0].semenSource == "Donor") {
        semenDonor = true;
      }

      // await treatmentAdvice.update(
      //   { cycleId: req.session.cycle_id },
      //   {
      //     where: {
      //       patientId: req.session.patientId,
      //       cycleId: 0,
      //     },
      //   }
      // );

      req.session.treatmentType = treatmentn;
      let patientCounselingData;
      if (req.session.treatmentType == "Sperm-Freezing") {
        patientCounselingData = {
          ...req.body,
          currentPage: "sperm",
          treatmentType: treatmentn,
          cycle_id: req.session.cycle_id, // Spread the body data
          patientId: req.session.patientId,
          spermDonor: semenDonor,
          oocyteDonor: oocyteDonor,
          frozenOocyte: frozenOocyte,
          mrn: JSON.stringify(mrn_no), // Add patientId from session
        };
      } else if (frozenOocyte) {
        patientCounselingData = {
          ...req.body,
          currentPage: "thawing",
          treatmentType: treatmentn,
          cycle_id: req.session.cycle_id, // Spread the body data
          patientId: req.session.patientId,
          spermDonor: semenDonor,
          oocyteDonor: oocyteDonor,
          frozenOocyte: frozenOocyte,
          mrn: JSON.stringify(mrn_no), // Add patientId from session
        };
      } else {
        patientCounselingData = {
          ...req.body,
          currentPage: "stimulation",
          treatmentType: treatmentn,
          cycle_id: req.session.cycle_id, // Spread the body data
          patientId: req.session.patientId,
          clinicId: req.user.clinicId,
          spermDonor: semenDonor,
          frozenOocyte: frozenOocyte,
          oocyteDonor: oocyteDonor,
          mrn: JSON.stringify(mrn_no), // Add patientId from session
        };
      }

      const newPatientCounseling = await PatientCounseling.update(
        patientCounselingData,
        {
          where: {
            patientId: req.session.patientId,
            status: true,
            clinicId: req.user.clinicId,
          },
        }
      );

      let todayDate = new Date().toISOString().split("T")[0];

      await stimulation.create({
        cycleId: req.session.cycle_id,
        dayId: 0,
        StimulationRows: { date: todayDate },
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
        option: "Antagonist Daily Dose 1",
      });

      res.status(201).json(newPatientCounseling);
    }
  } catch (error) {
    console.error("Error saving patient counseling data:", error);
    res.status(500).json({ message: "Error saving patient counseling data" });
  }
};

const fetchWashSemenSamplesBySessionCycleId = async (req, res) => {
  console.log(req.session);

  console.log(`req.query.cycleID: ${req.query.cycleID}`);

  const cycleId = req.query.cycleID || req.session?.cycle_id;

  // const cycleId = req.session?.cycle_id;

  if (!cycleId) {
    return res
      .status(400)
      .json({ message: "Cycle ID is not available in the session" });
  }

  try {
    const records = await WashSemenSample.findAll({
      where: { cycleId },
    });

    if (!records || records.length === 0) {
      return res
        .status(404)
        .json({ message: "No records found for the given cycleId" });
    }

    return res.status(200).json({ records });
  } catch (error) {
    console.error("Error fetching records:", error);
    return res.status(500).json({ message: "Internal Server Error" });
  }
};

const embrology_44_main = async (req, res) => {
  try {
    const currentStage = req.cookies["currentPage"];

    console.log(`current status is : ${currentStage}`);

    const [emb_treatmentadvic, metadata3] = await sequelize.query(
      `SELECT treatment FROM emb_treatmentadvice WHERE patientId=${req.session.patientId}`
    );

    // If no treatment advice data is found, return null
    const embTreatmentAdviceData =
      emb_treatmentadvic.length > 0 ? emb_treatmentadvic[0] : null;

    // Fetch data from embro_wash_semen_sample
    const [embro_wash_semen_sampl, metadata4] = await sequelize.query(
      `SELECT * FROM embro_wash_semen_sample WHERE patient_id=${req.session.patientId}`
    );

    const [embryo_transfers, metadata6] = await sequelize.query(
      `SELECT embryosTransferred FROM embryo_transfers WHERE cycleId=${req.session.cycle_id}`
    );

    const embTransfer = embryo_transfers.length > 0 ? embryo_transfers : null;

    const [emb_schedule_et, metadata7] = await sequelize.query(
      `SELECT etDate FROM mydb.emb_schedule_et WHERE cycleId=${req.session.cycle_id}`
    );

    const embEt = emb_schedule_et.length > 0 ? emb_schedule_et : null;

    // If no semen sample data is found, return null
    const embroWashSemenSampleData =
      embro_wash_semen_sampl.length > 0 ? embro_wash_semen_sampl[0] : null;

    // Fetch data from emb_day5record
    const [emb_day5recor, metadata5] = await sequelize.query(
      `SELECT reportData FROM emb_day5record WHERE cycleId=${req.session.cycle_id}`
    );

    // Fetch data from emb_day3record
    const [emb_day3recor, metadata8] = await sequelize.query(
      `SELECT reportData FROM emb_day3record WHERE cycleId=${req.session.cycle_id}`
    );

    // Fetch data from emb_day3record
    const [emb_day2recor, metadata9] = await sequelize.query(
      `SELECT reportData FROM emb_day2record WHERE cycleId=${req.session.cycle_id}`
    );

    // If no Day 5 record data is found, return null
    const embDay5RecordData =
      emb_day5recor.length > 0 ? emb_day5recor[0] : null;

    const embDay3RecordData =
      emb_day3recor.length > 0 ? emb_day3recor[0] : null;

    const embDay2RecordData =
      emb_day2recor.length > 0 ? emb_day2recor[0] : null;

    // Extract reportData from emb_day5record or use an empty array if missing
    const reportData = embDay5RecordData
      ? embDay5RecordData.reportData || []
      : [];

    const patientCounselling = await PatientCounseling.findOne({
      where: { patientId: req.session.patientId, clinicId: req.user.clinicId },
      attributes: ["currentPage"],
    });

    // Render the page with fetched data, or null/empty values where applicable
    res.status(200).json({
      emb_day5record: embDay5RecordData,
      emb_day3record: embDay3RecordData,
      emb_day2record: embDay2RecordData,
      reportData: reportData,
      embro_wash_semen_sample: embroWashSemenSampleData,
      emb_treatmentadvice: embTreatmentAdviceData,
      embryo_transfer: embTransfer,
      emb_schedule_et: embEt,
      currentStage: currentStage,
      patientCounselling,
    });
  } catch (error) {
    console.error("Error fetching data:", error.message);
    res.status(500).json({ msg: "An error occurred while fetching data." });
  }
};

const vitrifyEmbryosRecord = async (req, res) => {
  try {
    const cycleId = req.query.cycleID || req.session?.cycle_id;

    const data = await vitrifyEmbryos.findAll({
      where: { parent_cycleId: cycleId },
    });
    const noOfVirtifiedEmbryos = data.length;
    return res.json(noOfVirtifiedEmbryos);
  } catch (error) { }
};

const embrology_44_mainUPDATED = async (req, res) => {
  try {
    // here on top i first check

    console.log(req.session);

    // const cycleId = req.params.cycleID || req.session.cycle_id;

    const cycleId = req.query.cycleID || req.session?.cycle_id;

    console.log(`Cycle id  is : ${cycleId}`);

    // now in where every where we add a condiition

    //  *** cycleId: ppp || req.session.cycleId   ***

    const currentStage = req.cookies["currentPage"];

    console.log(`current status is : ${currentStage}`);

    // const cycleId = 1972;

    const [emb_treatmentadvic, metadata3] = await sequelize.query(
      `SELECT treatment FROM emb_treatmentadvice WHERE cycleId=${cycleId}`
    );

    // If no treatment advice data is found, return null
    const embTreatmentAdviceData =
      emb_treatmentadvic.length > 0 ? emb_treatmentadvic[0] : null;

    // Fetch data from embro_wash_semen_sample
    const [embro_wash_semen_sampl, metadata4] = await sequelize.query(
      `SELECT * FROM embro_wash_semen_sample WHERE cycleId=${cycleId}`
    );

    const [embryo_transfers, metadata6] = await sequelize.query(
      `SELECT embryosTransferred FROM embryo_transfers WHERE cycleId=${cycleId}`
    );

    const embTransfer = embryo_transfers.length > 0 ? embryo_transfers : null;

    // const [emb_schedule_et, metadata7] = await sequelize.query(
    //   `SELECT etDate FROM mydb.emb_schedule_et WHERE cycleId=${cycleId}`
    // );

    // const embEt = emb_schedule_et.length > 0 ? emb_schedule_et : null;

    // If no semen sample data is found, return null
    const embroWashSemenSampleData =
      embro_wash_semen_sampl.length > 0 ? embro_wash_semen_sampl[0] : null;

    // Fetch data from emb_day5record
    const [emb_day5recor, metadata5] = await sequelize.query(
      `SELECT reportData FROM emb_day5record WHERE cycleId=${cycleId}`
    );

    // Fetch data from emb_day3record
    const [emb_day3recor, metadata8] = await sequelize.query(
      `SELECT reportData FROM emb_day3record WHERE cycleId=${cycleId}`
    );

    // Fetch data from emb_day3record
    const [emb_day2recor, metadata9] = await sequelize.query(
      `SELECT reportData FROM emb_day2record WHERE cycleId=${cycleId}`
    );

    // If no Day 5 record data is found, return null
    const embDay5RecordData =
      emb_day5recor.length > 0 ? emb_day5recor[0] : null;

    const embDay3RecordData =
      emb_day3recor.length > 0 ? emb_day3recor[0] : null;

    const embDay2RecordData =
      emb_day2recor.length > 0 ? emb_day2recor[0] : null;

    // Extract reportData from emb_day5record or use an empty array if missing
    const reportData = embDay5RecordData
      ? embDay5RecordData.reportData || []
      : [];

    const patientCounselling = await PatientCounseling.findOne({
      where: { cycle_id: cycleId },
      attributes: ["currentPage"],
    });

    // here  i am adding condintion to show outcome

    // Fetch outcome based on cycleId

    // const outcome = await Outcome.findOne({
    //   where: {
    //     cycleId: counselingData.cycle_id,
    //     patientId: req.session.patientId,
    //     clinicId: req.user.clinicId,
    //   },
    // });

    // let outcomeStatus = "Unknown";
    // if (outcome) {
    //   if (outcome.miscarriageDate) {
    //     outcomeStatus = "Miscarriage";
    //   } else if (outcome.clinicalPregnancyDate) {
    //     outcomeStatus = "Pregnancy Success";
    //   } else if (outcome.ongoingPregnancyObservations) {
    //     outcomeStatus = "Ongoing Pregnancy";
    //   }
    // }

    // Render the page with fetched data, or null/empty values where applicable
    res.status(200).json({
      emb_day5record: embDay5RecordData,
      emb_day3record: embDay3RecordData,
      emb_day2record: embDay2RecordData,
      reportData: reportData,
      embro_wash_semen_sample: embroWashSemenSampleData,
      emb_treatmentadvice: embTreatmentAdviceData,
      embryo_transfer: embTransfer,
      // emb_schedule_et: embEt,
      currentStage: currentStage,
      patientCounselling,
    });
  } catch (error) {
    console.error("Error fetching data:", error.message);
    res.status(500).json({ msg: "An error occurred while fetching data." });
  }
};
// Fetch records based on session's cycle_id
const getOvumRecords = async (req, res) => {
  try {
    // const { cycle_id } = req.session; // Retrieve cycle_id from session
    const cycle_id = req.query.cycleID || req.session.cycle_id; // Retrieve cycle_id from session

    if (!cycle_id) {
      return res
        .status(400)
        .json({ error: "cycle_id is not set in the session" });
    }

    // Fetch records where cycleId matches session's cycle_id
    const records = await ovumSchedule.findAll({
      where: {
        cycleId: cycle_id,
      },
    });

    if (records.length === 0) {
      return res
        .status(404)
        .json({ message: "No records found for the current session cycle_id" });
    }

    return res.status(200).json({ records });
  } catch (error) {
    console.error("Error fetching records:", error);
    return res
      .status(500)
      .json({ error: "An error occurred while fetching records" });
  }
};

// Route to get patient counseling data by MRN
const patientCounsellingGet = async (req, res) => {
  try {
    const { mrn } = req.params;
    const patientCounseling = await PatientCounseling.findOne({
      where: { mrn, clinicId: req.user.clinicId },
    });

    if (patientCounseling) {
      res.status(200).json(patientCounseling);
    } else {
      res.status(404).json({ message: "Patient counseling data not found" });
    }
  } catch (error) {
    console.error("Error fetching patient counseling data:", error);
    res.status(500).json({ message: "Error fetching patient counseling data" });
  }
};

const getEmbryoTransferData = async (req, res) => {
  try {
    const cycle = req.query.cycleID || req.session.cycle_id;

    const embryoTransfers = await EmbryoTransfer.findAll({
      attributes: ["date", "embryosTransferred"],
      where: {
        cycleId: cycle,
        // patientId: req.session.patientId,
        clinicId: req.user.clinicId,
      },
    });

    const formatDate = (date) => {
      const d = new Date(date);
      const day = String(d.getDate()).padStart(2, "0");
      const month = String(d.getMonth() + 1).padStart(2, "0"); // months are zero-based
      const year = d.getFullYear();

      return `${day}-${month}-${year}`;
    };

    const result = embryoTransfers.map((record) => {
      const date = formatDate(record.date); // Apply date format here
      const embryosTransferred =
        typeof record.embryosTransferred === "string"
          ? JSON.parse(record.embryosTransferred)
          : record.embryosTransferred || [];
      const transferredCount = embryosTransferred.length;

      return {
        date,
        transferredCount,
      };
    });

    return res.status(200).json({ success: true, data: result });
  } catch (error) {
    console.error("Error fetching embryo transfer data:", error);
    return res
      .status(500)
      .json({ success: false, message: "Internal Server Error" });
  }
};

const getEmbryoTransferDataReport = async (req, res) => {
  try {
    const cycle = req.query.cycleID || req.session.cycle_id;

    const embryoTransfers = await EmbryoTransfer.findAll({
      attributes: ["date", "embryosTransferred", "doctor"], // Include required fields
      where: {
        cycleId: cycle,
        clinicId: req.user.clinicId,
      },
    });

    const formatDate = (date) => {
      const d = new Date(date);
      const day = String(d.getDate()).padStart(2, "0");
      const month = String(d.getMonth() + 1).padStart(2, "0");
      const year = d.getFullYear();
      return `${day}-${month}-${year}`;
    };

    const result = embryoTransfers.map((record) => {
      const date = formatDate(record.date);
      const embryosTransferred =
        typeof record.embryosTransferred === "string"
          ? JSON.parse(record.embryosTransferred)
          : record.embryosTransferred || [];

      const transferredCount = embryosTransferred.length;

      // Extract grades for all embryos
      const grades = embryosTransferred.map((embryo) => ({
        embryoNo: embryo.embryoNo || "Unknown",
        grade: embryo.grade || "N/A",
      }));

      return {
        date,
        transferredCount,
        doctor: record.doctor || "N/A",
        grades, // Include extracted grades
      };
    });

    return res.status(200).json({ success: true, data: result });
  } catch (error) {
    console.error("Error fetching embryo transfer data:", error);
    return res
      .status(500)
      .json({ success: false, message: "Internal Server Error" });
  }
};

// const getEmbryoTransferData = async (req, res) => {
//   try {
//     const embryoTransfers = await EmbryoTransfer.findAll({
//       attributes: ["date", "embryosTransferred"],
//       where: {
//         cycleId: req.session.cycle_id,
//         patientId: req.session.patientId,
//         clinicId: req.user.clinicId,
//       },
//     });

//     const result = embryoTransfers.map((record) => {
//       const date = record.date;
//       const embryosTransferred =
//         typeof record.embryosTransferred === "string"
//           ? JSON.parse(record.embryosTransferred)
//           : record.embryosTransferred || [];
//       const transferredCount = embryosTransferred.length;

//       return {
//         date,
//         transferredCount,
//       };
//     });

//     return res.status(200).json({ success: true, data: result });
//   } catch (error) {
//     console.error("Error fetching embryo transfer data:", error);
//     return res
//       .status(500)
//       .json({ success: false, message: "Internal Server Error" });
//   }
// };

// const getEmbryoTransferData = async (req, res) => {
//   try {
//     console.log(`in getEmbryoTransfwerred API`);

//     // Fetch data from the database
//     const embryoTransfers = await EmbryoTransfer.findAll({
//       attributes: ["date", "embryosTransferred"], // Fetch only the required fields
//       where: {
//         cycleId: req.session.cycle_id,
//         patientId: req.session.patientId,
//       },
//     });

//     // Process the data
//     const result = embryoTransfers.map((record) => {
//       const date = record.date;
//       const embryosTransferred = JSON.parse(record.embryosTransferred || "[]");
//       const transferredCount = embryosTransferred.length;

//       return {
//         date,
//         transferredCount,
//       };
//     });

//     // Send the response
//     return res.status(200).json({ success: true, data: result });
//   } catch (error) {
//     console.error("Error fetching embryo transfer data:", error);
//     return res
//       .status(500)
//       .json({ success: false, message: "Internal Server Error" });
//   }
// };

const saveEmbryoTransfer = async (req, res) => {
  try {
    const {
      date,
      time,
      embryosTransferred,
      catheter,
      difficulty,
      transferDFE,
      ecoguided,
      mucous,
      blood,
      repetition,
      bladder,
      allies,
      dilator,
      comments,
      doctor,
      embryologist,
      status,
    } = req.body;

    const convertToBoolean = (value) => {
      if (typeof value === "string") {
        return value === "on" || value === "true";
      }
      return Boolean(value);
    };

    // Check if an embryo transfer with the same cycle_Id already exists
    const existingEmbryoTransfer = await EmbryoTransfer.findOne({
      where: {
        cycleId: req.session.cycle_id,
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
      },
    });

    let savedEmbryoTransfer;

    if (existingEmbryoTransfer) {
      // Update the existing record
      savedEmbryoTransfer = await existingEmbryoTransfer.update(
        {
          date,
          time,
          embryosTransferred: embryosTransferred, // Store JSON as string
          catheter,
          difficulty,
          transferDFE: convertToBoolean(transferDFE), // Default to false if not provided
          ecoguided: convertToBoolean(ecoguided) || false,
          mucous: convertToBoolean(mucous) || false,
          blood: convertToBoolean(blood) || false,
          repetition: convertToBoolean(repetition),
          bladder: convertToBoolean(bladder) || false,
          allies: convertToBoolean(allies) || false,
          dilator: convertToBoolean(dilator) || false,
          comments,
          doctor,
          embryologist,
          status: status || false,
        },
        {
          where: {
            cycleId: req.session.cycle_id,
            patientId: req.session.patientId,
            clinicId: req.user.clinicId,
          },
        }
      );
    } else {
      // Create a new record
      savedEmbryoTransfer = await EmbryoTransfer.create({
        date,
        time,
        embryosTransferred: embryosTransferred, // Store JSON as string
        catheter,
        difficulty,
        transferDFE: convertToBoolean(transferDFE), // Default to false if not provided
        ecoguided: convertToBoolean(ecoguided) || false,
        mucous: convertToBoolean(mucous) || false,
        blood: convertToBoolean(blood) || false,
        repetition: convertToBoolean(repetition),
        bladder: convertToBoolean(bladder) || false,
        allies: convertToBoolean(allies) || false,
        dilator: convertToBoolean(dilator) || false,
        comments,
        doctor,
        embryologist,
        status: status || false,
        cycleId: req.session.cycle_id,
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
      });
    }

    await PatientCounseling.update(
      { currentPage: "outcome" },
      {
        where: {
          patientId: req.session.patientId,
          cycle_id: req.session.cycle_id,
          status: true,
          clinicId: req.user.clinicId,
        },
      }
    );

    // Respond with the saved object
    res.status(200).json(savedEmbryoTransfer);
  } catch (error) {
    console.error("Error saving embryo transfer:", error);
    res
      .status(500)
      .json({ error: "An error occurred while saving the embryo transfer." });
  }
};

const getEmbryoTransfers = async (req, res) => {
  try {
    // Fetch all records from the EmbryoTransfer table
    const embryoTransfers = await EmbryoTransfer.findAll({
      where: {
        clinicId: req.user.clinicId,
      },
    });

    // Respond with the retrieved data
    res.status(200).json(embryoTransfers);
  } catch (error) {
    console.error("Error fetching embryo transfers:", error);
    res.status(500).json({
      error: "An error occurred while fetching the embryo transfers.",
    });
  }
};

// Controller function to get embryo transfers filtered by cycle_Id from session
const getEmbryoTransfersByCycleId = async (req, res) => {
  try {
    const embryoTransfers = await EmbryoTransfer.findAll({
      where: {
        cycleId: req.session.cycle_id,
        clinicId: req.user.clinicId,
      },
    });

    // If no records found, return a 404
    if (embryoTransfers.length === 0) {
      return res
        .status(404)
        .json({ message: "No embryo transfers found for the given cycle_Id" });
    }

    // Respond with the filtered data
    res.status(200).json(embryoTransfers);
  } catch (error) {
    console.error("Error fetching embryo transfers by cycle_Id:", error);
    res.status(500).json({
      error: "An error occurred while fetching the embryo transfers.",
    });
  }
};
// mine

var { ovumSchedule, CurrentItemStock } = require("../models/embrology");

let postData = async (req, res) => {
  let data = req.body;
  console.log(data);

  try {
    // Assume 'id' is the unique identifier for each record
    // Check if the record exists
    let existingRecord = await ovumSchedule.findOne({
      where: {
        cycleId: req.session.cycle_id,
        patient_id: req.session.patientId,
        clinchId: req.user.clinicId,
      },
    });

    await PatientCounseling.update(
      { currentPage: "sperm" },
      {
        where: {
          patientId: req.session.patientId,
          cycle_id: req.session.cycle_id,
          status: true,
          clinicId: req.user.clinicId,
        },
      }
    );
    let dataSave;

    if (req.session.DonorId) {
      dataSave = {
        Option: data.Option,
        DenudationDoneBy: data.DenudationDoneBy,
        DenudationTime: data.DenudationTime,
        DenudationDate: data.DenudationDate,
        NoOfOocytes: data.NoOfOocytes,
        NoOfLeftFollicles: data.NoOfLeftFollicles,
        NoOfRightFollicles: data.NoOfRightFollicles,
        OPUNotes: data.OPUNotes,
        SecondaryEmbryologist: data.SecondaryEmbryologist,
        PrimaryEmbryologist: data.PrimaryEmbryologist,
        AnesthesiaType: data.AnesthesiaType,
        Anesthetist: data.Anesthetist,
        AssistantSurgeon: data.AssistantSurgeon,
        Surgeon: data.Surgeon,
        Time: data.Time,
        Date: data.Date,
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        DonorId: req.session.DonorId,
        clinchId: req.user.clinicId,
      };
    } else {
      dataSave = {
        Option: data.Option,
        DenudationDoneBy: data.DenudationDoneBy,
        DenudationTime: data.DenudationTime,
        DenudationDate: data.DenudationDate,
        NoOfOocytes: data.NoOfOocytes,
        NoOfLeftFollicles: data.NoOfLeftFollicles,
        NoOfRightFollicles: data.NoOfRightFollicles,
        OPUNotes: data.OPUNotes,
        SecondaryEmbryologist: data.SecondaryEmbryologist,
        PrimaryEmbryologist: data.PrimaryEmbryologist,
        AnesthesiaType: data.AnesthesiaType,
        Anesthetist: data.Anesthetist,
        AssistantSurgeon: data.AssistantSurgeon,
        Surgeon: data.Surgeon,
        Time: data.Time,
        Date: data.Date,
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinchId: req.user.clinicId,
      };
    }

    if (existingRecord) {
      // Record exists, update it
      await ovumSchedule.update(dataSave, {
        where: {
          patient_id: req.session.patientId,
          cycleId: req.session.cycle_id,
          clinchId: req.user.clinicId,
        },
      });
    } else {
      // Record does not exist, create a new one
      await ovumSchedule.create(dataSave);
    }

    res.status(200).send("Operation successful");
  } catch (error) {
    console.error("Error processing data:", error);
    res.status(500).send("Server error");
  }
};

let getDataOpu = async (req, res) => {
  try {
    let data = await ovumSchedule.findOne({
      where: {
        cycleId: req.session.cycle_id,
        patient_id: req.session.patientId,
        clinchId: req.user.clinicId,
      },
    });
    console.log(data);
    res.status(200).send({ dataOpu: data });
  } catch (error) {
    res.status(200).send({ data: "no data" });
  }
};

const getOpu = async (req, res) => {
  try {
    let data = await ovumSchedule.findOne({
      where: {
        cycleId: req.session.cycle_id,
        patient_id: req.session.patientId,
        clinchId: req.user.clinicId,
      },
    });
    console.log(data);
    res.status(200).send({ dataOpu: data });
  } catch (error) {
    res.status(200).send({ data: "no data" });
  }
};

const drugsData = async (req, res) => {
  try {
    // Fetch all items from ItemMasterNew
    const items = await ItemMasterNew.findAll({
      where: { isDrug: "YES", clinic_id: req.user.clinicId },
     
      // where: { item_category: "PHARMACY", clinic_id: req.user.clinicId },
      attributes: ["id", "item_name", "brand_name", "molecule_name"],
    });
    // Combine the item data with available stock
    const itemData = items.map((item) => ({
      id: item.id,
      item_name: item.item_name,
      brand_name: item.brand_name,
      molecule_name: item.molecule_name,
    }));

    res.status(200).send(itemData);
  } catch (error) {
    console.log("error", error);
  }
};

const getReadyForTransferRecords2 = async (req, res) => {
  try {
    const cycleId = req.session.cycle_id; // Ensure cycleId is correctly retrieved

    /*
    ====================================================
    ? => Fetch records from the database
    ====================================================
    */

    // Day 3 Records
    //
    const emb_day3_ready_forTransfer = await sequelize.query(
      `SELECT * FROM emb_day3record 
       WHERE JSON_CONTAINS(reportData, '{"status": "Ready for Transfer"}', '$') 
       AND cycleId = :cycleId`,
      {
        type: sequelize.QueryTypes.SELECT,
        replacements: { cycleId },
      }
    );

    // Day 4 Records
    const embday4_readyforTransfer = await sequelize.query(
      `SELECT * FROM emb_day4record 
       WHERE JSON_CONTAINS(reportData, '{"status": "Ready for Transfer"}', '$') 
       AND cycleId = :cycleId`,
      {
        type: sequelize.QueryTypes.SELECT,
        replacements: { cycleId },
      }
    );

    // Day 5 Records
    const embday5_readyforTransfer = await sequelize.query(
      `SELECT * FROM emb_day5record 
       WHERE JSON_CONTAINS(reportData, '{"status": "Ready for Transfer"}', '$') 
       AND cycleId = :cycleId`,
      {
        type: sequelize.QueryTypes.SELECT,
        replacements: { cycleId },
      }
    );

    // Day 6 Records
    const embday6_readyforTransfer = await sequelize.query(
      `SELECT * FROM emb_day6record 
       WHERE JSON_CONTAINS(reportData, '{"status": "Transfer"}', '$') 
       AND cycleId = :cycleId`,
      {
        type: sequelize.QueryTypes.SELECT,
        replacements: { cycleId },
      }
    );

    /*
    ====================================================
    ? => Process data for each day
    ====================================================
    */

    // Helper function to process data
    function processData(embData, statusToFilter) {
      if (embData && embData.length > 0) {
        const data = embData
          .flatMap((record) => {
            if (Array.isArray(record.reportData)) {
              return record.reportData;
            } else if (record.reportData) {
              return [record.reportData];
            } else {
              return [];
            }
          })
          .filter((res) => res.status === statusToFilter);

        // Replace the reportData in embData with the filtered data
        embData.forEach((record) => {
          record.reportData = data;
        });

        return data;
      } else {
        return [];
      }
    }

    // Process data for each day
    const dataDay3 = processData(
      emb_day3_ready_forTransfer,
      "Ready for Transfer"
    );
    const dataDay4 = processData(
      embday4_readyforTransfer,
      "Ready for Transfer"
    );
    const dataDay5 = processData(
      embday5_readyforTransfer,
      "Ready for Transfer"
    );
    const dataDay6 = processData(embday6_readyforTransfer, "Transfer");

    /*
    ====================================================
    ? => Send the response with modified data
    ====================================================
    */

    res.json({
      emb_day3_ready_forTransfer, // reportData replaced with dataDay3
      embday4_readyforTransfer, // reportData replaced with dataDay4
      embday5_readyforTransfer, // reportData replaced with dataDay5
      embday6_readyforTransfer, // reportData replaced with dataDay6
    });
  } catch (err) {
    console.error("Error processing data:", err);
    res.status(500).json({ error: "An error occurred while processing data." });
  }
};

// Function to fetch doctor notes by patientId and doctorId
const fetchDoctorNotes = async (req, res) => {
  // const { patientId, doctorId } = req.query; // Assuming both are passed as query parameters

  let patientId = req.session.patientId;
  try {
    // Fetch data from the database based on both patientId and doctorId
    const doctorNotesData = await doctorNotes.findAll({
      where: {
        [Op.and]: [{ patientId: patientId }, { clinic_id: req.user.clinicId }],
      },
      attributes: [
        "id",
        "clinic_id",
        "patientId",
        "doctorId",
        "doctorNotes",
        "Date",
        "createdAt",
        "updatedAt",
        "cycleId",
      ],
    });

    if (doctorNotesData.length > 0) {
      res.status(200).json(doctorNotesData);
    } else {
      res
        .status(404)
        .json({ message: "No records found for this patient and doctor" });
    }
  } catch (error) {
    console.error("Error fetching doctor notes:", error);
    res.status(500).json({ message: "Server error while fetching data" });
  }
};

// Function to fetch follow-up data by patientId and doctorId
const getFollowUpByPatientAndDoctor = async (req, res) => {
  let patientId = req.session.patientId;
  let doctorId = 0o11;
  try {
    const followUpData = await FollowUp.findAll({
      where: {
        patientId: patientId,
        doctorId: doctorId,
        clinic_id: req.user.clinicId,
      },
      attributes: [
        "id",
        "clinic_id",
        "patientId",
        "doctorId",
        "followUp",
        "createdAt",
        "updatedAt",
        "cycleId",
      ],
    });

    if (followUpData.length > 0) {
      return res.status(200).json(followUpData);
    } else {
      return res
        .status(404)
        .json({ message: "No records found for the given patient and doctor" });
    }
  } catch (error) {
    console.error("Error fetching follow-up data:", error);
    return res.status(500).json({ message: "Server error" });
  }
};
const chiefComJson = require("../public/myjson/chiefComplaints.json");
const { log } = require("handlebars");

const chiefComplaints = async (req, res) => {
  try {
    res.json(chiefComJson);
  } catch (error) {
    console.error("Error fetching Chief Complaints:", error);
    return res.status(500).json({ message: "Server error" });
  }
};

const getLatestTreatmentAdviceDetails = async (req, res) => {
  try {
    let patientId = req.session.patientId;

    const { treatment } = await treatmentAdvice.findOne({
      where: {
        patientId,
      },
      attributes: ["treatment"],
      order: [["createdAt", "DESC"]],
      limit: 1,
    });
    // const treatmentDetails = await sequelize.query(
    //   `SELECT  JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].doctor')) AS Doctor,
    //           JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
    //           JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].date')) AS Date
    //    FROM emb_treatmentadvice
    //    WHERE patientId = :id AND cycleId= 0`,
    //   {
    //     replacements: { id: patientId },
    //     type: sequelize.QueryTypes.SELECT,
    //   }
    // );
    const { treatmentType, date, doctor } = treatment[0];
    res.send({ treatmentType, date, doctor });
  } catch (error) {
    res.status(500).send({ message: error.message });
  }
};

const getClinicCounsellingData = async (req, res) => {
  try {
    const { patientId } = req.session;

    if (!patientId) {
      return res.status(400).send({ message: "Patient ID is missing." });
    }

    const data = await FollowUp.findAll({
      where: {
        patientId,
      },
      order: [['recordedDate', "DESC"]],
      attributes: ["recordedDate"],
      limit: 1
    });

    if (!data) {
      return res
        .status(404)
        .send({ message: "Clinic counselling data not found." });
    }

    res.status(200).send(data[0]);
  } catch (error) {
    console.error("Error fetching clinic counselling data:", error);
    res.status(500).send({ message: "An error occurred while fetching data." });
  }
};

const getCycleSummaryApi = async (req, res) => {
  try {
    let cycle = req.session.cycle_id;
    let patient = req.session.patientId;
    let treatment_Protocol;
    console.log("clinicId");
    console.log(req.user.clinicId);

    let startDate = await PatientCounseling.findAll({
      attributes: ["financialCounselingDate"], // Fetch only financialCounselingDate
      where: {
        patientId: patient,
        clinicId: req.user.clinicId, // Condition for patientId
      },
    });

    let patientCounsellingData = await PatientCounseling.findAll({
      attributes: ["cycle_id", "financialCounselingDate", "status"],
      where: {
        patientId: patient,
        clinicId: req.user.clinicId,
      },
    });

    treatment_Protocol = await stimulation.findAll({
      where: { patientId: patient, clinicId: req.user.clinicId },
      attributes: ["option", "cycleId"],
    });

    console.log(`Treatment Protocol according to cycleID`, treatment_Protocol);

    const totalcycle = patientCounsellingData.length;

    // Fetch treatment details from the emb_treatmentadvice table
    const treatmentDetails = await sequelize.query(
      `SELECT cycleId, clinic_id, JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].oocyteSource')) AS oocyteSource,
              JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
              JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].semenSource')) AS semenSource
       FROM emb_treatmentadvice
       WHERE patientId = :id`, // Use dynamic cycleId if necessary
      {
        replacements: { id: patient }, // Replace with dynamic PatientID if necessary
        type: sequelize.QueryTypes.SELECT, // To ensure SELECT query
      }
    );

    const clinicID = 44;

    // Fetch clinic city from ClinicConfiguration table
    let clinicCity = await ClinicConfiguration.findAll({
      where: { clinic_id: clinicID },
      attributes: ["clinic_city"],
    });

    const clinicCityValue =
      clinicCity.length > 0 ? clinicCity[0].clinic_city : null;

    // Merge treatmentDetails, treatment_Protocol, clinicCity, and outcomeStatus into patientCounsellingData based on cycle_id
    patientCounsellingData = await Promise.all(
      patientCounsellingData.map(async (counselingData) => {
        // Find the corresponding treatment details based on cycleId
        const treatmentDetail = treatmentDetails.find(
          (detail) => detail.cycleId === counselingData.cycle_id
        );

        // Find the corresponding treatment protocol based on cycleId
        const treatmentProtocolDetail = treatment_Protocol.find(
          (protocol) => protocol.cycleId === counselingData.cycle_id
        );

        // Fetch outcome based on cycleId
        const outcome = await Outcome.findOne({
          where: {
            cycleId: counselingData.cycle_id,
            patientId: req.session.patientId,
            clinicId: req.user.clinicId,
          },
        });

        let outcomeStatus = "Unknown";
        if (outcome) {
          if (outcome.miscarriageDate) {
            outcomeStatus = "Miscarriage";
          } else if (outcome.clinicalPregnancyDate) {
            outcomeStatus = "Pregnancy Success";
          } else if (outcome.ongoingPregnancyObservations) {
            outcomeStatus = "Ongoing Pregnancy";
          }
        }

        // Merge all data
        let mergedData = {
          ...counselingData.dataValues, // Spread existing counseling data
          clinic_city: clinicCityValue, // Add clinic city to each object
          outcomeStatus, // Add outcomeStatus to each object
        };

        if (treatmentDetail) {
          const { cycleId, ...otherTreatmentDetails } = treatmentDetail; // Exclude cycleId
          mergedData = {
            ...mergedData,
            ...otherTreatmentDetails, // Spread the rest of treatment details (without cycleId)
          };
        }

        if (treatmentProtocolDetail) {
          mergedData = {
            ...mergedData,
            treatmentProtocolOption: treatmentProtocolDetail.option,
          };
        }

        return mergedData;
      })
    );

    console.log(
      `Merged patientCounsellingData with treatmentDetails, treatmentProtocol, clinicCity, and outcomeStatus:`,
      patientCounsellingData
    );

    res.json({
      patientCounsellingData,
      totalcycle,
    });
  } catch (error) {
    console.error("Error in getCycleSummaryApi:", error);
    res.status(500).send("An error occurred while fetching the data.");
  }
};
const getCycleSummaryApiForOverview = async (req, res) => {
  try {
    let cycle = req.query.cycleID || req.session.cycle_id;
    let patient = req.session.patientId;
    let treatment_Protocol;

    // let startDate = await PatientCounseling.findAll({
    //   attributes: ["financialCounselingDate"], // Fetch only financialCounselingDate
    //   where: {
    //     patientId: patient,
    //     clinicId: req.user.clinicId, // Condition for patientId
    //   },
    // });

    let patientCounsellingData = await PatientCounseling.findAll({
      attributes: ["cycle_id", "financialCounselingDate", "status"],
      where: {
        cycle_id: cycle,
        clinicId: req.user.clinicId,
      },
    });

    treatment_Protocol = await stimulation.findAll({
      where: { cycleId: cycle, clinicId: req.user.clinicId },
      attributes: ["option", "cycleId"],
    });

    console.log(`Treatment Protocol according to cycleID`, treatment_Protocol);

    const totalcycle = patientCounsellingData.length;

    // Fetch treatment details from the emb_treatmentadvice table
    const treatmentDetails = await sequelize.query(
      `SELECT cycleId, clinic_id, JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].oocyteSource')) AS oocyteSource,
              JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
              JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].semenSource')) AS semenSource
       FROM emb_treatmentadvice
       WHERE patientId = :id`, // Use dynamic cycleId if necessary
      {
        replacements: { id: patient }, // Replace with dynamic PatientID if necessary
        type: sequelize.QueryTypes.SELECT, // To ensure SELECT query
      }
    );

    const clinicID = 44;

    // Fetch clinic city from ClinicConfiguration table
    let clinicCity = await ClinicConfiguration.findAll({
      where: { clinic_id: clinicID },
      attributes: ["clinic_city"],
    });

    const clinicCityValue =
      clinicCity.length > 0 ? clinicCity[0].clinic_city : null;

    // Merge treatmentDetails, treatment_Protocol, clinicCity, and outcomeStatus into patientCounsellingData based on cycle_id
    patientCounsellingData = await Promise.all(
      patientCounsellingData.map(async (counselingData) => {
        // Find the corresponding treatment details based on cycleId
        const treatmentDetail = treatmentDetails.find(
          (detail) => detail.cycleId === counselingData.cycle_id
        );

        // Find the corresponding treatment protocol based on cycleId
        const treatmentProtocolDetail = treatment_Protocol.find(
          (protocol) => protocol.cycleId === counselingData.cycle_id
        );

        // Fetch outcome based on cycleId
        const outcome = await Outcome.findOne({
          where: {
            cycleId: counselingData.cycle_id,
            patientId: req.session.patientId,
            clinicId: req.user.clinicId,
          },
        });

        let outcomeStatus = "Unknown";
        if (outcome) {
          if (outcome.miscarriageDate) {
            outcomeStatus = "Miscarriage";
          } else if (outcome.clinicalPregnancyDate) {
            outcomeStatus = "Pregnancy Success";
          } else if (outcome.ongoingPregnancyObservations) {
            outcomeStatus = "Ongoing Pregnancy";
          }
        }

        // Merge all data
        let mergedData = {
          ...counselingData.dataValues, // Spread existing counseling data
          clinic_city: clinicCityValue, // Add clinic city to each object
          outcomeStatus, // Add outcomeStatus to each object
        };

        if (treatmentDetail) {
          const { cycleId, ...otherTreatmentDetails } = treatmentDetail; // Exclude cycleId
          mergedData = {
            ...mergedData,
            ...otherTreatmentDetails, // Spread the rest of treatment details (without cycleId)
          };
        }

        if (treatmentProtocolDetail) {
          mergedData = {
            ...mergedData,
            treatmentProtocolOption: treatmentProtocolDetail.option,
          };
        }

        return mergedData;
      })
    );

    console.log(
      `Merged patientCounsellingData with treatmentDetails, treatmentProtocol, clinicCity, and outcomeStatus:`,
      patientCounsellingData
    );

    res.json({
      patientCounsellingData,
      totalcycle,
    });
  } catch (error) {
    console.error("Error in getCycleSummaryApi:", error);
    res.status(500).send("An error occurred while fetching the data.");
  }
};

const getCycleCard = async (req, res) => {
  try {
    if (req.session.treatmentType == "Donor") return;
    if (!req.session.patientId && !req.session.cycle_id) return;
    treatment_Protocol = await stimulation.findOne({
      where: {
        patientId: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinicId: req.user.clinicId,
        dayId: 0,
      },
      attributes: ["option"],
    });
    const treatmentDetails = await treatmentAdvice.findOne({
      where: {
        patientId: req.session.patientId,
        cycleId: req.session.cycle_id,
        clinic_id: req.user.clinicId,
      },
      attributes: [
        [sequelize.json("treatment[0].oocyteSource"), "oocyteSource"],
        [sequelize.json("treatment[0].treatmentType"), "treatmentType"],
        [sequelize.json("treatment[0].semenSource"), "semenSource"],
      ],
    });

    let startDate = await PatientCounseling.findOne({
      attributes: ["financialCounselingDate"], // Fetch only financialCounselingDate
      where: {
        patientId: req.session.patientId, // Condition for patientId
        cycle_id: req.session.cycle_id,
        clinicId: req.user.clinicId,
      },
    });
    const date1 = new Date(startDate.financialCounselingDate);
    const date2 = new Date();

    const diffInMs = date2 - date1;
    let diffInDays = Math.floor(diffInMs / (1000 * 60 * 60 * 24));
    let sendTreatment = "";
    if (treatmentDetails) {
      sendTreatment = `Treatment: ${treatmentDetails.dataValues.treatmentType || ""
        }`;

      if (treatmentDetails.dataValues.oocyteSource) {
        sendTreatment += `, ${treatmentDetails.dataValues.oocyteSource} (ovum)`;
      }

      if (treatmentDetails.dataValues.semenSource) {
        if (treatmentDetails.dataValues.oocyteSource) {
          sendTreatment += `, `;
        }
        sendTreatment += `${treatmentDetails.dataValues.semenSource} (sperm)`;
      }
    }
    if (diffInDays < 0) {
      diffInDays = "";
    }
    console.log("sendTreatment");
    console.log(sendTreatment);
    res.status(200).json({
      treatmentDetails: sendTreatment,
      diffInDays,
      treatment_Protocol,
    });
  } catch (error) {
    console.log(error);
  }
};

// const getCycleSummaryApi = async (req, res) => {
//   console.log(`inCycleSumrAPI`);

//   try {
//     console.log(`req.session.cycle_id`);
//     let cycle = req.session.cycle_id;
//     let patient = req.session.patientId;
//     let treatment_Protocol;

//     let patient_id = 1;

//     let startDate = await PatientCounseling.findAll({
//       attributes: ["financialCounselingDate"], // Fetch only financialCounselingDate
//       where: {
//         patientId: patient, // Condition for patientId
//       },
//     });

//     let patientCounsellingData = await PatientCounseling.findAll({
//       attributes: ["cycle_id", "financialCounselingDate", "status"],
//       where: {
//         patientId: patient,
//       },
//     });

//     treatment_Protocol = await stimulation.findAll({
//       where: { patientId: 1 },
//       attributes: ["option", "cycleId"],
//     });

//     console.log(`Treatment Protocol according to cycleID`, treatment_Protocol);

//     const totalcycle = patientCounsellingData.length;

//     // Fetch treatment details from the emb_treatmentadvice table
//     const treatmentDetails = await sequelize.query(
//       `SELECT cycleId, clinic_id, JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].oocyteSource')) AS oocyteSource,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].semenSource')) AS semenSource
//        FROM emb_treatmentadvice
//        WHERE patientId = :id`, // Use dynamic cycleId if necessary
//       {
//         replacements: { id: patient }, // Replace with dynamic PatientID if necessary
//         type: sequelize.QueryTypes.SELECT, // To ensure SELECT query
//       }
//     );

//     // // const clinicID = treatmentDetails[0].clinic_id;
//     const clinicID = 44;

//     // Fetch clinic city from ClinicConfiguration table
//     let clinicCity = await ClinicConfiguration.findAll({
//       where: { clinic_id: clinicID },
//       attributes: ["clinic_city"],
//     });

//     // Extract the clinic city value from the result
//     const clinicCityValue =
//       clinicCity.length > 0 ? clinicCity[0].clinic_city : null;

//     // Merge treatmentDetails, treatment_Protocol, and clinicCity into patientCounsellingData based on cycle_id
//     patientCounsellingData = patientCounsellingData.map((counselingData) => {
//       // Find the corresponding treatment details based on cycleId
//       const treatmentDetail = treatmentDetails.find(
//         (detail) => detail.cycleId === counselingData.cycle_id
//       );

//       // Find the corresponding treatment protocol based on cycleId
//       const treatmentProtocolDetail = treatment_Protocol.find(
//         (protocol) => protocol.cycleId === counselingData.cycle_id
//       );

//       // If a treatmentDetail is found, spread the details (except cycleId) into the counseling data
//       let mergedData = {
//         ...counselingData.dataValues, // Spread existing counseling data
//         clinic_city: clinicCityValue, // Add clinic city to each object
//       };

//       if (treatmentDetail) {
//         const { cycleId, ...otherTreatmentDetails } = treatmentDetail; // Exclude cycleId
//         mergedData = {
//           ...mergedData,
//           ...otherTreatmentDetails, // Spread the rest of treatment details (without cycleId)
//         };
//       }

//       // If a treatmentProtocolDetail is found, add it to the counseling data
//       if (treatmentProtocolDetail) {
//         mergedData = {
//           ...mergedData,
//           treatmentProtocolOption: treatmentProtocolDetail.option,
//         };
//       }

//       return mergedData;
//     });

//     console.log(
//       `Merged patientCounsellingData with treatmentDetails, treatmentProtocol, and clinicCity:`,
//       patientCounsellingData
//     );

//     res.json({
//       patientCounsellingData,
//       totalcycle,
//     });
//   } catch (error) {
//     console.error("Error in getCycleSummaryApi:", error);
//     res.status(500).send("An error occurred while fetching the data.");
//   }
// };

// const getCycleSummaryApi = async (req, res) => {
//   console.log(`inCycleSumrAPI`);

//   try {
//     console.log(`req.session.cycle_id`);
//     let cycle = req.session.cycle_id;
//     let patient = req.session.patientId;
//     let treatment_Protocol;

//     let patient_id = 1;

//     let startDate = await PatientCounseling.findAll({
//       attributes: ["financialCounselingDate"], // Fetch only financialCounselingDate
//       where: {
//         patientId: 1, // Condition for patientId
//       },
//     });

//     let patientCounsellingData = await PatientCounseling.findAll({
//       attributes: ["cycle_id", "financialCounselingDate", "status"],
//       where: {
//         patientId: 1,
//       },
//     });

//     treatment_Protocol = await stimulation.findAll({
//       where: { patientId: 1 },
//       attributes: ["option", "cycleId"],
//     });

//     console.log(`Treatment Protocol according to cycleID`, treatment_Protocol);

//     const totalcycle = patientCounsellingData.length;

//     // Fetch treatment details from the emb_treatmentadvice table
//     const treatmentDetails = await sequelize.query(
//       `SELECT cycleId, clinic_id, JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].oocyteSource')) AS oocyteSource,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].semenSource')) AS semenSource
//        FROM emb_treatmentadvice
//        WHERE patientId = :id`, // Use dynamic cycleId if necessary
//       {
//         replacements: { id: 7 }, // Replace with dynamic PatientID if necessary
//         type: sequelize.QueryTypes.SELECT, // To ensure SELECT query
//       }
//     );

//     let clinicCity = await ClinicConfiguration.findAll({
//       where: { clinic_id: 44 },
//       attributes: ["clinic_city"],
//     });

//     // console.log(clinicCity);

//     // Merge treatmentDetails and treatment_Protocol into patientCounsellingData based on cycle_id
//     patientCounsellingData = patientCounsellingData.map((counselingData) => {
//       // Find the corresponding treatment details based on cycleId
//       const treatmentDetail = treatmentDetails.find(
//         (detail) => detail.cycleId === counselingData.cycle_id
//       );

//       // Find the corresponding treatment protocol based on cycleId
//       const treatmentProtocolDetail = treatment_Protocol.find(
//         (protocol) => protocol.cycleId === counselingData.cycle_id
//       );

//       // If a treatmentDetail is found, spread the details (except cycleId) into the counseling data
//       let mergedData = {
//         ...counselingData.dataValues, // Spread existing counseling data
//       };

//       if (treatmentDetail) {
//         const { cycleId, ...otherTreatmentDetails } = treatmentDetail; // Exclude cycleId
//         mergedData = {
//           ...mergedData,
//           ...otherTreatmentDetails, // Spread the rest of treatment details (without cycleId)
//         };
//       }

//       // If a treatmentProtocolDetail is found, add it to the counseling data
//       if (treatmentProtocolDetail) {
//         mergedData = {
//           ...mergedData,
//           treatmentProtocolOption: treatmentProtocolDetail.option,
//         };
//       }

//       return mergedData;
//     });

//     console.log(
//       `Merged patientCounsellingData with treatmentDetails and treatmentProtocol:`,
//       patientCounsellingData
//     );

//     res.json({
//       patientCounsellingData,
//       totalcycle,
//       clinicCity,
//     });
//   } catch (error) {
//     console.error("Error in getCycleSummaryApi:", error);
//     res.status(500).send("An error occurred while fetching the data.");
//   }
// };

// const getCycleSummaryApi = async (req, res) => {
//   console.log(`inCycleSumrAPI`);

//   try {
//     console.log(`req.session.cycle_id`);
//     let cycle = req.session.cycle_id;
//     let patient = req.session.patientId;
//     let treatment_Protocol;

//     let patient_id = 1;

//     let startDate = await PatientCounseling.findAll({
//       attributes: ["financialCounselingDate"], // Fetch only financialCounselingDate
//       where: {
//         patientId: 1, // Condition for patientId
//       },
//     });

//     let patientCounsellingData = await PatientCounseling.findAll({
//       attributes: ["cycle_id", "financialCounselingDate", "status"],
//       where: {
//         patientId: 1,
//       },
//     });

//     treatment_Protocol = await stimulation.findAll({
//       where: { patientId: 1 },
//       attributes: ["option", "cycleId"],
//     });

//     console.log(`Treatment Protocol according to cycleID`, treatment_Protocol);

//     const totalcycle = patientCounsellingData.length;

//     // Fetch treatment details from the emb_treatmentadvice table
//     const treatmentDetails = await sequelize.query(
//       `SELECT cycleId, clinic_id, JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].oocyteSource')) AS oocyteSource,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].semenSource')) AS semenSource
//        FROM emb_treatmentadvice
//        WHERE patientId = :id`, // Use dynamic cycleId if necessary
//       {
//         replacements: { id: 7 }, // Replace with dynamic PatientID if necessary
//         type: sequelize.QueryTypes.SELECT, // To ensure SELECT query
//       }
//     );

//     // Merge treatmentDetails into patientCounsellingData based on cycle_id
//     patientCounsellingData = patientCounsellingData.map((counselingData) => {
//       // Find the corresponding treatment details based on cycleId
//       const treatmentDetail = treatmentDetails.find(
//         (detail) => detail.cycleId === counselingData.cycle_id
//       );

//       // If a treatmentDetail is found, spread the details (except cycleId) into the counseling data
//       if (treatmentDetail) {
//         const { cycleId, ...otherTreatmentDetails } = treatmentDetail; // Exclude cycleId
//         return {
//           ...counselingData.dataValues, // Spread existing counseling data
//           ...otherTreatmentDetails, // Spread the rest of treatment details (without cycleId)
//         };
//       }

//       // If no matching treatment detail is found, return the counseling data as is
//       return counselingData.dataValues;
//     });

//     console.log(
//       `Merged patientCounsellingData with treatmentDetails:`,
//       patientCounsellingData
//     );

//     res.json({
//       patientCounsellingData,
//       totalcycle,
//       treatment_Protocol,
//     });
//   } catch (error) {
//     console.error("Error in getCycleSummaryApi:", error);
//     res.status(500).send("An error occurred while fetching the data.");
//   }
// };

// const getCycleSummaryApi = async (req, res) => {
//   console.log(`inCycleSumrAPI`);

//   try {
//     console.log(`req.session.cycle_id`);
//     let cycle = req.session.cycle_id;
//     let patient = req.session.patientId;

//     let patient_id = 1;

//     let startDate;
//     let address;
//     let treatment_advice;
//     let noOfCycle;
//     let cycleStatus; // i.e active or past

//     startDate = await PatientCounseling.findAll({
//       attributes: ["financialCounselingDate"], // Fetch only financialCounselingDate
//       where: {
//         patientId: 1, // Condition for patientId
//       },
//     });

//     let patientCounsellingData = await PatientCounseling.findAll({
//       attributes: ["cycle_id", "financialCounselingDate", "status"],
//       where: {
//         patientId: 1,
//       },
//     });
//     // console.log(patientCounsellingData[0].cycle_id);

//     patientCounsellingData.forEach((item) => console.log(item.cycle_id));
//     console.log(`patientCounsellingAllData `, patientCounsellingData);
//     console.log(`TOTAL CYCLES  `, patientCounsellingData.length);
//     console.log(`ACTUAL DATA  `, patientCounsellingData.data);

//     // res.send("Hey", startDate);
//     console.log("Hey", startDate);

//     const totalcycle = patientCounsellingData.length;

//     let finalResponse;

//     const treatmentDetails = await sequelize.query(
//       `SELECT cycleId,clinic_id, JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].oocyteSource')) AS oocyteSource,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].treatmentType')) AS treatmentType,
//               JSON_UNQUOTE(JSON_EXTRACT(treatment, '$[0].semenSource')) AS semenSource
//        FROM emb_treatmentadvice
//        WHERE id = :id`,
//       {
//         replacements: { id: 38 }, // Replace with dynamic cycleId if necessary
//         type: sequelize.QueryTypes.SELECT, // To ensure SELECT query
//       }
//     );

//     console.log(`treatment Details`, treatmentDetails);
//     res.json({
//       patientCounsellingData,
//       totalcycle: totalcycle,
//       treatmentDetails: treatmentDetails,
//     });
//     // console.log(`StartDate`, startDate);

//     // // const clinicID = treatmentDetails[0].clinic_id;

//     // const clinicID = `012`;

//     // address = await sequelize.query(
//     //   `SELECT clinic_city FROM mydb.clinicconfigurations where clinic_id=:clinic_id`,
//     //   {
//     //     replacements: { clinic_id: clinicID },
//     //     type: sequelize.QueryTypes.SELECT,
//     //   }
//     // );
//     // console.log(`Address`, address);

//     // const stimulationData = await stimulation.findOne({
//     //   where: { cycleId: 1 }, // You can replace this with dynamic cycleId
//     //   attributes: ["StimulationRows"], // Fetch only StimulationRows
//     // });

//     // if (stimulationData && stimulationData.StimulationRows) {
//     //   const stimulationRows = stimulationData.StimulationRows[0]; // Access the first object in the array

//     //   // Get all keys of the first object
//     //   const keys = Object.keys(stimulationRows);

//     //   // Check if 'antagonist' key exists
//     //   if (keys.includes("antagonist")) {
//     //     treatment_Protocol = "antagonist";
//     //   } else {
//     //     // add more conditions like Clomiphene citrate Letrozole
//     //     // Antagonist Daily Dose 2
//     //     // Antagonist Daily Dose 2
//     //     // LongAgonist
//     //   }
//     // }

//     // // Fetch record based on cycleId
//     // const outcome = await Outcome.findOne({ where: { id: 8 } });

//     // console.log(`outcne`, outcome);
//     // // if (!outcome) {
//     // //   return res.status(404).json({ message: "Outcome not found" });
//     // // }

//     // // Apply conditions to determine outcome status
//     // let outcomeStatus = "Unknown";

//     // if (outcome.miscarriageDate) {
//     //   outcomeStatus = "Miscarriage";
//     // } else if (outcome.clinicalPregnancyDate) {
//     //   outcomeStatus = "Pregnancy Success";
//     // } else if (outcome.ongoingPregnancyObservations) {
//     //   outcomeStatus = "Ongoing Pregnancy";
//     // }

//     // console.log(`Outcome of Pregencay`, outcomeStatus);

//     res.json({
//       startDate,
//       treatmentDetails,
//       address,
//       treatment_Protocol,
//       outcomeStatus,
//       totalcycle,
//     });
//   } catch (error) {}
// };

const getSemenInvData = async (req, res) => {
  try {
    const data = await SemenSample.findAll({
      attributes: [
        "status",
        "patient_id",
        "id",
        "date_of_collect",
        "Storage",
        "donorId",
      ],
      where: {
        status: "frozen",
        clinchId: req.user.clinicId,
      },
    });
    let arr = [];
    for (element of data) {
      if (element.donorId) {
        let fill = {
          ...element.dataValues,
          Source: "donor",
          SourceMrn: "-",
          CoupleNo: "-",
          ReservedFor: "donate",
        };
        console.log(fill);
        arr.push(fill);
      }
    }
    console.log(arr);
    res.status(200).send(arr);
  } catch (error) {
    console.log(error);
  }
};

const thawUpdate = async (req, res) => {
  try {
    console.log(req.body);
    await SemenSample.update(
      { status: "collected", stage: "Fresh", cycleId: req.session.cycle_id },
      {
        where: {
          id: req.body.id,
          patient_id: req.session.patientId,
          clinchId: req.user.clinicId,
        },
      }
    );
    res.status(200).send("successful");
  } catch (error) { }
};

const tableVitrifyData = async (req, res) => {
  try {
    // Oocyte data fetch
    const oocytes = await vitrifyOocyte.findAll({
      where: {
        clinicId: req.user.clinicId,
      },
      attributes: { exclude: ["clinicId", "id", "oldCycleId"] },
    });

    const embryos = await vitrifyEmbryos.findAll({
      where: {
        clinicId: req.user.clinicId,
      },
      attributes: { exclude: ["clinicId", "id", "oldCycleId"] },
    });

    let oocytesData = [];
    let embryoData = [];

    for (const element of oocytes) {
      const patient = await PR_patientReg.findOne({
        attributes: ["mr_no", "coupleId", "firstName"],
        where: {
          id: element.patientId,
        },
      });

      const fill = {
        ...patient?.dataValues,
        ...element?.dataValues,
      };

      oocytesData.push(fill);
    }
    for (const element of embryos) {
      const patient = await PR_patientReg.findOne({
        attributes: ["mr_no", "coupleId", "firstName"],
        where: {
          id: element.patientId,
        },
      });

      const fill = {
        ...patient?.dataValues,
        ...element?.dataValues,
      };

      embryoData.push(fill);
    }

    // Respond with the fetched data
    res.json({
      vitrification: oocytesData,
      freeze: embryoData,
    });
  } catch (error) {
    // Handle and log errors
    console.error("Error fetching data:", error);
    res.status(500).json({ success: false, message: "Error fetching data" });
  }
};
const tableVitrifyData2 = async (req, res) => {
  try {
    // Oocyte data fetch
    const oocytes = await ovumSchedule.findAll({
      where: {
        Vitrification: true,
        clinchId: req.user.clinicId,
      },
      attributes: ["Date", "patient_id"],
    });

    let oocytesData = [];

    for (const element of oocytes) {
      const patient = await PR_patientReg.findOne({
        attributes: ["mr_no", "coupleId", "firstName"],
        where: {
          id: element.patient_id,
        },
      });

      const fill = {
        ...patient?.dataValues,
        Date: element.Date,
      };

      oocytesData.push(fill);
    }

    // days data of culture
    let day2 = [];
    let day3 = [];
    let day4 = [];
    let day5 = [];
    let day6 = [];

    const dataDay2 = await Day2Record.findAll({
      where: {
        [Op.and]: [
          sequelize.literal(
            `JSON_CONTAINS(reportData, '{"status": "Vitrify"}')`
          ),
          { clinicId: req.user.clinicId },
        ],
      },
    });

    const dataDay3 = await Day3Record.findAll({
      where: {
        [Op.and]: [
          sequelize.literal(
            `JSON_CONTAINS(reportData, '{"status": "Vitrify"}')`
          ),
          { clinicId: req.user.clinicId }, // Add clinicId filtering
        ],
      },
    });

    const dataDay4 = await Day4Record.findAll({
      where: {
        [Op.and]: [
          sequelize.literal(
            `JSON_CONTAINS(reportData, '{"status": "Vitrify"}')`
          ),
          { clinicId: req.user.clinicId }, // Add clinicId filtering
        ],
      },
    });

    const dataDay5 = await Day5Record.findAll({
      where: {
        [Op.and]: [
          sequelize.literal(
            `JSON_CONTAINS(reportData, '{"status": "Freeze"}')`
          ),
          { clinicId: req.user.clinicId }, // Add clinicId filtering
        ],
      },
    });

    const dataDay6 = await Day6Record.findAll({
      where: {
        [Op.and]: [
          sequelize.literal(
            `JSON_CONTAINS(reportData, '{"status": "Freeze"}')`
          ),
          { clinicId: req.user.clinicId }, // Add clinicId filtering
        ],
      },
    });

    day2 = await addData(dataDay2);
    day3 = await addData(dataDay3);
    day4 = await addData(dataDay4);
    day5 = await addData(dataDay5);
    day6 = await addData(dataDay6);

    // Respond with the fetched data
    res.json({
      day2: day2,
      day3: day3,
      day4: day4,
      day5: day5,
      day6: day6,
      vitrification: oocytesData,
    });
  } catch (error) {
    // Handle and log errors
    console.error("Error fetching data:", error);
    res.status(500).json({ success: false, message: "Error fetching data" });
  }
};

const vitrifyEmbryo = async (req, res) => {
  try {
    console.log(req.query);
    const DB = Day + req.query.str + Record;
    const dataDay2 = await DB.findOne({
      where: { id: req.query.id },
    });
    console.log(dataDay2);
  } catch (error) {
    console.log(error);
  }
};

const checkConsentForm = (requiredFormId) => {
  return async (req, res, next) => {
    const patientId = req.session.patientId;
    try {
      // Check if the patient has filled the required form
      const consent = await PatientConsent.findOne({
        where: {
          patient_id: patientId,
          form_id: requiredFormId,
          status: true,
        },
      });

      if (consent) {
        // If consent is filled, allow access to the page
        return next();
      } else {
        // Redirect to the form page or prompt to fill the consent
        // alert(`Fill Form Number : ${requiredFormId}`);
        // return res.redirect(`/embrology/concent`);

        return res.redirect("/embrology/concent");

        /*

       




        */
      }
    } catch (error) {
      console.error("Error checking consent form:", error);
      return res.status(500).send("Server error");
    }
  };
};

const getEtSchedule = async (req, res) => {
  try {
    const data = await ScheduleEt.findOne({
      where: {
        cycleId: req.session.cycle_id,
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
      },
      attributes: ["etDate", "etTime"],
    });
    return res.status(200).json(data);
  } catch (error) {
    res.status(400).json({ message: "not found" });
  }
};

const issuedSemen = async (req, res) => {
  try {
    const issuedSemen = await SemenSample.findAll({
      where: {
        patient_id: req.session.patientId,
        cycleId: req.session.cycle_id,
        status: "issued",
        clinchId: req.user.clinicId,
      },
      attributes: ["id"],
    });
    console.log(issuedSemen);
    res.status(200).json(issuedSemen);
  } catch (error) {
    console.log(error);
  }
};

// Controller function to save donor data

const saveDonor = async (req, res) => {
  try {
    const {
      code,
      eye_color,
      skin_color,
      hair_color,
      bone_structure,
      height,
      blood_group,
      referral_type,
      agency_name,
      viral_marker,
      betaThalassemia,
      chlamydia,
      DFI,
    } = req.body;

    // Generate a unique donorId
    let donorId;
    let isUnique = false;

    // Keep generating until we find a unique donorId
    while (!isUnique) {
      donorId = `don${Math.floor(100 + Math.random() * 900)}`;
      const existingDonor = await Donor.findOne({
        where: { donorId, clinicId: req.user.clinicId },
      });
      if (!existingDonor) {
        isUnique = true;
      }
    }

    const newDonor = await Donor.create({
      donorId,
      clinicId: req.user.clinicId,
      code,
      eye_color,
      skin_color,
      hair_color,
      bone_structure,
      height,
      blood_group,
      referral_type,
      agency_name,
      viral_marker,
      betaThalassemia,
      chlamydia,
      DFI,
      current_page: "donorVisit",
    });

    res
      .status(201)
      .json({ message: "Donor data saved successfully", data: newDonor });
  } catch (error) {
    console.error("Error saving donor data:", error);
    res
      .status(500)
      .json({ message: "Failed to save donor data", error: error.message });
  }
};

// const saveDonorOocyte = async (req, res) => {
//   try {
//     console.log(`in Save Donor Oocyte`);

//     console.log(`donor oocyte`);

//     console.log(req.body);

//     const {
//       code,
//       eye_color,
//       skin_color,
//       hair_color,
//       bone_structure,
//       height_feet,
//       height_inches,
//       weight,
//       blood_group,
//       referral_type,
//       agency_name,
//       viral_marker,
//       betaThalassemia,
//       chlamydia,
//       family_health_history,
//       psychological_evaluation,
//       consent_signed,
//     } = req.body;

//     const isConsentSigned = consent_signed === "Yes";
//     // Calculate BMI
//     const heightInMeters =
//       (parseInt(height_feet, 10) * 12 + parseInt(height_inches, 10)) * 0.0254; // Convert height to meters
//     const calculatedBMI = weight
//       ? (weight / heightInMeters ** 2).toFixed(2)
//       : null;

//     // Generate a unique donorId
//     let donorId;
//     let isUnique = false;

//     // Keep generating until we find a unique donorId
//     while (!isUnique) {
//       donorId = `don${Math.floor(100 + Math.random() * 900)}`;
//       const existingDonor = await DonorOocyte.findOne({ where: { donorId } });
//       if (!existingDonor) {
//         isUnique = true;
//       }
//     }

//     const newDonor = await DonorOocyte.create({
//       donorId,
//       code,
//       eye_color,
//       skin_color,
//       hair_color,
//       bone_structure,
//       height_feet,
//       height_inches,
//       weight,
//       bmi: calculatedBMI, // Save calculated BMI
//       blood_group,
//       referral_type,
//       agency_name,
//       viral_marker,
//       betaThalassemia,
//       chlamydia,
//       family_health_history,
//       psychological_evaluation,
//       consent_signed: isConsentSigned,
//       current_page: "donorVisit",
//     });

//     res
//       .status(201)
//       .json({ message: "Donor data saved successfully", data: newDonor });
//   } catch (error) {
//     console.error("Error saving donor data:", error);
//     res
//       .status(500)
//       .json({ message: "Failed to save donor data", error: error.message });
//   }
// };

const saveDonorOocyte = async (req, res) => {
  try {
    const {
      code,
      donor_name,
      dob,
      identity_card_type,
      identity_card_number,
      eye_color,
      skin_color,
      hair_color,
      bone_structure,
      height_feet,
      height_inches,
      weight,
      blood_group,
      referral_type,
      agency_name,
      viral_marker,
      betaThalassemia,
      chlamydia,
      family_health_history,
      psychological_evaluation,
      consent_signed,
    } = req.body;

    // Convert consent_signed to boolean
    const isConsentSigned = consent_signed === "Yes";

    // Calculate BMI
    const heightInMeters =
      (parseInt(height_feet, 10) * 12 + parseInt(height_inches, 10)) * 0.0254; // Convert height to meters
    const calculatedBMI = weight
      ? (weight / heightInMeters ** 2).toFixed(2)
      : null;

    // Generate a unique donorId
    let donorId;
    let isUnique = false;

    // Keep generating until we find a unique donorId
    while (!isUnique) {
      donorId = `don${Math.floor(100 + Math.random() * 900)}`;
      const existingDonor = await DonorOocyte.findOne({
        where: { donorId, clinicId: req.user.clinicId },
      });
      if (!existingDonor) {
        isUnique = true;
      }
    }

    const newDonor = await DonorOocyte.create({
      donorId,
      clinicId: req.user.clinicId,
      code,
      dob,
      donor_name,
      identity_card_type,
      identity_card_number,
      eye_color,
      skin_color,
      hair_color,
      bone_structure,
      height_feet,
      height_inches,
      weight,
      bmi: calculatedBMI, // Save calculated BMI
      blood_group,
      referral_type,
      agency_name,
      viral_marker,
      betaThalassemia,
      chlamydia,
      family_health_history,
      psychological_evaluation,
      consent_signed: isConsentSigned,
      current_page: "donorVisit",
    });

    res
      .status(201)
      .json({ message: "Donor data saved successfully", data: newDonor });
  } catch (error) {
    console.error("Error saving donor data:", error);
    res
      .status(500)
      .json({ message: "Failed to save donor data", error: error.message });
  }
};

const postVitrify = async (req, res) => {
  try {
    // Destructure request body
    const {
      witnessBy,
      DoneBy,
      Date,
      oocyteVitrifyData,
      expiryDate,
      expiryTime,
      expDate,
    } = req.body;
    console.log(req.body);

    // Validate required fields
    if (!witnessBy || !DoneBy || !Date || !oocyteVitrifyData || !expDate) {
      return res.status(400).send({ message: "Missing required fields" });
    }

    // Update the ovumSchedule table
    await ovumSchedule.update(
      { Vitrification: true },
      {
        where: {
          cycleId: req.session.cycle_id,
          patient_id: req.session.patientId,
          clinchId: req.user.clinicId,
        },
      }
    );

    // Update the PatientCounseling table
    await PatientCounseling.update(
      { status: false },
      {
        where: {
          cycle_id: req.session.cycle_id,
          patientId: req.session.patientId,
          clinicId: req.user.clinicId,
        },
      }
    );

    const bulkData = oocyteVitrifyData.map((item, index) => ({
      cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      witnessedBy: witnessBy,
      doneBy: DoneBy,
      expiryDate: expiryDate,
      expiryTime: expiryTime,
      vitrificationDate: Date,
      expDate: expDate, // Replace with your actual date
      ...item, // Spread the individual oocyte data (e.g., incubator, vitrificationTime, etc.)
    }));

    console.log(bulkData);

    await vitrifyOocyte.bulkCreate(bulkData);

    // Send success response
    res.send({ message: "Vitrification process completed successfully" });
  } catch (error) {
    // Log the error for debugging
    console.error("Error in postVitrify:", error);
    res
      .status(500)
      .send({ message: "Internal Server Error", error: error.message });
  }
};
const postVitrifyEmbryo = async (req, res) => {
  try {
    // Destructure request body
    const {
      witnessBy,
      DoneBy,
      Date,
      oocyteVitrifyData,
      expiryDate,
      expiryTime,
    } = req.body;
    console.log(req.body);

    // Validate required fields
    if (!witnessBy || !DoneBy || !Date || !oocyteVitrifyData) {
      return res.status(400).send({ message: "Missing required fields" });
    }

    // Update the ovumSchedule table
    // await ovumSchedule.update(
    //   { Vitrification: true },
    //   {
    //     where: {
    //       cycleId: req.session.cycle_id,
    //       patient_id: req.session.patientId,
    //     },
    //   }
    // );

    // Update the PatientCounseling table
    // await PatientCounseling.update(
    //   { status: false },
    //   {
    //     where: {
    //       cycle_id: req.session.cycle_id,
    //       patientId: req.session.patientId,
    //     },
    //   }
    // );

    const bulkData = oocyteVitrifyData.map((item, index) => ({
      parent_cycleId: req.session.cycle_id,
      patientId: req.session.patientId,
      clinicId: req.user.clinicId,
      witnessedBy: witnessBy,
      doneBy: DoneBy,
      expiryDate: expiryDate,
      expiryTime: expiryTime,
      vitrificationDate: Date, // Replace with your actual date
      ...item, // Spread the individual oocyte data (e.g., incubator, vitrificationTime, etc.)
    }));

    await vitrifyEmbryos.bulkCreate(bulkData);

    // Send success response
    res
      .status(200)
      .send({ message: "Vitrification process completed successfully" });
  } catch (error) {
    // Log the error for debugging
    console.error("Error in postVitrify:", error);
    res
      .status(500)
      .send({ message: "Internal Server Error", error: error.message });
  }
};

const getOocyteDonors = async (req, res) => {
  try {
    console.log(`in getOocyteDonors`);

    const donors = await DonorOocyte.findAll({
      where: {
        status: true,
        clinicId: req.user.clinicId,
      },
    });

    console.log(donors);

    res.status(200).json({
      success: true,
      data: donors,
    });
  } catch (error) {
    console.log(`Error Fetching Donors`, error);
    res.status(500).json({
      success: false,
      message: "failed to fetch donors",
      error: error.message,
    });
  }
};

const getCounsellingAllDataByCycleID = async (req, res) => {
  try {
    const cycleId = req.query.cycleID;

    console.log(`in getCounsellingAllDataByCycleID`, cycleId);

    if (!cycleId) {
    }

    const data = await PatientCounseling.findOne({
      where: { cycle_id: cycleId },
    });

    console.log(data);

    if (!data) {
    }

    res.status(200).json(data);
  } catch (error) { }
};

const getCounselingDetails = async (req, res) => {
  try {
    const { patientId } = req.session; // Retrieve patientId from the session

    if (!patientId) {
      return res
        .status(400)
        .json({ message: "Patient ID not found in session" });
    }

    const counselingDetails = await PatientCounseling.findOne({
      where: { patientId }, // Find based on patientId
      attributes: ["package_id", "assignedDoctor", "treatmentType"], // Fetch specific fields
    });

    if (!counselingDetails) {
      return res.status(404).json({ message: "Counseling details not found" });
    }

    res.status(200).json(counselingDetails);
  } catch (error) {
    console.error("Error fetching counseling details:", error);
    res.status(500).json({ message: "Internal server error" });
  }
};

const threesixty = async (req, res) => {
  try {
    const { mrno } = req.query;

    const patientId = req.session.patientId;

    if (!patientId) {
      return res
        .status(400)
        .json({ success: false, message: "Patient Id not Found" });
    }

    const treatmentAdviceData = await treatmentAdvice.findOne({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });
    console.log("1");

    const historyData = await History.findOne({
      where: { patientId: patientId },
    });
    const followupData = await FollowUp.findOne({
      where: { patientId: patientId },
    });

    const diagnosisData = await diagnosis.findOne({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });
    const allergiesData = await allergies.findOne({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    // const responseData = [
    //   { treatmentAdvice: treatmentAdviceData },
    //   { followups: followupData },
    // ];

    // const prescriptionData = await prescription.findOne({
    //   where: { id: 137 },
    // });
    const prescriptionData = await prescription.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const serviceAdviceData = await serviceAdvice.findOne({
      where: {
        patientId: patientId,
        clinic_id: req.user.clinicId,
      },
    });
    const preExistingConditionData = await preExistingCondition.findOne({
      where: {
        clinic_id: req.user.clinicId,
        patientId: patientId,
      },
    });
    const generalExaminationData = await GeneralExamination.findOne({
      where: {
        patientId: patientId,
        clinic_id: req.user.clinicId,
      },
    });

    const doctorNotesData = await doctorNotes.findAll({
      where: {
        patientId: patientId,
        clinic_id: req.user.clinicId,
      },
    });

    const stimulationSubmitData = await StimulationSubmit.findAll({
      where: { patientId: patientId, clinicId: req.user.clinicId },
    });
    const responseData = {
      treatmentAdvice: treatmentAdviceData,
      followups: followupData,
      prescription: prescriptionData,
      serviceAdvice: serviceAdviceData,
      doctorNotes: doctorNotesData,
      diagnosis: diagnosisData,
      generalExamination: generalExaminationData,
      allergies: allergiesData,
      preExistingCondition: preExistingConditionData,
      history: historyData,
      stimulationSubmit: stimulationSubmitData,
    };

    res.status(200).json({ success: true, data: responseData });
  } catch (error) {
    console.error(error);
  }
};

// const emrhistory = async (req, res) => {
//   try {
//     const patientId = req.session.patientId;

//     if (!patientId) {
//       return res
//         .status(400)
//         .json({ success: false, message: "Patient Id not Found" });
//     }

//     // Fetch the latest Treatment Advice for the patient
//     const treatmentAdviceData = await treatmentAdvice.findOne({
//       where: { patientId: patientId },
//       // order: [["createdAt", "DESC"]], // Order by createdAt field in descending order
//     });

//     // Fetch the latest History for the patient
//     const historyData = await History.findOne({
//       where: { patientId: patientId },
//       // order: [["createdAt", "DESC"]], // Order by createdAt field in descending order
//     });
//     console.log("1");

//     const followupData = await FollowUp.findOne({
//       where: { patientId: patientId },
//     });

//     const diagnosisData = await diagnosis.findOne({
//       where: { patientId: patientId },
//     });
//     const allergiesData = await allergies.findOne({
//       where: { patientId: patientId },
//     });

//     // const responseData = [
//     //   { treatmentAdvice: treatmentAdviceData },
//     //   { followups: followupData },
//     // ];

//     // const prescriptionData = await prescription.findOne({
//     //   where: { id: 137 },
//     // });
//     const prescriptionData = await prescription.findAll({
//       where: { patientId: patientId },
//     });

//     const serviceAdviceData = await serviceAdvice.findOne({
//       where: {
//         patientId: patientId,
//       },
//     });
//     const preExistingConditionData = await preExistingCondition.findOne({
//       where: {
//         patientId: patientId,
//       },
//     });
//     const generalExaminationData = await GeneralExamination.findOne({
//       where: {
//         patientId: patientId,
//       },
//     });

//     const doctorNotesData = await doctorNotes.findAll({
//       where: {
//         patientId: patientId,
//       },
//     });

//     const responseData = {
//       treatmentAdvice: treatmentAdviceData,
//       followups: followupData,
//       prescription: prescriptionData,
//       serviceAdvice: serviceAdviceData,
//       doctorNotes: doctorNotesData,
//       diagnosis: diagnosisData,
//       generalExamination: generalExaminationData,
//       allergies: allergiesData,
//       preExistingCondition: preExistingConditionData,
//       history: historyData,
//     };

//     res.status(200).json({ success: true, data: responseData });

//     // now in the end i create an array and push all like
//     //  treatementAdvice and service details and diagnosis and alll ...
//   } catch (error) {
//     console.error(error);
//   }
// };

const getEMRHistory = async (req, res) => {
  try {
    const patientId = req.session.patientId;

    if (!patientId) {
      return res
        .status(400)
        .json({ success: false, message: "Patient Id not Found" });
    }

    const preExistingConditionData = await preExistingCondition.findAll({
      where: {
        clinic_id: req.user.clinicId,
        patientId: patientId,
      },
    });

    const allergiesData = await allergies.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const chiefComplaintsData = await chiefComplaint.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const historyData = await History.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const generalExaminationData = await GeneralExamination.findAll({
      where: {
        patientId: patientId,
        clinic_id: req.user.clinicId,
      },
    });

    const diagnosisData = await diagnosis.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const doctorNotesData = await doctorNotes.findAll({
      where: {
        patientId: patientId,
        clinic_id: req.user.clinicId,
      },
    });

    const serviceAdviceData = await serviceAdvice.findAll({
      where: {
        patientId: patientId,
        clinic_id: req.user.clinicId,
      },
    });

    const prescriptionData = await prescription.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const attachmentsData = await attachments.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const treatmentAdviceData = await treatmentAdvice.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const followupData = await FollowUp.findAll({
      where: { patientId: patientId, clinic_id: req.user.clinicId },
    });

    const responseData = {
      preExistingCondition: preExistingConditionData,
      allergies: allergiesData,
      chiefComplaints: chiefComplaintsData,
      history: historyData,
      generalExamination: generalExaminationData,
      diagnosis: diagnosisData,
      doctorNotes: doctorNotesData,
      serviceAdvice: serviceAdviceData,
      prescription: prescriptionData,
      attachmentsData: attachmentsData,
      treatmentAdvice: treatmentAdviceData,
      followups: followupData,
    };

    res.status(200).json({ success: true, data: responseData });
  } catch (error) {
    console.error(error);
    res.status(500).send(error.message);
  }
};

const emrHistoryDates = async (req, res) => {
  const { patientId } = req.session;
  const { clinicId: clinic_id } = req.user;

  try {
    const data = await treatmentAdvice.findAll({
      where: {
        patientId,
        clinic_id,
      },
      attributes: ["createdAt"],
    });

    console.log(data);
    res.send(data);
  } catch (err) {
    res.status(500).send(err);
  }
};

const emrHistoryByDates = async (req, res) => {
  const { date } = req.params;
  const { patientId } = req.session;
  const { clinicId: clinic_id } = req.user;

  try {
    const data = await treatmentAdvice.findAll({
      where: { patientId, clinic_id, treatmentDate: date },
    });
    res.send(data);
  } catch (err) {
    console.log("Erro from emrHistoryByDates:", err);
    res.status(500).send({ message: "Unable to fetch history." });
  }
};

const postThawedOocytes = async (req, res) => {
  try {
    const { records } = req.body;

    const sessionCycleId = req.session.cycle_id;

    if (!records || !Array.isArray(records)) {
      return res.status(400).json({ message: "Invalid Request Body." });
    }

    for (const record of records) {
      const { cycleId, oocyteNumber } = record;

      const oocyte = await vitrifyOocyte.findOne({
        where: {
          cycleId,
          oocyteNumber,
          clinicId: req.user.clinicId,
        },
      });

      if (oocyte) {
        await oocyte.update({
          oldCycleId: cycleId,
          cycleId: sessionCycleId,
          status: "observe",
        });
      }
    }

    // comm ai in host voice done all

    await PatientCounseling.update(
      { currentPage: "sperm" },
      {
        where: {
          patientId: req.session.patientId,
          cycle_id: req.session.cycle_id,
          status: true,
          clinicId: req.user.clinicId,
        },
      }
    );

    res.status(200).json({ message: "Thaw records processed successfully" });
  } catch (error) {
    console.log(`Error Posting Thaw Oocytes `, error);
    res
      .status(500)
      .json({ message: "Failed to Post Thaw Records", error: error.message });
  }
};

const getVitrifiedOocytes = async (req, res) => {
  try {
    const oocytes = await vitrifyOocyte.findAll({
      where: {
        status: "freeze",
        patientId: req.session.patientId,
        clinicId: req.user.clinicId,
      },
    });
    res.status(200).json(oocytes);
  } catch (error) {
    console.error("Error fetching vitrified oocytes:", error);
    res.status(500).json({ error: "Internal server error" });
  }
};
const getThawedOocytes = async (req, res) => {
  try {
    const oocytes = await vitrifyOocyte.findAll({
      where: {
        patientId: req.session.patientId,
        status: "observe",
        clinicId: req.user.clinicId,
      },
    });
    res.status(200).json(oocytes);
  } catch (error) {
    res.status(500).json({ error: "Internal server error" });
  }
};

const vitrifyEmbryoes = async (req, res) => {
  try {
    const embryo = await vitrifyEmbryos.findAll({
      where: {
        patientId: req.session.patientId,
        status: "freeze",
        clinicId: req.user.clinicId,
      },
    });
    console.log(embryo);
    res.status(200).json(embryo);
  } catch (error) {
    res.status(500).json({ error: "Internal server error" });
  }
};

// for lakshay dashboard api's

const getTotalCounselingAndPatients = async (req, res) => {
  try {
    // Fetch total records for PatientCounseling (counseling done)
    const totalCounseling = await PatientCounseling.count();

    // Fetch total records for PR_patientReg (patient registrations)
    const totalPatients = await PR_patientReg.count();

    // Send the response with both total counts
    res.status(200).json({
      totalPatients,
      TotalCounselingDone: totalCounseling,
    });
  } catch (error) {
    console.error("Error fetching counts:", error);
    res.status(500).json({ error: "An error occurred while fetching counts." });
  }
};

const getTotalRecordsETandCounselling = async (req, res) => {
  try {
    // Fetch total records for PatientCounseling
    const totalCounseling = await PatientCounseling.count();

    // Fetch total records for EmbryoTransfer
    const totalET = await EmbryoTransfer.count();

    // Combine results into a single response
    res.status(200).json({
      success: true,
      data: {
        totalCounseling: totalCounseling,
        totalET: totalET,
      },
    });
  } catch (error) {
    console.error("Error fetching totals:", error);
    res.status(500).json({
      success: false,
      message: "Failed to fetch total records",
    });
  }
};

const getAllPackageIds = async (req, res) => {
  try {
    // Fetch all package_id values
    const packageIds = await PatientCounseling.findAll({
      attributes: ["package_id"],
      raw: true,
    });

    // Hardcoded mapping of package_id to package names
    const packageMapping = {
      1: "IUI",
      2: "IVF",
    };

    // Count occurrences of each package_id
    const packageCounts = packageIds.reduce((acc, item) => {
      if (item.package_id) {
        acc[item.package_id] = (acc[item.package_id] || 0) + 1;
      }
      return acc;
    }, {});

    // Transform the response into the required format
    const packageSummary = {};
    for (const [id, count] of Object.entries(packageCounts)) {
      const packageName = packageMapping[id];
      if (packageName) {
        packageSummary[packageName] = count;
      }
    }

    res.status(200).json({
      success: true,
      data: packageSummary,
    });
  } catch (error) {
    console.error("Error fetching package_ids:", error);
    res.status(500).json({
      success: false,
      message: "Failed to fetch package IDs",
    });
  }
};

const getPatientCountByMonth = async (req, res) => {
  try {
    // Fetch all records
    const records = await PR_patientReg.findAll();

    // Group the records by month
    const months = [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ];

    const monthCount = {};

    // Initialize the monthCount object with all months set to 0
    months.forEach((month) => {
      monthCount[month] = 0;
    });

    // Iterate through records and count them by month
    records.forEach((record) => {
      const createdAt = new Date(record.createdAt); // Assuming createdAt is a Date
      const monthName = months[createdAt.getMonth()]; // Get month name
      monthCount[monthName] += 1;
    });

    // Send the response
    res.status(200).json(monthCount);
  } catch (error) {
    console.error("Error fetching patient data:", error);
    res
      .status(500)
      .json({ error: "An error occurred while fetching patient data." });
  }
};

// combine api

// const getDashboardData = async (req, res) => {
//   try {
//     // Fetch total records for PatientCounseling (counseling done)

//     const totalCounseling = await PatientCounseling.count();

//     // Fetch total records for PR_patientReg (patient registrations)
//     const totalPatients = await PR_patientReg.count();

//     // Fetch total records for EmbryoTransfer
//     const totalET = await EmbryoTransfer.count();

//     // Fetch all records for patient registration
//     const records = await PR_patientReg.findAll();

//     // Group the records by month
//     const months = [
//       "January",
//       "February",
//       "March",
//       "April",
//       "May",
//       "June",
//       "July",
//       "August",
//       "September",
//       "October",
//       "November",
//       "December",
//     ];

//     const monthCount = {};
//     months.forEach((month) => {
//       monthCount[month] = 0;
//     });

//     // Iterate through records and count them by month
//     records.forEach((record) => {
//       const createdAt = new Date(record.createdAt); // Assuming createdAt is a Date
//       const monthName = months[createdAt.getMonth()]; // Get month name
//       monthCount[monthName] += 1;
//     });

//     // Fetch all package_id values for patient counseling
//     const packageIds = await PatientCounseling.findAll({
//       attributes: ["package_id"],
//       raw: true,
//     });

//     // Hardcoded mapping of package_id to package names
//     const packageMapping = {
//       1: "IUI",
//       2: "IVF",
//     };

//     // Count occurrences of each package_id
//     const packageCounts = packageIds.reduce((acc, item) => {
//       if (item.package_id) {
//         acc[item.package_id] = (acc[item.package_id] || 0) + 1;
//       }
//       return acc;
//     }, {});

//     // Transform the package counts into the required format
//     const packageSummary = {};
//     for (const [id, count] of Object.entries(packageCounts)) {
//       const packageName = packageMapping[id];
//       if (packageName) {
//         packageSummary[packageName] = count;
//       }
//     }

//     // Combine all data and send the response
//     res.status(200).json({
//       success: true,
//       data: {
//         totalPatients,
//         TotalCounselingDone: totalCounseling,
//         totalET,
//         monthlyPatientCount: monthCount,
//         packageSummary,
//       },
//     });
//   } catch (error) {
//     console.error("Error fetching dashboard data:", error);
//     res.status(500).json({
//       success: false,
//       message: "An error occurred while fetching the dashboard data.",
//     });
//   }
// };

const getDashboardData = async (req, res) => {
  try {
    console.log(`req.user.clinicId`);
    console.log(`req.user.clinicId`);
    console.log(req.user.clinicId);
    console.log(req.user.clinicId);
    console.log(req.user.clinicId);
    console.log(`req.user.clinicId`);

    // Fetch total records for PatientCounseling (counseling done) where clinic_id = 0
    const totalCounseling = await PatientCounseling.count({
      where: { clinicId: req.user.clinicId },
    });

    // Fetch total records for PR_patientReg (patient registrations) where clinic_id = 0
    const totalPatients = await PR_patientReg.count({
      where: { clinic_id: req.user.clinicId },
    });

    // Fetch total records for EmbryoTransfer where clinic_id = 0
    const totalET = await EmbryoTransfer.count({
      where: { clinicId: req.user.clinicId },
    });

    // Fetch all records for patient registration where clinic_id = 0
    const records = await PR_patientReg.findAll({
      where: { clinic_id: req.user.clinicId },
    });

    // Group the records by month
    const months = [
      "January",
      "February",
      "March",
      "April",
      "May",
      "June",
      "July",
      "August",
      "September",
      "October",
      "November",
      "December",
    ];

    const monthCount = {};
    months.forEach((month) => {
      monthCount[month] = 0;
    });

    // Iterate through records and count them by month
    records.forEach((record) => {
      const createdAt = new Date(record.createdAt); // Assuming createdAt is a Date
      const monthName = months[createdAt.getMonth()]; // Get month name
      monthCount[monthName] += 1;
    });

    // Fetch all package_id values for patient counseling where clinic_id = 0
    const packageIds = await PatientCounseling.findAll({
      attributes: ["package_id"],
      where: { clinicId: req.user.clinicId },
      raw: true,
    });

    // Hardcoded mapping of package_id to package names
    const packageMapping = {
      1: "IUI",
      2: "IVF",
    };

    // Count occurrences of each package_id
    const packageCounts = packageIds.reduce((acc, item) => {
      if (item.package_id) {
        acc[item.package_id] = (acc[item.package_id] || 0) + 1;
      }
      return acc;
    }, {});

    // Transform the package counts into the required format
    const packageSummary = {};
    for (const [id, count] of Object.entries(packageCounts)) {
      const packageName = packageMapping[id];
      if (packageName) {
        packageSummary[packageName] = count;
      }
    }

    // Combine all data and send the response

    res.status(200).json({
      success: true,
      data: {
        totalPatients,
        TotalCounselingDone: totalCounseling,
        totalET,
        monthlyPatientCount: monthCount,
        packageSummary,
      },
    });
  } catch (error) {
    console.error("Error fetching dashboard data:", error);
    res.status(500).json({
      success: false,
      message: "An error occurred while fetching the dashboard data.",
    });
  }
};

const getConcentRecords = async (req, res) => {
  try {
    // Query the database to find the record by patientID

    const patientId = req.session.patientId;

    const patientRecord = await ConsentPatientUser.findOne({
      where: { patientID: patientId },
    });

    if (!patientRecord) {
      return res.status(404).json({ message: "Patient not found" });
    }

    // Return the formNames
    return res.status(200).json({ formNames: patientRecord.formNames });
  } catch (error) {
    console.error(error);
    return res
      .status(500)
      .json({ message: "An error occurred while fetching data" });
  }
};

const getCurrentPageByCycleId = async (req, res) => {
  const cycle_id = req.session.cycle_id; // Assuming cycle_id is passed as a parameter in the URL

  try {
    // Fetch the currentPage based on cycle_id
    const counselingData = await PatientCounseling.findOne({
      where: { cycle_id },
      attributes: ["currentPage"], // Only fetch currentPage field
    });

    // Check if data exists
    if (!counselingData) {
      return res
        .status(404)
        .json({ message: "Counseling data not found for the given cycle_id" });
    }

    // Return the currentPage in response
    res.status(200).json({ currentPage: counselingData.currentPage });
  } catch (error) {
    console.error("Error fetching currentPage:", error);
    res.status(500).json({ message: "Internal server error" });
  }
};

const getFertilizationPerc = async (req, res) => {
  try {
    //number of oocytes --ivf icsi
    //fertilization rate
    const numberOfIvf = await Day0Record.count({
      where: {
        clinicId: req.user.clinicId,
        cycleId: req.query.cycleId,
        FertiMethod: "Conventional IVF",
      },
    });
    const numberOfICSI = await Day0Record.count({
      where: {
        clinicId: req.user.clinicId,
        cycleId: req.query.cycleId,
        FertiMethod: "ICSI",
      },
    });
    const numberOfBoth = await Day0Record.count({
      where: {
        clinicId: req.user.clinicId,
        cycleId: req.query.cycleId,
        FertiMethod: "Both IVF and ICSI",
      },
    });

    const numberOfOocyte = await ovumSchedule.findOne({
      where: { clinchId: req.user.clinicId, cycleId: req.query.cycleId },
      attributes: ["NoOfOocytes"],
    });
    let fertilizationPerc = 0;
    if (numberOfIvf) {
      fertilizationPerc =
        (parseFloat(numberOfIvf) / parseFloat(numberOfOocyte.NoOfOocytes)) *
        100;
    } else if (numberOfICSI) {
      fertilizationPerc =
        (parseFloat(numberOfICSI) / parseFloat(numberOfOocyte.NoOfOocytes)) *
        100;
    } else {
      fertilizationPerc =
        (parseFloat(numberOfBoth) / parseFloat(numberOfOocyte.NoOfOocytes)) *
        100;
    }

    res.status(200).json({
      IVF: numberOfIvf,
      ICSI: numberOfICSI,
      both: numberOfBoth,
      fertilizationPercentage: fertilizationPerc,
    });
  } catch (error) {
    console.log(error);
  }
};

const getStimulationSubmitDate = async (req, res) => {
  try {
    const StimulationData = await StimulationSubmit.findOne({
      where: {
        cycleId: req.query.cycleId,
      },
      attributes: ["triggerType"],
    });

    res.status(200).json(StimulationData);
  } catch (error) {
    console.log(error);
  }
};

const calculateDates = async (req, res) => {
  try {
    // Extract cycleID and patientId from query or session
    const cycleID = req.query.cycleID || req.session.cycle_id;
    const patientId = req.query.patientID || req.session.patientId;

    if (!cycleID || !patientId) {
      return res
        .status(400)
        .json({ message: "cycleID and patientId are required" });
    }

    // Fetch the EMR date
    const eMRDateData = await treatmentAdvice.findOne({
      where: { cycleId: cycleID, patientId: patientId },
      attributes: ["createdAt"],
    });

    if (!eMRDateData) {
      return res.status(404).json({ message: "EMR date not found" });
    }

    const treatmentStartedDate = eMRDateData.createdAt;

    // Parse the treatmentStartedDate into a Date object
    const startDate = new Date(treatmentStartedDate);
    if (isNaN(startDate)) {
      return res
        .status(400)
        .json({ message: "Invalid treatmentStartedDate format" });
    }

    // Helper function to add days to a date
    const addDays = (baseDate, days) => {
      const date = new Date(baseDate);
      date.setDate(date.getDate() + days);
      return date;
    };

    // Helper function to format date in DD-MM-YYYY format
    const formatDate = (date) => {
      if (!date) return null;
      const options = { day: "2-digit", month: "2-digit", year: "numeric" };
      return new Intl.DateTimeFormat("en-GB", options).format(new Date(date));
    };

    // Calculate all dates
    const dates = {
      counsellingDate: formatDate(addDays(startDate, 0)), // Same day
      consentDate: formatDate(addDays(startDate, 0)), // Same day
      stimulationStartDate: formatDate(addDays(startDate, 1)), // Start 2nd day
      stimulationEndDate: formatDate(addDays(startDate, 12)), // End on 12th day
      triggerDate: formatDate(addDays(startDate, 13)), // 13th day
      ovumPickupDate: formatDate(addDays(startDate, 14)), // 14th day
      spermRetrievalDate: formatDate(addDays(startDate, 15)), // 15th day
      cultureStartDate: formatDate(addDays(startDate, 15)), // Start 15th day
      cultureEndDate: formatDate(addDays(startDate, 21)), // End 21st day
      embryoTransferDate: formatDate(addDays(startDate, 21)), // 21st day
      betaHcgDateStart: formatDate(addDays(startDate, 33)), // 21st day + 12 days
      betaHcgDateEnd: formatDate(addDays(startDate, 35)), // 21st day + 14 days
    };

    // Return the calculated dates
    return res
      .status(200)
      .json({ message: "Dates calculated successfully", dates });
  } catch (error) {
    console.error("Error calculating dates:", error);
    return res
      .status(500)
      .json({ message: "Internal Server Error", error: error.message });
  }
};

const formatDate = (date) => {
  if (!date) return null;
  const options = { day: "2-digit", month: "2-digit", year: "numeric" };
  return new Intl.DateTimeFormat("en-GB", options).format(new Date(date));
};

const timeLineApi = async (req, res) => {
  try {
    const cycleID = req.query.cycleID || req.session.cycle_id;
    const patientId = req.query.patientID || req.session.patientId;

    const models = [
      {
        model: PR_patientReg,
        alias: "PrPatientDate",
        where: { id: patientId },
        attributes: ["createdAt"],
      },
      {
        model: PatientCounseling,
        alias: "counsellingDate",
        where: { cycle_id: cycleID, patientId: patientId },
        attributes: ["createdAt"],
      },
      {
        model: treatmentAdvice,
        alias: "eMRDate",
        where: { cycleId: cycleID, patientId: patientId },
        attributes: ["createdAt"],
      },
      {
        model: StimulationSubmit,
        alias: "stimulationDetailsDate",
        where: { cycleId: cycleID },
        attributes: ["createdAt"],
      },
      {
        model: ovumSchedule,
        alias: "opuData",
        where: { cycleId: cycleID, patient_id: patientId },
        attributes: ["createdAt"],
      },
      {
        model: SemenSample,
        alias: "semenSampleData",
        where: { cycleId: cycleID, patient_id: patientId },
        attributes: ["createdAt"],
      },
      {
        model: ScheduleEt,
        alias: "scheduleEtDate",
        where: { cycleId: cycleID, patientId: patientId },
        attributes: ["createdAt"],
      },
      {
        model: EmbryoTransfer,
        alias: "embryoTransfersDate",
        where: { cycleId: cycleID },
        attributes: ["createdAt"],
        isMultiple: true,
      },
    ];

    const results = await Promise.all(
      models.map(async ({ model, alias, where, attributes, isMultiple }) => {
        if (isMultiple) {
          const data = await model.findAll({ where, attributes });
          return {
            [alias]: data.map((item) => ({
              ...item.toJSON(),
              createdAt: formatDate(item.createdAt),
            })),
          };
        } else {
          const data = await model.findOne({ where, attributes });
          if (data) {
            return {
              [alias]: {
                ...data.toJSON(),
                createdAt: formatDate(data.createdAt),
              },
            };
          } else {
            return { [alias]: null };
          }
        }
      })
    );

    const response = results.reduce(
      (acc, result) => ({ ...acc, ...result }),
      {}
    );

    return res.status(200).json(response);
  } catch (error) {
    console.error("Error in timeLineApi:", error);
    return res.status(500).json({ message: "Internal server error", error });
  }
};

const getReferalDetails = async (req, res) => {
  try {
    console.log("Query Parameters:", req.query);
    console.log("On referral details API");

    const patientId = req.query.patientID || req.session.patientId;
    console.log(`Using patientID: ${patientId}`);

    if (!patientId) {
      return res.status(400).json({ message: "Patient ID is required." });
    }

    const referralDetails = await PR_patientReg.findOne({
      where: { id: patientId },
      attributes: ["Agent", "ReferralDetails", "SorOfRef"],
    });

    console.log("Referral Details:", referralDetails);

    if (!referralDetails) {
      return res.status(404).json({
        message: "No referral details found for the given patient ID.",
      });
    }

    res.status(200).json({ referralDetails });
  } catch (error) {
    console.error("Error occurred:", error);
    res.status(500).json({
      message: "An error occurred while fetching referral details.",
    });
  }
};

// for lakshay dashboard api's

module.exports = {
  calculateDates,
  timeLineApi,
  getReferalDetails,
  getStimulationDetails,
  getEtDateForAdmissionDischargeSummary,
  getFertilizationPerc,
  vitrifyEmbryosRecord,
  getEmbryoTransferDataReport,
  saveBetaHcg,
  getCycleSummaryApiForOverview,
  embrology_44_mainUPDATED,
  getOvumRecords,
  fetchWashSemenSamplesBySessionCycleId,
  getCounselingDetails,
  getDashboardData,
  getConcentRecords,
  getTotalCounselingAndPatients,
  getPatientCountByMonth,
  getTotalRecordsETandCounselling,
  getAllPackageIds,
  getOocyteDonors,
  getThawedOocytes,
  getVitrifiedOocytes,
  getEMRHistory,
  emrHistoryDates,
  emrHistoryByDates,
  threesixty,
  getEmbryoTransferData,
  saveDonor,
  saveDonorOocyte,
  embrology_44_main,
  getLatestTreatmentAdviceDetails,
  getClinicCounsellingData,
  getCycleCard,
  getCycleSummaryApi,
  getEtSchedule,
  newSemenSample,
  getSemenSample,
  WashSemenSampleStore,
  DiscardedSemenSample,
  DiscardedSemenSample2,
  newEmbroTransfor,
  getVolume,
  getVolumeSample,
  saveData,
  issueData,
  donorData,
  issuedData,
  issueUpdate,
  splitUpdate,
  Day0Submit,
  Day1Submit,
  Day2Submit,
  Day3Submit,
  Day4Submit,
  Day5Submit,
  Day6Submit,
  saveSpermAdvanceResult,
  stimulationSubmit,
  saveScheduleEt,
  submitOutcome,
  newEmbroTransfor,
  patientCounsellingGet,
  patientCounsellingPost,
  getReadyForTransferRecords2,
  saveEmbryoTransfer,
  getEmbryoTransfers,
  getEmbryoTransfersByCycleId,
  postData,
  getDataOpu,
  getOpu,
  postVitrify,
  postVitrifyEmbryo,
  vitrifyEmbryoes,
  serviceAdviceSubmit,
  doctorNotesSubmit,
  diagnosisDataSubmit,
  examinationSubmit,
  treatmentHistSubmit,
  HistSubmit,
  allergySubmit,
  complaintSubmit,
  attachmentSubmit,
  treatmentSubmit,
  conditionsSubmit,
  procedureSubmit,
  followUpSubmit,
  savePrescription,
  drugsData,
  updateDonor,
  fetchDoctorNotes,
  getFollowUpByPatientAndDoctor,
  chiefComplaints,
  tableVitrifyData,
  vitrifyEmbryo,
  getSemenInvData,
  thawUpdate,
  issuedSemen,
  getTreatmentAdvice,
  postThawedOocytes,
  getCounsellingAllDataByCycleID,
  getCurrentPageByCycleId,
};
