const { TempTable } = require("../models/File");

exports.getQRFileUploadPage = async (req, res) => {
  try {
    const { type } = req.params;
    res.render("uploadFilePage", { type });
  } catch (error) {
    res.status(500).send({ message: error.message });
  }
};

exports.getQRUploadedFile = async (req, res) => {
  try {
    const { id: uniqueId } = req.params;

    if (!uniqueId) return res.status(400).send("Unique ID is required");

    const file = await TempTable.findOne({ where: { uniqueId } });
    if (!file) return res.status(404).send("File not found");

    res.send(file);
  } catch (error) {
    res.status(500).send({ message: error.message });
  }
};

exports.uploadFile = async (req, res) => {
  const { id, folder } = req.query;
  console.log(req.query);
  const file = req.file;

  if (!file) return res.status(400).send({ message: "File not found." });

  console.log('file',file);
  try {
    file.uniqueId = id || null;
   
    file.path = file.filename

    const {
      uniqueId,
      originalname: originalName,
      mimetype: mimeType,
      path,
      size,
      filename: name,
    } = file;

    const tempFile = await TempTable.create({
      originalName,
      mimeType,
      path,
      size,
      name,
      uniqueId,
    });

    res.json(tempFile);
  } catch (error) {
    console.log("Error while uploading image", error);
    res.status(500).send({ message: error.message });
  }
};
