const { Op, Sequelize } = require("sequelize");
// const {
//   PR_BillFindPatient,
//   ClinicConfiguration,
//   PR_patientReg,
// } = require("../Models/pr_bill");
const { PR_BillFindPatient } = require("../models/PatientReg");
const { PR_patientReg } = require("../models/concentModel");
const { ClinicConfiguration } = require("../models/clinicConfig");
const { PurchaseOrder } = require("../models/mainInvSchema");

const getRecord = async (startDate, endDate, req) => {
  const clinicNames = await ClinicConfiguration.findAll({
    where: {
      clinic_id: req.user.clinicId,
    },
    attributes: ["id", "clinic_id", "clinic_area", "clinic_desc"],
    raw: true,
  });
  const whereCondition = {
    createdAt: {
      [Op.between]: [startDate, endDate],
    },
  };
  const purchaseValues = await PurchaseOrder.findAll({
    where: whereCondition,

    attributes: [
      "clinic_id",
      [
        Sequelize.fn(
          "SUM",
          Sequelize.cast(Sequelize.col("total_net_amount"), "INTEGER")
        ),
        "totalPurchaseAmount",
      ],
    ],
    group: ["clinic_id"], // Group by clinic_id
  });

  // Fetch revenue data for the custom date range
  const customRangeRevenue = await PR_BillFindPatient.findAll({
    where: whereCondition,
    attributes: [
      "clinic_id",
      [
        Sequelize.fn(
          "SUM",
          Sequelize.cast(Sequelize.col("totalNetAmount"), "INTEGER")
        ),
        "totalNetAmount",
      ],
      [
        Sequelize.fn(
          "SUM",
          Sequelize.cast(Sequelize.col("balanceAmount"), "INTEGER")
        ),
        "totalBalanceAmount",
      ],
    ],
    group: ["clinic_id"], // Group by clinic_id
  });

  // Convert to consistent format, filling missing fields with 0
  let customRangeResults = [];
  console.log(customRangeRevenue);

  clinicNames.forEach((clinic) => {
    const item = customRangeRevenue.find((pr) => pr.clinic_id === clinic.id);
    const purchase = purchaseValues.find((pr) => pr.clinic_id === clinic.id);

    customRangeResults.push({
      clinic_id: clinic.id,
      clinic_area: clinic?.clinic_area,
      clinic_name: clinic?.clinic_desc,
      totalNetAmount: parseInt(item?.dataValues?.totalNetAmount) || 0,
      totalBalanceAmount: parseInt(item?.dataValues?.totalBalanceAmount) || 0,
      totalPurchaseAmount: purchase?.dataValues?.totalPurchaseAmount || 0,
    });
  });
  // let result = new Set(customRangeResults);
  let result = Array.from(customRangeResults);

  // result = Array.from(result);
  console.log(result);

  return result;
};

const getRevenue = async (req, res) => {
  try {
    const { from, to, weekly, monthly } = req.query; // Get query params

    // Initialize empty array to hold results
    let results = [];
    if (!from && !to && !weekly && !monthly) {
      const today = new Date();
      const startOfToday = new Date(today);
      startOfToday.setHours(0, 0, 0, 0); // Start of day
      const endOfToday = new Date(today);
      endOfToday.setHours(23, 59, 59, 999); // End of day
      let result = await getRecord(startOfToday, endOfToday, req); // Fetch data for today\
      res.status(200).json(result);
      return;
    }

    // If from and to are provided, prioritize fetching data between these dates
    if (from && to) {
      const startDate = new Date(from);
      const endDate = new Date(to);
      endDate.setHours(23, 59, 59, 999); // Set the end of the day for the to date

      // Build where condition for the given date range
      let customRangeResults = [await getRecord(startDate, endDate, req)];
      return res.status(200).json(customRangeResults); // Return the result for custom range
    }

    // Weekly logic
    if (weekly) {
      const weeksAgo = parseInt(weekly, 10); // Convert weekly param to an integer
      if (!isNaN(weeksAgo) && weeksAgo > 0) {
        for (let i = 0; i < weeksAgo; i++) {
          const today = new Date();

          // Calculate endOfWeek and startOfWeek dates
          const endOfWeek = new Date(today);
          endOfWeek.setDate(today.getDate() - 7 * i); // Adjust for i weeks ago
          endOfWeek.setHours(23, 59, 59, 999); // End of day

          const startOfWeek = new Date(endOfWeek);
          startOfWeek.setDate(endOfWeek.getDate() - 6); // Start of the week (7 days ago)
          startOfWeek.setHours(0, 0, 0, 0); // Start of day

          // Build where condition for the current week's date range
          let clinics = await getRecord(startOfWeek, endOfWeek, req);

          results.push(clinics);
        }

        return res.status(200).json(results);
      }
    }

    // Monthly logic
    if (monthly) {
      const monthsAgo = parseInt(monthly, 10); // Convert monthly param to an integer
      if (!isNaN(monthsAgo) && monthsAgo > 0) {
        for (let i = 0; i < monthsAgo; i++) {
          const today = new Date();

          // Calculate endOfMonth and startOfMonth dates
          const endOfMonth = new Date(today);
          endOfMonth.setMonth(today.getMonth() - i); // Adjust for i months ago
          endOfMonth.setDate(
            new Date(
              endOfMonth.getFullYear(),
              endOfMonth.getMonth() + 1,
              0
            ).getDate()
          ); // End of the month
          endOfMonth.setHours(23, 59, 59, 999); // End of day

          const startOfMonth = new Date(endOfMonth);
          startOfMonth.setDate(1); // Start of the month
          startOfMonth.setHours(0, 0, 0, 0); // Start of day

          // Build where condition for the current month's date range
          let clinics = await getRecord(startOfMonth, endOfMonth, req);
          // Convert to consistent format, filling missing fields with 0

          results.push(clinics);
        }

        return res.status(200).json(results);
      }
    }

    res.status(400).json({ error: "Invalid query parameter" });
  } catch (err) {
    console.error("Error fetching revenue data:", err);
    res.status(500).send("Server Error");
  }
};

module.exports = { getRevenue };
