const { Op } = require("sequelize");
const { PR_patientReg, PR_BillFindPatient } = require("../models/PatientReg");
const { ItemMasterNew } = require("../models/adminInventorySchema");
// const { PR_BillFindPatient } = require("../models/PatientReg-1");

const search = async (req, res) => {
  try {
    const { searchTerm } = req.query;

    const patients = await PR_patientReg.findAll({
      where: {
        [Op.or]: [
          {
            firstName: {
              [Op.like]: `${searchTerm}%`, // Searches by first name, case-insensitive for MySQL
            },
          },
          {
            mr_no: {
              [Op.like]: `${searchTerm}%`, // Searches by MR number, case-insensitive for MySQL
            },
          },
          {
            phone1: {
              [Op.like]: `${searchTerm}%`, // Searches by phone, case-insensitive for MySQL
            },
          },
        ],
      },
      attributes: ["id", "firstName", "lastName", "dob", "Gender"],
    });

    if (patients.length > 0) {
      return res.status(200).json(patients);
    }

    const inventory = await ItemMasterNew.findAll({
      where: {
        [Op.or]: [
          {
            molecule_name: {
              [Op.like]: `%${searchTerm}%`, // Partial match with case-insensitive search for MySQL
            },
          },
          {
            item_name: {
              [Op.like]: `%${searchTerm}%`, // Partial match with case-insensitive search for MySQL
            },
          },
        ],
        clinic_id:req.user.clinicId
      },
    });

    if (inventory.length > 0) {
      return res.status(200).json(inventory);
    }

    const bills = await PR_BillFindPatient.findAll({
      where: {
        bill_no: {
          [Op.like]: `%${searchTerm}%`,
        },
      },
    });
    if (bills.length > 0) {
      return res.status(200).json(bills);
    }

    return res.status(404).json({ message: "No results found." });
  } catch (err) {
    res.status(500).json({ error: "An error occurred while searching" });
    console.log(err);
  }
};

// module.exports = { search };
