const path = require("path");
const multer = require("multer");
const generateSuffix = require("../utils/generateSuffix");

function destination(req, file, cb) {
  const uploadFolder =
    req.query.folder === "concent" ? "public/Concent" : "public/images/myuploads";
  cb(null, uploadFolder);
}

function filename(req, file, cb) {
  cb(null, `${generateSuffix()}${path.extname(file.originalname)}`);
}

const allowedFileTypes = [".jpeg", ".jpg", ".png", ".pdf"];

// File filter function
function fileFilter(req, file, cb) {
  const fileExt = path.extname(file.originalname).toLowerCase();
  if (allowedFileTypes.includes(fileExt)) {
    cb(null, true); // Accept file
  } else {
    cb(
      new Error(
        `Invalid file type. Only ${allowedFileTypes.join(", ")} are allowed.`
      ),
      false
    ); // Reject file
  }
}

const storage = multer.diskStorage({
  destination,
  filename,
});

const upload = multer({ storage, fileFilter });

module.exports = upload;
