const { DataTypes } = require("sequelize");
const { sequelize } = require("../sequelize");
const { Bifurcation_Stages, PatientCounseling, Outcome } = require('./embrology');
const { PatientRefund, CompanyRefund } = require('./MainBill');
const { KYC } = require('./Kyc')


const PR_patientReg = sequelize.define(
  "PR_patientReg",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    mr_no: {
      type: DataTypes.STRING(255),
    },
    ArtBankName: {
      type: DataTypes.TEXT,
    },
    Agent: {
      type: DataTypes.TEXT,
    },
    patientImg: {
      type: DataTypes.STRING,
    },
    spouseImg: {
      type: DataTypes.STRING,
    },
    ReferralDetails: {
      type: DataTypes.TEXT,
    },
    RegistrationType: {
      type: DataTypes.TEXT,
    },
    SorOfRef: {
      type: DataTypes.TEXT,
    },
    address: {
      type: DataTypes.TEXT,
    },
    age_days: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    age_months: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    age_years: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    altMobileNo: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    area: {
      type: DataTypes.TEXT,
    },
    bloodGroup: {
      type: DataTypes.STRING(10),
      defaultValue: "",
    },
    camp: {
      type: DataTypes.TEXT,
    },
    city: {
      type: DataTypes.TEXT,
    },
    clinic_status: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    company_name: {
      type: DataTypes.TEXT,
    },
    country: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    date: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    Gender: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    dob: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    education: {
      type: DataTypes.TEXT,
    },
    email: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    familyName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    fatherName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    firstName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    id_proof_number: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    id_proof_type: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    inHouseDoctor: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    is_vip: {
      type: DataTypes.STRING(50),
      defaultValue: '0',
    },
    is_employee: {
      type: DataTypes.STRING(50),
      defaultValue: '0',
    },
    is_insured: {
      type: DataTypes.STRING(50),
      defaultValue: '0',
    },
    is_international: {
      type: DataTypes.STRING(50),
      defaultValue: '0',
    },
    externalDoctor: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    landlineNo: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    lastName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    marital_status: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    marriage_anniversary: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    middleName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    mobileNo: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    mobile_1: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    mobile_2: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    occupation: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    phone1: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    phone2: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    pin_code: {
      type: DataTypes.STRING(20),
      defaultValue: "",
    },
    prefix: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    religion: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },

    special_registration: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    state: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_address: {
      type: DataTypes.TEXT,
    },
    spouse_age_day: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    spouse_age_month: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    spouse_age_year: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    spouse_area: {
      type: DataTypes.TEXT,
    },
    spouse_blood_group: {
      type: DataTypes.STRING(10),
      defaultValue: "",
    },
    spouse_city: {
      type: DataTypes.TEXT,
    },
    spouse_company_name: {
      type: DataTypes.TEXT,
    },
    spouse_country: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_dob: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    spouse_education: {
      type: DataTypes.TEXT,
    },
    spouse_email: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_familyName: {
      type: DataTypes.TEXT,
    },
    spouse_firstName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_gender: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    spouse_id_proof: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_id_proof_number: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_is_international: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    spouse_lastName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_marital_status: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    spouse_marriage_anniversary: {
      type: DataTypes.STRING,
    },
    spouse_middleName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_mobile_1: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_mobile_2: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_motherName: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_nationality: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_occupation: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_pin_code: {
      type: DataTypes.STRING(20),
      defaultValue: "",
    },
    spouse_preferred_language: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    spouse_prefix: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    spouse_religion: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    spouse_residence_phone_1: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_residence_phone_2: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_residence_phone_3: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    spouse_special_registration: {
      type: DataTypes.STRING(50),
      defaultValue: "",
    },
    spouse_state: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    sponsor_associated_company: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    sponsor_company: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    sponsor_investigation_no: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    sponsor_member_relation: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    sponsor_patient_category: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    sponsor_patient_source: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    sponsor_remark: {
      type: DataTypes.TEXT,
    },
    spouse_monthly_income: {
      type: DataTypes.STRING(30),
      defaultValue: "",
    },
    spouse_skill: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    spouse_vehicle_type: {
      type: DataTypes.STRING(20),
      defaultValue: "",
    },
    spouse_work_experience: {
      type: DataTypes.STRING(10),
      defaultValue: "",
    },
    sponsor_tariff: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    ifsc_code: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    branch: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    bank_name: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    account_type: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    account_no: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    account_holder: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    height: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    weight: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    bmi: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    coupleId: {
      type: DataTypes.STRING(100),
      defaultValue: "",
    },
    image_path: {
      type: DataTypes.STRING,
      allowNull: true, // Or false, depending on your requirements
    },
    spouse_path: {
      type: DataTypes.STRING,
      allowNull: true, // If you're saving spouse image too
    },
    dr_cabin: {
      type: DataTypes.STRING,
    },
    reasonOfVisit: {
      type: DataTypes.STRING,
    },
    department: {
      type: DataTypes.STRING,
    },
    doctor: {
      type: DataTypes.STRING,
    },
    remark: {
      type: DataTypes.TEXT,
    },
    referenceDoctor: {
      type: DataTypes.STRING,
    },
    visitNotes: {
      type: DataTypes.TEXT,},
    lead_no:{
     type:DataTypes.STRING,
     allowNull:true,
     defaultValue:""
    },
    transfer_id:{
      type: DataTypes.STRING,
    },
    previous_clinics:{
      type:DataTypes.JSON,
    },
    is_map :{type : DataTypes.INTEGER,defaultValue:0}
  },
  {
    timestamps: true, // Set to true if you have createdAt and updatedAt columns
    // alter: true,
    tableName: "pr_patientreg", // Ensure the table name is as per your database
  }
);

// PR_patientReg.sync({alter:true})
const PR_ReferralDoc = sequelize.define(
  "PR_ReferralDoc",
  {
    firstName: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    middleName: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    lastName: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    specialization: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    doctorType: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    gender: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    contactNumber: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    emailId: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    address: {
      type: DataTypes.TEXT,
      defaultValue: "",
    },
    PanCard: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    id_proof_type: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    id_proof_number: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    bank_name: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    branch: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    ifsc_code: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    account_no: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    account_holder: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
  },
  {
    timestamps: true,
    alter: true,
    tableName: "pr_referraldoc",
  }
);

const PR_Appointment = sequelize.define(
  "PR_Appointment",
  {
    mrNo: {
      type: DataTypes.STRING,
    },
    age_days: {
      type: DataTypes.STRING,
      defaultValue: 0,
    },
    age_months: {
      type: DataTypes.STRING,
      defaultValue: 0,
    },
    age_years: {
      type: DataTypes.STRING,
      defaultValue: 0,
    },
    appointment_date: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    appointment_reason: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    clinic: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    department: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    dob: {
      type: DataTypes.STRING,
    },
    doctor: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    firstName: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    from_time: {
      type: DataTypes.STRING,
    },
    gender: {
      type: DataTypes.STRING,
    },
    lastName: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    mobile_code: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    mobile_number: {
      type: DataTypes.STRING,
      defaultValue: "",
    },
    remark: {
      type: DataTypes.STRING,
    },
    address: {
      type: DataTypes.STRING,
    },

    special_registration: {
      type: DataTypes.STRING,
    },
    to_time: {
      type: DataTypes.STRING,
    },
  },
  {
    tableName: "pr_appointment",
    alter: true,
    timestamps: true,
  }
);

const PR_PatientVisit = sequelize.define(
  "PR_PatientVisit",
  {
    mrNo: {
      type: DataTypes.STRING,
    },
    unit: {
      type: DataTypes.STRING,
    },
    Visitdate: {
      type: DataTypes.DATEONLY,
    },
    time: {
      type: DataTypes.TIME,
    },
    reasonOfVisit: {
      type: DataTypes.STRING,
    },
    department: {
      type: DataTypes.STRING,
    },
    doctor: {
      type: DataTypes.STRING,
    },
    cabin: {
      type: DataTypes.STRING,
    },
    referenceDoctor: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.TEXT,
    },
    visitNotes: {
      type: DataTypes.TEXT,
    },
  },
  {
    tableName: "pr_patientvisits",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

const Patients = sequelize.define(
  "Patients",
  {
    clinic_id: {
      type: DataTypes.INTEGER, // Assuming age is an integer
    },
    PatientId: {
      type: DataTypes.INTEGER, // Assuming age is an integer
    },
    Name: {
      type: DataTypes.STRING,
    },
    Gender: {
      type: DataTypes.STRING, // Assuming gender is a string, can be 'Male', 'Female', etc.
    },
    MrNo: {
      type: DataTypes.STRING,
    },
    SpouseName: {
      type: DataTypes.STRING,
    },
    SpouseGender: {
      type: DataTypes.STRING, // Assuming gender of spouse
    },
    Age: {
      type: DataTypes.INTEGER, // Assuming age is an integer
    },
    Mobile: {
      type: DataTypes.STRING, // Assuming phone number is stored as a string
    },
    CoupleId: {
      type: DataTypes.INTEGER, // Assuming coupleId references another table
    },
    Dob: {
      type: DataTypes.DATEONLY, // Date of Birth (Only Date, without time)
    },
  },
  {
    tableName: "patients",
    alter: true,
    timestamps: true, // Enable createdAt and updatedAt timestamps
  }
);

// Patients.sync({force:true})

const PR_formNewCouple = sequelize.define(
  "PR_formNewCouple",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    mrNo: {
      type: DataTypes.STRING,
    },
    PatientName: {
      type: DataTypes.STRING,
    },
    Couple_mrNo: {
      type: DataTypes.STRING,
    },
    CoupleName: {
      type: DataTypes.STRING,
    },
    CoupleDob: {
      type: DataTypes.DATEONLY,
    },
  },
  {
    tableName: "pr_formnewcouple",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);

const PR_BillFindPatient = sequelize.define(
  "PR_BillFindPatient",
  {

    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    bill_no: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    mrNo: {
      type: DataTypes.STRING,
    },
    selectedBillServices: {
      type: DataTypes.JSON,
    },
    date: {
      type: DataTypes.DATEONLY,
    },
    totalPayAmount: {
      type: DataTypes.STRING,
    },
    clinicBillAmount: {
      type: DataTypes.STRING,
    },
    totalNetAmount: {
      type: DataTypes.STRING,
    },
    totalConcessionAmount: {
      type: DataTypes.STRING,
    },
    totalNetBillAmount: {
      type: DataTypes.STRING,
    },
    totalBillAmount: {
      type: DataTypes.STRING,
    },
    doctor: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    Advance: {
      type: DataTypes.STRING,
    },
    ConcessionReason: {
      type: DataTypes.STRING,
    },
    freeze: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0
    },

    approved: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },

    Approvalremark: {
      type: DataTypes.STRING,
    },
    approvedBy: {
      type: DataTypes.STRING,
    },
    discountRemarks: {
      type: DataTypes.TEXT,
    },
    billRemarks: {
      type: DataTypes.TEXT,
    },

    paidAmount: {
      type: DataTypes.STRING, // Assuming this is a numeric value stored as a string
    },
    balanceAmount: {
      type: DataTypes.STRING, // Assuming this is a numeric value stored as a string
    },
  },
  {
    tableName: "pr_billfindpatient",

    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);
PR_BillFindPatient.sync()

const PR_BillPharmacy = sequelize.define(
  "PR_BillPharmacy",
  {

    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    bill_no: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    mrNo: {
      type: DataTypes.STRING,
    },
    selectedBillItems: {
      type: DataTypes.JSON,
    },
    date: {
      type: DataTypes.DATEONLY,
    },
    totalPayAmount: {
      type: DataTypes.STRING,
    },
    pharmacyBillAmount: {
      type: DataTypes.STRING,
    },
    totalNetAmount: {
      type: DataTypes.STRING,
    },
    totalConcessionAmount: {
      type: DataTypes.STRING,
    },
    totalNetBillAmount: {
      type: DataTypes.STRING,
    },
    totalTaxableAmount: {
      type: DataTypes.STRING,
    },
    remarks: {
      type: DataTypes.STRING,
    },
    Advance: {
      type: DataTypes.STRING,
    },
    ConcessionReason: {
      type: DataTypes.STRING,
    },
    doctor: {
      type: DataTypes.STRING,
    },
    store: {
      type: DataTypes.STRING,
    },
    freeze: {
      type: DataTypes.BOOLEAN,
      defaultValue: 0
    },

    approved: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },

    Approvalremark: {
      type: DataTypes.STRING,
    },
    approvedBy: {
      type: DataTypes.STRING,
    },
    discountRemarks: {
      type: DataTypes.TEXT,
    },
    billRemarks: {
      type: DataTypes.TEXT,
    },

    paidAmount: {
      type: DataTypes.STRING, // Assuming this is a numeric value stored as a string
    },
    balanceAmount: {
      type: DataTypes.STRING, // Assuming this is a numeric value stored as a string
    },
  },
  {
    tableName: "pr_billpharmacy",
    alter: true,
    timestamps: true, // Enable this if you want createdAt and updatedAt timestamps
  }
);
// PR_BillPharmacy.sync()

const PR_BillPaymentDetails = sequelize.define('PR_BillPaymentDetails', {
  bill_no: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  createdAt: {
    type: DataTypes.DATE,
  },
  advancePayment: {
    type: DataTypes.STRING, // Assuming it is a numeric value stored as a string
    allowNull: false,
    defaultValue: '0.00',
  },
  adjustAdvancePayment: {
    type: DataTypes.STRING, // Assuming it is a numeric value stored as a string
    allowNull: true,
  },
  balanceAmount: {
    type: DataTypes.STRING, // Assuming it is a numeric value stored as a string
    allowNull: false,
    defaultValue: '0.00',
  },
  paymentMethod: {
    type: DataTypes.STRING, // Cash, Cheque, Card, TT, EPayment, NEFT, Insurance, Corporate
    allowNull: true,
  },
  recievedAmount: {
    type: DataTypes.STRING, // Assuming it is a numeric value stored as a string
    allowNull: true,
  },
  referenceNo: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  referenceDate: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  bankName: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  bankDetails: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  defaultBankAccount: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  payer: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  refNo: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  validFrom: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  validTo: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  financialRemarks: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  company: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  insurance: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  refNoCorporate: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  validFromCorporate: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  validToCorporate: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  corporateRemarks: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  chequeNo: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  chequeDate: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  bankNameCheque: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  bankDetailsCheque: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  defaultBankAccountCheque: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  referenceNoEPayment: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  referenceDateEPayment: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  ePaymentGatewayName: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  ePaymentDetails: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  defaultBankAccountEPayment: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  refNoTT: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  transactionDateTT: {
    type: DataTypes.STRING, // Changed from DATE to STRING
    allowNull: true,
  },
  bankNameTT: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  bankDetailsTT: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  defaultBankAccountTT: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  remarksTT: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  cardType: {
    type: DataTypes.STRING, // Debit, Credit
    allowNull: true,
  },
  cardNo: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  cardHolderName: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  bankNameCard: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  bankDetailsCard: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  defaultBankAccountCard: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  discountRemarks: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  billRemarks: {
    type: DataTypes.TEXT,
    allowNull: true,
  },
  printBillOnConfirm: {
    type: DataTypes.BOOLEAN,
    defaultValue: false,
  }
}, {
  tableName: 'pr_billpaymentdetails',
  timestamps: true,
});

const QRCodeModel = sequelize.define(
  "QRCode",
  {
    qrid: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    qrimg: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    qrsecid: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    qrstatus: {
      type: DataTypes.STRING,
      defaultValue: "I", // Inactive
    },
  },
  {
    tableName: "qrcode",
  }
);

const BillServices = sequelize.define('BillServices', {
  id: {
    type: DataTypes.INTEGER,
    autoIncrement: true,
    primaryKey: true,
  },
  billId: {
    type: DataTypes.INTEGER,
    allowNull: false,
  },
  serviceCode: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  serviceName: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  serviceRate: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false,
  },
  concession_per: {
    type: DataTypes.DECIMAL(5, 2),
    allowNull: true,
    defaultValue: 0,
  },
  concession_amount: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: true,
    defaultValue: 0,
  },
  service_amount: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: true,
    defaultValue: 0,
  },
  totalAmount: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false,
  },
  netAmount: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false,
  },
  doctor: {
    type: DataTypes.STRING,
    allowNull: true,
  },
}, {
  alter: true,
  tableName: 'pr_billservices',
  timestamps: true, // To include createdAt and updatedAt fields
});

const BillItems = sequelize.define('BillItems', {
  id: {
    type: DataTypes.INTEGER,
    autoIncrement: true,
    primaryKey: true,
  },
  billId: {
    type: DataTypes.INTEGER,
    allowNull: false,

  },
  item_code: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  item_name: {
    type: DataTypes.STRING,
    allowNull: false,
  },
  batch_code: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  hsn_code: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  expiry_date: {
    type: DataTypes.DATE,
    allowNull: true,
  },
  rate: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false,
  },
  quantity: {
    type: DataTypes.INTEGER,
    allowNull: false,
    defaultValue: 1,
  },
  concession_per: {
    type: DataTypes.DECIMAL(5, 2),
    allowNull: true,
    defaultValue: 0,
  },
  concession_amount: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: true,
    defaultValue: 0,
  },
  totalAmount: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false,
  },
  netAmount: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false,
  },
  doctor: {
    type: DataTypes.STRING,
    allowNull: true,
  },
  gst: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: true,
    defaultValue: 0,
  },

}, {
  alter: true,
  tableName: 'pr_billitems',
  timestamps: true, // To include createdAt and updatedAt fields
});

const Advance = sequelize.define('PatientAdvance', {
  date: {
    type: DataTypes.STRING, // Date
  },
  rec_no: {
    type: DataTypes.STRING, // Receipt No.
  },
  clinic_name: {
    type: DataTypes.STRING,
    defaultValue: '1' // Clinic Name
  },
  patient_id: {
    type: DataTypes.STRING, // Clinic Name
  },
  amount: {
    type: DataTypes.DECIMAL(10, 2), // Amount (stored as 'amount')
  },
  consume_amount: {
    type: DataTypes.DECIMAL(10, 2), // Consume Amount
  },
  balance_amount: {
    type: DataTypes.DECIMAL(10, 2), // Balance Amount
  },
  paymentMethod: {
    type: DataTypes.STRING, // Payment Mode (stored as 'paymentMethod')
  },
  referenceNo: {
    type: DataTypes.STRING, // Reference No. (stored as 'referenceNo')
  },
  chequeNo: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  chequeDate: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  bankName: {
    type: DataTypes.STRING, // Bank Name (stored as 'bankName')
  },
  referenceDate: {
    type: DataTypes.STRING, // Reference Date (stored as 'referenceDate')
  },
  bankDetails: {
    type: DataTypes.STRING, // Bank Details (stored as 'bankDetails')
  },
  defaultBankAccount: {
    type: DataTypes.STRING, // Default Bank Account (stored as 'defaultBankAccount')
  },
  ePaymentGatewayName: {
    type: DataTypes.STRING, // E-Payment Gateway Name (stored as 'ePaymentGatewayName')
  },
  ePaymentDetails: {
    type: DataTypes.STRING, // E-payment Details (stored as 'ePaymentDetails')
  },
  cardType: {
    type: DataTypes.STRING, // Card Type (stored as 'cardType')
  },
  cardNo: {
    type: DataTypes.STRING, // Card No. (stored as 'cardNo')
  },
  cardHolderName: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  transactionDate: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  approvalNo: {
    type: DataTypes.STRING, // Approval No. (stored as 'approvalNo')
  },
  printBillOnConfirm: {
    type: DataTypes.BOOLEAN, // Print Bill on Confirm (stored as 'printBillOnConfirm')
  },
  remarks: {
    type: DataTypes.TEXT, // Remarks (stored as 'remarks')
    allowNull: true
  }
}, {
  timestamps: true,
  alter: true,
  tableName: 'mainpatientadvance',
});

const CompanyAdvance = sequelize.define('CompanyAdvance', {
  date: {
    type: DataTypes.STRING, // Date
  },
  rec_no: {
    type: DataTypes.STRING, // Receipt No.
  },
  clinic_name: {
    type: DataTypes.STRING,
    defaultValue: '1' // Clinic Name
  },
  patient_id: {
    type: DataTypes.STRING,
  },
  patient_name: {
    type: DataTypes.STRING, // Clinic Name
  },
  company_name: {
    type: DataTypes.STRING, // Clinic Name
  },
  amount: {
    type: DataTypes.DECIMAL(10, 2),
    defaultValue: 0.00 // Amount (stored as 'amount')
  },
  consume_amount: {
    type: DataTypes.DECIMAL(10, 2),
    defaultValue: 0.00 // Consume Amount
  },
  refunded_amount: {
    type: DataTypes.DECIMAL(10, 2),
    defaultValue: 0.00
  },
  balance_amount: {
    type: DataTypes.DECIMAL(10, 2), // Balance Amount
  },
  paymentMethod: {
    type: DataTypes.STRING, // Payment Mode (stored as 'paymentMethod')
  },
  referenceNo: {
    type: DataTypes.STRING, // Reference No. (stored as 'referenceNo')
  },
  chequeNo: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  chequeDate: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  bankName: {
    type: DataTypes.STRING, // Bank Name (stored as 'bankName')
  },
  referenceDate: {
    type: DataTypes.STRING, // Reference Date (stored as 'referenceDate')
  },
  bankDetails: {
    type: DataTypes.STRING, // Bank Details (stored as 'bankDetails')
  },
  defaultBankAccount: {
    type: DataTypes.STRING, // Default Bank Account (stored as 'defaultBankAccount')
  },
  ePaymentGatewayName: {
    type: DataTypes.STRING, // E-Payment Gateway Name (stored as 'ePaymentGatewayName')
  },
  ePaymentDetails: {
    type: DataTypes.STRING, // E-payment Details (stored as 'ePaymentDetails')
  },
  cardType: {
    type: DataTypes.STRING, // Card Type (stored as 'cardType')
  },
  cardNo: {
    type: DataTypes.STRING, // Card No. (stored as 'cardNo')
  },
  cardHolderName: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  transactionDate: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  approvalNo: {
    type: DataTypes.STRING, // Approval No. (stored as 'approvalNo')
  },
  printBillOnConfirm: {
    type: DataTypes.BOOLEAN, // Print Bill on Confirm (stored as 'printBillOnConfirm')
  },
  remarks: {
    type: DataTypes.TEXT, // Remarks (stored as 'remarks')
    allowNull: true
  }
}, {
  timestamps: true,
  tableName: 'maincompany_advance',
});




//? TABLE Mapping :---

PR_patientReg.hasOne(KYC, {
  foreignKey: "lead_no",
  sourceKey: "lead_no",
  as: "kycDetails",
});

KYC.belongsTo(PR_patientReg, {
  foreignKey: "lead_no",
  targetKey: "lead_no",
  as: "patient",
});

PR_patientReg.hasMany(PR_BillFindPatient, {
  foreignKey: "mrNo",
  sourceKey: "mr_no",
  as: "billFindPatients",
});

PR_BillFindPatient.belongsTo(PR_patientReg, {
  foreignKey: "mrNo",
  targetKey: "mr_no",
  as: "patient",
});

PR_patientReg.hasMany(PR_BillPharmacy, {
  foreignKey: "mrNo",
  sourceKey: "mr_no",
  as: "billPharmacies",
});

PR_BillPharmacy.belongsTo(PR_patientReg, {
  foreignKey: "mrNo",
  targetKey: "mr_no",
  as: "patient",
});


PR_patientReg.hasMany(CompanyRefund, {
  foreignKey: "patient_id",
  sourceKey: "id",
  as: "companyRefunds",
});

CompanyRefund.belongsTo(PR_patientReg, {
  foreignKey: "patient_id",
  targetKey: "id",
  as: "patient",
});


PR_patientReg.hasMany(PatientRefund, {
  foreignKey: "patient_id",
  sourceKey: "id",
  as: "refunds",
});

PatientRefund.belongsTo(PR_patientReg, {
  foreignKey: "patient_id",
  targetKey: "id",
  as: "patient",
});


PR_patientReg.hasMany(Bifurcation_Stages, {
  foreignKey: "patientId",
  sourceKey: "id",
  as: "bifurcationStages",
});

Bifurcation_Stages.belongsTo(PR_patientReg, {
  foreignKey: "patientId",
  targetKey: "id",
  as: "patient",
});


PR_patientReg.hasMany(PatientCounseling, {
  foreignKey: "patientId",
  sourceKey: "id",
  as: "patientCounseling",
});

PatientCounseling.belongsTo(PR_patientReg, {
  foreignKey: "patientId",
  targetKey: "id",
  as: "patient",
});



PatientCounseling.hasOne(Outcome, {
  foreignKey: "cycleId",
  sourceKey: "cycle_id",
  as: "Outcome", 
});

Outcome.belongsTo(PatientCounseling, {
  foreignKey: "cycleId",
  targetKey: "cycle_id",
  as: "PatientCounseling", 
});



// sequelize.sync()
module.exports = {
  PR_patientReg,
  PR_ReferralDoc,
  PR_Appointment,
  PR_PatientVisit,
  PR_formNewCouple,
  PR_BillFindPatient,
  QRCodeModel,
  BillServices,
  Advance,
  PR_BillPaymentDetails,
  CompanyAdvance,
  PR_BillPharmacy,
  BillItems,
  Patients
};
