const { DataTypes } = require("sequelize");
const { sequelize } = require("../sequelize");

const SupplierCategory = sequelize.define(
  "SupplierCategory",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    description: {
      type: DataTypes.STRING,
    },
    code: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvsuppliercategory",
  }
);
// SupplierCategory.sync({alter:true})
const StoreDetails = sequelize.define(
  "StoreDetails",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    clinic: {
      type: DataTypes.STRING,
    },
    parent_store: {
      type: DataTypes.STRING,
    },
    cost_center_code: {
      type: DataTypes.STRING,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    apply_all_items: {
      type: DataTypes.STRING,
    },
    apply_to_category: {
      type: DataTypes.STRING,
    },
    is_quarantine_store: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    timestamps: true,
    tableName: "adminvstore",
    alert: true,
  }
);
// StoreDetails.sync({alter:true})

const TaxCategory = sequelize.define(
  "TaxCategory",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    tax_desc: {
      type: DataTypes.STRING,
    },
    tax_code: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvtaxcategory",
  }
);
// TaxCategory.sync({alter:true})

const ItemMove = sequelize.define(
  "ItemMove",
  {
    item_desc: {
      type: DataTypes.STRING,
    },
    item_code: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvitemmove",
  }
);
const CurrencyMaster = sequelize.define(
  "CurrencyMaster",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    currency_desc: {
      type: DataTypes.STRING,
    },
    currency_code: {
      type: DataTypes.STRING,
    },
    currency_symbol: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvcurrencymaster",
  }
);
// CurrencyMaster.sync({alter:true})

const RackMaster = sequelize.define(
  "RackMaster",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    rank_desc: {
      type: DataTypes.STRING,
    },
    rank_code: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvrackmaster",
  }
);
// RackMaster.sync({alter:true})

const ItemLocation = sequelize.define(
  "itemlocation",
  {
    itemCode: {
      type: DataTypes.STRING,
    },
    store: {
      type: DataTypes.STRING,
    },
    rack: {
      type: DataTypes.STRING,
    },
    shelf: {
      type: DataTypes.STRING,
    },
    bin: {
      type: DataTypes.STRING,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvitemlocation",
  }
);
const ItemConv = sequelize.define(
  "itemConv",
  {
    itemCode: {
      type: DataTypes.STRING,
    },
    from_uom: {
      type: DataTypes.STRING,
    },
    to_uom: {
      type: DataTypes.STRING,
    },
    conversion_factor: {
      type: DataTypes.INTEGER,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvitemconv",
  }
);
const BinMaster = sequelize.define(
  "BinMaster",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    bin_desc: {
      type: DataTypes.STRING,
    },
    bin_code: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvbinmaster",
  }
);

// BinMaster.sync({alter:true})
const ShelfMaster = sequelize.define(
  "ShelfMaster",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    shelf_desc: {
      type: DataTypes.STRING,
    },
    shelf_code: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvshelfmaster",
  }
);
// ShelfMaster.sync({alter:true})

const PackageMembership = sequelize.define(
  "PackageMembership",
  {
    packageCode: {
      type: DataTypes.STRING,
    },
    packageName: {
      type: DataTypes.STRING,
    },
    packageRate: {
      type: DataTypes.INTEGER,
    },
    packageEffectiveDate: {
      type: DataTypes.DATE,
    },
    packageExpiryDate: {
      type: DataTypes.DATE,
    },
    specialization: {
      type: DataTypes.STRING,
    },
    subSpecialization: {
      type: DataTypes.STRING,
    },
    shortDescription: {
      type: DataTypes.TEXT,
    },
    longDescription: {
      type: DataTypes.TEXT,
    },
    serviceTax: {
      type: DataTypes.STRING,
    },
    service_tax_percentage: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    service_tax_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staffDiscount: {
      type: DataTypes.STRING,
    },
    staff_discount_percentage: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staff_discount_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staffParentDiscount: {
      type: DataTypes.STRING,
    },
    staff_parent_discount_percentage: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    staff_parent_discount_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    concession: {
      type: DataTypes.STRING,
    },
    concession_percentage: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    concession_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    outsource_test_checkbox: {
      type: DataTypes.STRING,
    },
    outsource_test_percentage: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    outsource_test_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    consultant_rate_checkbox: {
      type: DataTypes.STRING,
    },
    consultant_rate_percentage: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    consultant_rate_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    hospital_rate_checkbox: {
      type: DataTypes.STRING,
    },
    hospital_rate_percentage: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    hospital_rate_amount: {
      type: DataTypes.STRING,
      defaultValue: "0",
    },
    family: {
      type: DataTypes.STRING,
    },
    count: {
      type: DataTypes.INTEGER,
    },
    applicableMemberRelations: {
      type: DataTypes.STRING,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvpackagemembership",
  }
);

const ItemMasterNew = sequelize.define(
  "ItemMaster",
  {
    item_code: {
      type: DataTypes.STRING,
    },
    brand_name: {
      type: DataTypes.STRING,
    },
    item_name: {
      type: DataTypes.STRING,
    },
    item_group: {
      type: DataTypes.STRING,
    },
    dispensing_type: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    pregnancy_class: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    manufactured_by: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    purchase_uom: {
      type: DataTypes.STRING,
    },
    base_uom: {
      type: DataTypes.STRING,
    },
    conversion_factor: {
      type: DataTypes.INTEGER,
    },
    base_unit_mrp: {
      type: DataTypes.FLOAT,
    },
    discount_on_sale: {
      type: DataTypes.STRING,
    },
    AnalysisRequired: {
      type: DataTypes.STRING,
    },
    expiry_alert_before_in_days: {
      type: DataTypes.STRING,
    },
    hsn_code: {
      type: DataTypes.STRING,
    },
    gst: {
      type: DataTypes.FLOAT,
    },
    walk_in_patients_discount_on_sale: {
      type: DataTypes.STRING,
    },
    staff_discount_on_sale: {
      type: DataTypes.STRING,
    },
    registered_patients_discount_on_sale: {
      type: DataTypes.STRING,
    },
    strength: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    strength_unit: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    molecule_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    item_category: {
      type: DataTypes.STRING,
    },
    storage_type: {
      type: DataTypes.STRING,
    },
    storage_degree: {
      type: DataTypes.STRING,
    },
    therapeutic_class: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    stocking_uom: {
      type: DataTypes.STRING,
    },
    selling_uom: {
      type: DataTypes.STRING,
    },
    base_unit_cost_price: {
      type: DataTypes.FLOAT,
    },
    route: {
      type: DataTypes.STRING,
    },
    batchesRequired: {
      type: DataTypes.STRING,
    },
    batchesRequired: {
      type: DataTypes.STRING,
    },
    suspend: {
      type: DataTypes.BOOLEAN,
    },
    isStimulation: {
      type: DataTypes.BOOLEAN,
      defaultValue: false,
    },
    isDrug:{
      type:DataTypes.STRING,
    },
    createdBy: { type: DataTypes.STRING },
    updatedBy: { type: DataTypes.STRING },
    status: { type: DataTypes.BOOLEAN },
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvitemmaster",
  }
);
// ItemMasterNew.sync({ alter: true });

const ItemCategoryNew = sequelize.define(
  "ItemCategoryNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    Item_code: {
      type: DataTypes.STRING,
    },
    Item_description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvitem_categories",
  }
);
// ItemCategoryNew.sync({alter:true})
const ItemGroupNew = sequelize.define(
  "ItemCategory",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    general_ledger: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvitem_groups",
    timestamps: true,
  }
);
ItemGroupNew.sync({ alter: true });

const StorageTypeNew = sequelize.define(
  "StorageType",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvstorage_types",
    timestamps: true,
  }
);
// StorageTypeNew.sync({alter:true})
const DispensingTypeNew = sequelize.define(
  "DispensingTypeNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvdispensing_type",
    timestamps: true,
  }
);
// DispensingTypeNew.sync({alter:true})
const MoleculeNew = sequelize.define(
  "MoleculeNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvmolecule",
    timestamps: true,
  }
);
// MoleculeNew.sync({alter:true})
const PregnancyClassNew = sequelize.define(
  "PregnancyClassNew",
  {
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "admnvpregnancy_class",
    timestamps: true,
  }
);
const ItemCompanyNew = sequelize.define(
  "ItemCompanyNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvitem_company",
    timestamps: true,
  }
);
// ItemCompanyNew.sync({alter:true})
const TherapeuticClassNew = sequelize.define(
  "TherapeuticClassNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvtherapeuticclass",
    timestamps: true,
  }
);
// TherapeuticClassNew.sync({alter:true})

const UnitOfMeasurementNew = sequelize.define(
  "UnitOfMeasurementNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvunitofmeasurement",
    timestamps: true,
  }
);
// UnitOfMeasurementNew.sync({alter:true})
const TearmAndConditionNew = sequelize.define(
  "TearmAndConditionNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvtearmandcondition",
    timestamps: true,
  }
);
// TearmAndConditionNew.sync({alter:true})
const ItemStoreMinMax = sequelize.define(
  "ItemStoreMinMax",
  {
    itemCode: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    clinic: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    store_id: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    store_name: {
      type: DataTypes.STRING,
      allowNull: true,
    },
    min: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    max: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    reorder: {
      type: DataTypes.INTEGER,
      allowNull: true,
    },
    isSelected: {
      type: DataTypes.BOOLEAN,
      allowNull: true,
    },
  },
  {
    tableName: "adminvitemstoreminmax",
    timestamps: true, // Set to true if you want createdAt and updatedAt
    hooks: {
      beforeCreate: (record) => {
        if (record.min === "") record.min = null;
        if (record.max === "") record.max = null;
        if (record.reorder === "") record.reorder = null;
      },
      beforeUpdate: (record) => {
        if (record.min === "") record.min = null;
        if (record.max === "") record.max = null;
        if (record.reorder === "") record.reorder = null;
      },
    },
  }
);

const ItemStoreTax = sequelize.define(
  "ItemStoreTax",
  {
    itemCode: {
      type: DataTypes.STRING,
    },
    clinic: {
      type: DataTypes.STRING,
    },
    store: {
      type: DataTypes.STRING,
    },
    CGST: {
      type: DataTypes.FLOAT,
    },
    SGST: {
      type: DataTypes.FLOAT,
    },
    IGST: {
      type: DataTypes.FLOAT,
    },
    applicable_for: {
      type: DataTypes.STRING,
    },
    applicable_on: {
      type: DataTypes.STRING,
    },

    taxType: {
      type: DataTypes.STRING,
    },
  },
  {
    alert: true,
    tableName: "adminvitemstoretax",
    timestamps: true,
  }
);
const ItemOtherDetails = sequelize.define(
  "ItemOtherDetails",
  {
    itemCode: {
      type: DataTypes.STRING,
    },
    contra_indication: {
      type: DataTypes.TEXT,
    },
    side_effects: {
      type: DataTypes.TEXT,
    },
    help_url: {
      type: DataTypes.TEXT,
    },
  },
  {
    alert: true,
    tableName: "adminvitemotherdetails",
    timestamps: true,
  }
);

const ItemSupplier = sequelize.define(
  "ItemSupplier",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    itemCode: {
      type: DataTypes.STRING,
    },
    supplierCode: {
      type: DataTypes.STRING,
    },
  },
  {
    tableName: "adminvitemsupplier",
    timestamps: true,
  }
);

const Supplier = sequelize.define(
  "Supplier",
  {
    code: {
      type: DataTypes.STRING,
    },
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    description: {
      type: DataTypes.STRING,
    },
    country: {
      type: DataTypes.STRING,
    },
    state: {
      type: DataTypes.STRING,
    },
    city: {
      type: DataTypes.STRING,
    },
    area: {
      type: DataTypes.STRING,
    },
    pin_code: {
      type: DataTypes.STRING,
    },
    supplier_category: {
      type: DataTypes.STRING,
    },
    address_line_1: {
      type: DataTypes.TEXT,
    },
    address_line_2: {
      type: DataTypes.TEXT,
    },
    address_line_3: {
      type: DataTypes.TEXT,
    },
    depreciation: {
      type: DataTypes.STRING,
    },
    rating: {
      type: DataTypes.STRING,
    },
    po_auto_close_days: {
      type: DataTypes.STRING,
    },
    contact_person_1_name: {
      type: DataTypes.STRING,
    },
    contact_person_1_mobile_no: {
      type: DataTypes.STRING,
    },
    contact_person_1_email: {
      type: DataTypes.STRING,
    },
    contact_person_1_phone_no: {
      type: DataTypes.STRING,
    },
    contact_person_1_fax: {
      type: DataTypes.STRING,
    },
    contact_person_2_name: {
      type: DataTypes.STRING,
    },
    contact_person_2_mobile_no: {
      type: DataTypes.STRING,
    },
    contact_person_2_email: {
      type: DataTypes.STRING,
    },
    contact_person_2_phone_no: {
      type: DataTypes.STRING,
    },
    contact_person_2_fax: {
      type: DataTypes.STRING,
    },
    mode_of_payment: {
      type: DataTypes.STRING,
    },
    terms_of_payment: {
      type: DataTypes.STRING,
    },
    tax_nature: {
      type: DataTypes.STRING,
    },
    currency: {
      type: DataTypes.STRING,
    },
    msme_number: {
      type: DataTypes.STRING,
    },
    cst_number: {
      type: DataTypes.STRING,
    },
    vat_number: {
      type: DataTypes.STRING,
    },
    gstin_number: {
      type: DataTypes.STRING,
    },
    drug_licence_form_20: {
      type: DataTypes.STRING,
    },
    drug_licence_form_21: {
      type: DataTypes.STRING,
    },
    drug_licence_validity: {
      type: DataTypes.STRING,
    },
    pan_number: {
      type: DataTypes.STRING,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    timestamps: true,
    tableName: "adminvsupplier",
  }
);
// Supplier.sync({alter:true})
const RateContract = sequelize.define(
  "RateContract",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
    },
    description: {
      type: DataTypes.STRING,
    },
    contractStartDate: {
      type: DataTypes.DATEONLY,
    },
    contractEndDate: {
      type: DataTypes.DATEONLY,
    },
    contractDate: {
      type: DataTypes.DATEONLY,
    },
    supplier: {
      type: DataTypes.STRING,
    },
    clinicRepresentative: {
      type: DataTypes.STRING,
    },
    remark: {
      type: DataTypes.STRING,
    },
    net_amount: {
      type: DataTypes.DECIMAL(10, 2),
    },
    item_code: {
      type: DataTypes.STRING,
    },
    item_name: {
      type: DataTypes.STRING,
    },
    manufactured_by: {
      type: DataTypes.STRING,
    },
    purchase_quantity: {
      type: DataTypes.INTEGER,
    },
    transaction_uom: {
      type: DataTypes.STRING,
    },
    purchase_cost_price: {
      type: DataTypes.DECIMAL(10, 2),
    },
    cost_amount: {
      type: DataTypes.DECIMAL(10, 2),
    },
    mrp: {
      type: DataTypes.DECIMAL(10, 2),
    },
    amount: {
      type: DataTypes.DECIMAL(10, 2),
    },
    discount_percent: {
      type: DataTypes.DECIMAL(5, 2),
    },
    discount_amount: {
      type: DataTypes.DECIMAL(10, 2),
    },
    net_amount_item: {
      type: DataTypes.DECIMAL(10, 2),
    },
    hsn_code: {
      type: DataTypes.STRING,
    },
    remarks_item: {
      type: DataTypes.STRING,
    },
  },
  {
    timestamps: true,
    tableName: "adminvrate_contracts",
  }
);
// RateContract.sync({alter:true})
const StrUnitMasterNew = sequelize.define(
  "StrUnitMaster",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvstrength_unit_master",
    timestamps: true,
  }
);
// StrUnitMasterNew.sync({alter:true})

const WorkOrderItemNew = sequelize.define(
  "WorkOrderItemNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "admnvwork_order_item",
    timestamps: true,
  }
);
// WorkOrderItemNew.sync({alter:true})
const CostCenterCodeNew = sequelize.define(
  "CostCenterCodeNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvcost_center_code",
    timestamps: true,
  }
);
// CostCenterCodeNew.sync({alter:true})
const HSNCodeNew = sequelize.define(
  "HSNCodeNew",
  {
    clinic_id: {
      type: DataTypes.INTEGER,
      defaultValue: 0,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  {
    alert: true,
    tableName: "adminvhsn_code_master",
    timestamps: true,
  }
);

// HSNCodeNew.sync({alter:true})
// sequelize.sync();

// CRYO MASTER

const CryoIncubator = sequelize.define(
  "CryoIncubator",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  { alert: true, tableName: "adminv_cryo_incubator", timestamps: true }
);
CryoIncubator.sync({ alter: true });

const CryoTank = sequelize.define(
  "CryoTank",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  { alert: true, tableName: "adminv_cryo_tank", timestamps: true }
);
CryoTank.sync({ alter: true });

const CryoCanister = sequelize.define(
  "CryoCanister",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  { alert: true, tableName: "adminv_cryo_canister", timestamps: true }
);
CryoCanister.sync({ alter: true });

const CryoGoble = sequelize.define(
  "CryoGoble",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  { alert: true, tableName: "adminv_cryo_goble", timestamps: true }
);
CryoGoble.sync({ alter: true });

const CryoHexatube = sequelize.define(
  "CryoHexatube",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  { alert: true, tableName: "adminv_cryo_hexatube", timestamps: true }
);
CryoHexatube.sync({ alter: true });

const CryoVisotube = sequelize.define(
  "CryoVisotube",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  { alert: true, tableName: "adminv_cryo_visotube", timestamps: true }
);
CryoVisotube.sync({ alter: true });

const CryoCryotop = sequelize.define(
  "CryoCryotop",
  {
    id: {
      type: DataTypes.INTEGER,
      autoIncrement: true,
      primaryKey: true,
    },
    code: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    description: {
      type: DataTypes.STRING,
      allowNull: false,
    },
    status: {
      type: DataTypes.BOOLEAN,
      defaultValue: true,
    },
  },
  { alert: true, tableName: "adminv_cryo_cryotop", timestamps: true }
);
CryoCryotop.sync({ alter: true });

module.exports = {
  SupplierCategory,
  Supplier,
  StoreDetails,
  TaxCategory,
  ItemMove,
  CurrencyMaster,
  RackMaster,
  BinMaster,
  ShelfMaster,
  PackageMembership,
  ItemMasterNew,
  ItemGroupNew,
  StorageTypeNew,
  DispensingTypeNew,
  MoleculeNew,
  PregnancyClassNew,
  ItemCompanyNew,
  TherapeuticClassNew,
  UnitOfMeasurementNew,
  TearmAndConditionNew,
  ItemLocation,
  ItemConv,
  ItemStoreMinMax,
  ItemStoreTax,
  ItemOtherDetails,
  ItemSupplier,
  ItemCategoryNew,
  RateContract,
  StrUnitMasterNew,
  WorkOrderItemNew,
  CostCenterCodeNew,
  HSNCodeNew,
  CryoIncubator,
  CryoTank,
  CryoCanister,
  CryoGoble,
  CryoHexatube,
  CryoVisotube,
  CryoCryotop,
};
