const { DataTypes } = require('sequelize');
const {sequelize} = require('../sequelize');


const expensedetails = sequelize.define('expensedetails', {
  userId: {
    type: DataTypes.INTEGER,
  },
  clinic_id: {
    type: DataTypes.INTEGER,
    defaultValue: 0
  },
  clinic: {
    type: DataTypes.STRING
  },
  expenseAgainst: {
    type: DataTypes.STRING
  },
  voucherNo: {
    type: DataTypes.STRING
  },
  voucherDate: {
    type: DataTypes.STRING
  },
  amount: {
    type: DataTypes.STRING
  },
  voucherCreatedBy: {
    type: DataTypes.STRING
  },
  remarks: {
    type: DataTypes.STRING,
  },
  isFreezeExpenses: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  },
  status: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  }
}, {
  alert: true,
  tableName: 'MainBillExpenseDetails',
  timestamps: true
});


// const advance = sequelize.define('advance', {
//     userId: {
//         type: DataTypes.INTEGER,
//     },
//     clinic_id: {
//         type: DataTypes.INTEGER,
//         defaultValue: 0
//     },
//     advanceType: {
//         type: DataTypes.STRING,
//     },
//     company: {
//         type: DataTypes.STRING,
//     },
//     advanceAgainst: {
//         type: DataTypes.STRING,
//     },
//     amount: {
//         type: DataTypes.INTEGER,
//     },
//     remarks: {
//         type: DataTypes.STRING,
//     },
//     package_bill_freeze: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     }
// }, {
//     alert: true,
//     tableName: 'mainAdvance',
//     timestamps: true // This will add createdAt and updatedAt fields
// });


const CompanyRefund = sequelize.define('refund', {
  userId: {
    type: DataTypes.INTEGER,
    defaultValue:1
  },
  clinic_name: {
    type: DataTypes.STRING,
    defaultValue:1
  },
  patient_id: {
    type: DataTypes.STRING,
    defaultValue:1
  },
  rec_no: {
    type: DataTypes.STRING,
    defaultValue:1
  },
  refund_date: {
    type: DataTypes.DATE
  },
  Adv_recipt_no:{
    type: DataTypes.STRING,
    defaultValue:""
  },
  refundAmount: {
    type: DataTypes.DECIMAL
  },
  totalAdvance: {
    type: DataTypes.DECIMAL
  },
  advanceConsumed: {
    type: DataTypes.DECIMAL
  },
  totalRefund: {
    type: DataTypes.DECIMAL
  },
  advanceAvailable: {
    type: DataTypes.DECIMAL
  },
  remarks: {
    type: DataTypes.STRING,
  },
  isApprove:{
    type:DataTypes.BOOLEAN,
    defaultValue:false
  },
  freeze:{
    type:DataTypes.BOOLEAN,
    defaultValue:false
  }

}, {
  timestamps: true,
  alter:true,
  tableName: 'mainCompanyRefunds',
});


const concent = sequelize.define('concent', {
  userId: {
    type: DataTypes.INTEGER,
  },
  clinic_id: {
    type: DataTypes.INTEGER,
    defaultValue: 0
  },
  Cname: {
    type: DataTypes.STRING(255),
    allowNull: false
  },
  Cfile: {
    type: DataTypes.STRING(255),
    allowNull: false
  },
  Cstatus: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  },
  Csection: {
    type: DataTypes.STRING(50),
    allowNull: false
  }
}, {
  alert: true,
  tableName: 'concent',
  timestamps: true, // Automatically adds createdAt and updatedAt fields
});



const ServiceMasterSchema = sequelize.define('tbl_service_master', {
  serviceCode: {
    type: DataTypes.STRING,
    allowNull: false,
    unique: true
  },
  codeType: {
    type: DataTypes.STRING,
    allowNull: false
  },
  codeDetails: {
    type: DataTypes.STRING,
    allowNull: true
  },
  specialization: {
    type: DataTypes.STRING,
    allowNull: true
  },
  subSpecialization: {
    type: DataTypes.STRING,
    allowNull: true
  },
  sacCode: {
    type: DataTypes.STRING,
    allowNull: true
  },
  shortDescription: {
    type: DataTypes.STRING,
    allowNull: true
  },
  longDescription: {
    type: DataTypes.STRING,
    allowNull: true
  },
  serviceName: {
    type: DataTypes.STRING,
    allowNull: false
  },
  baseServiceRate: {
    type: DataTypes.STRING,
    allowNull: false
  },
  inHouse: {
    type: DataTypes.STRING,
  },
  inHouse_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  inHouse_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  service_tax: {
    type: DataTypes.STRING,
  },
  service_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  service_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  staffDiscount: {
    type: DataTypes.STRING,
  },
  staffDiscount_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  staffDiscount_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  staffParentAccount: {
    type: DataTypes.STRING,
  },
  staffParent_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  staffParent_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  concession: {
    type: DataTypes.STRING,
  },
  concession_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  concession_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  doctor: {
    type: DataTypes.STRING,
  },
  doctor_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  doctor_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  rateEditable: {
    type: DataTypes.STRING,
  },
  rateEditable_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  rateEditable_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  S_Citizen_Con: {
    type: DataTypes.STRING,
  },
  S_Citizen_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  S_Citizen_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  luxuryTax: {
    type: DataTypes.STRING,
  },
  luxuryTax_per: {
    type: DataTypes.STRING,
    allowNull: true
  },
  luxuryTax_amount: {
    type: DataTypes.STRING,
    allowNull: true
  },
  className: {
    type: DataTypes.STRING,
    allowNull: false
  },
  className_rate: {
    type: DataTypes.STRING,
    allowNull: false
  },
  status: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  }
}
  , {
    timestamps: false,
    tableName: 'services'
  });

// const Bill = sequelize.define('Bill', {
//     clinic_id: {
//         type: DataTypes.INTEGER,
//         defaultValue: 1
//     },
//     clinical_bill: {
//         type: DataTypes.STRING,

//     },
//     total_net_amount: {
//         type: DataTypes.DECIMAL
//     },
//     pay_amount: {
//         type: DataTypes.DECIMAL
//     },
//     advance: {
//         type: DataTypes.DECIMAL
//     },
//     remark: {
//         type: DataTypes.STRING,

//     },
//     concession_reason: {
//         type: DataTypes.STRING,

//     },
//     freeze_bill: {
//         type: DataTypes.BOOLEAN,
//         defaultValue: false
//     },
//     against: {
//         type: DataTypes.STRING
//     },
//     option: {
//         type: DataTypes.STRING
//     }
// }, {
//     timestamps: true // Adds createdAt and updatedAt columns
// });


const Advance = sequelize.define('PatientAdvance', {
  date: {
    type: DataTypes.STRING, // Date
  },
  rec_no: {
    type: DataTypes.STRING, // Receipt No.
  },
  clinic_name: {
    type: DataTypes.STRING,
    defaultValue:'1' // Clinic Name
  },
  patient_id: {
    type: DataTypes.STRING, // Clinic Name
  },
  amount: {
    type: DataTypes.DECIMAL(10, 2), // Amount (stored as 'amount')
  },
  consume_amount: {
    type: DataTypes.DECIMAL(10, 2), // Consume Amount
  },
  balance_amount: {
    type: DataTypes.DECIMAL(10, 2), // Balance Amount
  },
  paymentMethod: {
    type: DataTypes.STRING, // Payment Mode (stored as 'paymentMethod')
  },
  referenceNo: {
    type: DataTypes.STRING, // Reference No. (stored as 'referenceNo')
  },
  chequeNo: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  chequeDate: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  bankName: {
    type: DataTypes.STRING, // Bank Name (stored as 'bankName')
  },
  referenceDate: {
    type: DataTypes.STRING, // Reference Date (stored as 'referenceDate')
  },
  bankDetails: {
    type: DataTypes.STRING, // Bank Details (stored as 'bankDetails')
  },
  defaultBankAccount: {
    type: DataTypes.STRING, // Default Bank Account (stored as 'defaultBankAccount')
  },
  ePaymentGatewayName: {
    type: DataTypes.STRING, // E-Payment Gateway Name (stored as 'ePaymentGatewayName')
  },
  ePaymentDetails: {
    type: DataTypes.STRING, // E-payment Details (stored as 'ePaymentDetails')
  },
  cardType: {
    type: DataTypes.STRING, // Card Type (stored as 'cardType')
  },
  cardNo: {
    type: DataTypes.STRING, // Card No. (stored as 'cardNo')
  },
  cardHolderName: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  transactionDate: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  approvalNo: {
    type: DataTypes.STRING, // Approval No. (stored as 'approvalNo')
  },
  printBillOnConfirm: {
    type: DataTypes.BOOLEAN, // Print Bill on Confirm (stored as 'printBillOnConfirm')
  },
  remarks: {
    type: DataTypes.TEXT, // Remarks (stored as 'remarks')
    allowNull: true
  }
}, {
  timestamps: true,
  alter: true,
  tableName: 'mainpatientadvance',
});


  
const CompanyAdvance = sequelize.define('CompanyAdvance', {
  date: {
    type: DataTypes.STRING, // Date
  },
  rec_no: {
    type: DataTypes.STRING, // Receipt No.
  },
  clinic_name: {
    type: DataTypes.STRING,
    defaultValue:'1' // Clinic Name
  },
  patient_id: {
    type: DataTypes.STRING, // Clinic Name
  },
  patient_name: {
    type: DataTypes.STRING, // Clinic Name
  },
  company_name: {
    type: DataTypes.STRING, // Clinic Name
  },
  amount: {
    type: DataTypes.DECIMAL(10, 2), // Amount (stored as 'amount')
  },
  consume_amount: {
    type: DataTypes.DECIMAL(10, 2), // Consume Amount
  },
  balance_amount: {
    type: DataTypes.DECIMAL(10, 2), // Balance Amount
  },
  paymentMethod: {
    type: DataTypes.STRING, // Payment Mode (stored as 'paymentMethod')
  },
  referenceNo: {
    type: DataTypes.STRING, // Reference No. (stored as 'referenceNo')
  },
  chequeNo: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  chequeDate: {
    type: DataTypes.STRING, // Cheque No. (stored as 'chequeNo')
  },
  bankName: {
    type: DataTypes.STRING, // Bank Name (stored as 'bankName')
  },
  referenceDate: {
    type: DataTypes.STRING, // Reference Date (stored as 'referenceDate')
  },
  bankDetails: {
    type: DataTypes.STRING, // Bank Details (stored as 'bankDetails')
  },
  defaultBankAccount: {
    type: DataTypes.STRING, // Default Bank Account (stored as 'defaultBankAccount')
  },
  ePaymentGatewayName: {
    type: DataTypes.STRING, // E-Payment Gateway Name (stored as 'ePaymentGatewayName')
  },
  ePaymentDetails: {
    type: DataTypes.STRING, // E-payment Details (stored as 'ePaymentDetails')
  },
  cardType: {
    type: DataTypes.STRING, // Card Type (stored as 'cardType')
  },
  cardNo: {
    type: DataTypes.STRING, // Card No. (stored as 'cardNo')
  },
  cardHolderName: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  transactionDate: {
    type: DataTypes.STRING, // Card Holder Name (stored as 'cardHolderName')
  },
  approvalNo: {
    type: DataTypes.STRING, // Approval No. (stored as 'approvalNo')
  },
  printBillOnConfirm: {
    type: DataTypes.BOOLEAN, // Print Bill on Confirm (stored as 'printBillOnConfirm')
  },
  remarks: {
    type: DataTypes.TEXT, // Remarks (stored as 'remarks')
    allowNull: true
  }
}, {
  timestamps: true,
  tableName: 'maincompany_advance',
});



 







const PatientRefund = sequelize.define('PatientRefund', {
  userId: {
    type: DataTypes.INTEGER,
    defaultValue:1
  },
  clinic_name: {
    type: DataTypes.INTEGER,
    defaultValue: 1
  },
  patient_id: {
    type: DataTypes.INTEGER,
  },
  rec_no: {
    type: DataTypes.STRING,
  },
  date: {
    type: DataTypes.STRING,
  },
  Advance_receipt_no: {
    type: DataTypes.STRING,
    defaultValue:""
  },
  refundAmount: {
    type: DataTypes.DECIMAL
  },
  totalAdvance: {
    type: DataTypes.DECIMAL
  },
  advanceConsumed: {
    type: DataTypes.DECIMAL
  },
  totalRefund: {
    type: DataTypes.DECIMAL
  },
  advanceAvailable: {
    type: DataTypes.DECIMAL
  },
  remarks: {
    type: DataTypes.STRING,
    allowNull: true
  },
  isApprove:{
    type:DataTypes.BOOLEAN,
    defaultValue:false
  },
  freeze:{
    type:DataTypes.BOOLEAN,
    defaultValue:false
  }
}, {
  tableName: 'mainPatientRefund',
  alter:true,
  timestamps: true,
});

const BillServiceApproval = sequelize.define('BillApproval', {
  billId: {
    type: DataTypes.INTEGER,
    allowNull: false
  },
  billNo: {
    type: DataTypes.STRING,
    allowNull: false
  },
  serviceId: {
    type: DataTypes.JSON, // Store service IDs as JSON array
    allowNull: false
  },
  serviceCode: {
    type: DataTypes.JSON, // Store service codes as JSON array
    allowNull: false
  },
  refundAmount: {
    type: DataTypes.JSON,
    allowNull: false
  },
  remark: {
    type: DataTypes.TEXT,
    allowNull: true
  },
  refDate: {
    type: DataTypes.DATE,
    allowNull: true // Ensure this matches your requirements
  },
  approveRemark: {
    type: DataTypes.STRING,
    allowNull: true // Ensure this matches your requirements
  },
  approvedBy: {
    type: DataTypes.STRING,
    allowNull: true // Ensure this matches your requirements
  },
  approvalDate: {
    type: DataTypes.DATE,
    allowNull: true
  },
  Approve: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  },
  freeze: {
    type: DataTypes.BOOLEAN,
    defaultValue: false
  },
}, {
  tableName: 'PR_billServiceApprovals',
  timestamps: true, // For createdAt and updatedAt fields
});

const PatientAssignPackage = sequelize.define('PatientAssignPackage', {
  packageId: {
    type: DataTypes.INTEGER,
 
  },
  mrNo:{
    type: DataTypes.STRING,
    allowNull: false
  },
  packageName: {
    type: DataTypes.STRING,
    allowNull: false
  },
  packageCost: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false
  },
  advanceAmt: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: false
  },
  consumedAmt: {
    type: DataTypes.DECIMAL(10, 2),
    allowNull: true
  },
  serviceComponent: {
    type: DataTypes.JSON,
    allowNull: true
  },
  pharmacyComponent: {
    type: DataTypes.JSON,
    allowNull: true
  }
}, {
  timestamps: true, // Adds createdAt and updatedAt fields
  tableName: 'patientassignpackage' // Customize table name
});

module.exports = {
  expensedetails,
  Advance,
  CompanyRefund,
  concent,
  
  ServiceMasterSchema,
  PatientRefund,
  
  CompanyAdvance,
  BillServiceApproval,
  PatientAssignPackage
}