const { DataTypes } = require("sequelize");
const { sequelize } = require("../sequelize");

const ConsentPatientUser = sequelize.define("ConcentPatientUserTable", {
  id: {
    type: DataTypes.UUID,
    primaryKey: true,
    defaultValue: DataTypes.UUIDV4,
    unique: true,
  },
  patientID: {
    type: DataTypes.INTEGER,
    allowNull: false,
  },
  patientMr_num: {
    type: DataTypes.STRING,
    // allowNull: false,
  },
  patientName: {
    type: DataTypes.STRING,
    // allowNull: false,
  },
  formNames: {
    type: DataTypes.JSON,
  },
  status: {
    type: DataTypes.BOOLEAN,
    defaultValue: true,
    allowNull: false,
  },
});

ConsentPatientUser.sync({ alter: true });

module.exports = { ConsentPatientUser };
