const { DataTypes } = require('sequelize');
const { sequelize } = require("../sequelize"); 

const OutboundCall = sequelize.define('OutboundCall', {
    id: {
        type: DataTypes.UUID,
        primaryKey: true,
        defaultValue: DataTypes.UUIDV4,
    },
    assistantId: {
        type: DataTypes.UUID,
        allowNull: true,
    },
    phoneNumberId: {
        type: DataTypes.UUID,
        allowNull: true,
    },
    type: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    createdAt: {
        type: DataTypes.DATE,
        allowNull: true,
        defaultValue: DataTypes.NOW,
    },
    updatedAt: {
        type: DataTypes.DATE,
        allowNull: true,
        defaultValue: DataTypes.NOW,
    },
    orgId: {
        type: DataTypes.UUID,
        allowNull: true,
    },
    cost: {
        type: DataTypes.FLOAT,
        allowNull: true,
        defaultValue: 0,
    },
    customerNumber: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    status: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    phoneCallProvider: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    phoneCallProviderId: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    phoneCallTransport: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    listenUrl: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    controlUrl: {
        type: DataTypes.STRING,
        allowNull: true,
    },
}, {
    tableName: 'outbound_calls',
    timestamps: true,
});

module.exports = OutboundCall;
