const { DataTypes } = require("sequelize");
const { sequelize } = require("../sequelize"); 


const LeadZapier = sequelize.define("LeadZapier", {
    id: {
        type: DataTypes.INTEGER,
        primaryKey: true,
        autoIncrement: true,
    },
    name: { type: DataTypes.STRING, allowNull: false },
    email: { type: DataTypes.STRING, allowNull: false },
    phone: { type: DataTypes.STRING, allowNull: false, },
    utm_source: { type: DataTypes.STRING,  defaultValue: "N/A" },
    utm_medium: { type: DataTypes.STRING, defaultValue: "N/A" },
    utm_term: { type: DataTypes.STRING , defaultValue: "N/A"},
    utm_content: { type: DataTypes.STRING, defaultValue: "N/A" },
    utm_campaign: { type: DataTypes.STRING, defaultValue: "N/A" },
    source: { type: DataTypes.STRING, defaultValue: "N/A" }, // ✅ Final detected source
    extra_data: { type: DataTypes.JSON },
});

//sequelize.sync(); // Sync database

module.exports = LeadZapier;