function loadDropdown(dropdownId, url, callback) {
  const $dropdown = $(`#${dropdownId}`);
  $dropdown.empty().append("<option value=''>Select</option>");

  fetch(url)
    .then((response) => response.json())
    .then((data) => {
      data.forEach((item) => {
        $dropdown.append(callback(item));
      });
    })
    .catch((error) => console.error("Error fetching data:", error));
}

function loadDropdownsByClass(className, url, callback) {
  const $dropdowns = $(`.${className}`);

  // Fetch data from the API
  fetch(url)
    .then((response) => response.json())
    .then((data) => {
      $dropdowns.each(function () {
        const $dropdown = $(this);
        $dropdown.empty().append("<option value=''>Select</option>"); // Clear & add default option

        let optionsHTML = "";
        data.forEach((item) => {
          optionsHTML += callback(item); // Build the options as a string
        });

        $dropdown.append(optionsHTML); // Append all at once (better performance)
      });
    })
    .catch((error) => console.error("Error fetching data:", error));
}
