function myAjax(formData, errorDivId, url, loadingDiv) {
  // Show loading indicator
  $(loadingDiv).show();

  return new Promise((resolve, reject) => {
    $.ajax({
      url: url,
      type: "POST",
      contentType: "application/json",
      data: JSON.stringify(formData),
      beforeSend: function () {
        // Show loading spinner or text
        $(loadingDiv).text("Loading...").show();
      },
      success: function (response) {
        // Hide loading indicator on success
        $(loadingDiv).hide();
        $("#sucs1").modal("show");
        $(errorDivId)
          .removeClass("alert-danger")
          .addClass("alert-success")
          .text("Form submitted successfully!")
          .show();
        console.log("abc:", response);
        resolve(response); // Resolve the promise with the response
      },
      error: function (xhr, status, error) {
        // Hide loading indicator on error
        $(loadingDiv).hide();
        alert("Error in saving form");
        const response = JSON.parse(xhr.responseText);
        $(errorDivId)
          .removeClass("alert-success")
          .addClass("alert-danger")
          .text(response.msg)
          .show();
        console.error("Error:", error);
        reject(error); // Reject the promise with the error
      },
    });
  });
}
