const express = require('express');
const router = express.Router();

const clinics = ['Clinic A', 'Clinic B'];
const doctors = ['Dr. Smith', 'Dr. Johnson', 'Dr. Lee'];
const locations = ['New York', 'Los Angeles'];
const appointments = [
    { patient: "John Doe", doctor: "Dr. Smith", date: "2023-10-05", time: "10:00", clinic: "Clinic A", location: "New York" },
    { patient: "Alice Smith", doctor: "Dr. Johnson", date: "2023-10-06", time: "11:00", clinic: "Clinic B", location: "Los Angeles" },
    { patient: "Bob Johnson", doctor: "Dr. Lee", date: "2023-10-07", time: "14:00", clinic: "Clinic A", location: "New York" }
];

const doctorsByClinic = {
    "Clinic A": ["Dr. Smith", "Dr. Lee"],
    "Clinic B": ["Dr. Johnson"]
};

router.get('/', (req, res) => {
    res.render('appointment-calendar', {
        clinics,
        doctors,
        locations,
        appointments,
        doctorsByClinic
    });
});

module.exports = router;