var express = require("express");
var router = express.Router();
var path = require("path");
var fs = require("fs");
const CryptoJS = require("crypto-js");
const session = require("express-session");
const auth = require("../middleware/auth");
router.use(express.static(path.join(__dirname, "public")));
router.use(express.json());
router.use(express.urlencoded({ extended: true }));
var flash = require("express-flash");
router.use(
  session({
    secret: "keyboard cat",
    resave: false,
    saveUninitialized: true,
    cookie: {
      maxAge: 1000 * 60,
    },
  })
);
router.use(flash());
const multer = require("multer");
const { Sequelize } = require("../sequelize");
const { Op } = require("sequelize");
const {
  SaveStatusData,
  bcHFCtrl,
  bcExpMCtrl,
  getExpM,
  bcCompMasMCtrl,
  bcSerNew,
  bcComTypeNew,
  // bcserviceMaster,
  jsonStoraInDB,
  bcSerMasAssignConc,
  bcSerMastApplyLevl,
  updateAndCreatJson,
  createCitytoJson,
  createStatetoJson,
  bcTariffMasNew,
  bcAdvAgntNew,
  // bcTrfSer,
  // bcDocShare,
  bcAssCompNew,
  insertUser,
  verifyLogin,
  BcblRateChange,
  allTariff,
  BCExpMasterNew,
  changeExpStatus,
  getAdvAgent,
  // changeStatusAdvagnt,
  bcAdvAgent,
  BcAssCompNew,
  getTariffList,
  getAccComData,
  changeTrfStatus,
  changeAssCom,
  getAllDoctor,
  updateExpMaster,
  showExpMaster,
  insertServiseRate,
  getAllServiesMst,
  serMstStatusChange,
  updateSerMst,
  updatePageSer,
  getAllTrfList,
  updateTrfMaster,
  loadTrfPage,
  Selectedservice,
  serviceMstStatusChange,
  getServices,
  selServices,
  getServ,
  changeSerStatus,
  updateSelSer,
  companyType,
  companyTypeSubmit,
  getCompanyType,
  changeCompTypeStatus,
  updateCompType,
  getTariffM,
  changeTariffMasterStatus,
  updateTariff,
  doctorSelected,
  getTariffs,
  getDoc,
  changeDocStatus,
  showDoc,
  showConcessionMaster,
  getConcession,
  BCConcessionNew,
  changeConcessionStatus,
  BCSacMasterNew,
  getSacMaster,
  changeSacStatus,
  getRefundMaster,
  changeRefundStatus,
  BCRefundMasterNew,
  addDoctorServices,
  changeBulkTariffStatus,
  getTriData,
} = require("../controllers/BillingBackController");
const {
  CompanyHF,
  SacMaster,
  RefundMaster,
  Doctor,
  selectedDoctor,
  bcBullRateChange,
} = require("../models/billingSchema");
const { SubSpecialization } = require("../models/clinicConfig");
const { Prefix } = require("../models/mainInvSchema");

//decryption and encryption fxn
function decryptData(encryptedData, secretKey) {
  const bytes = CryptoJS.AES.decrypt(encryptedData, secretKey);
  return bytes.toString(CryptoJS.enc.Utf8);
}
function encryptDataForUrl(data) {
  console.log(data);
  const secretKey = "ll"; // Replace with your actual secret key
  const encrypted = CryptoJS.AES.encrypt(data, secretKey).toString();
  const encodedEncrypted = encodeURIComponent(encrypted);
  return encodedEncrypted;
}

function generateTwoDigitNumber() {
  return Math.floor(Math.random() * 90) + 10;
}

const storage = multer.diskStorage({
  destination: function (req, file, cb) {
    console.log("Uploading file:", file);
    cb(null, "public/images/myuploads"); // Destination directory
  },
  filename: function (req, file, cb) {
    // Generate a unique file name with original extension
    const uniqueName = `BC_${Date.now()}_${file.originalname}`;
    cb(null, uniqueName);
  },
});

const upload = multer({ storage: storage });

const uploadFields = upload.fields([
  { name: "comp_footer_image", maxCount: 1 },
  { name: "head_image", maxCount: 1 },
  { name: "comp_logo", maxCount: 1 },
]);

router.get("/1", async (req, res) => {
  try {
      const data = await CompanyHF.findOne({
          where: {
              clinic_id: req.user.clinicId
          }
      });

      // Log the data to debug
      console.log(data);

      // If no data is found, send a blank object
      res.render("billing/bc-company-new-company-other-details", {
          data: data || {} // Use an empty object if no data is found
      });
  } catch (error) {
      console.error("Error fetching data:", error);
      res.status(500).send("Internal Server Error");
  }
});

router.get("/2", loadTrfPage);
router.get("/3", showExpMaster);

router.get("/4", (req, res) => {
  const schema = "BCExpMaster";
  const status = "exp_status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BCEM12-expense-master", { a, b });
});
router.get("/5", updatePageSer);
router.get("/6", (req, res) => {
  const schema = "bcAdvAgent";
  const status = "adv_agnt_status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BCAA9-advance-against", { a, b });
});
router.get("/7", (req, res) => {
  res.render("billing/BCCTN10-company-type-new");
});
router.get("/8", (req, res) => {
  res.render("billing/BCSMAC3-service-master-assign-concent");
});
router.get("/9", (req, res) => {
  res.render("billing/BCCN14-company-new");
});
// router.get('/10', (req, res) => {
//   res.render('billing/BCEMN2-expense%20master-new')
// })
router.get("/11", (req, res) => {
  const schema = "ServiceMasterSchema";
  const status = "status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BCSM6-service-master", { a, b });
});
router.get("/12", (req, res) => {
  res.render("billing/BCSMAL15-service-master-apply-level", { a, b });
});
router.get("/13", (req, res) => {
  const schema = "SelectedService";
  const status = "status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BCSRDCW25-service-rate-doctor-category-wise", { a, b });
});
router.get("/14", loadTrfPage);
router.get("/15", (req, res) => {
  const schema = "BcAssCompNew";
  const status = "status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BCAC22-associated-company", { a, b });
});
router.get("/16", async (req, res) => {
  const id = req.query.id;
  const secretKey = "ll";
  const Id = decryptData(decodeURIComponent(id), secretKey);
  console.log(Id);
  let result = "";

  if (Id) {
    try {
      result = await bcAdvAgent.findByPk(Id);
      console.log(result);
      // Only render once
      res.render("billing/BCAAN21-advance-against-new", { result: result });
    } catch (error) {
      console.error("Error fetching department data:", error);
      // Handle error and send response once
      return res.status(500).send("Internal Server Error");
    }
  } else {
    // Render the view when Id is not provided, without fetching from database
    res.render("billing/BCAAN21-advance-against-new", { result: result });
  }
});

router.get("/17", (req, res) => {
  const schema = "ServiceMasterSchema";
  const status = "status";
  const a = encryptDataForUrl(schema.toString());
  res.render("billing/BCTS20-Tariff-service", { a });
});
router.get("/18", (req, res) => {
  const schema = "selectedDoctor";
  const status = "status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BCDS24-doctor-share", { a, b });
});
// router.get('/19', (req, res) => {
//   res.render('billing/BCACN27-associate-company-new')
// })
router.get("/19", async (req, res) => {
  const id = req.query.id;

  const secretKey = "ll";
  const Id = decryptData(decodeURIComponent(id), secretKey);
  let result = "";
  if (Id) {
    try {
      const result = await BcAssCompNew.findByPk(Id);
      console.log(result);
      res.render("billing/BCACN27-associate-company-new", { result: result });
    } catch (error) {
      console.error("Error fetching department data:", error);
      res.status(500).send("Internal Server Error");
    }
  } else {
    res.render("billing/BCACN27-associate-company-new", { result: result });
  }
});
router.get("/20", (req, res) => {
  const schema = "CompanyType";
  const a = encryptDataForUrl(schema.toString());
  res.render("billing/BCCT23-company-type", { a });
});

router.get("/21", (req, res) => {
  const schema = "bcBullRateChange";
  const status = "status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BCBRC29-bulk-rate-change", { a, b });
});
// router.get('/22', (req, res) => {
//   res.render('billing/BCBRCLOT28-bulk-rate-change-list-of-tariff')
// })
router.get("/22", async (req, res) => {
  const id = req.query.id;

  const secretKey = "ll";
  const Id = decryptData(decodeURIComponent(id), secretKey);
  console.log("Id given : ", Id);

  let result = "";
  if (Id) {
    try {
      const result = await bcBullRateChange.findByPk(Id);
      console.log(result);
      res.render("billing/BCBRCLOT28-bulk-rate-change-list-of-tariff", {
        result: result,
      });
    } catch (error) {
      console.error("Error fetching department data:", error);
      res.status(500).send("Internal Server Error");
    }
  } else {
    res.render("billing/BCBRCLOT28-bulk-rate-change-list-of-tariff", {
      result: result,
    });
  }
});

router.get("/23", showDoc);

router.get("/24", selServices);
router.get("/25", (req, res) => {
  res.render("billing/service-rate-dr-cat");
});
router.get("/26", companyType);
router.get("/27", (req, res) => {
  const schema = "bcTariffMasterNew";
  const status = "trf_status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/Tariff-master-listing", { a, b });
});
router.get("/29", showConcessionMaster);
router.get("/28", (req, res) => {
  const schema = "ConcessionMaster";
  const status = "exp_status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/BC-ListConcession", { a, b });
});
router.get("/30", (req, res) => {
  const schema = "SacMaster";
  const status = "exp_status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/bc-listSacCode", { a, b });
});
router.get("/31", async (req, res) => {
  const id = req.query.id;

  const secretKey = "ll";
  const ExpId = decryptData(decodeURIComponent(id), secretKey);

  let result = "";
  if (ExpId) {
    try {
      console.log("Here");
      const result = await SacMaster.findOne({ where: { id: ExpId } });
      console.log(result);
      // console.log(ExpId);
      res.render("billing/bc-sacCodeMaster", { result: result });
    } catch (error) {
      console.error("Error fetching department data:", error);
      res.status(500).send("Internal Server Error");
    }
  } else {
    res.render("billing/bc-sacCodeMaster", { result: result });
  }
});
router.get("/32", (req, res) => {
  const schema = "RefundMaster";
  const status = "exp_status";
  const a = encryptDataForUrl(schema.toString());
  const b = encryptDataForUrl(status.toString());
  res.render("billing/bc-listRefundMaster", { a, b });
});
router.get("/33", async (req, res) => {
  const id = req.query.id;

  const secretKey = "ll";
  const ExpId = decryptData(decodeURIComponent(id), secretKey);

  let result = "";
  if (ExpId) {
    try {
      console.log("Here");
      const result = await RefundMaster.findOne({ where: { id: ExpId } });
      console.log(result);
      // console.log(ExpId);
      res.render("billing/bc-RefundMaster", { result: result });
    } catch (error) {
      console.error("Error fetching department data:", error);
      res.status(500).send("Internal Server Error");
    }
  } else {
    res.render("billing/bc-RefundMaster", { result: result });
  }
});

/* GET Billing listing. */
router.get("/", function (req, res, next) {
  res.send("respond with a resource");
});

router.post("/bc_c_n_o_d", uploadFields, bcHFCtrl);

router.post("/bc_e_m", bcExpMCtrl);
router.post("/bc-exp-master-new", BCExpMasterNew);
router.post("/bc-concession-master-new", BCConcessionNew);
router.post("/bc-sac-master-new", BCSacMasterNew);
router.post("/bc-reason-master-new", BCRefundMasterNew);
router.post("/bccn_Comp_Mas", bcCompMasMCtrl);
router.get("/get-exp-m", getExpM);
router.get("/get-concession-m", getConcession);
router.get("/get-sac-m", getSacMaster);
router.get("/get-refund-m", getRefundMaster);
router.get("/get-blkTariff", allTariff);
router.get("/get-doc", getDoc);
router.get("/get_tariff_master", getTariffM);
router.get("/get_services", getServ);
router.post("/change-exp-status", changeExpStatus);
router.post("/change-concession-status", changeConcessionStatus);
router.post("/change-sac-status", changeSacStatus);
router.post("/change-refund-status", changeRefundStatus);
router.post("/changeBulkTariffStatus", changeBulkTariffStatus);
router.post("/change-doc-status", changeDocStatus);
router.post("/change-tariff-master-status", changeTariffMasterStatus);
router.post("/change_ser_status", changeSerStatus);
router.get("/bc-s-m-n", bcSerNew);
router.post("/bc-com-type-new", bcComTypeNew);
// router.post('/bc-ser-master', bcserviceMaster);
router.post("/bc-ser-mas-ass-cont", bcSerMasAssignConc);
router.post("/bc-ser-mast-apply-levl", bcSerMastApplyLevl);
router.post("/bc-tariff-master-new", bcTariffMasNew);
router.get("/get-Tariff-list", getTariffList);
router.get("/get_comp_type", getCompanyType);
router.post("/bc-adv-agnt-new", bcAdvAgntNew);
router.get("/get-Adv-agent", getAdvAgent);
// router.post('/change-adv-agent-status', changeStatusAdvagnt)
// router.post('/bc-trf-ser', bcTrfSer);
// router.post('/bc-doc-share', bcDocShare);
router.post("/bc-ass-comp-new", bcAssCompNew);
router.get("/loadAssComData", getAccComData);
router.get("/get-Ass-Com-list", getAccComData);
router.post("/change-Comp-status", changeAssCom);
router.post("/bc-bl-rate-change", BcblRateChange);
// router.get('/loadUpdatePage', loadUpdatePage);
router.post("/update-acc-master", async (req, res) => {
  const { id } = req.body;
  console.log(id);
  req.flash("id", id);
  res.sendStatus(200);
});

router.post("/update-adv-master", (req, res) => {
 
  const { id } = req.body;
  console.log(id);
  req.flash("id", id);
  res.sendStatus(200);
});

router.post("/update-exp-master", updateExpMaster);
router.post("/update-ser-master", updateSelSer);
router.post("/update-tarr-mst", updateTariff);
router.post("/change-trf-status", changeTrfStatus);
router.post("/update-trf-master", updateTrfMaster);
router.post("/change_Comptype_status", changeCompTypeStatus);
router.post("/update_Comptyper", updateCompType);

router.post("/get-ser-Mst-list", getAllServiesMst);
router.post("/change-ser-mst-status", serMstStatusChange);
router.post("/update-ser-master", updateSerMst);

router.get("/get-trf-list", getAllTrfList);
router.post("/bc-Servise-mst", insertServiseRate);

router.get("/get-Doctor", getAllDoctor);
router.get("/get-service", getServices);
router.post("/update_services", serviceMstStatusChange);
router.post("/store-jsonInDb", jsonStoraInDB),
  router.post("/updateAndCreatJson", updateAndCreatJson);
router.get("/get", createCitytoJson);
router.get("/post", createStatetoJson);
router.post("/admin/registration", auth.isLogout, insertUser);
router.post("/admin/login", verifyLogin);
router.post("/selectedService", Selectedservice);
router.post("/companyTypeSubmit", companyTypeSubmit);
router.post("/doctorSelected", doctorSelected);
router.get("/get-Tariffs", getTariffs);
router.get("/getTriData", getTriData);
router.post("/add-services", addDoctorServices);

router.get("/get-available-doctors", async (req, res) => {
  try {
    // Fetch all doctor IDs that have been selected
    const selected = await selectedDoctor.findAll({
      attributes: ["id"], // Assuming 'id' is the unique identifier for selectedDoctor
    });

    const selectedIds = selected.map((doc) => doc.id);

    // Fetch all doctors excluding those selected
    const availableDoctors = await Doctor.findAll({
      where: {
        id: { [Op.notIn]: selectedIds }, // Use the Op object for notIn
      },
    });

    console.log(availableDoctors);
    res.json(availableDoctors);
  } catch (err) {
    console.error("Error fetching available doctors: ", err.message);
    res.status(500).send("Server error");
  }
});

router.get("/reloadSubSpec", async (req, res) => {
  const { spec_desc } = req.query; // Get the spec_desc from the query parameter

  try {
    let queryOptions = {};

    // If spec_desc is provided, add a where condition to filter by spec_desc
    if (spec_desc) {
      queryOptions.where = { sub_spec_spec: spec_desc };
    }

    // Fetch the data from the Subspec model
    const subspecData = await SubSpecialization.findAll(queryOptions);

    // Return the data as JSON
    res.json(subspecData);
  } catch (error) {
    console.error("Error fetching data from Subspec:", error);
    res.status(500).send("Error fetching data from database");
  }
});

router.post("/save-status-data", SaveStatusData);

router.get('/generate-code/:schema', async (req, res) => {
  const schemaName = req.params.schema;
console.log({schemaName})
  try {
   
      const models = require('../models/billingSchema');
      const Model = models[schemaName];
   console.log({Model})
      if (!Model) {
          return res.status(404).json({ message: 'Schema not found.' });
      }

      const prefixEntry = await Prefix.findOne({
          where: { name: schemaName } 
      });
console.log({prefixEntry})
      if (!prefixEntry) {
          return res.status(404).json({ message: 'Prefix not found for the specified schema.' });
      }

      const prefix = prefixEntry.prefix; 


      const lastEntry = await Model.findOne({
          order: [['createdAt', 'DESC']], 
      });
console.log({lastEntry})
      if (!lastEntry) {
         
          return res.json({ newCode: `${prefix}1` });
      }

      const newCode = `${prefix}${parseInt(lastEntry.id) + 1}`; 

   
      res.json({ newCode });
  } catch (error) {
      console.error('Error retrieving last entry or prefix:', error);
      res.status(500).json({ error: 'An error occurred while retrieving the last entry or prefix.' });
  }
});


module.exports = router;
