const express = require('express');
const router = express.Router();
const { submitLead, fetchAndStoreFacebookLeads } = require('../controllers/leadController');

//? Submit a lead (generic endpoint for all sources)
router.post('/submit', submitLead);

//? Fetch and store Facebook leads
router.get('/facebook/leads', async (req, res) => {
  await fetchAndStoreFacebookLeads();
  res.status(200).json({ message: "Facebook leads fetched and stored successfully" });
});

//? In leadRoute.js
router.get('/test', (req, res) => {
  res.status(200).json({ message: "Test route is working!" });
});

module.exports = router;