const {
  createOpeningBalance,
  getOpeningBalance,
  getItemDetails,
  createOrUpdateIndent,
  getStoreIndent,
  getIndentDetails,
  getItems,
  deleteIndent,
  updateFreezeStatus,
  getIndent,
  createOrUpdateRequisition,
  getAllRequisitions,
  getRequisitionDetails,
  getRequisition,
  deleteRequisition,
  getCurrentItemStock,
  getUniqueItemsWithStock,
  savePurchaseOrder,
  approvePR,
  fetchRequisitionItemsWithDetails,
  saveIssueToClinic,
  getIssueToclinic,
  getAllPO,
  getPOItems,
  deleteRecord,
  getItemsOnSearch,
  getItemBatches,
  saveGRNData,
  approveIndent,
  approvePO,
  getItemsFromIndents,
  getItemsFromPR,
  fetchPurchaseOrderItemsWithDetails,
  saveConsumption,
  getConsume,
  getCurrentItemsOnSearch,
  getAllGRN,
  approveGRN,
  getBatchDetails,
  fetchIndentItemsWithDetails,
  getCurrentItemStockByStore,
  fetchIssueItemsWithDetails,
  createReceiveAgainstIssue
} = require('../controllers/mainInvCtrls');
const router = require('express').Router();

router.get('/1',(req,res)=>{
  res.render('MainInv/recorder-item');
})

// router.get('/2',(req,res)=>{
//     res.render('MainInv/expired-item-list');
// })

// router.get('/3',(req,res)=>{
//     res.render('MainInv/pending-indents-list');
// })

// router.get('/4',(req,res)=>{
//     res.render('MainInv/pending-purchase-order-list');
// })

// router.get('/5',(req,res)=>{
//     res.render('MainInv/pending-purchase-requisition-list');
// })

router.get('/6',(req,res)=>{
  res.render('MainInv/item-stock');
})

router.get('/7',(req,res)=>{
  res.render('MainInv/opening-balance');
})

router.get('/8',(req,res)=>{
  res.render('MainInv/opening-balance-new-copy');
})

router.get('/9',(req,res)=>{
  res.render('MainInv/store-indents-list');
})

router.get('/10',(req,res)=>{
 
  const {id} = req.query;
  res.render('MainInv/store-indents-list-new',{id});
})

router.get('/11',(req,res)=>{
  
  res.render('MainInv/purchase-requisition');
})

router.get('/12',(req,res)=>{
  const {id} = req.query;
  res.render('MainInv/purchase-requisition-new',{id});
})

router.get('/13',(req,res)=>{
  res.render('MainInv/purchase-requisition-new-add-items');
})

router.get('/14',(req,res)=>{
  res.render('MainInv/goods-received-notes-main-items');
})

router.get('/15',(req,res)=>{
  res.render('MainInv/goods-received-notes-free-items');
})

router.get('/16',(req,res)=>{
  res.render('MainInv/goods-received-notes-new');
})
router.get('/90',(req,res)=>{
  res.render('MainInv/approveGrn');
})
router.get('/91',(req,res)=>{
  res.render('MainInv/goods -recieved-notes-list');
})

router.get('/17',(req,res)=>{
  res.render('MainInv/approve-purchase-requisition-copy');
})

router.get('/18',(req,res)=>{
  res.render('MainInv/goods-return-notes');
})

router.get('/19',(req,res)=>{
  res.render('MainInv/goods-return-notes-new');
})

router.get('/20',(req,res)=>{
  res.render('MainInv/issue-to-clinic');
})

router.get('/21',(req,res)=>{
  res.render('MainInv/issue-to-clinic-new');
})

router.get('/22',(req,res)=>{
  res.render('MainInv/receive-item-against-issue');
})

router.get('/23',(req,res)=>{
  res.render('MainInv/receive-item-against-issue-new');
})

router.get('/24',(req,res)=>{
  res.render('MainInv/approve-purchase-order');
})

router.get('/25',(req,res)=>{
  res.render('MainInv/return-item');
})

router.get('/26',(req,res)=>{
  res.render('MainInv/return-item-new');
})

router.get('/27',(req,res)=>{
  res.render('MainInv/receive-item-against-return');
})

router.get('/28',(req,res)=>{
  res.render('MainInv/receive-item-against-return-new');
})

router.get('/29',(req,res)=>{
  res.render('MainInv/expired-item-return');
})

router.get('/30',(req,res)=>{
  res.render('MainInv/expired-item-return-new');
})

router.get('/31',(req,res)=>{
  res.render('MainInv/stock-adjustment');
})

router.get('/32',(req,res)=>{
  res.render('MainInv/stock-adjustment-new');
})

router.get('/33',(req,res)=>{
  res.render('MainInv/approve-indent');
})

router.get('/34',(req,res)=>{
  res.render('MainInv/scrap-sale');
})

router.get('/35',(req,res)=>{
  res.render('MainInv/scrap-sale-new');
})

router.get('/36',(req,res)=>{
  res.render('MainInv/purchase-order');
})

router.get('/37',(req,res)=>{
  res.render('MainInv/purchase-order-new');
})

router.get('/38',(req,res)=>{
  res.render('MainInv/purchase-order-new-get-items-TABLE-INCOMPLETE');
})
router.get('/39',(req,res)=>{
  res.render('MainInv/material-consumption');
})

router.get('/40',(req,res)=>{
  res.render('MainInv/material-consumption-new');
})

router.get('/41',(req,res)=>{
  res.render('MainInv/physical-item-stock');
})

router.get('/42',(req,res)=>{
  
    res.render('MainInv/42-PIM-physical-item-stock-new[12-30]')
  })
  router.get('/43', (req, res) => {
    res.render('MainInv/43-PIM-approve-goods-received-notes-main-items[12-42]');
  });
  
  router.get('/44', (req, res) => {
    res.render('MainInv/44-PIM-approve-goods-received-notes-free-items[13-05]');
  });
  
  router.get('/45', (req, res) => {
    res.render('MainInv/45-PIM-stock-adjustment[13-36]');
  });
  
  router.get('/46', (req, res) => {
    res.render('MainInv/46-PIM-item-enquiry[13-42]');
  });
  
  router.get('/47', (req, res) => {
    res.render('MainInv/47-PIM-item-enquiry-new[13-45]');
  });
  
  router.get('/48', (req, res) => {
    res.render('MainInv/48-PIM-item-enquiry-add-item[14-00]');
  });
  
  router.get('/49', (req, res) => {
    res.render('MainInv/49-PIM-quotation-details[14-09]');
  });
  
  router.get('/50', (req, res) => {
    res.render('MainInv/50-PIM-quotation-details-new[14-19]');
  });
  
  router.get('/51', (req, res) => {
    res.render('MainInv/51-PIM-quotation-details-new-enquiry-details[14-27]');
  });
  
  router.get('/52', (req, res) => {
    res.render('MainInv/52-PIM-quotation-details-new-add-items[14-33]');
  });
  
  router.get('/53', (req, res) => {
    res.render('MainInv/53-PIM-item-sales-return[14-43]');
  });
  
  router.get('/54', (req, res) => {
    res.render('MainInv/54tab-PIM-item-sales-return-new[14-45]');
  });
  
  router.get('/55', (req, res) => {
    res.render('MainInv/55-PIM-work-order[14-50]');
  });
  
  router.get('/56', (req, res) => {
    res.render('MainInv/56-PIM-work-order-new[15-00]');
  });

  router.get('/57', (req, res) => {
    res.render('MainInv/57-PIM-approve-work-order[15-14]');
  });
  
  router.get('/58', (req, res) => {
    res.render('MainInv/58-PIM-suspend-stock-transaction[15-27]');
  });
  
  router.get('/59', (req, res) => {
    res.render('MainInv/59-PIM-suspend-stock-transaction-new[15-29]');
  });
  
  router.get('/60', (req, res) => {
    res.render('MainInv/60-PIM-issue-to-qs[15-37]');
  });
  
  router.get('/61', (req, res) => {
    res.render('MainInv/61-PIM-issue-to-qs-new[15-39]');
  });
  
  router.get('/62', (req, res) => {
    res.render('MainInv/62-PIM-receive-item-against-qs[15-48]');
  });
  
  router.get('/63', (req, res) => {
    res.render('MainInv/63-PIM-receive-item-against-qs-new[15-51]');
  });
  
  router.get('/64', (req, res) => {
    res.render('MainInv/64-PIM-issue-grn-item-to-qs');
  });
  
  router.get('/65', (req, res) => {
    res.render('MainInv/65-PIM-issue-grn-item-to-qs-new');
  });
  
  router.get('/66', (req, res) => {
    res.render('MainInv/66-PIM-receive-grn-to-qs-item[15-59]');
  });
  
  router.get('/67', (req, res) => {
    res.render('MainInv/67-PIM-receive-grn-to-qs-item-new[16-00]');
  });
  
  router.get('/68', (req, res) => {
    res.render('MainInv/68-PIM-approve-goods-return-note[16-08]');
  });
  
  router.get('/69', (req, res) => {
    res.render('MainInv/69-PIM-approve-expired-item-return[16-19]');
  });
  
  router.get('/70', (req, res) => {
    res.render('MainInv/70-PIM-approve-scrap-sale[16-37]');
  });
  
  router.get('/71', (req, res) => {
    res.render('MainInv/71-PIM-mrp-adjustment[16-44]');
  });
  
  router.get('/72', (req, res) => {
    res.render('MainInv/72-PIM-mrp-adjustment-new[16-45]');
  });
  
  router.get('/73', (req, res) => {
    res.render('MainInv/73-PIM-mrp-adjustment-new-get-items[17-02]');
  });
  
  router.get('/74', (req, res) => {
    res.render('MainInv/74-PIM-approve-mrp-adjustment[17-27]');
  });
  
  router.get('/75', (req, res) => {
    res.render('MainInv/75-PIM-approve-direct[17-40]');
  });
  
  router.get('/76', (req, res) => {
    res.render('MainInv/Consumption',{username:req.user.username});
  });
  router.get('/77', (req, res) => {
    res.render('MainInv/ConsuptionList');
  });
  router.get('/78', (req, res) => {
    res.render('MainInv/receiveAgainstIssue');
  });

  router.post('/save-opening-balance', createOpeningBalance);
  router.get('/get-opening-balance', getOpeningBalance);
  router.get('/getCurrentItemStock', getCurrentItemStock);
  router.get('/getCurrentItemStockByStore', getCurrentItemStockByStore);
  router.get('/getAll-indents', getStoreIndent);
  router.get('/getAll-consume', getConsume);
  router.get('/get-opening-balance-item/:itemId', getItemDetails);
  router.get('/get-current-item-stock/:itemId', getItemDetails);
  router.get('/get-indent-details/:itemId', getIndentDetails);
  router.get('/get-items/:item_code', getItems);
  router.get('/get-indent/:id', getIndent);
  
  router.post('/createindent', createOrUpdateIndent);
  router.post('/createReceive', createReceiveAgainstIssue);
  router.delete('/delete-indent/:id', deleteIndent);
  router.post('/update-freeze-status/:type/:id', updateFreezeStatus);
  
  router.post('/createrequisition', createOrUpdateRequisition);
  router.get('/getAll-requisitions', getAllRequisitions);

  router.get('/get-requisition-details/:id', getRequisitionDetails);
  router.get('/get-requisition/:id', getRequisition);
  router.delete('/delete-record/:type/:id', deleteRecord); // Add this route
  router.post('/approve-requisition/:id', approvePR); // Add this route
  router.post('/approve-indent/:id', approveIndent); // Add this route
  router.post('/approve-po/:id', approvePO); // Add this route
  router.post('/approve-grn/:id', approveGRN); // Add this route

  router.get('/get-current-item-counts',getUniqueItemsWithStock)

  router.post('/save-purchase-order',savePurchaseOrder)
  router.post('/save-consumption',saveConsumption)

  router.get('/getprdata',fetchRequisitionItemsWithDetails)
  router.get('/getIssuedata',fetchIssueItemsWithDetails)
  router.get('/getIndentdata',fetchIndentItemsWithDetails)
  router.get('/getBatchDetails',getBatchDetails)
  router.get('/getPodata',fetchPurchaseOrderItemsWithDetails)
  router.get('/get-issue-to-clinic',getIssueToclinic)
  router.post('/saveIssueToClinic',saveIssueToClinic)

  router.get('/getItemsOnSearch',getItemsOnSearch)
  router.get('/getCurrentItemsOnSearch',getCurrentItemsOnSearch)
  router.get('/getIndentOnSearch',getItemsFromIndents)
  router.get('/getPROnSearch',getItemsFromPR)


  router.get('/getAllPO',getAllPO)
  router.get('/getAllGrn',getAllGRN)
  router.get('/getPOItems/:id', getPOItems);
  router.get('/getIssueItems/:id', getIssueItems);

  router.get('/getItemBatches/:id', getItemBatches);


  router.post('/saveGRNData', saveGRNData);


  // router.get('/100',(req,res)=>{
  //   res.render('MainInv/42-PIM-physical-item-stock-new[12-30]');
  // })

  // router.post('/1001',(req,res)=>{
  //   console.log(req.body);
  // })


  
  

  module.exports = router